/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum OpcuaStatusCode {
  Good((long) 0x00000000L),
  Uncertain((long) 0x40000000L),
  Bad((long) 0x80000000L),
  BadUnexpectedError((long) 0x80010000L),
  BadInternalError((long) 0x80020000L),
  BadOutOfMemory((long) 0x80030000L),
  BadResourceUnavailable((long) 0x80040000L),
  BadCommunicationError((long) 0x80050000L),
  BadEncodingError((long) 0x80060000L),
  BadDecodingError((long) 0x80070000L),
  BadEncodingLimitsExceeded((long) 0x80080000L),
  BadRequestTooLarge((long) 0x80B80000L),
  BadResponseTooLarge((long) 0x80B90000L),
  BadUnknownResponse((long) 0x80090000L),
  BadTimeout((long) 0x800A0000L),
  BadServiceUnsupported((long) 0x800B0000L),
  BadShutdown((long) 0x800C0000L),
  BadServerNotConnected((long) 0x800D0000L),
  BadServerHalted((long) 0x800E0000L),
  BadNothingToDo((long) 0x800F0000L),
  BadTooManyOperations((long) 0x80100000L),
  BadTooManyMonitoredItems((long) 0x80DB0000L),
  BadDataTypeIdUnknown((long) 0x80110000L),
  BadCertificateInvalid((long) 0x80120000L),
  BadSecurityChecksFailed((long) 0x80130000L),
  BadCertificatePolicyCheckFailed((long) 0x81140000L),
  BadCertificateTimeInvalid((long) 0x80140000L),
  BadCertificateIssuerTimeInvalid((long) 0x80150000L),
  BadCertificateHostNameInvalid((long) 0x80160000L),
  BadCertificateUriInvalid((long) 0x80170000L),
  BadCertificateUseNotAllowed((long) 0x80180000L),
  BadCertificateIssuerUseNotAllowed((long) 0x80190000L),
  BadCertificateUntrusted((long) 0x801A0000L),
  BadCertificateRevocationUnknown((long) 0x801B0000L),
  BadCertificateIssuerRevocationUnknown((long) 0x801C0000L),
  BadCertificateRevoked((long) 0x801D0000L),
  BadCertificateIssuerRevoked((long) 0x801E0000L),
  BadCertificateChainIncomplete((long) 0x810D0000L),
  BadUserAccessDenied((long) 0x801F0000L),
  BadIdentityTokenInvalid((long) 0x80200000L),
  BadIdentityTokenRejected((long) 0x80210000L),
  BadSecureChannelIdInvalid((long) 0x80220000L),
  BadInvalidTimestamp((long) 0x80230000L),
  BadNonceInvalid((long) 0x80240000L),
  BadSessionIdInvalid((long) 0x80250000L),
  BadSessionClosed((long) 0x80260000L),
  BadSessionNotActivated((long) 0x80270000L),
  BadSubscriptionIdInvalid((long) 0x80280000L),
  BadRequestHeaderInvalid((long) 0x802A0000L),
  BadTimestampsToReturnInvalid((long) 0x802B0000L),
  BadRequestCancelledByClient((long) 0x802C0000L),
  BadTooManyArguments((long) 0x80E50000L),
  BadLicenseExpired((long) 0x810E0000L),
  BadLicenseLimitsExceeded((long) 0x810F0000L),
  BadLicenseNotAvailable((long) 0x81100000L),
  BadServerTooBusy((long) 0x80EE0000L),
  GoodPasswordChangeRequired((long) 0x00EF0000L),
  GoodSubscriptionTransferred((long) 0x002D0000L),
  GoodCompletesAsynchronously((long) 0x002E0000L),
  GoodOverload((long) 0x002F0000L),
  GoodClamped((long) 0x00300000L),
  BadNoCommunication((long) 0x80310000L),
  BadWaitingForInitialData((long) 0x80320000L),
  BadNodeIdInvalid((long) 0x80330000L),
  BadNodeIdUnknown((long) 0x80340000L),
  BadAttributeIdInvalid((long) 0x80350000L),
  BadIndexRangeInvalid((long) 0x80360000L),
  BadIndexRangeNoData((long) 0x80370000L),
  BadIndexRangeDataMismatch((long) 0x80EA0000L),
  BadDataEncodingInvalid((long) 0x80380000L),
  BadDataEncodingUnsupported((long) 0x80390000L),
  BadNotReadable((long) 0x803A0000L),
  BadNotWritable((long) 0x803B0000L),
  BadOutOfRange((long) 0x803C0000L),
  BadNotSupported((long) 0x803D0000L),
  BadNotFound((long) 0x803E0000L),
  BadObjectDeleted((long) 0x803F0000L),
  BadNotImplemented((long) 0x80400000L),
  BadMonitoringModeInvalid((long) 0x80410000L),
  BadMonitoredItemIdInvalid((long) 0x80420000L),
  BadMonitoredItemFilterInvalid((long) 0x80430000L),
  BadMonitoredItemFilterUnsupported((long) 0x80440000L),
  BadFilterNotAllowed((long) 0x80450000L),
  BadStructureMissing((long) 0x80460000L),
  BadEventFilterInvalid((long) 0x80470000L),
  BadContentFilterInvalid((long) 0x80480000L),
  BadFilterOperatorInvalid((long) 0x80C10000L),
  BadFilterOperatorUnsupported((long) 0x80C20000L),
  BadFilterOperandCountMismatch((long) 0x80C30000L),
  BadFilterOperandInvalid((long) 0x80490000L),
  BadFilterElementInvalid((long) 0x80C40000L),
  BadFilterLiteralInvalid((long) 0x80C50000L),
  BadContinuationPointInvalid((long) 0x804A0000L),
  BadNoContinuationPoints((long) 0x804B0000L),
  BadReferenceTypeIdInvalid((long) 0x804C0000L),
  BadBrowseDirectionInvalid((long) 0x804D0000L),
  BadNodeNotInView((long) 0x804E0000L),
  BadNumericOverflow((long) 0x81120000L),
  BadLocaleNotSupported((long) 0x80ED0000L),
  BadNoValue((long) 0x80F00000L),
  BadServerUriInvalid((long) 0x804F0000L),
  BadServerNameMissing((long) 0x80500000L),
  BadDiscoveryUrlMissing((long) 0x80510000L),
  BadSempahoreFileMissing((long) 0x80520000L),
  BadRequestTypeInvalid((long) 0x80530000L),
  BadSecurityModeRejected((long) 0x80540000L),
  BadSecurityPolicyRejected((long) 0x80550000L),
  BadTooManySessions((long) 0x80560000L),
  BadUserSignatureInvalid((long) 0x80570000L),
  BadApplicationSignatureInvalid((long) 0x80580000L),
  BadNoValidCertificates((long) 0x80590000L),
  BadIdentityChangeNotSupported((long) 0x80C60000L),
  BadRequestCancelledByRequest((long) 0x805A0000L),
  BadParentNodeIdInvalid((long) 0x805B0000L),
  BadReferenceNotAllowed((long) 0x805C0000L),
  BadNodeIdRejected((long) 0x805D0000L),
  BadNodeIdExists((long) 0x805E0000L),
  BadNodeClassInvalid((long) 0x805F0000L),
  BadBrowseNameInvalid((long) 0x80600000L),
  BadBrowseNameDuplicated((long) 0x80610000L),
  BadNodeAttributesInvalid((long) 0x80620000L),
  BadTypeDefinitionInvalid((long) 0x80630000L),
  BadSourceNodeIdInvalid((long) 0x80640000L),
  BadTargetNodeIdInvalid((long) 0x80650000L),
  BadDuplicateReferenceNotAllowed((long) 0x80660000L),
  BadInvalidSelfReference((long) 0x80670000L),
  BadReferenceLocalOnly((long) 0x80680000L),
  BadNoDeleteRights((long) 0x80690000L),
  UncertainReferenceNotDeleted((long) 0x40BC0000L),
  BadServerIndexInvalid((long) 0x806A0000L),
  BadViewIdUnknown((long) 0x806B0000L),
  BadViewTimestampInvalid((long) 0x80C90000L),
  BadViewParameterMismatch((long) 0x80CA0000L),
  BadViewVersionInvalid((long) 0x80CB0000L),
  UncertainNotAllNodesAvailable((long) 0x40C00000L),
  GoodResultsMayBeIncomplete((long) 0x00BA0000L),
  BadNotTypeDefinition((long) 0x80C80000L),
  UncertainReferenceOutOfServer((long) 0x406C0000L),
  BadTooManyMatches((long) 0x806D0000L),
  BadQueryTooComplex((long) 0x806E0000L),
  BadNoMatch((long) 0x806F0000L),
  BadMaxAgeInvalid((long) 0x80700000L),
  BadSecurityModeInsufficient((long) 0x80E60000L),
  BadHistoryOperationInvalid((long) 0x80710000L),
  BadHistoryOperationUnsupported((long) 0x80720000L),
  BadInvalidTimestampArgument((long) 0x80BD0000L),
  BadWriteNotSupported((long) 0x80730000L),
  BadTypeMismatch((long) 0x80740000L),
  BadMethodInvalid((long) 0x80750000L),
  BadArgumentsMissing((long) 0x80760000L),
  BadNotExecutable((long) 0x81110000L),
  BadTooManySubscriptions((long) 0x80770000L),
  BadTooManyPublishRequests((long) 0x80780000L),
  BadNoSubscription((long) 0x80790000L),
  BadSequenceNumberUnknown((long) 0x807A0000L),
  GoodRetransmissionQueueNotSupported((long) 0x00DF0000L),
  BadMessageNotAvailable((long) 0x807B0000L),
  BadInsufficientClientProfile((long) 0x807C0000L),
  BadStateNotActive((long) 0x80BF0000L),
  BadAlreadyExists((long) 0x81150000L),
  BadTcpServerTooBusy((long) 0x807D0000L),
  BadTcpMessageTypeInvalid((long) 0x807E0000L),
  BadTcpSecureChannelUnknown((long) 0x807F0000L),
  BadTcpMessageTooLarge((long) 0x80800000L),
  BadTcpNotEnoughResources((long) 0x80810000L),
  BadTcpInternalError((long) 0x80820000L),
  BadTcpEndpointUrlInvalid((long) 0x80830000L),
  BadRequestInterrupted((long) 0x80840000L),
  BadRequestTimeout((long) 0x80850000L),
  BadSecureChannelClosed((long) 0x80860000L),
  BadSecureChannelTokenUnknown((long) 0x80870000L),
  BadSequenceNumberInvalid((long) 0x80880000L),
  BadProtocolVersionUnsupported((long) 0x80BE0000L),
  BadConfigurationError((long) 0x80890000L),
  BadNotConnected((long) 0x808A0000L),
  BadDeviceFailure((long) 0x808B0000L),
  BadSensorFailure((long) 0x808C0000L),
  BadOutOfService((long) 0x808D0000L),
  BadDeadbandFilterInvalid((long) 0x808E0000L),
  UncertainNoCommunicationLastUsableValue((long) 0x408F0000L),
  UncertainLastUsableValue((long) 0x40900000L),
  UncertainSubstituteValue((long) 0x40910000L),
  UncertainInitialValue((long) 0x40920000L),
  UncertainSensorNotAccurate((long) 0x40930000L),
  UncertainEngineeringUnitsExceeded((long) 0x40940000L),
  UncertainSubNormal((long) 0x40950000L),
  GoodLocalOverride((long) 0x00960000L),
  GoodSubNormal((long) 0x00EB0000L),
  BadRefreshInProgress((long) 0x80970000L),
  BadConditionAlreadyDisabled((long) 0x80980000L),
  BadConditionAlreadyEnabled((long) 0x80CC0000L),
  BadConditionDisabled((long) 0x80990000L),
  BadEventIdUnknown((long) 0x809A0000L),
  BadEventNotAcknowledgeable((long) 0x80BB0000L),
  BadDialogNotActive((long) 0x80CD0000L),
  BadDialogResponseInvalid((long) 0x80CE0000L),
  BadConditionBranchAlreadyAcked((long) 0x80CF0000L),
  BadConditionBranchAlreadyConfirmed((long) 0x80D00000L),
  BadConditionAlreadyShelved((long) 0x80D10000L),
  BadConditionNotShelved((long) 0x80D20000L),
  BadShelvingTimeOutOfRange((long) 0x80D30000L),
  BadNoData((long) 0x809B0000L),
  BadBoundNotFound((long) 0x80D70000L),
  BadBoundNotSupported((long) 0x80D80000L),
  BadDataLost((long) 0x809D0000L),
  BadDataUnavailable((long) 0x809E0000L),
  BadEntryExists((long) 0x809F0000L),
  BadNoEntryExists((long) 0x80A00000L),
  BadTimestampNotSupported((long) 0x80A10000L),
  GoodEntryInserted((long) 0x00A20000L),
  GoodEntryReplaced((long) 0x00A30000L),
  UncertainDataSubNormal((long) 0x40A40000L),
  GoodNoData((long) 0x00A50000L),
  GoodMoreData((long) 0x00A60000L),
  BadAggregateListMismatch((long) 0x80D40000L),
  BadAggregateNotSupported((long) 0x80D50000L),
  BadAggregateInvalidInputs((long) 0x80D60000L),
  BadAggregateConfigurationRejected((long) 0x80DA0000L),
  GoodDataIgnored((long) 0x00D90000L),
  BadRequestNotAllowed((long) 0x80E40000L),
  BadRequestNotComplete((long) 0x81130000L),
  BadTransactionPending((long) 0x80E80000L),
  BadTicketRequired((long) 0x811F0000L),
  BadTicketInvalid((long) 0x81200000L),
  BadLocked((long) 0x80E90000L),
  BadRequiresLock((long) 0x80EC0000L),
  GoodEdited((long) 0x00DC0000L),
  GoodPostActionFailed((long) 0x00DD0000L),
  UncertainDominantValueChanged((long) 0x40DE0000L),
  GoodDependentValueChanged((long) 0x00E00000L),
  BadDominantValueChanged((long) 0x80E10000L),
  UncertainDependentValueChanged((long) 0x40E20000L),
  BadDependentValueChanged((long) 0x80E30000L),
  GoodEdited_DependentValueChanged((long) 0x01160000L),
  GoodEdited_DominantValueChanged((long) 0x01170000L),
  GoodEdited_DominantValueChanged_DependentValueChanged((long) 0x01180000L),
  BadEdited_OutOfRange((long) 0x81190000L),
  BadInitialValue_OutOfRange((long) 0x811A0000L),
  BadOutOfRange_DominantValueChanged((long) 0x811B0000L),
  BadEdited_OutOfRange_DominantValueChanged((long) 0x811C0000L),
  BadOutOfRange_DominantValueChanged_DependentValueChanged((long) 0x811D0000L),
  BadEdited_OutOfRange_DominantValueChanged_DependentValueChanged((long) 0x811E0000L),
  GoodCommunicationEvent((long) 0x00A70000L),
  GoodShutdownEvent((long) 0x00A80000L),
  GoodCallAgain((long) 0x00A90000L),
  GoodNonCriticalTimeout((long) 0x00AA0000L),
  BadInvalidArgument((long) 0x80AB0000L),
  BadConnectionRejected((long) 0x80AC0000L),
  BadDisconnect((long) 0x80AD0000L),
  BadConnectionClosed((long) 0x80AE0000L),
  BadInvalidState((long) 0x80AF0000L),
  BadEndOfStream((long) 0x80B00000L),
  BadNoDataAvailable((long) 0x80B10000L),
  BadWaitingForResponse((long) 0x80B20000L),
  BadOperationAbandoned((long) 0x80B30000L),
  BadExpectedStreamToBlock((long) 0x80B40000L),
  BadWouldBlock((long) 0x80B50000L),
  BadSyntaxError((long) 0x80B60000L),
  BadMaxConnectionsReached((long) 0x80B70000L),
  UncertainTransducerInManual((long) 0x42080000L),
  UncertainSimulatedValue((long) 0x42090000L),
  UncertainSensorCalibration((long) 0x420A0000L),
  UncertainConfigurationError((long) 0x420F0000L),
  GoodCascadeInitializationAcknowledged((long) 0x04010000L),
  GoodCascadeInitializationRequest((long) 0x04020000L),
  GoodCascadeNotInvited((long) 0x04030000L),
  GoodCascadeNotSelected((long) 0x04040000L),
  GoodFaultStateActive((long) 0x04070000L),
  GoodInitiateFaultState((long) 0x04080000L),
  GoodCascade((long) 0x04090000L),
  BadDataSetIdInvalid((long) 0x80E70000L);
  private static final Map<Long, OpcuaStatusCode> map;

  static {
    map = new HashMap<>();
    for (OpcuaStatusCode value : OpcuaStatusCode.values()) {
      map.put((long) value.getValue(), value);
    }
  }

  private final long value;

  OpcuaStatusCode(long value) {
    this.value = value;
  }

  public long getValue() {
    return value;
  }

  public static OpcuaStatusCode enumForValue(long value) {
    return map.get(value);
  }

  public static Boolean isDefined(long value) {
    return map.containsKey(value);
  }
}
