/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class HistoryEventFieldList extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "922";
  }

  // Properties.
  protected final int noOfEventFields;
  protected final List<Variant> eventFields;

  public HistoryEventFieldList(int noOfEventFields, List<Variant> eventFields) {
    super();
    this.noOfEventFields = noOfEventFields;
    this.eventFields = eventFields;
  }

  public int getNoOfEventFields() {
    return noOfEventFields;
  }

  public List<Variant> getEventFields() {
    return eventFields;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("HistoryEventFieldList");

    // Simple Field (noOfEventFields)
    writeSimpleField("noOfEventFields", noOfEventFields, writeSignedInt(writeBuffer, 32));

    // Array Field (eventFields)
    writeComplexTypeArrayField("eventFields", eventFields, writeBuffer);

    writeBuffer.popContext("HistoryEventFieldList");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    HistoryEventFieldList _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (noOfEventFields)
    lengthInBits += 32;

    // Array field
    if (eventFields != null) {
      int i = 0;
      for (Variant element : eventFields) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= eventFields.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("HistoryEventFieldList");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int noOfEventFields = readSimpleField("noOfEventFields", readSignedInt(readBuffer, 32));

    List<Variant> eventFields =
        readCountArrayField(
            "eventFields",
            new DataReaderComplexDefault<>(() -> Variant.staticParse(readBuffer), readBuffer),
            noOfEventFields);

    readBuffer.closeContext("HistoryEventFieldList");
    // Create the instance
    return new HistoryEventFieldListBuilderImpl(noOfEventFields, eventFields);
  }

  public static class HistoryEventFieldListBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final int noOfEventFields;
    private final List<Variant> eventFields;

    public HistoryEventFieldListBuilderImpl(int noOfEventFields, List<Variant> eventFields) {
      this.noOfEventFields = noOfEventFields;
      this.eventFields = eventFields;
    }

    public HistoryEventFieldList build() {
      HistoryEventFieldList historyEventFieldList =
          new HistoryEventFieldList(noOfEventFields, eventFields);
      return historyEventFieldList;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof HistoryEventFieldList)) {
      return false;
    }
    HistoryEventFieldList that = (HistoryEventFieldList) o;
    return (getNoOfEventFields() == that.getNoOfEventFields())
        && (getEventFields() == that.getEventFields())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getNoOfEventFields(), getEventFields());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
