/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.opcua.readwrite.OpcuaStatusCode;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class OpcuaMessageError
extends MessagePDU
implements Message {
    protected final String chunk;
    protected final OpcuaStatusCode error;
    protected final PascalString reason;

    @Override
    public String getMessageType() {
        return "ERR";
    }

    @Override
    public Boolean getResponse() {
        return true;
    }

    public OpcuaMessageError(String chunk, OpcuaStatusCode error, PascalString reason) {
        this.chunk = chunk;
        this.error = error;
        this.reason = reason;
    }

    public String getChunk() {
        return this.chunk;
    }

    public OpcuaStatusCode getError() {
        return this.error;
    }

    public PascalString getReason() {
        return this.reason;
    }

    @Override
    protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("OpcuaMessageError", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"chunk", (Object)this.chunk, (DataWriter)DataWriterFactory.writeString((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        int messageSize = this.getLengthInBytes();
        FieldWriterFactory.writeImplicitField((String)"messageSize", (Object)messageSize, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"error", (String)"OpcuaStatusCode", (Object)((Object)this.error), (DataWriter)new DataWriterEnumDefault(OpcuaStatusCode::getValue, Enum::name, DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"reason", (Object)this.reason, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("OpcuaMessageError", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        OpcuaMessageError _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 32;
        lengthInBits += 32;
        return lengthInBits += this.reason.getLengthInBits();
    }

    public static MessagePDU.MessagePDUBuilder staticParseMessagePDUBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("OpcuaMessageError", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        String chunk = (String)FieldReaderFactory.readSimpleField((String)"chunk", (DataReader)DataReaderFactory.readString((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        int messageSize = (Integer)FieldReaderFactory.readImplicitField((String)"messageSize", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        OpcuaStatusCode error = (OpcuaStatusCode)((Object)FieldReaderFactory.readEnumField((String)"error", (String)"OpcuaStatusCode", (DataReader)new DataReaderEnumDefault(OpcuaStatusCode::enumForValue, DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        PascalString reason = (PascalString)FieldReaderFactory.readSimpleField((String)"reason", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("OpcuaMessageError", new WithReaderArgs[0]);
        return new OpcuaMessageErrorBuilderImpl(chunk, error, reason);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaMessageError)) {
            return false;
        }
        OpcuaMessageError that = (OpcuaMessageError)o;
        return this.getChunk() == that.getChunk() && this.getError() == that.getError() && this.getReason() == that.getReason() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getChunk(), this.getError(), this.getReason()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class OpcuaMessageErrorBuilderImpl
    implements MessagePDU.MessagePDUBuilder {
        private final String chunk;
        private final OpcuaStatusCode error;
        private final PascalString reason;

        public OpcuaMessageErrorBuilderImpl(String chunk, OpcuaStatusCode error, PascalString reason) {
            this.chunk = chunk;
            this.error = error;
            this.reason = reason;
        }

        @Override
        public OpcuaMessageError build() {
            OpcuaMessageError opcuaMessageError = new OpcuaMessageError(this.chunk, this.error, this.reason);
            return opcuaMessageError;
        }
    }
}

