/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class Argument
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString name;
    protected final NodeId dataType;
    protected final int valueRank;
    protected final int noOfArrayDimensions;
    protected final List<Long> arrayDimensions;
    protected final LocalizedText description;

    @Override
    public String getIdentifier() {
        return "298";
    }

    public Argument(PascalString name, NodeId dataType, int valueRank, int noOfArrayDimensions, List<Long> arrayDimensions, LocalizedText description) {
        this.name = name;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.noOfArrayDimensions = noOfArrayDimensions;
        this.arrayDimensions = arrayDimensions;
        this.description = description;
    }

    public PascalString getName() {
        return this.name;
    }

    public NodeId getDataType() {
        return this.dataType;
    }

    public int getValueRank() {
        return this.valueRank;
    }

    public int getNoOfArrayDimensions() {
        return this.noOfArrayDimensions;
    }

    public List<Long> getArrayDimensions() {
        return this.arrayDimensions;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("Argument", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"name", (Object)this.name, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"dataType", (Object)this.dataType, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"valueRank", (Object)this.valueRank, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfArrayDimensions", (Object)this.noOfArrayDimensions, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"arrayDimensions", this.arrayDimensions, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"description", (Object)this.description, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("Argument", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        Argument _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.name.getLengthInBits();
        lengthInBits += this.dataType.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.arrayDimensions != null) {
            lengthInBits += 32 * this.arrayDimensions.size();
        }
        return lengthInBits += this.description.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("Argument", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString name = (PascalString)FieldReaderFactory.readSimpleField((String)"name", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        NodeId dataType = (NodeId)FieldReaderFactory.readSimpleField((String)"dataType", (DataReader)new DataReaderComplexDefault(() -> NodeId.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int valueRank = (Integer)FieldReaderFactory.readSimpleField((String)"valueRank", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfArrayDimensions = (Integer)FieldReaderFactory.readSimpleField((String)"noOfArrayDimensions", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List arrayDimensions = FieldReaderFactory.readCountArrayField((String)"arrayDimensions", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (long)noOfArrayDimensions, (WithReaderArgs[])new WithReaderArgs[0]);
        LocalizedText description = (LocalizedText)FieldReaderFactory.readSimpleField((String)"description", (DataReader)new DataReaderComplexDefault(() -> LocalizedText.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("Argument", new WithReaderArgs[0]);
        return new ArgumentBuilderImpl(name, dataType, valueRank, noOfArrayDimensions, arrayDimensions, description);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Argument)) {
            return false;
        }
        Argument that = (Argument)o;
        return this.getName() == that.getName() && this.getDataType() == that.getDataType() && this.getValueRank() == that.getValueRank() && this.getNoOfArrayDimensions() == that.getNoOfArrayDimensions() && this.getArrayDimensions() == that.getArrayDimensions() && this.getDescription() == that.getDescription() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getDataType(), this.getValueRank(), this.getNoOfArrayDimensions(), this.getArrayDimensions(), this.getDescription());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ArgumentBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString name;
        private final NodeId dataType;
        private final int valueRank;
        private final int noOfArrayDimensions;
        private final List<Long> arrayDimensions;
        private final LocalizedText description;

        public ArgumentBuilderImpl(PascalString name, NodeId dataType, int valueRank, int noOfArrayDimensions, List<Long> arrayDimensions, LocalizedText description) {
            this.name = name;
            this.dataType = dataType;
            this.valueRank = valueRank;
            this.noOfArrayDimensions = noOfArrayDimensions;
            this.arrayDimensions = arrayDimensions;
            this.description = description;
        }

        @Override
        public Argument build() {
            Argument argument = new Argument(this.name, this.dataType, this.valueRank, this.noOfArrayDimensions, this.arrayDimensions, this.description);
            return argument;
        }
    }
}

