/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.protocol;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.opcua.context.SecureChannel;
import org.apache.plc4x.java.opcua.protocol.OpcuaProtocolLogic;
import org.apache.plc4x.java.opcua.readwrite.CreateMonitoredItemsRequest;
import org.apache.plc4x.java.opcua.readwrite.CreateMonitoredItemsResponse;
import org.apache.plc4x.java.opcua.readwrite.DataChangeNotification;
import org.apache.plc4x.java.opcua.readwrite.DataValue;
import org.apache.plc4x.java.opcua.readwrite.DeleteSubscriptionsRequest;
import org.apache.plc4x.java.opcua.readwrite.DeleteSubscriptionsResponse;
import org.apache.plc4x.java.opcua.readwrite.ExpandedNodeId;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.MonitoredItemCreateRequest;
import org.apache.plc4x.java.opcua.readwrite.MonitoredItemCreateResult;
import org.apache.plc4x.java.opcua.readwrite.MonitoredItemNotification;
import org.apache.plc4x.java.opcua.readwrite.MonitoringMode;
import org.apache.plc4x.java.opcua.readwrite.MonitoringParameters;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.NodeIdFourByte;
import org.apache.plc4x.java.opcua.readwrite.NotificationMessage;
import org.apache.plc4x.java.opcua.readwrite.OpcuaAPU;
import org.apache.plc4x.java.opcua.readwrite.OpcuaStatusCode;
import org.apache.plc4x.java.opcua.readwrite.PublishRequest;
import org.apache.plc4x.java.opcua.readwrite.PublishResponse;
import org.apache.plc4x.java.opcua.readwrite.QualifiedName;
import org.apache.plc4x.java.opcua.readwrite.ReadValueId;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.opcua.readwrite.ResponseHeader;
import org.apache.plc4x.java.opcua.readwrite.ServiceFault;
import org.apache.plc4x.java.opcua.readwrite.SubscriptionAcknowledgement;
import org.apache.plc4x.java.opcua.readwrite.TimestampsToReturn;
import org.apache.plc4x.java.opcua.tag.OpcuaTag;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionEvent;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.model.DefaultPlcConsumerRegistration;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionHandle;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcuaSubscriptionHandle
extends DefaultPlcSubscriptionHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpcuaSubscriptionHandle.class);
    private final Set<Consumer<PlcSubscriptionEvent>> consumers;
    private final List<String> tagNames;
    private final SecureChannel channel;
    private final PlcSubscriptionRequest subscriptionRequest;
    private final AtomicBoolean destroy = new AtomicBoolean(false);
    private final OpcuaProtocolLogic plcSubscriber;
    private final Long subscriptionId;
    private final long cycleTime;
    private final long revisedCycleTime;
    private boolean complete = false;
    private final AtomicLong clientHandles = new AtomicLong(1L);
    private final ConversationContext<OpcuaAPU> context;

    public OpcuaSubscriptionHandle(ConversationContext<OpcuaAPU> context, OpcuaProtocolLogic plcSubscriber, SecureChannel channel, PlcSubscriptionRequest subscriptionRequest, Long subscriptionId, long cycleTime) {
        super((PlcSubscriber)plcSubscriber);
        this.consumers = new HashSet<Consumer<PlcSubscriptionEvent>>();
        this.subscriptionRequest = subscriptionRequest;
        this.tagNames = new ArrayList<String>(subscriptionRequest.getTagNames());
        this.channel = channel;
        this.subscriptionId = subscriptionId;
        this.plcSubscriber = plcSubscriber;
        this.cycleTime = cycleTime;
        this.revisedCycleTime = cycleTime;
        this.context = context;
        try {
            this.onSubscribeCreateMonitoredItemsRequest().get();
        }
        catch (Exception e) {
            LOGGER.info("Unable to serialize the Create Monitored Item Subscription Message", (Throwable)e);
            plcSubscriber.onDisconnect(context);
        }
        this.startSubscriber();
    }

    private CompletableFuture<CreateMonitoredItemsResponse> onSubscribeCreateMonitoredItemsRequest() {
        ArrayList<ExtensionObjectDefinition> requestList = new ArrayList<ExtensionObjectDefinition>(this.tagNames.size());
        for (String tagName : this.tagNames) {
            MonitoringMode monitoringMode;
            DefaultPlcSubscriptionTag tagDefaultPlcSubscription = (DefaultPlcSubscriptionTag)this.subscriptionRequest.getTag(tagName);
            NodeId idNode = OpcuaProtocolLogic.generateNodeId((OpcuaTag)tagDefaultPlcSubscription.getTag());
            ReadValueId readValueId = new ReadValueId(idNode, 13L, OpcuaProtocolLogic.NULL_STRING, new QualifiedName(0, OpcuaProtocolLogic.NULL_STRING));
            switch (tagDefaultPlcSubscription.getPlcSubscriptionType()) {
                case CYCLIC: {
                    monitoringMode = MonitoringMode.monitoringModeSampling;
                    break;
                }
                case CHANGE_OF_STATE: {
                    monitoringMode = MonitoringMode.monitoringModeReporting;
                    break;
                }
                case EVENT: {
                    monitoringMode = MonitoringMode.monitoringModeReporting;
                    break;
                }
                default: {
                    monitoringMode = MonitoringMode.monitoringModeReporting;
                }
            }
            long clientHandle = this.clientHandles.getAndIncrement();
            MonitoringParameters parameters = new MonitoringParameters(clientHandle, this.cycleTime, OpcuaProtocolLogic.NULL_EXTENSION_OBJECT, 1L, true);
            MonitoredItemCreateRequest request = new MonitoredItemCreateRequest(readValueId, monitoringMode, parameters);
            requestList.add(request);
        }
        CompletableFuture<CreateMonitoredItemsResponse> future = new CompletableFuture<CreateMonitoredItemsResponse>();
        RequestHeader requestHeader = new RequestHeader(this.channel.getAuthenticationToken(), SecureChannel.getCurrentDateTime(), this.channel.getRequestHandle(), 0L, OpcuaProtocolLogic.NULL_STRING, 10000L, OpcuaProtocolLogic.NULL_EXTENSION_OBJECT);
        CreateMonitoredItemsRequest createMonitoredItemsRequest = new CreateMonitoredItemsRequest(requestHeader, this.subscriptionId, TimestampsToReturn.timestampsToReturnBoth, requestList.size(), requestList);
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(createMonitoredItemsRequest.getIdentifier())), null, null);
        ExtensionObject extObject = new ExtensionObject(expandedNodeId, null, createMonitoredItemsRequest);
        try {
            WriteBufferByteBased buffer = new WriteBufferByteBased(extObject.getLengthInBytes(), ByteOrder.LITTLE_ENDIAN);
            extObject.serialize((WriteBuffer)buffer);
            Consumer<byte[]> consumer = opcuaResponse -> {
                CreateMonitoredItemsResponse responseMessage = null;
                try {
                    ExtensionObjectDefinition unknownExtensionObject = ExtensionObject.staticParse((ReadBuffer)new ReadBufferByteBased(opcuaResponse, ByteOrder.LITTLE_ENDIAN), false).getBody();
                    if (unknownExtensionObject instanceof CreateMonitoredItemsResponse) {
                        responseMessage = (CreateMonitoredItemsResponse)unknownExtensionObject;
                    } else {
                        ServiceFault serviceFault = (ServiceFault)unknownExtensionObject;
                        ResponseHeader header = (ResponseHeader)serviceFault.getResponseHeader();
                        LOGGER.error("Subscription ServiceFault returned from server with error code,  '{}'", (Object)header.getServiceResult().toString());
                        this.plcSubscriber.onDisconnect(this.context);
                    }
                }
                catch (ParseException e) {
                    LOGGER.error("Unable to parse the returned Subscription response", (Throwable)e);
                    this.plcSubscriber.onDisconnect(this.context);
                }
                MonitoredItemCreateResult[] array = responseMessage.getResults().toArray(new MonitoredItemCreateResult[0]);
                int index = 0;
                int arrayLength = array.length;
                while (index < arrayLength) {
                    MonitoredItemCreateResult result = array[index];
                    if (OpcuaStatusCode.enumForValue(result.getStatusCode().getStatusCode()) != OpcuaStatusCode.Good) {
                        LOGGER.error("Invalid Tag {}, subscription created without this tag", (Object)this.tagNames.get(index));
                    } else {
                        LOGGER.debug("Tag {} was added to the subscription", (Object)this.tagNames.get(index));
                    }
                    ++index;
                }
                future.complete(responseMessage);
            };
            Consumer<TimeoutException> timeout = e -> {
                LOGGER.info("Timeout while sending the Create Monitored Item Subscription Message", (Throwable)e);
                this.plcSubscriber.onDisconnect(this.context);
            };
            BiConsumer<OpcuaAPU, Throwable> error = (message, e) -> {
                LOGGER.info("Error while sending the Create Monitored Item Subscription Message", e);
                this.plcSubscriber.onDisconnect(this.context);
            };
            this.channel.submit(this.context, timeout, error, consumer, buffer);
        }
        catch (SerializationException e2) {
            LOGGER.info("Unable to serialize the Create Monitored Item Subscription Message", (Throwable)e2);
            this.plcSubscriber.onDisconnect(this.context);
        }
        return future;
    }

    private void sleep(long length) {
        try {
            Thread.sleep(length);
        }
        catch (InterruptedException e) {
            LOGGER.trace("Interrupted Exception");
        }
    }

    public void startSubscriber() {
        LOGGER.trace("Starting Subscription");
        CompletableFuture.supplyAsync(() -> {
            try {
                LinkedList outstandingAcknowledgements = new LinkedList();
                LinkedList<Long> outstandingRequests = new LinkedList<Long>();
                while (!this.destroy.get()) {
                    long requestHandle = this.channel.getRequestHandle();
                    if (outstandingRequests.size() <= 1) {
                        RequestHeader requestHeader = new RequestHeader(this.channel.getAuthenticationToken(), SecureChannel.getCurrentDateTime(), requestHandle, 0L, OpcuaProtocolLogic.NULL_STRING, this.revisedCycleTime * 10L, OpcuaProtocolLogic.NULL_EXTENSION_OBJECT);
                        LinkedList acks = (LinkedList)outstandingAcknowledgements.clone();
                        int ackLength = acks.size() == 0 ? -1 : acks.size();
                        outstandingAcknowledgements.removeAll(acks);
                        PublishRequest publishRequest = new PublishRequest(requestHeader, ackLength, acks);
                        ExpandedNodeId extExpandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(publishRequest.getIdentifier())), null, null);
                        ExtensionObject extObject = new ExtensionObject(extExpandedNodeId, null, publishRequest);
                        try {
                            WriteBufferByteBased buffer = new WriteBufferByteBased(extObject.getLengthInBytes(), ByteOrder.LITTLE_ENDIAN);
                            extObject.serialize((WriteBuffer)buffer);
                            Consumer<byte[]> consumer = opcuaResponse -> {
                                PublishResponse responseMessage = null;
                                ServiceFault serviceFault = null;
                                try {
                                    ExtensionObjectDefinition unknownExtensionObject = ExtensionObject.staticParse((ReadBuffer)new ReadBufferByteBased(opcuaResponse, ByteOrder.LITTLE_ENDIAN), false).getBody();
                                    if (unknownExtensionObject instanceof PublishResponse) {
                                        responseMessage = (PublishResponse)unknownExtensionObject;
                                    } else {
                                        serviceFault = (ServiceFault)unknownExtensionObject;
                                        ResponseHeader header = (ResponseHeader)serviceFault.getResponseHeader();
                                        LOGGER.debug("Subscription ServiceFault returned from server with error code,  '{}', ignoring as it is probably just a result of a Delete Subscription Request", (Object)header.getServiceResult().toString());
                                    }
                                }
                                catch (ParseException e) {
                                    LOGGER.error("Unable to parse the returned Subscription response", (Throwable)e);
                                    this.plcSubscriber.onDisconnect(this.context);
                                }
                                if (serviceFault == null) {
                                    outstandingRequests.remove(((ResponseHeader)responseMessage.getResponseHeader()).getRequestHandle());
                                    for (long availableSequenceNumber : responseMessage.getAvailableSequenceNumbers()) {
                                        outstandingAcknowledgements.add(new SubscriptionAcknowledgement(this.subscriptionId, availableSequenceNumber));
                                    }
                                    for (ExtensionObject notificationMessage : ((NotificationMessage)responseMessage.getNotificationMessage()).getNotificationData()) {
                                        ExtensionObjectDefinition notification = notificationMessage.getBody();
                                        if (notification instanceof DataChangeNotification) {
                                            LOGGER.trace("Found a Data Change notification");
                                            List<ExtensionObjectDefinition> items = ((DataChangeNotification)notification).getMonitoredItems();
                                            this.onSubscriptionValue(items.toArray(new MonitoredItemNotification[0]));
                                            continue;
                                        }
                                        LOGGER.warn("Unsupported Notification type");
                                    }
                                }
                            };
                            Consumer<TimeoutException> timeout = e -> {
                                LOGGER.error("Timeout while waiting for subscription response", (Throwable)e);
                                this.plcSubscriber.onDisconnect(this.context);
                            };
                            BiConsumer<OpcuaAPU, Throwable> error = (message, e) -> {
                                LOGGER.error("Error while waiting for subscription response", e);
                                this.plcSubscriber.onDisconnect(this.context);
                            };
                            outstandingRequests.add(requestHandle);
                            this.channel.submit(this.context, timeout, error, consumer, buffer);
                        }
                        catch (SerializationException e2) {
                            LOGGER.warn("Unable to serialize subscription request", (Throwable)e2);
                        }
                    }
                    this.sleep(this.revisedCycleTime);
                }
                this.complete = true;
            }
            catch (Exception e3) {
                LOGGER.error("Failed to start subscription", (Throwable)e3);
            }
            return null;
        });
    }

    public void stopSubscriber() {
        this.destroy.set(true);
        long requestHandle = this.channel.getRequestHandle();
        RequestHeader requestHeader = new RequestHeader(this.channel.getAuthenticationToken(), SecureChannel.getCurrentDateTime(), requestHandle, 0L, OpcuaProtocolLogic.NULL_STRING, this.revisedCycleTime * 10L, OpcuaProtocolLogic.NULL_EXTENSION_OBJECT);
        ArrayList<Long> subscriptions = new ArrayList<Long>(1);
        subscriptions.add(this.subscriptionId);
        DeleteSubscriptionsRequest deleteSubscriptionrequest = new DeleteSubscriptionsRequest(requestHeader, 1, subscriptions);
        ExpandedNodeId extExpandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(deleteSubscriptionrequest.getIdentifier())), null, null);
        ExtensionObject extObject = new ExtensionObject(extExpandedNodeId, null, deleteSubscriptionrequest);
        try {
            WriteBufferByteBased buffer = new WriteBufferByteBased(extObject.getLengthInBytes(), ByteOrder.LITTLE_ENDIAN);
            extObject.serialize((WriteBuffer)buffer);
            Consumer<byte[]> consumer = opcuaResponse -> {
                DeleteSubscriptionsResponse responseMessage = null;
                try {
                    ExtensionObjectDefinition unknownExtensionObject = ExtensionObject.staticParse((ReadBuffer)new ReadBufferByteBased(opcuaResponse, ByteOrder.LITTLE_ENDIAN), false).getBody();
                    if (unknownExtensionObject instanceof DeleteSubscriptionsResponse) {
                        responseMessage = (DeleteSubscriptionsResponse)unknownExtensionObject;
                    } else {
                        ServiceFault serviceFault = (ServiceFault)unknownExtensionObject;
                        ResponseHeader header = (ResponseHeader)serviceFault.getResponseHeader();
                        LOGGER.debug("Fault when deleting Subscription ServiceFault return from server with error code,  '{}', ignoring as it is probably just a result of a Delete Subscription Request", (Object)header.getServiceResult().toString());
                    }
                }
                catch (ParseException e) {
                    LOGGER.error("Unable to parse the returned Delete Subscriptions Response", (Throwable)e);
                }
            };
            Consumer<TimeoutException> timeout = e -> {
                LOGGER.error("Timeout while waiting for delete subscription response", (Throwable)e);
                this.plcSubscriber.onDisconnect(this.context);
            };
            BiConsumer<OpcuaAPU, Throwable> error = (message, e) -> {
                LOGGER.error("Error while waiting for delete subscription response", e);
                this.plcSubscriber.onDisconnect(this.context);
            };
            this.channel.submit(this.context, timeout, error, consumer, buffer);
        }
        catch (SerializationException e2) {
            LOGGER.warn("Unable to serialize subscription request", (Throwable)e2);
        }
        this.sleep(500L);
        this.plcSubscriber.removeSubscription(this.subscriptionId);
    }

    private void onSubscriptionValue(MonitoredItemNotification[] values) {
        LinkedHashSet<String> tagNameList = new LinkedHashSet<String>();
        ArrayList<DataValue> dataValues = new ArrayList<DataValue>(values.length);
        MonitoredItemNotification[] monitoredItemNotificationArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            MonitoredItemNotification value = monitoredItemNotificationArray[n2];
            tagNameList.add(this.tagNames.get((int)value.getClientHandle() - 1));
            dataValues.add(value.getValue());
            ++n2;
        }
        Map<String, ResponseItem<PlcValue>> tags = this.plcSubscriber.readResponse(tagNameList, dataValues);
        DefaultPlcSubscriptionEvent event = new DefaultPlcSubscriptionEvent(Instant.now(), tags);
        this.consumers.forEach(arg_0 -> OpcuaSubscriptionHandle.lambda$10((PlcSubscriptionEvent)event, arg_0));
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer) {
        LOGGER.info("Registering a new OPCUA subscription consumer");
        this.consumers.add(consumer);
        return new DefaultPlcConsumerRegistration((PlcSubscriber)this.plcSubscriber, consumer, new PlcSubscriptionHandle[]{this});
    }

    private static /* synthetic */ void lambda$10(PlcSubscriptionEvent plcSubscriptionEvent, Consumer plcSubscriptionEventConsumer) {
        plcSubscriptionEventConsumer.accept(plcSubscriptionEvent);
    }
}

