/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.context;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.opcua.context.SecureChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureChannelTransactionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureChannel.class);
    public static final int DEFAULT_MAX_REQUEST_ID = -1;
    private final AtomicInteger transactionIdentifierGenerator = new AtomicInteger(0);
    private final AtomicInteger requestIdentifierGenerator = new AtomicInteger(0);
    private final AtomicInteger activeTransactionId = new AtomicInteger(0);
    private final Map<Integer, Transaction> queue = new HashMap<Integer, Transaction>();

    public synchronized void submit(Consumer<Integer> onSend, Integer transactionId) {
        LOGGER.info("Active transaction Number {}", (Object)this.activeTransactionId.get());
        if (this.activeTransactionId.get() == transactionId.intValue()) {
            onSend.accept(transactionId);
            int newTransactionId = this.getActiveTransactionIdentifier();
            if (!this.queue.isEmpty()) {
                Transaction t = this.queue.remove(newTransactionId);
                if (t == null) {
                    LOGGER.info("Length of Queue is {}", (Object)this.queue.size());
                    LOGGER.info("Transaction ID is {}", (Object)newTransactionId);
                    LOGGER.info("Map  is {}", this.queue);
                    throw new PlcRuntimeException("Transaction Id not found in queued messages {}");
                }
                this.submit(t.getConsumer(), t.getTransactionId());
            }
        } else {
            LOGGER.info("Storing out of order transaction {}", (Object)transactionId);
            this.queue.put(transactionId, new Transaction(onSend, transactionId));
        }
    }

    public int getTransactionIdentifier() {
        int transactionId = this.transactionIdentifierGenerator.getAndIncrement();
        if (this.transactionIdentifierGenerator.get() == -1) {
            this.transactionIdentifierGenerator.set(1);
        }
        return transactionId;
    }

    private int getActiveTransactionIdentifier() {
        int transactionId = this.activeTransactionId.incrementAndGet();
        if (this.activeTransactionId.get() == -1) {
            this.activeTransactionId.set(1);
        }
        return transactionId;
    }

    public static class Transaction {
        private final Integer transactionId;
        private final Consumer<Integer> consumer;

        public Transaction(Consumer<Integer> consumer, Integer transactionId) {
            this.consumer = consumer;
            this.transactionId = transactionId;
        }

        public Integer getTransactionId() {
            return this.transactionId;
        }

        public Consumer<Integer> getConsumer() {
            return this.consumer;
        }
    }
}

