/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.context;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.authentication.PlcUsernamePasswordAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.opcua.config.OpcuaConfiguration;
import org.apache.plc4x.java.opcua.context.CertificateKeyPair;
import org.apache.plc4x.java.opcua.context.EncryptionHandler;
import org.apache.plc4x.java.opcua.context.OpcuaDriverContext;
import org.apache.plc4x.java.opcua.context.SecureChannelTransactionManager;
import org.apache.plc4x.java.opcua.readwrite.ActivateSessionRequest;
import org.apache.plc4x.java.opcua.readwrite.ActivateSessionResponse;
import org.apache.plc4x.java.opcua.readwrite.AnonymousIdentityToken;
import org.apache.plc4x.java.opcua.readwrite.ApplicationDescription;
import org.apache.plc4x.java.opcua.readwrite.ApplicationType;
import org.apache.plc4x.java.opcua.readwrite.ChannelSecurityToken;
import org.apache.plc4x.java.opcua.readwrite.CloseSecureChannelRequest;
import org.apache.plc4x.java.opcua.readwrite.CloseSessionRequest;
import org.apache.plc4x.java.opcua.readwrite.CloseSessionResponse;
import org.apache.plc4x.java.opcua.readwrite.CreateSessionRequest;
import org.apache.plc4x.java.opcua.readwrite.CreateSessionResponse;
import org.apache.plc4x.java.opcua.readwrite.EndpointDescription;
import org.apache.plc4x.java.opcua.readwrite.ExpandedNodeId;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectEncodingMask;
import org.apache.plc4x.java.opcua.readwrite.GetEndpointsRequest;
import org.apache.plc4x.java.opcua.readwrite.GetEndpointsResponse;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.MessageSecurityMode;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.NodeIdFourByte;
import org.apache.plc4x.java.opcua.readwrite.NodeIdTwoByte;
import org.apache.plc4x.java.opcua.readwrite.NodeIdTypeDefinition;
import org.apache.plc4x.java.opcua.readwrite.NullExtension;
import org.apache.plc4x.java.opcua.readwrite.OpcuaAPU;
import org.apache.plc4x.java.opcua.readwrite.OpcuaAcknowledgeResponse;
import org.apache.plc4x.java.opcua.readwrite.OpcuaCloseRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaHelloRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaMessageRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaMessageResponse;
import org.apache.plc4x.java.opcua.readwrite.OpcuaOpenRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaOpenResponse;
import org.apache.plc4x.java.opcua.readwrite.OpcuaStatusCode;
import org.apache.plc4x.java.opcua.readwrite.OpenSecureChannelRequest;
import org.apache.plc4x.java.opcua.readwrite.OpenSecureChannelResponse;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.opcua.readwrite.ResponseHeader;
import org.apache.plc4x.java.opcua.readwrite.SecurityTokenRequestType;
import org.apache.plc4x.java.opcua.readwrite.ServiceFault;
import org.apache.plc4x.java.opcua.readwrite.SignatureData;
import org.apache.plc4x.java.opcua.readwrite.UserIdentityToken;
import org.apache.plc4x.java.opcua.readwrite.UserNameIdentityToken;
import org.apache.plc4x.java.opcua.readwrite.UserTokenPolicy;
import org.apache.plc4x.java.opcua.readwrite.UserTokenType;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureChannel.class);
    private static final String FINAL_CHUNK = "F";
    private static final String CONTINUATION_CHUNK = "C";
    private static final String ABORT_CHUNK = "A";
    private static final int VERSION = 0;
    private static final int DEFAULT_MAX_CHUNK_COUNT = 64;
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 0x200000;
    private static final int DEFAULT_RECEIVE_BUFFER_SIZE = 65535;
    private static final int DEFAULT_SEND_BUFFER_SIZE = 65535;
    public static final Duration REQUEST_TIMEOUT = Duration.ofMillis(10000L);
    public static final long REQUEST_TIMEOUT_LONG = 10000L;
    private static final String PASSWORD_ENCRYPTION_ALGORITHM = "http://www.w3.org/2001/04/xmlenc#rsa-oaep";
    private static final PascalString SECURITY_POLICY_NONE = new PascalString("http://opcfoundation.org/UA/SecurityPolicy#None");
    protected static final PascalString NULL_STRING = new PascalString("");
    private static final PascalByteString NULL_BYTE_STRING = new PascalByteString(-1, null);
    private static final ExpandedNodeId NULL_EXPANDED_NODE_ID = new ExpandedNodeId(false, false, new NodeIdTwoByte(0), null, null);
    protected static final ExtensionObject NULL_EXTENSION_OBJECT = new ExtensionObject(NULL_EXPANDED_NODE_ID, new ExtensionObjectEncodingMask(false, false, false), new NullExtension());
    public static final Pattern INET_ADDRESS_PATTERN = Pattern.compile("(.(?<transportCode>tcp))?://(?<transportHost>[\\w.-]+)(:(?<transportPort>\\d*))?");
    public static final Pattern URI_PATTERN = Pattern.compile("^(?<protocolCode>opc)" + INET_ADDRESS_PATTERN + "(?<transportEndpoint>[\\w/=]*)[?]?");
    private static final long EPOCH_OFFSET = 116444736000000000L;
    private static final PascalString APPLICATION_URI = new PascalString("urn:apache:plc4x:client");
    private static final PascalString PRODUCT_URI = new PascalString("urn:apache:plc4x:client");
    private static final PascalString APPLICATION_TEXT = new PascalString("OPCUA client for the Apache PLC4X:PLC4J project");
    private static final long DEFAULT_CONNECTION_LIFETIME = 36000000L;
    private final String sessionName = "UaSession:" + APPLICATION_TEXT.getStringValue() + ":" + RandomStringUtils.random((int)20, (boolean)true, (boolean)true);
    private final byte[] clientNonce = RandomUtils.nextBytes((int)40);
    private final AtomicInteger requestHandleGenerator = new AtomicInteger(1);
    private PascalString policyId;
    private UserTokenType tokenType;
    private final PascalString endpoint;
    private final String username;
    private final String password;
    private final String securityPolicy;
    private final PascalByteString publicCertificate;
    private final PascalByteString thumbprint;
    private final boolean isEncrypted;
    private byte[] senderCertificate = null;
    private byte[] senderNonce = null;
    private final EncryptionHandler encryptionHandler;
    private final OpcuaConfiguration configuration;
    private final OpcuaDriverContext driverContext;
    private final AtomicInteger channelId = new AtomicInteger(1);
    private final AtomicInteger tokenId = new AtomicInteger(1);
    private NodeIdTypeDefinition authenticationToken = new NodeIdTwoByte(0);
    private ConversationContext<OpcuaAPU> context;
    private final SecureChannelTransactionManager channelTransactionManager = new SecureChannelTransactionManager();
    private long lifetime = 36000000L;
    private CompletableFuture<Void> keepAlive;
    private final List<String> endpoints = new ArrayList<String>();
    private final AtomicLong senderSequenceNumber = new AtomicLong();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SecureChannel(OpcuaDriverContext driverContext, OpcuaConfiguration configuration, PlcAuthentication authentication) {
        this.configuration = configuration;
        this.driverContext = driverContext;
        this.endpoint = new PascalString(driverContext.getEndpoint());
        if (authentication != null) {
            if (!(authentication instanceof PlcUsernamePasswordAuthentication)) throw new PlcRuntimeException("This type of connection only supports username-password authentication");
            this.username = ((PlcUsernamePasswordAuthentication)authentication).getUsername();
            this.password = ((PlcUsernamePasswordAuthentication)authentication).getPassword();
        } else {
            this.username = configuration.getUsername();
            this.password = configuration.getPassword();
        }
        this.securityPolicy = "http://opcfoundation.org/UA/SecurityPolicy#" + configuration.getSecurityPolicy();
        CertificateKeyPair ckp = driverContext.getCertificateKeyPair();
        if (configuration.getSecurityPolicy() != null && configuration.getSecurityPolicy().equals("Basic256Sha256")) {
            this.senderCertificate = driverContext.getSenderCertificate();
            this.encryptionHandler = new EncryptionHandler(ckp, this.senderCertificate, configuration.getSecurityPolicy());
            try {
                this.publicCertificate = new PascalByteString(ckp.getCertificate().getEncoded().length, ckp.getCertificate().getEncoded());
                this.isEncrypted = true;
            }
            catch (CertificateEncodingException e) {
                throw new PlcRuntimeException("Failed to encode the certificate");
            }
            this.thumbprint = driverContext.getThumbprint();
        } else {
            this.encryptionHandler = new EncryptionHandler(ckp, this.senderCertificate, configuration.getSecurityPolicy());
            this.publicCertificate = NULL_BYTE_STRING;
            this.thumbprint = NULL_BYTE_STRING;
            this.isEncrypted = false;
        }
        try {
            InetAddress address = InetAddress.getByName(driverContext.getHost());
            this.endpoints.add(address.getHostAddress());
            this.endpoints.add(address.getHostName());
            this.endpoints.add(address.getCanonicalHostName());
            return;
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unable to resolve host name. Using original host from connection string which may cause issues connecting to server");
            this.endpoints.add(driverContext.getHost());
        }
    }

    public void submit(ConversationContext<OpcuaAPU> context, Consumer<TimeoutException> onTimeout, BiConsumer<OpcuaAPU, Throwable> error, Consumer<byte[]> consumer, WriteBufferByteBased buffer) {
        OpcuaAPU apu;
        int transactionId = this.channelTransactionManager.getTransactionIdentifier();
        OpcuaMessageRequest messageRequest = new OpcuaMessageRequest(FINAL_CHUNK, this.channelId.get(), this.tokenId.get(), transactionId, transactionId, buffer.getBytes());
        try {
            apu = this.isEncrypted ? OpcuaAPU.staticParse(this.encryptionHandler.encodeMessage(messageRequest, buffer.getBytes()), false) : new OpcuaAPU(messageRequest);
        }
        catch (ParseException e) {
            throw new PlcRuntimeException("Unable to encrypt message before sending");
        }
        Consumer<Integer> requestConsumer = t -> {
            try {
                ByteArrayOutputStream messageBuffer = new ByteArrayOutputStream();
                context.sendRequest((Object)apu).expectResponse(OpcuaAPU.class, REQUEST_TIMEOUT).onTimeout(onTimeout).onError(error).unwrap(this.encryptionHandler::decodeMessage).unwrap(OpcuaAPU::getMessage).check(OpcuaMessageResponse.class::isInstance).unwrap(OpcuaMessageResponse.class::cast).check(p -> {
                    if (p.getRequestId() == transactionId) {
                        try {
                            messageBuffer.write(p.getMessage());
                            if (this.senderSequenceNumber.incrementAndGet() != (long)p.getSequenceNumber()) {
                                LOGGER.error("Sequence number isn't as expected, we might have missed a packet. - {} != {}", (Object)this.senderSequenceNumber.incrementAndGet(), (Object)p.getSequenceNumber());
                                context.fireDisconnected();
                            }
                        }
                        catch (IOException e) {
                            LOGGER.debug("Failed to store incoming message in buffer");
                            throw new PlcRuntimeException("Error while sending message");
                        }
                        return p.getChunk().equals(FINAL_CHUNK);
                    }
                    return false;
                }).handle(opcuaResponse -> {
                    if (opcuaResponse.getChunk().equals(FINAL_CHUNK)) {
                        this.tokenId.set(opcuaResponse.getSecureTokenId());
                        this.channelId.set(opcuaResponse.getSecureChannelId());
                        consumer.accept(messageBuffer.toByteArray());
                    }
                });
            }
            catch (Exception e) {
                throw new PlcRuntimeException("Error while sending message");
            }
        };
        LOGGER.debug("Submitting Transaction to TransactionManager {}", (Object)transactionId);
        this.channelTransactionManager.submit(requestConsumer, transactionId);
    }

    public void onConnect(ConversationContext<OpcuaAPU> context) {
        LOGGER.debug("Opcua Driver running in ACTIVE mode.");
        this.context = context;
        OpcuaHelloRequest hello = new OpcuaHelloRequest(FINAL_CHUNK, 0, 65535, 65535, 0x200000, 64, this.endpoint);
        Consumer<Integer> requestConsumer = t -> {
            ConversationContext.ContextHandler contextHandler = context.sendRequest((Object)new OpcuaAPU(hello)).expectResponse(OpcuaAPU.class, REQUEST_TIMEOUT).check(p -> p.getMessage() instanceof OpcuaAcknowledgeResponse).unwrap(p -> (OpcuaAcknowledgeResponse)p.getMessage()).handle(opcuaAcknowledgeResponse -> this.onConnectOpenSecureChannel(context, (OpcuaAcknowledgeResponse)opcuaAcknowledgeResponse));
        };
        this.channelTransactionManager.submit(requestConsumer, this.channelTransactionManager.getTransactionIdentifier());
    }

    public void onConnectOpenSecureChannel(ConversationContext<OpcuaAPU> context, OpcuaAcknowledgeResponse opcuaAcknowledgeResponse) {
        int transactionId = this.channelTransactionManager.getTransactionIdentifier();
        RequestHeader requestHeader = new RequestHeader(new NodeId(this.authenticationToken), SecureChannel.getCurrentDateTime(), 0L, 0L, NULL_STRING, 10000L, NULL_EXTENSION_OBJECT);
        OpenSecureChannelRequest openSecureChannelRequest = this.isEncrypted ? new OpenSecureChannelRequest(requestHeader, 0L, SecurityTokenRequestType.securityTokenRequestTypeIssue, MessageSecurityMode.messageSecurityModeSignAndEncrypt, new PascalByteString(this.clientNonce.length, this.clientNonce), this.lifetime) : new OpenSecureChannelRequest(requestHeader, 0L, SecurityTokenRequestType.securityTokenRequestTypeIssue, MessageSecurityMode.messageSecurityModeNone, NULL_BYTE_STRING, this.lifetime);
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(openSecureChannelRequest.getIdentifier())), null, null);
        ExtensionObject extObject = new ExtensionObject(expandedNodeId, null, openSecureChannelRequest);
        try {
            WriteBufferByteBased buffer = new WriteBufferByteBased(extObject.getLengthInBytes(), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
            extObject.serialize((WriteBuffer)buffer);
            OpcuaOpenRequest openRequest = new OpcuaOpenRequest(FINAL_CHUNK, 0, new PascalString(this.securityPolicy), this.publicCertificate, this.thumbprint, transactionId, transactionId, buffer.getBytes());
            OpcuaAPU apu = this.isEncrypted ? OpcuaAPU.staticParse(this.encryptionHandler.encodeMessage(openRequest, buffer.getBytes()), false) : new OpcuaAPU(openRequest);
            Consumer<Integer> requestConsumer = t -> {
                ConversationContext.ContextHandler contextHandler = context.sendRequest((Object)apu).expectResponse(OpcuaAPU.class, REQUEST_TIMEOUT).unwrap(apuMessage -> this.encryptionHandler.decodeMessage((OpcuaAPU)apuMessage)).check(p -> p.getMessage() instanceof OpcuaOpenResponse).unwrap(p -> (OpcuaOpenResponse)p.getMessage()).check(p -> p.getRequestId() == transactionId).handle(opcuaOpenResponse -> {
                    try {
                        ReadBufferByteBased readBuffer = new ReadBufferByteBased(opcuaOpenResponse.getMessage(), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
                        ExtensionObject message = ExtensionObject.staticParse((ReadBuffer)readBuffer, false);
                        this.senderSequenceNumber.set(opcuaOpenResponse.getSequenceNumber());
                        if (message.getBody() instanceof ServiceFault) {
                            ServiceFault fault = (ServiceFault)message.getBody();
                            LOGGER.error("Failed to connect to opc ua server for the following reason:- {}, {}", (Object)((ResponseHeader)fault.getResponseHeader()).getServiceResult().getStatusCode(), (Object)OpcuaStatusCode.enumForValue(((ResponseHeader)fault.getResponseHeader()).getServiceResult().getStatusCode()));
                        } else {
                            LOGGER.debug("Got Secure Response Connection Response");
                            try {
                                OpenSecureChannelResponse openSecureChannelResponse = (OpenSecureChannelResponse)message.getBody();
                                ChannelSecurityToken securityToken = (ChannelSecurityToken)openSecureChannelResponse.getSecurityToken();
                                this.tokenId.set((int)securityToken.getTokenId());
                                this.channelId.set((int)securityToken.getChannelId());
                                this.onConnectCreateSessionRequest(context);
                            }
                            catch (PlcConnectionException e) {
                                LOGGER.error("Error occurred while connecting to OPC UA server", (Throwable)e);
                            }
                        }
                    }
                    catch (ParseException e) {
                        LOGGER.error("Error parsing", (Throwable)e);
                    }
                });
            };
            LOGGER.debug("Submitting OpenSecureChannel with id of {}", (Object)transactionId);
            this.channelTransactionManager.submit(requestConsumer, transactionId);
        }
        catch (ParseException | SerializationException e) {
            LOGGER.error("Unable to to Parse Open Secure Request");
        }
    }

    public void onConnectCreateSessionRequest(ConversationContext<OpcuaAPU> context) throws PlcConnectionException {
        RequestHeader requestHeader = new RequestHeader(new NodeId(this.authenticationToken), SecureChannel.getCurrentDateTime(), 0L, 0L, NULL_STRING, 10000L, NULL_EXTENSION_OBJECT);
        LocalizedText applicationName = new LocalizedText(true, true, new PascalString("en"), APPLICATION_TEXT);
        int noOfDiscoveryUrls = -1;
        ArrayList<PascalString> discoveryUrls = new ArrayList<PascalString>(0);
        ApplicationDescription clientDescription = new ApplicationDescription(APPLICATION_URI, PRODUCT_URI, applicationName, ApplicationType.applicationTypeClient, NULL_STRING, NULL_STRING, noOfDiscoveryUrls, discoveryUrls);
        CreateSessionRequest createSessionRequest = new CreateSessionRequest(requestHeader, clientDescription, NULL_STRING, this.endpoint, new PascalString(this.sessionName), new PascalByteString(this.clientNonce.length, this.clientNonce), NULL_BYTE_STRING, 120000.0, 0L);
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(createSessionRequest.getIdentifier())), null, null);
        ExtensionObject extObject = new ExtensionObject(expandedNodeId, null, createSessionRequest);
        try {
            WriteBufferByteBased buffer = new WriteBufferByteBased(extObject.getLengthInBytes(), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
            extObject.serialize((WriteBuffer)buffer);
            Consumer<byte[]> consumer = opcuaResponse -> {
                block7: {
                    try {
                        ExtensionObject message = ExtensionObject.staticParse((ReadBuffer)new ReadBufferByteBased(opcuaResponse, org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN), false);
                        if (message.getBody() instanceof ServiceFault) {
                            ServiceFault fault = (ServiceFault)message.getBody();
                            LOGGER.error("Failed to connect to opc ua server for the following reason:- {}, {}", (Object)((ResponseHeader)fault.getResponseHeader()).getServiceResult().getStatusCode(), (Object)OpcuaStatusCode.enumForValue(((ResponseHeader)fault.getResponseHeader()).getServiceResult().getStatusCode()));
                            break block7;
                        }
                        LOGGER.debug("Got Create Session Response Connection Response");
                        try {
                            ExtensionObjectDefinition unknownExtensionObject = ExtensionObject.staticParse((ReadBuffer)new ReadBufferByteBased(opcuaResponse, org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN), false).getBody();
                            if (unknownExtensionObject instanceof CreateSessionResponse) {
                                CreateSessionResponse responseMessage = (CreateSessionResponse)unknownExtensionObject;
                                this.authenticationToken = responseMessage.getAuthenticationToken().getNodeId();
                                this.onConnectActivateSessionRequest(context, responseMessage, (CreateSessionResponse)message.getBody());
                                break block7;
                            }
                            ServiceFault serviceFault = (ServiceFault)unknownExtensionObject;
                            ResponseHeader header = (ResponseHeader)serviceFault.getResponseHeader();
                            LOGGER.error("Subscription ServiceFault returned from server with error code,  '{}'", (Object)header.getServiceResult().toString());
                        }
                        catch (PlcConnectionException e) {
                            LOGGER.error("Error occurred while connecting to OPC UA server");
                        }
                        catch (ParseException e) {
                            LOGGER.error("Unable to parse the returned Subscription response", (Throwable)e);
                        }
                    }
                    catch (ParseException e) {
                        LOGGER.error("Error parsing", (Throwable)e);
                    }
                }
            };
            Consumer<TimeoutException> timeout = e -> LOGGER.error("Timeout while waiting for subscription response", (Throwable)e);
            BiConsumer<OpcuaAPU, Throwable> error = (message, e) -> LOGGER.error("Error while waiting for subscription response", e);
            this.submit(context, timeout, error, consumer, buffer);
        }
        catch (SerializationException e2) {
            LOGGER.error("Unable to to Parse Create Session Request");
        }
    }

    private void onConnectActivateSessionRequest(ConversationContext<OpcuaAPU> context, CreateSessionResponse opcuaMessageResponse, CreateSessionResponse sessionResponse) throws PlcConnectionException, ParseException {
        this.senderCertificate = sessionResponse.getServerCertificate().getStringValue();
        this.encryptionHandler.setServerCertificate(EncryptionHandler.getCertificateX509(this.senderCertificate));
        this.senderNonce = sessionResponse.getServerNonce().getStringValue();
        String[] endpoints = new String[3];
        try {
            InetAddress address = InetAddress.getByName(this.driverContext.getHost());
            endpoints[0] = "opc.tcp://" + address.getHostAddress() + ":" + this.driverContext.getPort() + this.driverContext.getTransportEndpoint();
            endpoints[1] = "opc.tcp://" + address.getHostName() + ":" + this.driverContext.getPort() + this.driverContext.getTransportEndpoint();
            endpoints[2] = "opc.tcp://" + address.getCanonicalHostName() + ":" + this.driverContext.getPort() + this.driverContext.getTransportEndpoint();
        }
        catch (UnknownHostException e2) {
            LOGGER.debug("error getting host", (Throwable)e2);
        }
        this.selectEndpoint(sessionResponse);
        if (this.policyId == null) {
            throw new PlcRuntimeException("Unable to find endpoint - " + endpoints[1]);
        }
        ExtensionObject userIdentityToken = this.getIdentityToken(this.tokenType, this.policyId.getStringValue());
        int requestHandle = this.getRequestHandle();
        RequestHeader requestHeader = new RequestHeader(new NodeId(this.authenticationToken), SecureChannel.getCurrentDateTime(), requestHandle, 0L, NULL_STRING, 10000L, NULL_EXTENSION_OBJECT);
        SignatureData clientSignature = new SignatureData(NULL_STRING, NULL_BYTE_STRING);
        ActivateSessionRequest activateSessionRequest = new ActivateSessionRequest(requestHeader, clientSignature, 0, null, 0, null, userIdentityToken, clientSignature);
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(activateSessionRequest.getIdentifier())), null, null);
        ExtensionObject extObject = new ExtensionObject(expandedNodeId, null, activateSessionRequest);
        try {
            WriteBufferByteBased buffer = new WriteBufferByteBased(extObject.getLengthInBytes(), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
            extObject.serialize((WriteBuffer)buffer);
            Consumer<byte[]> consumer = opcuaResponse -> {
                try {
                    ExtensionObject message = ExtensionObject.staticParse((ReadBuffer)new ReadBufferByteBased(opcuaResponse, org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN), false);
                    if (message.getBody() instanceof ServiceFault) {
                        ServiceFault fault = (ServiceFault)message.getBody();
                        LOGGER.error("Failed to connect to opc ua server for the following reason:- {}, {}", (Object)((ResponseHeader)fault.getResponseHeader()).getServiceResult().getStatusCode(), (Object)OpcuaStatusCode.enumForValue(((ResponseHeader)fault.getResponseHeader()).getServiceResult().getStatusCode()));
                        return;
                    }
                }
                catch (ParseException e) {
                    LOGGER.error("Error parsing", (Throwable)e);
                    return;
                }
                LOGGER.debug("Got Activate Session Response Connection Response");
                try {
                    ExtensionObjectDefinition unknownExtensionObject = ExtensionObject.staticParse((ReadBuffer)new ReadBufferByteBased(opcuaResponse, org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN), false).getBody();
                    if (unknownExtensionObject instanceof ActivateSessionResponse) {
                        ActivateSessionResponse responseMessage = (ActivateSessionResponse)unknownExtensionObject;
                        long returnedRequestHandle = ((ResponseHeader)responseMessage.getResponseHeader()).getRequestHandle();
                        if ((long)requestHandle != returnedRequestHandle) {
                            LOGGER.error("Request handle isn't as expected, we might have missed a packet. {} != {}", (Object)requestHandle, (Object)returnedRequestHandle);
                        }
                        this.keepAlive();
                        context.fireConnected();
                    } else {
                        ServiceFault serviceFault = (ServiceFault)unknownExtensionObject;
                        ResponseHeader header = (ResponseHeader)serviceFault.getResponseHeader();
                        LOGGER.error("Subscription ServiceFault returned from server with error code,  '{}'", (Object)header.getServiceResult().toString());
                    }
                }
                catch (ParseException e) {
                    LOGGER.error("Unable to parse the returned Subscription response", (Throwable)e);
                }
            };
            Consumer<TimeoutException> timeout = e -> LOGGER.error("Timeout while waiting for activate session response", (Throwable)e);
            BiConsumer<OpcuaAPU, Throwable> error = (message, e) -> LOGGER.error("Error while waiting for activate session response", e);
            this.submit(context, timeout, error, consumer, buffer);
        }
        catch (SerializationException e3) {
            LOGGER.error("Unable to to Parse Activate Session Request", (Throwable)e3);
        }
    }

    public void onDisconnect(ConversationContext<OpcuaAPU> context) {
        LOGGER.info("Disconnecting");
        int requestHandle = this.getRequestHandle();
        if (this.keepAlive != null) {
            this.keepAlive.complete(null);
        }
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, 473), null, null);
        RequestHeader requestHeader = new RequestHeader(new NodeId(this.authenticationToken), SecureChannel.getCurrentDateTime(), requestHandle, 0L, NULL_STRING, 5000L, NULL_EXTENSION_OBJECT);
        CloseSessionRequest closeSessionRequest = new CloseSessionRequest(requestHeader, true);
        ExtensionObject extObject = new ExtensionObject(expandedNodeId, null, closeSessionRequest);
        try {
            WriteBufferByteBased buffer = new WriteBufferByteBased(extObject.getLengthInBytes(), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
            extObject.serialize((WriteBuffer)buffer);
            Consumer<byte[]> consumer = opcuaResponse -> {
                try {
                    ExtensionObject message = ExtensionObject.staticParse((ReadBuffer)new ReadBufferByteBased(opcuaResponse, org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN), false);
                    if (message.getBody() instanceof ServiceFault) {
                        ServiceFault fault = (ServiceFault)message.getBody();
                        LOGGER.error("Failed to connect to opc ua server for the following reason:- {}, {}", (Object)((ResponseHeader)fault.getResponseHeader()).getServiceResult().getStatusCode(), (Object)OpcuaStatusCode.enumForValue(((ResponseHeader)fault.getResponseHeader()).getServiceResult().getStatusCode()));
                        return;
                    }
                }
                catch (ParseException e) {
                    LOGGER.error("Error parsing", (Throwable)e);
                }
                LOGGER.debug("Got Close Session Response Connection Response");
                try {
                    ExtensionObjectDefinition unknownExtensionObject = ExtensionObject.staticParse((ReadBuffer)new ReadBufferByteBased(opcuaResponse, org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN), false).getBody();
                    if (unknownExtensionObject instanceof CloseSessionResponse) {
                        CloseSessionResponse responseMessage = (CloseSessionResponse)unknownExtensionObject;
                        LOGGER.trace("Got Close Session Response Connection Response" + responseMessage);
                        this.onDisconnectCloseSecureChannel(context);
                    } else {
                        ServiceFault serviceFault = (ServiceFault)unknownExtensionObject;
                        ResponseHeader header = (ResponseHeader)serviceFault.getResponseHeader();
                        LOGGER.error("Subscription ServiceFault returned from server with error code,  '{}'", (Object)header.getServiceResult().toString());
                    }
                }
                catch (ParseException e) {
                    LOGGER.error("Unable to parse the returned Close Session response", (Throwable)e);
                }
            };
            Consumer<TimeoutException> timeout = e -> LOGGER.error("Timeout while waiting for close session response", (Throwable)e);
            BiConsumer<OpcuaAPU, Throwable> error = (message, e) -> LOGGER.error("Error while waiting for close session response", e);
            this.submit(context, timeout, error, consumer, buffer);
        }
        catch (SerializationException e2) {
            LOGGER.error("Unable to to Parse Close Session Request", (Throwable)e2);
        }
    }

    private void onDisconnectCloseSecureChannel(ConversationContext<OpcuaAPU> context) {
        int transactionId = this.channelTransactionManager.getTransactionIdentifier();
        RequestHeader requestHeader = new RequestHeader(new NodeId(this.authenticationToken), SecureChannel.getCurrentDateTime(), 0L, 0L, NULL_STRING, 10000L, NULL_EXTENSION_OBJECT);
        CloseSecureChannelRequest closeSecureChannelRequest = new CloseSecureChannelRequest(requestHeader);
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(closeSecureChannelRequest.getIdentifier())), null, null);
        OpcuaCloseRequest closeRequest = new OpcuaCloseRequest(FINAL_CHUNK, this.channelId.get(), this.tokenId.get(), transactionId, transactionId, new ExtensionObject(expandedNodeId, null, closeSecureChannelRequest));
        Consumer<Integer> requestConsumer = t -> {
            context.sendRequest((Object)new OpcuaAPU(closeRequest)).expectResponse(OpcuaAPU.class, REQUEST_TIMEOUT).check(p -> p.getMessage() instanceof OpcuaMessageResponse).unwrap(p -> (OpcuaMessageResponse)p.getMessage()).check(p -> p.getRequestId() == transactionId).handle(opcuaMessageResponse -> LOGGER.trace("Got Close Secure Channel Response" + opcuaMessageResponse.toString()));
            context.fireDisconnected();
        };
        this.channelTransactionManager.submit(requestConsumer, transactionId);
    }

    public void onDiscover(ConversationContext<OpcuaAPU> context) {
        if (!this.driverContext.getEncrypted().booleanValue()) {
            LOGGER.debug("not encrypted, ignoring onDiscover");
            return;
        }
        LOGGER.debug("Opcua Driver running in ACTIVE mode, discovering endpoints");
        OpcuaHelloRequest hello = new OpcuaHelloRequest(FINAL_CHUNK, 0, 65535, 65535, 0x200000, 64, this.endpoint);
        Consumer<Integer> requestConsumer = t -> {
            ConversationContext.ContextHandler contextHandler = context.sendRequest((Object)new OpcuaAPU(hello)).expectResponse(OpcuaAPU.class, REQUEST_TIMEOUT).check(p -> p.getMessage() instanceof OpcuaAcknowledgeResponse).unwrap(p -> (OpcuaAcknowledgeResponse)p.getMessage()).handle(opcuaAcknowledgeResponse -> {
                LOGGER.debug("Got Hello Response Connection Response");
                this.onDiscoverOpenSecureChannel(context, (OpcuaAcknowledgeResponse)opcuaAcknowledgeResponse);
            });
        };
        this.channelTransactionManager.submit(requestConsumer, this.channelTransactionManager.getTransactionIdentifier());
    }

    public void onDiscoverOpenSecureChannel(ConversationContext<OpcuaAPU> context, OpcuaAcknowledgeResponse opcuaAcknowledgeResponse) {
        int transactionId = this.channelTransactionManager.getTransactionIdentifier();
        RequestHeader requestHeader = new RequestHeader(new NodeId(this.authenticationToken), SecureChannel.getCurrentDateTime(), 0L, 0L, NULL_STRING, 10000L, NULL_EXTENSION_OBJECT);
        OpenSecureChannelRequest openSecureChannelRequest = new OpenSecureChannelRequest(requestHeader, 0L, SecurityTokenRequestType.securityTokenRequestTypeIssue, MessageSecurityMode.messageSecurityModeNone, NULL_BYTE_STRING, this.lifetime);
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(openSecureChannelRequest.getIdentifier())), null, null);
        ExtensionObject extObject = new ExtensionObject(expandedNodeId, null, openSecureChannelRequest);
        try {
            WriteBufferByteBased buffer = new WriteBufferByteBased(extObject.getLengthInBytes(), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
            extObject.serialize((WriteBuffer)buffer);
            OpcuaOpenRequest openRequest = new OpcuaOpenRequest(FINAL_CHUNK, 0, SECURITY_POLICY_NONE, NULL_BYTE_STRING, NULL_BYTE_STRING, transactionId, transactionId, buffer.getBytes());
            Consumer<Integer> requestConsumer = t -> {
                ConversationContext.ContextHandler contextHandler = context.sendRequest((Object)new OpcuaAPU(openRequest)).expectResponse(OpcuaAPU.class, REQUEST_TIMEOUT).check(p -> p.getMessage() instanceof OpcuaOpenResponse).unwrap(p -> (OpcuaOpenResponse)p.getMessage()).check(p -> p.getRequestId() == transactionId).handle(opcuaOpenResponse -> {
                    try {
                        ExtensionObject message = ExtensionObject.staticParse((ReadBuffer)new ReadBufferByteBased(opcuaOpenResponse.getMessage(), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN), false);
                        if (message.getBody() instanceof ServiceFault) {
                            ServiceFault fault = (ServiceFault)message.getBody();
                            LOGGER.error("Failed to connect to opc ua server for the following reason:- {}, {}", (Object)((ResponseHeader)fault.getResponseHeader()).getServiceResult().getStatusCode(), (Object)OpcuaStatusCode.enumForValue(((ResponseHeader)fault.getResponseHeader()).getServiceResult().getStatusCode()));
                        } else {
                            LOGGER.debug("Got Secure Response Connection Response");
                            try {
                                this.onDiscoverGetEndpointsRequest(context, (OpcuaOpenResponse)opcuaOpenResponse, (OpenSecureChannelResponse)message.getBody());
                            }
                            catch (PlcConnectionException e) {
                                LOGGER.error("Error occurred while connecting to OPC UA server");
                            }
                        }
                    }
                    catch (ParseException e) {
                        LOGGER.debug("error caught", (Throwable)e);
                    }
                });
            };
            this.channelTransactionManager.submit(requestConsumer, transactionId);
        }
        catch (SerializationException e) {
            LOGGER.error("Unable to to Parse Create Session Request");
        }
    }

    public void onDiscoverGetEndpointsRequest(ConversationContext<OpcuaAPU> context, OpcuaOpenResponse opcuaOpenResponse, OpenSecureChannelResponse openSecureChannelResponse) throws PlcConnectionException {
        ChannelSecurityToken securityToken = (ChannelSecurityToken)openSecureChannelResponse.getSecurityToken();
        this.tokenId.set((int)securityToken.getTokenId());
        this.channelId.set((int)securityToken.getChannelId());
        int transactionId = this.channelTransactionManager.getTransactionIdentifier();
        int nextSequenceNumber = opcuaOpenResponse.getSequenceNumber() + 1;
        int nextRequestId = opcuaOpenResponse.getRequestId() + 1;
        if (transactionId != nextSequenceNumber) {
            LOGGER.error("Sequence number isn't as expected, we might have missed a packet. - " + transactionId + " != " + nextSequenceNumber);
            throw new PlcConnectionException("Sequence number isn't as expected, we might have missed a packet. - " + transactionId + " != " + nextSequenceNumber);
        }
        RequestHeader requestHeader = new RequestHeader(new NodeId(this.authenticationToken), SecureChannel.getCurrentDateTime(), 0L, 0L, NULL_STRING, 10000L, NULL_EXTENSION_OBJECT);
        GetEndpointsRequest endpointsRequest = new GetEndpointsRequest(requestHeader, this.endpoint, 0, null, 0, null);
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(endpointsRequest.getIdentifier())), null, null);
        ExtensionObject extObject = new ExtensionObject(expandedNodeId, null, endpointsRequest);
        try {
            WriteBufferByteBased buffer = new WriteBufferByteBased(extObject.getLengthInBytes(), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
            extObject.serialize((WriteBuffer)buffer);
            OpcuaMessageRequest messageRequest = new OpcuaMessageRequest(FINAL_CHUNK, this.channelId.get(), this.tokenId.get(), nextSequenceNumber, nextRequestId, buffer.getBytes());
            Consumer<Integer> requestConsumer = t -> {
                ConversationContext.ContextHandler contextHandler = context.sendRequest((Object)new OpcuaAPU(messageRequest)).expectResponse(OpcuaAPU.class, REQUEST_TIMEOUT).check(p -> p.getMessage() instanceof OpcuaMessageResponse).unwrap(p -> (OpcuaMessageResponse)p.getMessage()).check(p -> p.getRequestId() == transactionId).handle(opcuaMessageResponse -> {
                    try {
                        ExtensionObject message = ExtensionObject.staticParse((ReadBuffer)new ReadBufferByteBased(opcuaMessageResponse.getMessage(), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN), false);
                        if (message.getBody() instanceof ServiceFault) {
                            ServiceFault fault = (ServiceFault)message.getBody();
                            LOGGER.error("Failed to connect to opc ua server for the following reason:- {}, {}", (Object)((ResponseHeader)fault.getResponseHeader()).getServiceResult().getStatusCode(), (Object)OpcuaStatusCode.enumForValue(((ResponseHeader)fault.getResponseHeader()).getServiceResult().getStatusCode()));
                            return;
                        }
                        LOGGER.debug("Got Create Session Response Connection Response");
                        GetEndpointsResponse response = (GetEndpointsResponse)message.getBody();
                        List<ExtensionObjectDefinition> endpoints = response.getEndpoints();
                        for (ExtensionObjectDefinition endpoint : endpoints) {
                            EndpointDescription endpointDescription = (EndpointDescription)endpoint;
                            if (!endpointDescription.getEndpointUrl().getStringValue().equals(this.endpoint.getStringValue()) || !endpointDescription.getSecurityPolicyUri().getStringValue().equals(this.securityPolicy)) continue;
                            LOGGER.info("Found OPC UA endpoint {}", (Object)this.endpoint.getStringValue());
                            this.driverContext.setSenderCertificate(endpointDescription.getServerCertificate().getStringValue());
                        }
                        try {
                            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                            byte[] digest = messageDigest.digest(this.driverContext.getSenderCertificate());
                            this.driverContext.setThumbprint(new PascalByteString(digest.length, digest));
                        }
                        catch (NoSuchAlgorithmException e) {
                            LOGGER.error("Failed to find hashing algorithm");
                        }
                        this.onDiscoverCloseSecureChannel(context, response);
                    }
                    catch (ParseException e) {
                        LOGGER.error("Error parsing", (Throwable)e);
                    }
                });
            };
            this.channelTransactionManager.submit(requestConsumer, transactionId);
        }
        catch (SerializationException e) {
            LOGGER.error("Unable to to Parse Create Session Request");
        }
    }

    private void onDiscoverCloseSecureChannel(ConversationContext<OpcuaAPU> context, GetEndpointsResponse message) {
        int transactionId = this.channelTransactionManager.getTransactionIdentifier();
        RequestHeader requestHeader = new RequestHeader(new NodeId(this.authenticationToken), SecureChannel.getCurrentDateTime(), 0L, 0L, NULL_STRING, 10000L, NULL_EXTENSION_OBJECT);
        CloseSecureChannelRequest closeSecureChannelRequest = new CloseSecureChannelRequest(requestHeader);
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(closeSecureChannelRequest.getIdentifier())), null, null);
        OpcuaCloseRequest closeRequest = new OpcuaCloseRequest(FINAL_CHUNK, this.channelId.get(), this.tokenId.get(), transactionId, transactionId, new ExtensionObject(expandedNodeId, null, closeSecureChannelRequest));
        Consumer<Integer> requestConsumer = t -> {
            ConversationContext.ContextHandler contextHandler = context.sendRequest((Object)new OpcuaAPU(closeRequest)).expectResponse(OpcuaAPU.class, REQUEST_TIMEOUT).check(p -> p.getMessage() instanceof OpcuaMessageResponse).unwrap(p -> (OpcuaMessageResponse)p.getMessage()).check(p -> p.getRequestId() == transactionId).handle(opcuaMessageResponse -> {
                LOGGER.trace("Got Close Secure Channel Response" + opcuaMessageResponse.toString());
                context.fireDiscovered((Configuration)this.configuration);
            });
        };
        this.channelTransactionManager.submit(requestConsumer, transactionId);
    }

    private void keepAlive() {
        this.keepAlive = CompletableFuture.supplyAsync(() -> {
            while (true) {
                try {
                    Thread.sleep((long)Math.ceil((float)this.lifetime * 0.75f));
                }
                catch (InterruptedException e) {
                    LOGGER.trace("Interrupted Exception");
                }
                int transactionId = this.channelTransactionManager.getTransactionIdentifier();
                RequestHeader requestHeader = new RequestHeader(new NodeId(this.authenticationToken), SecureChannel.getCurrentDateTime(), 0L, 0L, NULL_STRING, 10000L, NULL_EXTENSION_OBJECT);
                OpenSecureChannelRequest openSecureChannelRequest = this.isEncrypted ? new OpenSecureChannelRequest(requestHeader, 0L, SecurityTokenRequestType.securityTokenRequestTypeIssue, MessageSecurityMode.messageSecurityModeSignAndEncrypt, new PascalByteString(this.clientNonce.length, this.clientNonce), this.lifetime) : new OpenSecureChannelRequest(requestHeader, 0L, SecurityTokenRequestType.securityTokenRequestTypeIssue, MessageSecurityMode.messageSecurityModeNone, NULL_BYTE_STRING, this.lifetime);
                ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(openSecureChannelRequest.getIdentifier())), null, null);
                ExtensionObject extObject = new ExtensionObject(expandedNodeId, null, openSecureChannelRequest);
                try {
                    WriteBufferByteBased buffer = new WriteBufferByteBased(extObject.getLengthInBytes(), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
                    extObject.serialize((WriteBuffer)buffer);
                    OpcuaOpenRequest openRequest = new OpcuaOpenRequest(FINAL_CHUNK, 0, new PascalString(this.securityPolicy), this.publicCertificate, this.thumbprint, transactionId, transactionId, buffer.getBytes());
                    OpcuaAPU apu = this.isEncrypted ? OpcuaAPU.staticParse(this.encryptionHandler.encodeMessage(openRequest, buffer.getBytes()), false) : new OpcuaAPU(openRequest);
                    Consumer<Integer> requestConsumer = t -> {
                        ConversationContext.ContextHandler contextHandler = this.context.sendRequest((Object)apu).expectResponse(OpcuaAPU.class, REQUEST_TIMEOUT).unwrap(apuMessage -> this.encryptionHandler.decodeMessage((OpcuaAPU)apuMessage)).check(p -> p.getMessage() instanceof OpcuaOpenResponse).unwrap(p -> (OpcuaOpenResponse)p.getMessage()).check(p -> p.getRequestId() == transactionId).handle(opcuaOpenResponse -> {
                            try {
                                ReadBufferByteBased readBuffer = new ReadBufferByteBased(opcuaOpenResponse.getMessage(), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
                                ExtensionObject message = ExtensionObject.staticParse((ReadBuffer)readBuffer, false);
                                if (message.getBody() instanceof ServiceFault) {
                                    ServiceFault fault = (ServiceFault)message.getBody();
                                    LOGGER.error("Failed to connect to opc ua server for the following reason:- {}, {}", (Object)((ResponseHeader)fault.getResponseHeader()).getServiceResult().getStatusCode(), (Object)OpcuaStatusCode.enumForValue(((ResponseHeader)fault.getResponseHeader()).getServiceResult().getStatusCode()));
                                } else {
                                    LOGGER.debug("Got Secure Response Connection Response");
                                    OpenSecureChannelResponse openSecureChannelResponse = (OpenSecureChannelResponse)message.getBody();
                                    ChannelSecurityToken token = (ChannelSecurityToken)openSecureChannelResponse.getSecurityToken();
                                    this.tokenId.set((int)token.getTokenId());
                                    this.channelId.set((int)token.getChannelId());
                                    this.lifetime = token.getRevisedLifetime();
                                }
                            }
                            catch (ParseException e) {
                                LOGGER.error("parse exception caught", (Throwable)e);
                            }
                        });
                    };
                    this.channelTransactionManager.submit(requestConsumer, transactionId);
                    continue;
                }
                catch (ParseException | SerializationException e) {
                    LOGGER.error("Unable to to Parse Open Secure Request");
                    continue;
                }
                break;
            }
        });
    }

    public int getRequestHandle() {
        int transactionId = this.requestHandleGenerator.getAndIncrement();
        if (this.requestHandleGenerator.get() == -1) {
            this.requestHandleGenerator.set(1);
        }
        return transactionId;
    }

    public NodeId getAuthenticationToken() {
        return new NodeId(this.authenticationToken);
    }

    public int getChannelId() {
        return this.channelId.get();
    }

    public int getTokenId() {
        return this.tokenId.get();
    }

    private void selectEndpoint(CreateSessionResponse sessionResponse) throws PlcRuntimeException {
        Stream<EndpointDescription> filteredEndpoints = sessionResponse.getServerEndpoints().stream().map(e -> (EndpointDescription)e).filter(this::isEndpoint);
        filteredEndpoints.forEach(endpoint -> this.hasIdentity((UserTokenPolicy[])endpoint.getUserIdentityTokens().stream().map(p -> (UserTokenPolicy)p).toArray(UserTokenPolicy[]::new)));
        if (this.policyId == null) {
            throw new PlcRuntimeException("Unable to find endpoint - " + this.endpoints.get(0));
        }
        if (this.tokenType == null) {
            throw new PlcRuntimeException("Unable to find Security Policy for endpoint - " + this.endpoints.get(0));
        }
    }

    private boolean isEndpoint(EndpointDescription endpoint) throws PlcRuntimeException {
        Matcher matcher = URI_PATTERN.matcher(endpoint.getEndpointUrl().getStringValue());
        if (!matcher.matches()) {
            throw new PlcRuntimeException("Endpoint returned from the server doesn't match the format '{protocol-code}:({transport-code})?//{transport-host}(:{transport-port})(/{transport-endpoint})'");
        }
        LOGGER.trace("Using Endpoint {} {} {}", new Object[]{matcher.group("transportHost"), matcher.group("transportPort"), matcher.group("transportEndpoint")});
        if (this.configuration.isDiscovery() && !this.endpoints.contains(matcher.group("transportHost"))) {
            return false;
        }
        if (!this.driverContext.getPort().equals(matcher.group("transportPort"))) {
            return false;
        }
        if (!this.driverContext.getTransportEndpoint().equals(matcher.group("transportEndpoint"))) {
            return false;
        }
        if (!this.configuration.isDiscovery()) {
            this.driverContext.setHost(matcher.group("transportHost"));
        }
        return true;
    }

    private void hasIdentity(UserTokenPolicy[] policies) {
        UserTokenPolicy[] userTokenPolicyArray = policies;
        int n = policies.length;
        int n2 = 0;
        while (n2 < n) {
            UserTokenPolicy identityToken = userTokenPolicyArray[n2];
            if (identityToken.getTokenType() == UserTokenType.userTokenTypeAnonymous && this.username == null) {
                this.policyId = identityToken.getPolicyId();
                this.tokenType = identityToken.getTokenType();
            } else if (identityToken.getTokenType() == UserTokenType.userTokenTypeUserName && this.username != null) {
                this.policyId = identityToken.getPolicyId();
                this.tokenType = identityToken.getTokenType();
            }
            ++n2;
        }
    }

    private ExtensionObject getIdentityToken(UserTokenType tokenType, String policyId) {
        switch (tokenType) {
            case userTokenTypeAnonymous: {
                AnonymousIdentityToken anonymousIdentityToken = new AnonymousIdentityToken();
                ExpandedNodeId extExpandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, 321), null, null);
                return new ExtensionObject(extExpandedNodeId, new ExtensionObjectEncodingMask(false, false, true), new UserIdentityToken(new PascalString(policyId), anonymousIdentityToken));
            }
            case userTokenTypeUserName: {
                byte[] passwordBytes = this.password == null ? new byte[]{} : this.password.getBytes();
                ByteBuffer encodeableBuffer = ByteBuffer.allocate(4 + passwordBytes.length + this.senderNonce.length);
                encodeableBuffer.order(ByteOrder.LITTLE_ENDIAN);
                encodeableBuffer.putInt(passwordBytes.length + this.senderNonce.length);
                encodeableBuffer.put(passwordBytes);
                encodeableBuffer.put(this.senderNonce);
                byte[] encodeablePassword = new byte[4 + passwordBytes.length + this.senderNonce.length];
                encodeableBuffer.position(0);
                encodeableBuffer.get(encodeablePassword);
                byte[] encryptedPassword = this.encryptionHandler.encryptPassword(encodeablePassword);
                UserNameIdentityToken userNameIdentityToken = new UserNameIdentityToken(new PascalString(this.username), new PascalByteString(encryptedPassword.length, encryptedPassword), new PascalString(PASSWORD_ENCRYPTION_ALGORITHM));
                ExpandedNodeId extExpandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, 324), null, null);
                return new ExtensionObject(extExpandedNodeId, new ExtensionObjectEncodingMask(false, false, true), new UserIdentityToken(new PascalString(policyId), userNameIdentityToken));
            }
        }
        return null;
    }

    public static long getCurrentDateTime() {
        return System.currentTimeMillis() * 10000L + 116444736000000000L;
    }
}

