/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpcuaMessageError extends MessagePDU implements Message {

  // Accessors for discriminator values.
  public String getMessageType() {
    return (String) "ERR";
  }

  public Boolean getResponse() {
    return (boolean) true;
  }

  // Properties.
  protected final String chunk;
  protected final OpcuaStatusCode error;
  protected final PascalString reason;

  public OpcuaMessageError(String chunk, OpcuaStatusCode error, PascalString reason) {
    super();
    this.chunk = chunk;
    this.error = error;
    this.reason = reason;
  }

  public String getChunk() {
    return chunk;
  }

  public OpcuaStatusCode getError() {
    return error;
  }

  public PascalString getReason() {
    return reason;
  }

  @Override
  protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OpcuaMessageError");

    // Simple Field (chunk)
    writeSimpleField("chunk", chunk, writeString(writeBuffer, 8));

    // Implicit Field (messageSize) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int messageSize = (int) (getLengthInBytes());
    writeImplicitField("messageSize", messageSize, writeSignedInt(writeBuffer, 32));

    // Simple Field (error)
    writeSimpleEnumField(
        "error",
        "OpcuaStatusCode",
        error,
        new DataWriterEnumDefault<>(
            OpcuaStatusCode::getValue, OpcuaStatusCode::name, writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (reason)
    writeSimpleField("reason", reason, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("OpcuaMessageError");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpcuaMessageError _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (chunk)
    lengthInBits += 8;

    // Implicit Field (messageSize)
    lengthInBits += 32;

    // Simple field (error)
    lengthInBits += 32;

    // Simple field (reason)
    lengthInBits += reason.getLengthInBits();

    return lengthInBits;
  }

  public static MessagePDUBuilder staticParseMessagePDUBuilder(
      ReadBuffer readBuffer, Boolean response) throws ParseException {
    readBuffer.pullContext("OpcuaMessageError");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    String chunk = readSimpleField("chunk", readString(readBuffer, 8));

    int messageSize = readImplicitField("messageSize", readSignedInt(readBuffer, 32));

    OpcuaStatusCode error =
        readEnumField(
            "error",
            "OpcuaStatusCode",
            new DataReaderEnumDefault<>(
                OpcuaStatusCode::enumForValue, readUnsignedLong(readBuffer, 32)));

    PascalString reason =
        readSimpleField(
            "reason",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("OpcuaMessageError");
    // Create the instance
    return new OpcuaMessageErrorBuilderImpl(chunk, error, reason);
  }

  public static class OpcuaMessageErrorBuilderImpl implements MessagePDU.MessagePDUBuilder {
    private final String chunk;
    private final OpcuaStatusCode error;
    private final PascalString reason;

    public OpcuaMessageErrorBuilderImpl(String chunk, OpcuaStatusCode error, PascalString reason) {
      this.chunk = chunk;
      this.error = error;
      this.reason = reason;
    }

    public OpcuaMessageError build() {
      OpcuaMessageError opcuaMessageError = new OpcuaMessageError(chunk, error, reason);
      return opcuaMessageError;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpcuaMessageError)) {
      return false;
    }
    OpcuaMessageError that = (OpcuaMessageError) o;
    return (getChunk() == that.getChunk())
        && (getError() == that.getError())
        && (getReason() == that.getReason())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getChunk(), getError(), getReason());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
