/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class NodeReference extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "582";
  }

  // Properties.
  protected final NodeId nodeId;
  protected final NodeId referenceTypeId;
  protected final boolean isForward;
  protected final int noOfReferencedNodeIds;
  protected final List<NodeId> referencedNodeIds;

  public NodeReference(
      NodeId nodeId,
      NodeId referenceTypeId,
      boolean isForward,
      int noOfReferencedNodeIds,
      List<NodeId> referencedNodeIds) {
    super();
    this.nodeId = nodeId;
    this.referenceTypeId = referenceTypeId;
    this.isForward = isForward;
    this.noOfReferencedNodeIds = noOfReferencedNodeIds;
    this.referencedNodeIds = referencedNodeIds;
  }

  public NodeId getNodeId() {
    return nodeId;
  }

  public NodeId getReferenceTypeId() {
    return referenceTypeId;
  }

  public boolean getIsForward() {
    return isForward;
  }

  public int getNoOfReferencedNodeIds() {
    return noOfReferencedNodeIds;
  }

  public List<NodeId> getReferencedNodeIds() {
    return referencedNodeIds;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("NodeReference");

    // Simple Field (nodeId)
    writeSimpleField("nodeId", nodeId, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (referenceTypeId)
    writeSimpleField(
        "referenceTypeId", referenceTypeId, new DataWriterComplexDefault<>(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

    // Simple Field (isForward)
    writeSimpleField("isForward", isForward, writeBoolean(writeBuffer));

    // Simple Field (noOfReferencedNodeIds)
    writeSimpleField(
        "noOfReferencedNodeIds", noOfReferencedNodeIds, writeSignedInt(writeBuffer, 32));

    // Array Field (referencedNodeIds)
    writeComplexTypeArrayField("referencedNodeIds", referencedNodeIds, writeBuffer);

    writeBuffer.popContext("NodeReference");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    NodeReference _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (nodeId)
    lengthInBits += nodeId.getLengthInBits();

    // Simple field (referenceTypeId)
    lengthInBits += referenceTypeId.getLengthInBits();

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (isForward)
    lengthInBits += 1;

    // Simple field (noOfReferencedNodeIds)
    lengthInBits += 32;

    // Array field
    if (referencedNodeIds != null) {
      int i = 0;
      for (NodeId element : referencedNodeIds) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= referencedNodeIds.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("NodeReference");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    NodeId nodeId =
        readSimpleField(
            "nodeId",
            new DataReaderComplexDefault<>(() -> NodeId.staticParse(readBuffer), readBuffer));

    NodeId referenceTypeId =
        readSimpleField(
            "referenceTypeId",
            new DataReaderComplexDefault<>(() -> NodeId.staticParse(readBuffer), readBuffer));

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

    boolean isForward = readSimpleField("isForward", readBoolean(readBuffer));

    int noOfReferencedNodeIds =
        readSimpleField("noOfReferencedNodeIds", readSignedInt(readBuffer, 32));

    List<NodeId> referencedNodeIds =
        readCountArrayField(
            "referencedNodeIds",
            new DataReaderComplexDefault<>(() -> NodeId.staticParse(readBuffer), readBuffer),
            noOfReferencedNodeIds);

    readBuffer.closeContext("NodeReference");
    // Create the instance
    return new NodeReferenceBuilderImpl(
        nodeId, referenceTypeId, isForward, noOfReferencedNodeIds, referencedNodeIds);
  }

  public static class NodeReferenceBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final NodeId nodeId;
    private final NodeId referenceTypeId;
    private final boolean isForward;
    private final int noOfReferencedNodeIds;
    private final List<NodeId> referencedNodeIds;

    public NodeReferenceBuilderImpl(
        NodeId nodeId,
        NodeId referenceTypeId,
        boolean isForward,
        int noOfReferencedNodeIds,
        List<NodeId> referencedNodeIds) {
      this.nodeId = nodeId;
      this.referenceTypeId = referenceTypeId;
      this.isForward = isForward;
      this.noOfReferencedNodeIds = noOfReferencedNodeIds;
      this.referencedNodeIds = referencedNodeIds;
    }

    public NodeReference build() {
      NodeReference nodeReference =
          new NodeReference(
              nodeId, referenceTypeId, isForward, noOfReferencedNodeIds, referencedNodeIds);
      return nodeReference;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof NodeReference)) {
      return false;
    }
    NodeReference that = (NodeReference) o;
    return (getNodeId() == that.getNodeId())
        && (getReferenceTypeId() == that.getReferenceTypeId())
        && (getIsForward() == that.getIsForward())
        && (getNoOfReferencedNodeIds() == that.getNoOfReferencedNodeIds())
        && (getReferencedNodeIds() == that.getReferencedNodeIds())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getNodeId(),
        getReferenceTypeId(),
        getIsForward(),
        getNoOfReferencedNodeIds(),
        getReferencedNodeIds());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
