/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class EUInformation extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "889";
  }

  // Properties.
  protected final PascalString namespaceUri;
  protected final int unitId;
  protected final LocalizedText displayName;
  protected final LocalizedText description;

  public EUInformation(
      PascalString namespaceUri, int unitId, LocalizedText displayName, LocalizedText description) {
    super();
    this.namespaceUri = namespaceUri;
    this.unitId = unitId;
    this.displayName = displayName;
    this.description = description;
  }

  public PascalString getNamespaceUri() {
    return namespaceUri;
  }

  public int getUnitId() {
    return unitId;
  }

  public LocalizedText getDisplayName() {
    return displayName;
  }

  public LocalizedText getDescription() {
    return description;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("EUInformation");

    // Simple Field (namespaceUri)
    writeSimpleField("namespaceUri", namespaceUri, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (unitId)
    writeSimpleField("unitId", unitId, writeSignedInt(writeBuffer, 32));

    // Simple Field (displayName)
    writeSimpleField("displayName", displayName, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (description)
    writeSimpleField("description", description, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("EUInformation");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    EUInformation _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (namespaceUri)
    lengthInBits += namespaceUri.getLengthInBits();

    // Simple field (unitId)
    lengthInBits += 32;

    // Simple field (displayName)
    lengthInBits += displayName.getLengthInBits();

    // Simple field (description)
    lengthInBits += description.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("EUInformation");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString namespaceUri =
        readSimpleField(
            "namespaceUri",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    int unitId = readSimpleField("unitId", readSignedInt(readBuffer, 32));

    LocalizedText displayName =
        readSimpleField(
            "displayName",
            new DataReaderComplexDefault<>(
                () -> LocalizedText.staticParse(readBuffer), readBuffer));

    LocalizedText description =
        readSimpleField(
            "description",
            new DataReaderComplexDefault<>(
                () -> LocalizedText.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("EUInformation");
    // Create the instance
    return new EUInformationBuilderImpl(namespaceUri, unitId, displayName, description);
  }

  public static class EUInformationBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString namespaceUri;
    private final int unitId;
    private final LocalizedText displayName;
    private final LocalizedText description;

    public EUInformationBuilderImpl(
        PascalString namespaceUri,
        int unitId,
        LocalizedText displayName,
        LocalizedText description) {
      this.namespaceUri = namespaceUri;
      this.unitId = unitId;
      this.displayName = displayName;
      this.description = description;
    }

    public EUInformation build() {
      EUInformation eUInformation =
          new EUInformation(namespaceUri, unitId, displayName, description);
      return eUInformation;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof EUInformation)) {
      return false;
    }
    EUInformation that = (EUInformation) o;
    return (getNamespaceUri() == that.getNamespaceUri())
        && (getUnitId() == that.getUnitId())
        && (getDisplayName() == that.getDisplayName())
        && (getDescription() == that.getDescription())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getNamespaceUri(), getUnitId(), getDisplayName(), getDescription());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
