/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class TransferSubscriptionsRequest extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "841";
  }

  // Properties.
  protected final ExtensionObjectDefinition requestHeader;
  protected final int noOfSubscriptionIds;
  protected final List<Long> subscriptionIds;
  protected final boolean sendInitialValues;
  // Reserved Fields
  private Short reservedField0;

  public TransferSubscriptionsRequest(
      ExtensionObjectDefinition requestHeader,
      int noOfSubscriptionIds,
      List<Long> subscriptionIds,
      boolean sendInitialValues) {
    super();
    this.requestHeader = requestHeader;
    this.noOfSubscriptionIds = noOfSubscriptionIds;
    this.subscriptionIds = subscriptionIds;
    this.sendInitialValues = sendInitialValues;
  }

  public ExtensionObjectDefinition getRequestHeader() {
    return requestHeader;
  }

  public int getNoOfSubscriptionIds() {
    return noOfSubscriptionIds;
  }

  public List<Long> getSubscriptionIds() {
    return subscriptionIds;
  }

  public boolean getSendInitialValues() {
    return sendInitialValues;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("TransferSubscriptionsRequest");

    // Simple Field (requestHeader)
    writeSimpleField("requestHeader", requestHeader, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfSubscriptionIds)
    writeSimpleField("noOfSubscriptionIds", noOfSubscriptionIds, writeSignedInt(writeBuffer, 32));

    // Array Field (subscriptionIds)
    writeSimpleTypeArrayField(
        "subscriptionIds", subscriptionIds, writeUnsignedLong(writeBuffer, 32));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (short) 0x00,
        writeUnsignedShort(writeBuffer, 7));

    // Simple Field (sendInitialValues)
    writeSimpleField("sendInitialValues", sendInitialValues, writeBoolean(writeBuffer));

    writeBuffer.popContext("TransferSubscriptionsRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    TransferSubscriptionsRequest _value = this;

    // Simple field (requestHeader)
    lengthInBits += requestHeader.getLengthInBits();

    // Simple field (noOfSubscriptionIds)
    lengthInBits += 32;

    // Array field
    if (subscriptionIds != null) {
      lengthInBits += 32 * subscriptionIds.size();
    }

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (sendInitialValues)
    lengthInBits += 1;

    return lengthInBits;
  }

  public static TransferSubscriptionsRequestBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("TransferSubscriptionsRequest");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    ExtensionObjectDefinition requestHeader =
        readSimpleField(
            "requestHeader",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("391")),
                readBuffer));

    int noOfSubscriptionIds = readSimpleField("noOfSubscriptionIds", readSignedInt(readBuffer, 32));

    List<Long> subscriptionIds =
        readCountArrayField(
            "subscriptionIds", readUnsignedLong(readBuffer, 32), noOfSubscriptionIds);

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 7), (short) 0x00);

    boolean sendInitialValues = readSimpleField("sendInitialValues", readBoolean(readBuffer));

    readBuffer.closeContext("TransferSubscriptionsRequest");
    // Create the instance
    return new TransferSubscriptionsRequestBuilder(
        requestHeader, noOfSubscriptionIds, subscriptionIds, sendInitialValues, reservedField0);
  }

  public static class TransferSubscriptionsRequestBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExtensionObjectDefinition requestHeader;
    private final int noOfSubscriptionIds;
    private final List<Long> subscriptionIds;
    private final boolean sendInitialValues;
    private final Short reservedField0;

    public TransferSubscriptionsRequestBuilder(
        ExtensionObjectDefinition requestHeader,
        int noOfSubscriptionIds,
        List<Long> subscriptionIds,
        boolean sendInitialValues,
        Short reservedField0) {
      this.requestHeader = requestHeader;
      this.noOfSubscriptionIds = noOfSubscriptionIds;
      this.subscriptionIds = subscriptionIds;
      this.sendInitialValues = sendInitialValues;
      this.reservedField0 = reservedField0;
    }

    public TransferSubscriptionsRequest build() {
      TransferSubscriptionsRequest transferSubscriptionsRequest =
          new TransferSubscriptionsRequest(
              requestHeader, noOfSubscriptionIds, subscriptionIds, sendInitialValues);
      transferSubscriptionsRequest.reservedField0 = reservedField0;
      return transferSubscriptionsRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TransferSubscriptionsRequest)) {
      return false;
    }
    TransferSubscriptionsRequest that = (TransferSubscriptionsRequest) o;
    return (getRequestHeader() == that.getRequestHeader())
        && (getNoOfSubscriptionIds() == that.getNoOfSubscriptionIds())
        && (getSubscriptionIds() == that.getSubscriptionIds())
        && (getSendInitialValues() == that.getSendInitialValues())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getRequestHeader(),
        getNoOfSubscriptionIds(),
        getSubscriptionIds(),
        getSendInitialValues());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
