/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum OpcuaNodeIdServices {
  AccessLevelExType((int) 15406L),
  AccessLevelType((int) 15031L),
  AccessRestrictionType((int) 95L),
  AcknowledgeableConditionType((int) 2881L),
  AdditionalParametersType((int) 16313L),
  AdditionalParametersType_Encoding_DefaultBinary((int) 17537L),
  AdditionalParametersType_Encoding_DefaultJson((int) 17547L),
  AdditionalParametersType_Encoding_DefaultXml((int) 17541L),
  AddNodesItem((int) 376L),
  AddNodesItem_Encoding_DefaultBinary((int) 378L),
  AddNodesItem_Encoding_DefaultJson((int) 15165L),
  AddNodesItem_Encoding_DefaultXml((int) 377L),
  AddReferencesItem((int) 379L),
  AddReferencesItem_Encoding_DefaultBinary((int) 381L),
  AddReferencesItem_Encoding_DefaultJson((int) 15169L),
  AddReferencesItem_Encoding_DefaultXml((int) 380L),
  AddressSpaceFileType((int) 11595L),
  AggregateConfiguration((int) 948L),
  AggregateConfiguration_Encoding_DefaultBinary((int) 950L),
  AggregateConfiguration_Encoding_DefaultJson((int) 15304L),
  AggregateConfiguration_Encoding_DefaultXml((int) 949L),
  AggregateConfigurationType((int) 11187L),
  AggregateFunction_AnnotationCount((int) 2351L),
  AggregateFunction_Average((int) 2342L),
  AggregateFunction_Count((int) 2352L),
  AggregateFunction_Delta((int) 2359L),
  AggregateFunction_DeltaBounds((int) 11507L),
  AggregateFunction_DurationBad((int) 2361L),
  AggregateFunction_DurationGood((int) 2360L),
  AggregateFunction_DurationInStateNonZero((int) 11308L),
  AggregateFunction_DurationInStateZero((int) 11307L),
  AggregateFunction_End((int) 2358L),
  AggregateFunction_EndBound((int) 11506L),
  AggregateFunction_Interpolative((int) 2341L),
  AggregateFunction_Maximum((int) 2347L),
  AggregateFunction_Maximum2((int) 11287L),
  AggregateFunction_MaximumActualTime((int) 2349L),
  AggregateFunction_MaximumActualTime2((int) 11306L),
  AggregateFunction_Minimum((int) 2346L),
  AggregateFunction_Minimum2((int) 11286L),
  AggregateFunction_MinimumActualTime((int) 2348L),
  AggregateFunction_MinimumActualTime2((int) 11305L),
  AggregateFunction_NumberOfTransitions((int) 2355L),
  AggregateFunction_PercentBad((int) 2363L),
  AggregateFunction_PercentGood((int) 2362L),
  AggregateFunction_Range((int) 2350L),
  AggregateFunction_Range2((int) 11288L),
  AggregateFunction_StandardDeviationPopulation((int) 11427L),
  AggregateFunction_StandardDeviationSample((int) 11426L),
  AggregateFunction_Start((int) 2357L),
  AggregateFunction_StartBound((int) 11505L),
  AggregateFunction_TimeAverage((int) 2343L),
  AggregateFunction_TimeAverage2((int) 11285L),
  AggregateFunction_Total((int) 2344L),
  AggregateFunction_Total2((int) 11304L),
  AggregateFunction_VariancePopulation((int) 11429L),
  AggregateFunction_VarianceSample((int) 11428L),
  AggregateFunction_WorstQuality((int) 2364L),
  AggregateFunction_WorstQuality2((int) 11292L),
  AggregateFunctionType((int) 2340L),
  Aggregates((int) 44L),
  AlarmConditionType((int) 2915L),
  AlarmGroupMember((int) 16362L),
  AlarmGroupType((int) 16405L),
  AlarmMetricsType((int) 17279L),
  AlarmRateVariableType((int) 17277L),
  Aliases((int) 23470L),
  AliasFor((int) 23469L),
  AliasNameCategoryType((int) 23456L),
  AliasNameDataType((int) 23468L),
  AliasNameDataType_Encoding_DefaultBinary((int) 23499L),
  AliasNameDataType_Encoding_DefaultJson((int) 23511L),
  AliasNameDataType_Encoding_DefaultXml((int) 23505L),
  AliasNameType((int) 23455L),
  AllowNulls((int) 3070L),
  AlwaysGeneratesEvent((int) 3065L),
  AnalogItemType((int) 2368L),
  AnalogUnitRangeType((int) 17570L),
  AnalogUnitType((int) 17497L),
  Annotation((int) 891L),
  Annotation_Encoding_DefaultBinary((int) 893L),
  Annotation_Encoding_DefaultJson((int) 15382L),
  Annotation_Encoding_DefaultXml((int) 892L),
  Annotations((int) 11214L),
  AnonymousIdentityToken((int) 319L),
  AnonymousIdentityToken_Encoding_DefaultBinary((int) 321L),
  AnonymousIdentityToken_Encoding_DefaultJson((int) 15141L),
  AnonymousIdentityToken_Encoding_DefaultXml((int) 320L),
  ApplicationCertificateType((int) 12557L),
  ApplicationDescription((int) 308L),
  ApplicationDescription_Encoding_DefaultBinary((int) 310L),
  ApplicationDescription_Encoding_DefaultJson((int) 15087L),
  ApplicationDescription_Encoding_DefaultXml((int) 309L),
  ApplicationInstanceCertificate((int) 311L),
  ApplicationType((int) 307L),
  Argument((int) 296L),
  Argument_Encoding_DefaultBinary((int) 298L),
  Argument_Encoding_DefaultJson((int) 15081L),
  Argument_Encoding_DefaultXml((int) 297L),
  ArrayItemType((int) 12021L),
  AttributeOperand((int) 598L),
  AttributeOperand_Encoding_DefaultBinary((int) 600L),
  AttributeOperand_Encoding_DefaultJson((int) 15209L),
  AttributeOperand_Encoding_DefaultXml((int) 599L),
  AttributeWriteMask((int) 347L),
  AudioDataType((int) 16307L),
  AudioVariableType((int) 17986L),
  AuditActivateSessionEventType((int) 2075L),
  AuditAddNodesEventType((int) 2091L),
  AuditAddReferencesEventType((int) 2095L),
  AuditCancelEventType((int) 2078L),
  AuditCertificateDataMismatchEventType((int) 2082L),
  AuditCertificateEventType((int) 2080L),
  AuditCertificateExpiredEventType((int) 2085L),
  AuditCertificateInvalidEventType((int) 2086L),
  AuditCertificateMismatchEventType((int) 2089L),
  AuditCertificateRevokedEventType((int) 2088L),
  AuditCertificateUntrustedEventType((int) 2087L),
  AuditChannelEventType((int) 2059L),
  AuditConditionAcknowledgeEventType((int) 8944L),
  AuditConditionCommentEventType((int) 2829L),
  AuditConditionConfirmEventType((int) 8961L),
  AuditConditionEnableEventType((int) 2803L),
  AuditConditionEventType((int) 2790L),
  AuditConditionOutOfServiceEventType((int) 17259L),
  AuditConditionResetEventType((int) 15013L),
  AuditConditionRespondEventType((int) 8927L),
  AuditConditionShelvingEventType((int) 11093L),
  AuditConditionSilenceEventType((int) 17242L),
  AuditConditionSuppressionEventType((int) 17225L),
  AuditCreateSessionEventType((int) 2071L),
  AuditDeleteNodesEventType((int) 2093L),
  AuditDeleteReferencesEventType((int) 2097L),
  AuditEventType((int) 2052L),
  AuditHistoryAnnotationUpdateEventType((int) 19095L),
  AuditHistoryAtTimeDeleteEventType((int) 3019L),
  AuditHistoryDeleteEventType((int) 3012L),
  AuditHistoryEventDeleteEventType((int) 3022L),
  AuditHistoryEventUpdateEventType((int) 2999L),
  AuditHistoryRawModifyDeleteEventType((int) 3014L),
  AuditHistoryUpdateEventType((int) 2104L),
  AuditHistoryValueUpdateEventType((int) 3006L),
  AuditNodeManagementEventType((int) 2090L),
  AuditOpenSecureChannelEventType((int) 2060L),
  AuditProgramTransitionEventType((int) 11856L),
  AuditSecurityEventType((int) 2058L),
  AuditSessionEventType((int) 2069L),
  AuditUpdateEventType((int) 2099L),
  AuditUpdateMethodEventType((int) 2127L),
  AuditUpdateStateEventType((int) 2315L),
  AuditUrlMismatchEventType((int) 2748L),
  AuditWriteUpdateEventType((int) 2100L),
  AuthorizationServiceConfigurationType((int) 17852L),
  AuthorizationServices((int) 17732L),
  AuthorizationServicesConfigurationFolderType((int) 23556L),
  AxisInformation((int) 12079L),
  AxisInformation_Encoding_DefaultBinary((int) 12089L),
  AxisInformation_Encoding_DefaultJson((int) 15379L),
  AxisInformation_Encoding_DefaultXml((int) 12081L),
  AxisScaleEnumeration((int) 12077L),
  BaseAnalogType((int) 15318L),
  BaseConditionClassType((int) 11163L),
  BaseDataType((int) 24L),
  BaseDataVariableType((int) 63L),
  BaseEventType((int) 2041L),
  BaseInterfaceType((int) 17602L),
  BaseModelChangeEventType((int) 2132L),
  BaseObjectType((int) 58L),
  BaseVariableType((int) 62L),
  BitFieldMaskDataType((int) 11737L),
  Boolean((int) 1L),
  BrokerConnectionTransportDataType((int) 15007L),
  BrokerConnectionTransportDataType_Encoding_DefaultBinary((int) 15479L),
  BrokerConnectionTransportDataType_Encoding_DefaultJson((int) 15726L),
  BrokerConnectionTransportDataType_Encoding_DefaultXml((int) 15579L),
  BrokerConnectionTransportType((int) 15155L),
  BrokerDataSetReaderTransportDataType((int) 15670L),
  BrokerDataSetReaderTransportDataType_Encoding_DefaultBinary((int) 15733L),
  BrokerDataSetReaderTransportDataType_Encoding_DefaultJson((int) 16526L),
  BrokerDataSetReaderTransportDataType_Encoding_DefaultXml((int) 16023L),
  BrokerDataSetReaderTransportType((int) 21142L),
  BrokerDataSetWriterTransportDataType((int) 15669L),
  BrokerDataSetWriterTransportDataType_Encoding_DefaultBinary((int) 15729L),
  BrokerDataSetWriterTransportDataType_Encoding_DefaultJson((int) 16525L),
  BrokerDataSetWriterTransportDataType_Encoding_DefaultXml((int) 16022L),
  BrokerDataSetWriterTransportType((int) 21138L),
  BrokerTransportQualityOfService((int) 15008L),
  BrokerWriterGroupTransportDataType((int) 15667L),
  BrokerWriterGroupTransportDataType_Encoding_DefaultBinary((int) 15727L),
  BrokerWriterGroupTransportDataType_Encoding_DefaultJson((int) 16524L),
  BrokerWriterGroupTransportDataType_Encoding_DefaultXml((int) 16021L),
  BrokerWriterGroupTransportType((int) 21136L),
  BuildInfo((int) 338L),
  BuildInfo_Encoding_DefaultBinary((int) 340L),
  BuildInfo_Encoding_DefaultJson((int) 15361L),
  BuildInfo_Encoding_DefaultXml((int) 339L),
  BuildInfoType((int) 3051L),
  Byte((int) 3L),
  ByteString((int) 15L),
  CartesianCoordinates((int) 18809L),
  CartesianCoordinates_Encoding_DefaultBinary((int) 18818L),
  CartesianCoordinates_Encoding_DefaultJson((int) 19067L),
  CartesianCoordinates_Encoding_DefaultXml((int) 18854L),
  CartesianCoordinatesType((int) 18772L),
  CertificateExpirationAlarmType((int) 13225L),
  CertificateGroupFolderType((int) 13813L),
  CertificateGroupType((int) 12555L),
  CertificateType((int) 12556L),
  CertificateUpdatedAuditEventType((int) 12620L),
  ChoiceStateType((int) 15109L),
  Communication((int) 24227L),
  ComplexNumberType((int) 12171L),
  ComplexNumberType_Encoding_DefaultBinary((int) 12181L),
  ComplexNumberType_Encoding_DefaultJson((int) 15377L),
  ComplexNumberType_Encoding_DefaultXml((int) 12173L),
  ConditionType((int) 2782L),
  ConditionVariableType((int) 9002L),
  ConfigurationVersionDataType((int) 14593L),
  ConfigurationVersionDataType_Encoding_DefaultBinary((int) 14847L),
  ConfigurationVersionDataType_Encoding_DefaultJson((int) 15049L),
  ConfigurationVersionDataType_Encoding_DefaultXml((int) 14803L),
  ConnectionTransportDataType((int) 15618L),
  ConnectionTransportDataType_Encoding_DefaultBinary((int) 15695L),
  ConnectionTransportDataType_Encoding_DefaultJson((int) 16282L),
  ConnectionTransportDataType_Encoding_DefaultXml((int) 15993L),
  ConnectionTransportType((int) 17721L),
  ContentFilter((int) 586L),
  ContentFilter_Encoding_DefaultBinary((int) 588L),
  ContentFilter_Encoding_DefaultJson((int) 15205L),
  ContentFilter_Encoding_DefaultXml((int) 587L),
  ContentFilterElement((int) 583L),
  ContentFilterElement_Encoding_DefaultBinary((int) 585L),
  ContentFilterElement_Encoding_DefaultJson((int) 15204L),
  ContentFilterElement_Encoding_DefaultXml((int) 584L),
  ContinuationPoint((int) 521L),
  Counter((int) 289L),
  CubeItemType((int) 12057L),
  CurrencyUnit((int) 23501L),
  CurrencyUnitType((int) 23498L),
  CurrencyUnitType_Encoding_DefaultBinary((int) 23507L),
  CurrencyUnitType_Encoding_DefaultJson((int) 23528L),
  CurrencyUnitType_Encoding_DefaultXml((int) 23520L),
  DatagramConnectionTransportDataType((int) 17467L),
  DatagramConnectionTransportDataType_Encoding_DefaultBinary((int) 17468L),
  DatagramConnectionTransportDataType_Encoding_DefaultJson((int) 17476L),
  DatagramConnectionTransportDataType_Encoding_DefaultXml((int) 17472L),
  DatagramConnectionTransportType((int) 15064L),
  DatagramWriterGroupTransportDataType((int) 15532L),
  DatagramWriterGroupTransportDataType_Encoding_DefaultBinary((int) 21155L),
  DatagramWriterGroupTransportDataType_Encoding_DefaultJson((int) 21203L),
  DatagramWriterGroupTransportDataType_Encoding_DefaultXml((int) 21179L),
  DatagramWriterGroupTransportType((int) 21133L),
  DataItemType((int) 2365L),
  DataSetFieldContentMask((int) 15583L),
  DataSetFieldFlags((int) 15904L),
  DataSetFolderType((int) 14477L),
  DataSetMetaDataType((int) 14523L),
  DataSetMetaDataType_Encoding_DefaultBinary((int) 124L),
  DataSetMetaDataType_Encoding_DefaultJson((int) 15050L),
  DataSetMetaDataType_Encoding_DefaultXml((int) 14794L),
  DataSetOrderingType((int) 20408L),
  DataSetReaderDataType((int) 15623L),
  DataSetReaderDataType_Encoding_DefaultBinary((int) 15703L),
  DataSetReaderDataType_Encoding_DefaultJson((int) 16286L),
  DataSetReaderDataType_Encoding_DefaultXml((int) 16007L),
  DataSetReaderMessageDataType((int) 15629L),
  DataSetReaderMessageDataType_Encoding_DefaultBinary((int) 15706L),
  DataSetReaderMessageDataType_Encoding_DefaultJson((int) 16288L),
  DataSetReaderMessageDataType_Encoding_DefaultXml((int) 16009L),
  DataSetReaderMessageType((int) 21104L),
  DataSetReaderTransportDataType((int) 15628L),
  DataSetReaderTransportDataType_Encoding_DefaultBinary((int) 15705L),
  DataSetReaderTransportDataType_Encoding_DefaultJson((int) 16287L),
  DataSetReaderTransportDataType_Encoding_DefaultXml((int) 16008L),
  DataSetReaderTransportType((int) 15319L),
  DataSetReaderType((int) 15306L),
  DataSetToWriter((int) 14936L),
  DataSetWriterDataType((int) 15597L),
  DataSetWriterDataType_Encoding_DefaultBinary((int) 15682L),
  DataSetWriterDataType_Encoding_DefaultJson((int) 16156L),
  DataSetWriterDataType_Encoding_DefaultXml((int) 15955L),
  DataSetWriterMessageDataType((int) 15605L),
  DataSetWriterMessageDataType_Encoding_DefaultBinary((int) 15688L),
  DataSetWriterMessageDataType_Encoding_DefaultJson((int) 16158L),
  DataSetWriterMessageDataType_Encoding_DefaultXml((int) 15987L),
  DataSetWriterMessageType((int) 21096L),
  DataSetWriterTransportDataType((int) 15598L),
  DataSetWriterTransportDataType_Encoding_DefaultBinary((int) 15683L),
  DataSetWriterTransportDataType_Encoding_DefaultJson((int) 16157L),
  DataSetWriterTransportDataType_Encoding_DefaultXml((int) 15956L),
  DataSetWriterTransportType((int) 15305L),
  DataSetWriterType((int) 15298L),
  DataTypeDefinition((int) 97L),
  DataTypeDefinition_Encoding_DefaultBinary((int) 121L),
  DataTypeDefinition_Encoding_DefaultJson((int) 15063L),
  DataTypeDefinition_Encoding_DefaultXml((int) 14797L),
  DataTypeDescription((int) 14525L),
  DataTypeDescription_Encoding_DefaultBinary((int) 125L),
  DataTypeDescription_Encoding_DefaultJson((int) 15057L),
  DataTypeDescription_Encoding_DefaultXml((int) 14796L),
  DataTypeDescriptionType((int) 69L),
  DataTypeDictionaryType((int) 72L),
  DataTypeEncodingType((int) 76L),
  DataTypeSchemaHeader((int) 15534L),
  DataTypeSchemaHeader_Encoding_DefaultBinary((int) 15676L),
  DataTypeSchemaHeader_Encoding_DefaultJson((int) 16151L),
  DataTypeSchemaHeader_Encoding_DefaultXml((int) 15950L),
  DataTypesFolder((int) 90L),
  DataTypeSystemType((int) 75L),
  DataValue((int) 23L),
  Date((int) 293L),
  DateString((int) 12881L),
  DateTime((int) 13L),
  Decimal((int) 50L),
  DecimalString((int) 12878L),
  DefaultBinary((int) 3062L),
  DefaultInstanceBrowseName((int) 17605L),
  DefaultXml((int) 3063L),
  DeleteNodesItem((int) 382L),
  DeleteNodesItem_Encoding_DefaultBinary((int) 384L),
  DeleteNodesItem_Encoding_DefaultJson((int) 15172L),
  DeleteNodesItem_Encoding_DefaultXml((int) 383L),
  DeleteReferencesItem((int) 385L),
  DeleteReferencesItem_Encoding_DefaultBinary((int) 387L),
  DeleteReferencesItem_Encoding_DefaultJson((int) 15175L),
  DeleteReferencesItem_Encoding_DefaultXml((int) 386L),
  DeviceFailureEventType((int) 2131L),
  DiagnosticInfo((int) 25L),
  DiagnosticsLevel((int) 19723L),
  DialogConditionType((int) 2830L),
  Dictionaries((int) 17594L),
  DictionaryEntryType((int) 17589L),
  DictionaryFolderType((int) 17591L),
  DiscoveryConfiguration((int) 12890L),
  DiscoveryConfiguration_Encoding_DefaultBinary((int) 12900L),
  DiscoveryConfiguration_Encoding_DefaultJson((int) 15105L),
  DiscoveryConfiguration_Encoding_DefaultXml((int) 12892L),
  DiscrepancyAlarmType((int) 17080L),
  DiscreteAlarmType((int) 10523L),
  DiscreteItemType((int) 2372L),
  Double((int) 11L),
  DoubleComplexNumberType((int) 12172L),
  DoubleComplexNumberType_Encoding_DefaultBinary((int) 12182L),
  DoubleComplexNumberType_Encoding_DefaultJson((int) 15378L),
  DoubleComplexNumberType_Encoding_DefaultXml((int) 12174L),
  Duplex((int) 24210L),
  Duration((int) 290L),
  DurationString((int) 12879L),
  EccApplicationCertificateType((int) 23537L),
  EccBrainpoolP256r1ApplicationCertificateType((int) 23540L),
  EccBrainpoolP384r1ApplicationCertificateType((int) 23541L),
  EccCurve25519ApplicationCertificateType((int) 23542L),
  EccCurve448ApplicationCertificateType((int) 23543L),
  EccNistP256ApplicationCertificateType((int) 23538L),
  EccNistP384ApplicationCertificateType((int) 23539L),
  ElementOperand((int) 592L),
  ElementOperand_Encoding_DefaultBinary((int) 594L),
  ElementOperand_Encoding_DefaultJson((int) 15207L),
  ElementOperand_Encoding_DefaultXml((int) 593L),
  ElseGuardVariableType((int) 15317L),
  EndpointConfiguration((int) 331L),
  EndpointConfiguration_Encoding_DefaultBinary((int) 333L),
  EndpointConfiguration_Encoding_DefaultJson((int) 15199L),
  EndpointConfiguration_Encoding_DefaultXml((int) 332L),
  EndpointDescription((int) 312L),
  EndpointDescription_Encoding_DefaultBinary((int) 314L),
  EndpointDescription_Encoding_DefaultJson((int) 15099L),
  EndpointDescription_Encoding_DefaultXml((int) 313L),
  EndpointType((int) 15528L),
  EndpointType_Encoding_DefaultBinary((int) 15671L),
  EndpointType_Encoding_DefaultJson((int) 16150L),
  EndpointType_Encoding_DefaultXml((int) 15949L),
  EndpointUrlListDataType((int) 11943L),
  EndpointUrlListDataType_Encoding_DefaultBinary((int) 11957L),
  EndpointUrlListDataType_Encoding_DefaultJson((int) 15363L),
  EndpointUrlListDataType_Encoding_DefaultXml((int) 11949L),
  EngineeringUnits((int) 11513L),
  EnumDefinition((int) 100L),
  EnumDefinition_Encoding_DefaultBinary((int) 123L),
  EnumDefinition_Encoding_DefaultJson((int) 15067L),
  EnumDefinition_Encoding_DefaultXml((int) 14799L),
  EnumDescription((int) 15488L),
  EnumDescription_Encoding_DefaultBinary((int) 127L),
  EnumDescription_Encoding_DefaultJson((int) 15059L),
  EnumDescription_Encoding_DefaultXml((int) 15590L),
  Enumeration((int) 29L),
  EnumField((int) 102L),
  EnumField_Encoding_DefaultBinary((int) 14845L),
  EnumField_Encoding_DefaultJson((int) 15083L),
  EnumField_Encoding_DefaultXml((int) 14801L),
  EnumStrings((int) 11432L),
  EnumValues((int) 3071L),
  EnumValueType((int) 7594L),
  EnumValueType_Encoding_DefaultBinary((int) 8251L),
  EnumValueType_Encoding_DefaultJson((int) 15082L),
  EnumValueType_Encoding_DefaultXml((int) 7616L),
  EphemeralKeyType((int) 17548L),
  EphemeralKeyType_Encoding_DefaultBinary((int) 17549L),
  EphemeralKeyType_Encoding_DefaultJson((int) 17557L),
  EphemeralKeyType_Encoding_DefaultXml((int) 17553L),
  EUInformation((int) 887L),
  EUInformation_Encoding_DefaultBinary((int) 889L),
  EUInformation_Encoding_DefaultJson((int) 15376L),
  EUInformation_Encoding_DefaultXml((int) 888L),
  EventFilter((int) 725L),
  EventFilter_Encoding_DefaultBinary((int) 727L),
  EventFilter_Encoding_DefaultJson((int) 15295L),
  EventFilter_Encoding_DefaultXml((int) 726L),
  EventNotifierType((int) 15033L),
  EventQueueOverflowEventType((int) 3035L),
  EventTypesFolder((int) 3048L),
  ExceptionDeviationFormat((int) 890L),
  ExclusiveDeviationAlarmType((int) 9764L),
  ExclusiveLevelAlarmType((int) 9482L),
  ExclusiveLimitAlarmType((int) 9341L),
  ExclusiveLimitStateMachineType((int) 9318L),
  ExclusiveRateOfChangeAlarmType((int) 9623L),
  ExpandedNodeId((int) 18L),
  ExpressionGuardVariableType((int) 15128L),
  ExtensionFieldsType((int) 15489L),
  FieldMetaData((int) 14524L),
  FieldMetaData_Encoding_DefaultBinary((int) 14839L),
  FieldMetaData_Encoding_DefaultJson((int) 15051L),
  FieldMetaData_Encoding_DefaultXml((int) 14795L),
  FieldTargetDataType((int) 14744L),
  FieldTargetDataType_Encoding_DefaultBinary((int) 14848L),
  FieldTargetDataType_Encoding_DefaultJson((int) 15061L),
  FieldTargetDataType_Encoding_DefaultXml((int) 14804L),
  FileDirectoryType((int) 13353L),
  FileSystem((int) 16314L),
  FileTransferStateMachineType((int) 15803L),
  FileType((int) 11575L),
  FilterOperand((int) 589L),
  FilterOperand_Encoding_DefaultBinary((int) 591L),
  FilterOperand_Encoding_DefaultJson((int) 15206L),
  FilterOperand_Encoding_DefaultXml((int) 590L),
  FilterOperator((int) 576L),
  FiniteStateMachineType((int) 2771L),
  FiniteStateVariableType((int) 2760L),
  FiniteTransitionVariableType((int) 2767L),
  Float((int) 10L),
  FolderType((int) 61L),
  Frame((int) 18813L),
  Frame_Encoding_DefaultBinary((int) 18822L),
  Frame_Encoding_DefaultJson((int) 19071L),
  Frame_Encoding_DefaultXml((int) 18858L),
  FrameType((int) 18786L),
  FromState((int) 51L),
  GeneralModelChangeEventType((int) 2133L),
  GeneratesEvent((int) 41L),
  GuardVariableType((int) 15113L),
  Guid((int) 14L),
  HAConfiguration((int) 11202L),
  HasAddIn((int) 17604L),
  HasAlarmSuppressionGroup((int) 16361L),
  HasArgumentDescription((int) 129L),
  HasCause((int) 53L),
  HasChild((int) 34L),
  HasComponent((int) 47L),
  HasCondition((int) 9006L),
  HasDataSetReader((int) 15297L),
  HasDataSetWriter((int) 15296L),
  HasDescription((int) 39L),
  HasDictionaryEntry((int) 17597L),
  HasEffect((int) 54L),
  HasEffectDisable((int) 17276L),
  HasEffectEnable((int) 17983L),
  HasEffectSuppressed((int) 17984L),
  HasEffectUnsuppressed((int) 17985L),
  HasEncoding((int) 38L),
  HasEventSource((int) 36L),
  HasFalseSubState((int) 9005L),
  HasGuard((int) 15112L),
  HasHistoricalConfiguration((int) 56L),
  HasInterface((int) 17603L),
  HasModellingRule((int) 37L),
  HasNotifier((int) 48L),
  HasOptionalInputArgumentDescription((int) 131L),
  HasOrderedComponent((int) 49L),
  HasProperty((int) 46L),
  HasPubSubConnection((int) 14476L),
  HasReaderGroup((int) 18805L),
  HasSubStateMachine((int) 117L),
  HasSubtype((int) 45L),
  HasTrueSubState((int) 9004L),
  HasTypeDefinition((int) 40L),
  HasWriterGroup((int) 18804L),
  HierarchicalReferences((int) 33L),
  HighlyManagedAlarmConditionClassType((int) 17219L),
  HistoricalDataConfigurationType((int) 2318L),
  HistoricalEventFilter((int) 11215L),
  HistoryEvent((int) 659L),
  HistoryEvent_Encoding_DefaultBinary((int) 661L),
  HistoryEvent_Encoding_DefaultJson((int) 15273L),
  HistoryEvent_Encoding_DefaultXml((int) 660L),
  HistoryEventFieldList((int) 920L),
  HistoryEventFieldList_Encoding_DefaultBinary((int) 922L),
  HistoryEventFieldList_Encoding_DefaultJson((int) 15349L),
  HistoryEventFieldList_Encoding_DefaultXml((int) 921L),
  HistoryServerCapabilities((int) 11192L),
  HistoryServerCapabilitiesType((int) 2330L),
  HistoryUpdateType((int) 11234L),
  HttpsCertificateType((int) 12558L),
  IBaseEthernetCapabilitiesType((int) 24167L),
  Icon((int) 3067L),
  IdentityCriteriaType((int) 15632L),
  IdentityMappingRuleType((int) 15634L),
  IdentityMappingRuleType_Encoding_DefaultBinary((int) 15736L),
  IdentityMappingRuleType_Encoding_DefaultJson((int) 15042L),
  IdentityMappingRuleType_Encoding_DefaultXml((int) 15728L),
  IdType((int) 256L),
  IIeeeAutoNegotiationStatusType((int) 24233L),
  IIeeeBaseEthernetPortType((int) 24158L),
  IIeeeBaseTsnStatusStreamType((int) 24183L),
  IIeeeBaseTsnStreamType((int) 24173L),
  IIeeeBaseTsnTrafficSpecificationType((int) 24179L),
  IIeeeTsnInterfaceConfigurationListenerType((int) 24195L),
  IIeeeTsnInterfaceConfigurationTalkerType((int) 24191L),
  IIeeeTsnInterfaceConfigurationType((int) 24188L),
  IIeeeTsnMacAddressType((int) 24199L),
  IIeeeTsnVlanTagType((int) 24202L),
  IIetfBaseNetworkInterfaceType((int) 24148L),
  Image((int) 30L),
  ImageBMP((int) 2000L),
  ImageGIF((int) 2001L),
  ImageItemType((int) 12047L),
  ImageJPG((int) 2002L),
  ImagePNG((int) 2003L),
  Index((int) 17588L),
  InitialStateType((int) 2309L),
  InputArguments((int) 3072L),
  InstrumentDiagnosticAlarmType((int) 18347L),
  Int16((int) 4L),
  Int32((int) 6L),
  Int64((int) 8L),
  Integer((int) 27L),
  IntegerId((int) 288L),
  InterfaceAdminStatus((int) 24212L),
  InterfaceOperStatus((int) 24214L),
  InterfaceTypes((int) 17708L),
  IOrderedObjectType((int) 23513L),
  IPriorityMappingEntryType((int) 24205L),
  IrdiDictionaryEntryType((int) 17598L),
  ISrClassType((int) 24169L),
  IssuedIdentityToken((int) 938L),
  IssuedIdentityToken_Encoding_DefaultBinary((int) 940L),
  IssuedIdentityToken_Encoding_DefaultJson((int) 15144L),
  IssuedIdentityToken_Encoding_DefaultXml((int) 939L),
  JsonDataSetMessageContentMask((int) 15658L),
  JsonDataSetReaderMessageDataType((int) 15665L),
  JsonDataSetReaderMessageDataType_Encoding_DefaultBinary((int) 15725L),
  JsonDataSetReaderMessageDataType_Encoding_DefaultJson((int) 16404L),
  JsonDataSetReaderMessageDataType_Encoding_DefaultXml((int) 16019L),
  JsonDataSetReaderMessageType((int) 21130L),
  JsonDataSetWriterMessageDataType((int) 15664L),
  JsonDataSetWriterMessageDataType_Encoding_DefaultBinary((int) 15724L),
  JsonDataSetWriterMessageDataType_Encoding_DefaultJson((int) 16394L),
  JsonDataSetWriterMessageDataType_Encoding_DefaultXml((int) 16018L),
  JsonDataSetWriterMessageType((int) 21128L),
  JsonNetworkMessageContentMask((int) 15654L),
  JsonWriterGroupMessageDataType((int) 15657L),
  JsonWriterGroupMessageDataType_Encoding_DefaultBinary((int) 15719L),
  JsonWriterGroupMessageDataType_Encoding_DefaultJson((int) 16393L),
  JsonWriterGroupMessageDataType_Encoding_DefaultXml((int) 16017L),
  JsonWriterGroupMessageType((int) 21126L),
  KeyCredentialAuditEventType((int) 18011L),
  KeyCredentialConfiguration((int) 18155L),
  KeyCredentialConfigurationFolderType((int) 17496L),
  KeyCredentialConfigurationType((int) 18001L),
  KeyCredentialDeletedAuditEventType((int) 18047L),
  KeyCredentialUpdatedAuditEventType((int) 18029L),
  KeyValuePair((int) 14533L),
  KeyValuePair_Encoding_DefaultBinary((int) 14846L),
  KeyValuePair_Encoding_DefaultJson((int) 15041L),
  KeyValuePair_Encoding_DefaultXml((int) 14802L),
  LimitAlarmType((int) 2955L),
  ListenerStreams((int) 24232L),
  LiteralOperand((int) 595L),
  LiteralOperand_Encoding_DefaultBinary((int) 597L),
  LiteralOperand_Encoding_DefaultJson((int) 15208L),
  LiteralOperand_Encoding_DefaultXml((int) 596L),
  LocaleId((int) 295L),
  LocalizedText((int) 21L),
  LocalTime((int) 3069L),
  MaintenanceConditionClassType((int) 11165L),
  MappingTables((int) 24228L),
  MaxArrayLength((int) 11512L),
  MaxByteStringLength((int) 12908L),
  MaxCharacters((int) 15002L),
  MaxStringLength((int) 11498L),
  MdnsDiscoveryConfiguration((int) 12891L),
  MdnsDiscoveryConfiguration_Encoding_DefaultBinary((int) 12901L),
  MdnsDiscoveryConfiguration_Encoding_DefaultJson((int) 15106L),
  MdnsDiscoveryConfiguration_Encoding_DefaultXml((int) 12893L),
  MessageSecurityMode((int) 302L),
  ModelChangeStructureDataType((int) 877L),
  ModelChangeStructureDataType_Encoding_DefaultBinary((int) 879L),
  ModelChangeStructureDataType_Encoding_DefaultJson((int) 15373L),
  ModelChangeStructureDataType_Encoding_DefaultXml((int) 878L),
  ModellingRule_ExposesItsArray((int) 83L),
  ModellingRule_Mandatory((int) 78L),
  ModellingRule_MandatoryPlaceholder((int) 11510L),
  ModellingRule_Optional((int) 80L),
  ModellingRule_OptionalPlaceholder((int) 11508L),
  ModellingRuleType((int) 77L),
  MonitoringFilter((int) 719L),
  MonitoringFilter_Encoding_DefaultBinary((int) 721L),
  MonitoringFilter_Encoding_DefaultJson((int) 15293L),
  MonitoringFilter_Encoding_DefaultXml((int) 720L),
  MultiStateDictionaryEntryDiscreteBaseType((int) 19077L),
  MultiStateDictionaryEntryDiscreteType((int) 19084L),
  MultiStateDiscreteType((int) 2376L),
  MultiStateValueDiscreteType((int) 11238L),
  NamespaceMetadataType((int) 11616L),
  NamespacesType((int) 11645L),
  NamingRuleType((int) 120L),
  NDimensionArrayItemType((int) 12068L),
  NegotiationStatus((int) 24216L),
  NetworkAddressDataType((int) 15502L),
  NetworkAddressDataType_Encoding_DefaultBinary((int) 21151L),
  NetworkAddressDataType_Encoding_DefaultJson((int) 21199L),
  NetworkAddressDataType_Encoding_DefaultXml((int) 21175L),
  NetworkAddressType((int) 21145L),
  NetworkAddressUrlDataType((int) 15510L),
  NetworkAddressUrlDataType_Encoding_DefaultBinary((int) 21152L),
  NetworkAddressUrlDataType_Encoding_DefaultJson((int) 21200L),
  NetworkAddressUrlDataType_Encoding_DefaultXml((int) 21176L),
  NetworkAddressUrlType((int) 21147L),
  NetworkGroupDataType((int) 11944L),
  NetworkGroupDataType_Encoding_DefaultBinary((int) 11958L),
  NetworkGroupDataType_Encoding_DefaultJson((int) 15364L),
  NetworkGroupDataType_Encoding_DefaultXml((int) 11950L),
  NetworkInterfaces((int) 24229L),
  NodeAttributesMask((int) 348L),
  NodeClass((int) 257L),
  NodeId((int) 17L),
  NodeVersion((int) 3068L),
  NonExclusiveDeviationAlarmType((int) 10368L),
  NonExclusiveLevelAlarmType((int) 10060L),
  NonExclusiveLimitAlarmType((int) 9906L),
  NonExclusiveRateOfChangeAlarmType((int) 10214L),
  NonHierarchicalReferences((int) 32L),
  NonTransparentNetworkRedundancyType((int) 11945L),
  NonTransparentRedundancyType((int) 2039L),
  NormalizedString((int) 12877L),
  Number((int) 26L),
  NumericRange((int) 291L),
  ObjectsFolder((int) 85L),
  ObjectTypesFolder((int) 88L),
  OffNormalAlarmType((int) 10637L),
  OPCBinarySchema_TypeSystem((int) 93L),
  OpcUa_BinarySchema((int) 7617L),
  OpcUa_XmlSchema((int) 8252L),
  OPCUANamespaceMetadata((int) 15957L),
  OpenFileMode((int) 11939L),
  OperationLimitsType((int) 11564L),
  OptionSet((int) 12755L),
  OptionSet_Encoding_DefaultBinary((int) 12765L),
  OptionSet_Encoding_DefaultJson((int) 15084L),
  OptionSet_Encoding_DefaultXml((int) 12757L),
  OptionSetType((int) 11487L),
  OptionSetValues((int) 12745L),
  OrderedListType((int) 23518L),
  Organizes((int) 35L),
  Orientation((int) 18811L),
  Orientation_Encoding_DefaultBinary((int) 18820L),
  Orientation_Encoding_DefaultJson((int) 19069L),
  Orientation_Encoding_DefaultXml((int) 18856L),
  OrientationType((int) 18779L),
  OutputArguments((int) 3073L),
  OverrideValueHandling((int) 15874L),
  PerformUpdateType((int) 11293L),
  PermissionType((int) 94L),
  ProcessConditionClassType((int) 11164L),
  ProgramDiagnostic2DataType((int) 24033L),
  ProgramDiagnostic2DataType_Encoding_DefaultBinary((int) 24034L),
  ProgramDiagnostic2DataType_Encoding_DefaultJson((int) 24042L),
  ProgramDiagnostic2DataType_Encoding_DefaultXml((int) 24038L),
  ProgramDiagnostic2Type((int) 15383L),
  ProgramDiagnosticDataType((int) 894L),
  ProgramDiagnosticDataType_Encoding_DefaultBinary((int) 896L),
  ProgramDiagnosticDataType_Encoding_DefaultJson((int) 15381L),
  ProgramDiagnosticDataType_Encoding_DefaultXml((int) 895L),
  ProgramDiagnosticType((int) 2380L),
  ProgramStateMachineType((int) 2391L),
  ProgramTransitionAuditEventType((int) 3806L),
  ProgramTransitionEventType((int) 2378L),
  ProgressEventType((int) 11436L),
  PropertyType((int) 68L),
  PublishedDataItemsDataType((int) 15581L),
  PublishedDataItemsDataType_Encoding_DefaultBinary((int) 15679L),
  PublishedDataItemsDataType_Encoding_DefaultJson((int) 16154L),
  PublishedDataItemsDataType_Encoding_DefaultXml((int) 15953L),
  PublishedDataItemsType((int) 14534L),
  PublishedDataSetDataType((int) 15578L),
  PublishedDataSetDataType_Encoding_DefaultBinary((int) 15677L),
  PublishedDataSetDataType_Encoding_DefaultJson((int) 16152L),
  PublishedDataSetDataType_Encoding_DefaultXml((int) 15951L),
  PublishedDataSetSourceDataType((int) 15580L),
  PublishedDataSetSourceDataType_Encoding_DefaultBinary((int) 15678L),
  PublishedDataSetSourceDataType_Encoding_DefaultJson((int) 16153L),
  PublishedDataSetSourceDataType_Encoding_DefaultXml((int) 15952L),
  PublishedDataSetType((int) 14509L),
  PublishedEventsDataType((int) 15582L),
  PublishedEventsDataType_Encoding_DefaultBinary((int) 15681L),
  PublishedEventsDataType_Encoding_DefaultJson((int) 16155L),
  PublishedEventsDataType_Encoding_DefaultXml((int) 15954L),
  PublishedEventsType((int) 14572L),
  PublishedVariableDataType((int) 14273L),
  PublishedVariableDataType_Encoding_DefaultBinary((int) 14323L),
  PublishedVariableDataType_Encoding_DefaultJson((int) 15060L),
  PublishedVariableDataType_Encoding_DefaultXml((int) 14319L),
  PublishSubscribe((int) 14443L),
  PublishSubscribeType((int) 14416L),
  PubSubCommunicationFailureEventType((int) 15563L),
  PubSubConfigurationDataType((int) 15530L),
  PubSubConfigurationDataType_Encoding_DefaultBinary((int) 21154L),
  PubSubConfigurationDataType_Encoding_DefaultJson((int) 21202L),
  PubSubConfigurationDataType_Encoding_DefaultXml((int) 21178L),
  PubSubConnectionDataType((int) 15617L),
  PubSubConnectionDataType_Encoding_DefaultBinary((int) 15694L),
  PubSubConnectionDataType_Encoding_DefaultJson((int) 16281L),
  PubSubConnectionDataType_Encoding_DefaultXml((int) 15992L),
  PubSubConnectionType((int) 14209L),
  PubSubDiagnosticsConnectionType((int) 19786L),
  PubSubDiagnosticsCounterClassification((int) 19730L),
  PubSubDiagnosticsCounterType((int) 19725L),
  PubSubDiagnosticsDataSetReaderType((int) 20027L),
  PubSubDiagnosticsDataSetWriterType((int) 19968L),
  PubSubDiagnosticsReaderGroupType((int) 19903L),
  PubSubDiagnosticsRootType((int) 19732L),
  PubSubDiagnosticsType((int) 19677L),
  PubSubDiagnosticsWriterGroupType((int) 19834L),
  PubSubGroupDataType((int) 15609L),
  PubSubGroupDataType_Encoding_DefaultBinary((int) 15689L),
  PubSubGroupDataType_Encoding_DefaultJson((int) 16159L),
  PubSubGroupDataType_Encoding_DefaultXml((int) 15988L),
  PubSubGroupType((int) 14232L),
  PubSubKeyServiceType((int) 15906L),
  PubSubState((int) 14647L),
  PubSubStatusEventType((int) 15535L),
  PubSubStatusType((int) 14643L),
  PubSubTransportLimitsExceedEventType((int) 15548L),
  QualifiedName((int) 20L),
  Range((int) 884L),
  Range_Encoding_DefaultBinary((int) 886L),
  Range_Encoding_DefaultJson((int) 15375L),
  Range_Encoding_DefaultXml((int) 885L),
  RationalNumber((int) 18806L),
  RationalNumber_Encoding_DefaultBinary((int) 18815L),
  RationalNumber_Encoding_DefaultJson((int) 19064L),
  RationalNumber_Encoding_DefaultXml((int) 18851L),
  RationalNumberType((int) 17709L),
  ReaderGroupDataType((int) 15520L),
  ReaderGroupDataType_Encoding_DefaultBinary((int) 21153L),
  ReaderGroupDataType_Encoding_DefaultJson((int) 21201L),
  ReaderGroupDataType_Encoding_DefaultXml((int) 21177L),
  ReaderGroupMessageDataType((int) 15622L),
  ReaderGroupMessageDataType_Encoding_DefaultBinary((int) 15702L),
  ReaderGroupMessageDataType_Encoding_DefaultJson((int) 16285L),
  ReaderGroupMessageDataType_Encoding_DefaultXml((int) 15996L),
  ReaderGroupMessageType((int) 21091L),
  ReaderGroupTransportDataType((int) 15621L),
  ReaderGroupTransportDataType_Encoding_DefaultBinary((int) 15701L),
  ReaderGroupTransportDataType_Encoding_DefaultJson((int) 16284L),
  ReaderGroupTransportDataType_Encoding_DefaultXml((int) 15995L),
  ReaderGroupTransportType((int) 21090L),
  ReaderGroupType((int) 17999L),
  RedundancySupport((int) 851L),
  RedundantServerDataType((int) 853L),
  RedundantServerDataType_Encoding_DefaultBinary((int) 855L),
  RedundantServerDataType_Encoding_DefaultJson((int) 15362L),
  RedundantServerDataType_Encoding_DefaultXml((int) 854L),
  References((int) 31L),
  ReferenceTypesFolder((int) 91L),
  RefreshEndEventType((int) 2788L),
  RefreshRequiredEventType((int) 2789L),
  RefreshStartEventType((int) 2787L),
  RegisteredServer((int) 432L),
  RegisteredServer_Encoding_DefaultBinary((int) 434L),
  RegisteredServer_Encoding_DefaultJson((int) 15102L),
  RegisteredServer_Encoding_DefaultXml((int) 433L),
  RelativePath((int) 540L),
  RelativePath_Encoding_DefaultBinary((int) 542L),
  RelativePath_Encoding_DefaultJson((int) 15189L),
  RelativePath_Encoding_DefaultXml((int) 541L),
  RelativePathElement((int) 537L),
  RelativePathElement_Encoding_DefaultBinary((int) 539L),
  RelativePathElement_Encoding_DefaultJson((int) 15188L),
  RelativePathElement_Encoding_DefaultXml((int) 538L),
  Resources((int) 24226L),
  RoleMappingRuleChangedAuditEventType((int) 17641L),
  RolePermissionType((int) 96L),
  RolePermissionType_Encoding_DefaultBinary((int) 128L),
  RolePermissionType_Encoding_DefaultJson((int) 15062L),
  RolePermissionType_Encoding_DefaultXml((int) 16126L),
  RoleSetType((int) 15607L),
  RoleType((int) 15620L),
  RootFolder((int) 84L),
  RsaMinApplicationCertificateType((int) 12559L),
  RsaSha256ApplicationCertificateType((int) 12560L),
  SafetyConditionClassType((int) 17218L),
  SamplingIntervalDiagnosticsArrayType((int) 2164L),
  SamplingIntervalDiagnosticsDataType((int) 856L),
  SamplingIntervalDiagnosticsDataType_Encoding_DefaultBinary((int) 858L),
  SamplingIntervalDiagnosticsDataType_Encoding_DefaultJson((int) 15365L),
  SamplingIntervalDiagnosticsDataType_Encoding_DefaultXml((int) 857L),
  SamplingIntervalDiagnosticsType((int) 2165L),
  SByte((int) 2L),
  SecurityGroupFolderType((int) 15452L),
  SecurityGroupType((int) 15471L),
  SecurityTokenRequestType((int) 315L),
  SelectionListType((int) 16309L),
  SemanticChangeEventType((int) 2738L),
  SemanticChangeStructureDataType((int) 897L),
  SemanticChangeStructureDataType_Encoding_DefaultBinary((int) 899L),
  SemanticChangeStructureDataType_Encoding_DefaultJson((int) 15374L),
  SemanticChangeStructureDataType_Encoding_DefaultXml((int) 898L),
  Server((int) 2253L),
  Server_ServerRedundancy_CurrentServerId((int) 11312L),
  Server_ServerRedundancy_RedundantServerArray((int) 11313L),
  Server_ServerRedundancy_ServerNetworkGroups((int) 14415L),
  Server_ServerRedundancy_ServerUriArray((int) 11314L),
  ServerCapabilitiesType((int) 2013L),
  ServerConfiguration((int) 12637L),
  ServerConfigurationType((int) 12581L),
  ServerDiagnosticsSummaryDataType((int) 859L),
  ServerDiagnosticsSummaryDataType_Encoding_DefaultBinary((int) 861L),
  ServerDiagnosticsSummaryDataType_Encoding_DefaultJson((int) 15366L),
  ServerDiagnosticsSummaryDataType_Encoding_DefaultXml((int) 860L),
  ServerDiagnosticsSummaryType((int) 2150L),
  ServerDiagnosticsType((int) 2020L),
  ServerOnNetwork((int) 12189L),
  ServerOnNetwork_Encoding_DefaultBinary((int) 12207L),
  ServerOnNetwork_Encoding_DefaultJson((int) 15095L),
  ServerOnNetwork_Encoding_DefaultXml((int) 12195L),
  ServerRedundancyType((int) 2034L),
  ServerState((int) 852L),
  ServerStatusDataType((int) 862L),
  ServerStatusDataType_Encoding_DefaultBinary((int) 864L),
  ServerStatusDataType_Encoding_DefaultJson((int) 15367L),
  ServerStatusDataType_Encoding_DefaultXml((int) 863L),
  ServerStatusType((int) 2138L),
  ServerType((int) 2004L),
  ServerVendorCapabilityType((int) 2137L),
  ServiceCounterDataType((int) 871L),
  ServiceCounterDataType_Encoding_DefaultBinary((int) 873L),
  ServiceCounterDataType_Encoding_DefaultJson((int) 15370L),
  ServiceCounterDataType_Encoding_DefaultXml((int) 872L),
  SessionAuthenticationToken((int) 388L),
  SessionDiagnosticsArrayType((int) 2196L),
  SessionDiagnosticsDataType((int) 865L),
  SessionDiagnosticsDataType_Encoding_DefaultBinary((int) 867L),
  SessionDiagnosticsDataType_Encoding_DefaultJson((int) 15368L),
  SessionDiagnosticsDataType_Encoding_DefaultXml((int) 866L),
  SessionDiagnosticsObjectType((int) 2029L),
  SessionDiagnosticsVariableType((int) 2197L),
  SessionsDiagnosticsSummaryType((int) 2026L),
  SessionSecurityDiagnosticsArrayType((int) 2243L),
  SessionSecurityDiagnosticsDataType((int) 868L),
  SessionSecurityDiagnosticsDataType_Encoding_DefaultBinary((int) 870L),
  SessionSecurityDiagnosticsDataType_Encoding_DefaultJson((int) 15369L),
  SessionSecurityDiagnosticsDataType_Encoding_DefaultXml((int) 869L),
  SessionSecurityDiagnosticsType((int) 2244L),
  ShelvedStateMachineType((int) 2929L),
  SignedSoftwareCertificate((int) 344L),
  SignedSoftwareCertificate_Encoding_DefaultBinary((int) 346L),
  SignedSoftwareCertificate_Encoding_DefaultJson((int) 15136L),
  SignedSoftwareCertificate_Encoding_DefaultXml((int) 345L),
  SimpleAttributeOperand((int) 601L),
  SimpleAttributeOperand_Encoding_DefaultBinary((int) 603L),
  SimpleAttributeOperand_Encoding_DefaultJson((int) 15210L),
  SimpleAttributeOperand_Encoding_DefaultXml((int) 602L),
  SimpleTypeDescription((int) 15005L),
  SimpleTypeDescription_Encoding_DefaultBinary((int) 15421L),
  SimpleTypeDescription_Encoding_DefaultJson((int) 15700L),
  SimpleTypeDescription_Encoding_DefaultXml((int) 15529L),
  StateMachineType((int) 2299L),
  StateType((int) 2307L),
  StateVariableType((int) 2755L),
  StatisticalConditionClassType((int) 18665L),
  StatusCode((int) 19L),
  StatusResult((int) 299L),
  StatusResult_Encoding_DefaultBinary((int) 301L),
  StatusResult_Encoding_DefaultJson((int) 15371L),
  StatusResult_Encoding_DefaultXml((int) 300L),
  Streams((int) 24230L),
  String((int) 12L),
  Structure((int) 22L),
  StructureDefinition((int) 99L),
  StructureDefinition_Encoding_DefaultBinary((int) 122L),
  StructureDefinition_Encoding_DefaultJson((int) 15066L),
  StructureDefinition_Encoding_DefaultXml((int) 14798L),
  StructureDescription((int) 15487L),
  StructureDescription_Encoding_DefaultBinary((int) 126L),
  StructureDescription_Encoding_DefaultJson((int) 15058L),
  StructureDescription_Encoding_DefaultXml((int) 15589L),
  StructureField((int) 101L),
  StructureField_Encoding_DefaultBinary((int) 14844L),
  StructureField_Encoding_DefaultJson((int) 15065L),
  StructureField_Encoding_DefaultXml((int) 14800L),
  StructureType((int) 98L),
  SubscribedDataSetDataType((int) 15630L),
  SubscribedDataSetDataType_Encoding_DefaultBinary((int) 15707L),
  SubscribedDataSetDataType_Encoding_DefaultJson((int) 16308L),
  SubscribedDataSetDataType_Encoding_DefaultXml((int) 16010L),
  SubscribedDataSetMirrorDataType((int) 15635L),
  SubscribedDataSetMirrorDataType_Encoding_DefaultBinary((int) 15713L),
  SubscribedDataSetMirrorDataType_Encoding_DefaultJson((int) 16311L),
  SubscribedDataSetMirrorDataType_Encoding_DefaultXml((int) 16012L),
  SubscribedDataSetMirrorType((int) 15127L),
  SubscribedDataSetType((int) 15108L),
  SubscriptionDiagnosticsArrayType((int) 2171L),
  SubscriptionDiagnosticsDataType((int) 874L),
  SubscriptionDiagnosticsDataType_Encoding_DefaultBinary((int) 876L),
  SubscriptionDiagnosticsDataType_Encoding_DefaultJson((int) 15372L),
  SubscriptionDiagnosticsDataType_Encoding_DefaultXml((int) 875L),
  SubscriptionDiagnosticsType((int) 2172L),
  SystemConditionClassType((int) 11166L),
  SystemDiagnosticAlarmType((int) 18496L),
  SystemEventType((int) 2130L),
  SystemOffNormalAlarmType((int) 11753L),
  SystemStatusChangeEventType((int) 11446L),
  TagVariables((int) 23479L),
  TalkerStreams((int) 24231L),
  TargetVariablesDataType((int) 15631L),
  TargetVariablesDataType_Encoding_DefaultBinary((int) 15712L),
  TargetVariablesDataType_Encoding_DefaultJson((int) 16310L),
  TargetVariablesDataType_Encoding_DefaultXml((int) 16011L),
  TargetVariablesType((int) 15111L),
  TemporaryFileTransferType((int) 15744L),
  TestingConditionSubClassType((int) 17221L),
  ThreeDCartesianCoordinates((int) 18810L),
  ThreeDCartesianCoordinates_Encoding_DefaultBinary((int) 18819L),
  ThreeDCartesianCoordinates_Encoding_DefaultJson((int) 19068L),
  ThreeDCartesianCoordinates_Encoding_DefaultXml((int) 18855L),
  ThreeDCartesianCoordinatesType((int) 18774L),
  ThreeDFrame((int) 18814L),
  ThreeDFrame_Encoding_DefaultBinary((int) 18823L),
  ThreeDFrame_Encoding_DefaultJson((int) 19072L),
  ThreeDFrame_Encoding_DefaultXml((int) 18859L),
  ThreeDFrameType((int) 18791L),
  ThreeDOrientation((int) 18812L),
  ThreeDOrientation_Encoding_DefaultBinary((int) 18821L),
  ThreeDOrientation_Encoding_DefaultJson((int) 19070L),
  ThreeDOrientation_Encoding_DefaultXml((int) 18857L),
  ThreeDOrientationType((int) 18781L),
  ThreeDVector((int) 18808L),
  ThreeDVector_Encoding_DefaultBinary((int) 18817L),
  ThreeDVector_Encoding_DefaultJson((int) 19066L),
  ThreeDVector_Encoding_DefaultXml((int) 18853L),
  ThreeDVectorType((int) 17716L),
  Time((int) 292L),
  TimeString((int) 12880L),
  TimeZoneDataType((int) 8912L),
  TimeZoneDataType_Encoding_DefaultBinary((int) 8917L),
  TimeZoneDataType_Encoding_DefaultJson((int) 15086L),
  TimeZoneDataType_Encoding_DefaultXml((int) 8913L),
  Topics((int) 23488L),
  ToState((int) 52L),
  TrainingConditionClassType((int) 17220L),
  TransitionEventType((int) 2311L),
  TransitionType((int) 2310L),
  TransitionVariableType((int) 2762L),
  TransparentRedundancyType((int) 2036L),
  TripAlarmType((int) 10751L),
  TrustListDataType((int) 12554L),
  TrustListDataType_Encoding_DefaultBinary((int) 12680L),
  TrustListDataType_Encoding_DefaultJson((int) 15044L),
  TrustListDataType_Encoding_DefaultXml((int) 12676L),
  TrustListMasks((int) 12552L),
  TrustListOutOfDateAlarmType((int) 19297L),
  TrustListType((int) 12522L),
  TrustListUpdatedAuditEventType((int) 12561L),
  TsnFailureCode((int) 24218L),
  TsnListenerStatus((int) 24224L),
  TsnStreamState((int) 24220L),
  TsnTalkerStatus((int) 24222L),
  TwoStateDiscreteType((int) 2373L),
  TwoStateVariableType((int) 8995L),
  TypesFolder((int) 86L),
  UABinaryFileDataType((int) 15006L),
  UABinaryFileDataType_Encoding_DefaultBinary((int) 15422L),
  UABinaryFileDataType_Encoding_DefaultJson((int) 15714L),
  UABinaryFileDataType_Encoding_DefaultXml((int) 15531L),
  UadpDataSetMessageContentMask((int) 15646L),
  UadpDataSetReaderMessageDataType((int) 15653L),
  UadpDataSetReaderMessageDataType_Encoding_DefaultBinary((int) 15718L),
  UadpDataSetReaderMessageDataType_Encoding_DefaultJson((int) 16392L),
  UadpDataSetReaderMessageDataType_Encoding_DefaultXml((int) 16016L),
  UadpDataSetReaderMessageType((int) 21116L),
  UadpDataSetWriterMessageDataType((int) 15652L),
  UadpDataSetWriterMessageDataType_Encoding_DefaultBinary((int) 15717L),
  UadpDataSetWriterMessageDataType_Encoding_DefaultJson((int) 16391L),
  UadpDataSetWriterMessageDataType_Encoding_DefaultXml((int) 16015L),
  UadpDataSetWriterMessageType((int) 21111L),
  UadpNetworkMessageContentMask((int) 15642L),
  UadpWriterGroupMessageDataType((int) 15645L),
  UadpWriterGroupMessageDataType_Encoding_DefaultBinary((int) 15715L),
  UadpWriterGroupMessageDataType_Encoding_DefaultJson((int) 16323L),
  UadpWriterGroupMessageDataType_Encoding_DefaultXml((int) 16014L),
  UadpWriterGroupMessageType((int) 21105L),
  UInt16((int) 5L),
  UInt32((int) 7L),
  UInt64((int) 9L),
  UInteger((int) 28L),
  Union((int) 12756L),
  Union_Encoding_DefaultBinary((int) 12766L),
  Union_Encoding_DefaultJson((int) 15085L),
  Union_Encoding_DefaultXml((int) 12758L),
  UnsignedRationalNumber((int) 24107L),
  UnsignedRationalNumber_Encoding_DefaultBinary((int) 24110L),
  UnsignedRationalNumber_Encoding_DefaultJson((int) 24134L),
  UnsignedRationalNumber_Encoding_DefaultXml((int) 24122L),
  UriDictionaryEntryType((int) 17600L),
  UserCredentialCertificateType((int) 15181L),
  UserIdentityToken((int) 316L),
  UserIdentityToken_Encoding_DefaultBinary((int) 318L),
  UserIdentityToken_Encoding_DefaultJson((int) 15140L),
  UserIdentityToken_Encoding_DefaultXml((int) 317L),
  UserNameIdentityToken((int) 322L),
  UserNameIdentityToken_Encoding_DefaultBinary((int) 324L),
  UserNameIdentityToken_Encoding_DefaultJson((int) 15142L),
  UserNameIdentityToken_Encoding_DefaultXml((int) 323L),
  UserTokenPolicy((int) 304L),
  UserTokenPolicy_Encoding_DefaultBinary((int) 306L),
  UserTokenPolicy_Encoding_DefaultJson((int) 15098L),
  UserTokenPolicy_Encoding_DefaultXml((int) 305L),
  UserTokenType((int) 303L),
  UtcTime((int) 294L),
  ValueAsText((int) 11433L),
  VariableTypesFolder((int) 89L),
  Vector((int) 18807L),
  Vector_Encoding_DefaultBinary((int) 18816L),
  Vector_Encoding_DefaultJson((int) 19065L),
  Vector_Encoding_DefaultXml((int) 18852L),
  VectorType((int) 17714L),
  VendorServerInfoType((int) 2033L),
  VersionTime((int) 20998L),
  ViewsFolder((int) 87L),
  ViewVersion((int) 12170L),
  WellKnownRole_Anonymous((int) 15644L),
  WellKnownRole_AuthenticatedUser((int) 15656L),
  WellKnownRole_ConfigureAdmin((int) 15716L),
  WellKnownRole_Engineer((int) 16036L),
  WellKnownRole_Observer((int) 15668L),
  WellKnownRole_Operator((int) 15680L),
  WellKnownRole_SecurityAdmin((int) 15704L),
  WellKnownRole_Supervisor((int) 15692L),
  WriterGroupDataType((int) 15480L),
  WriterGroupDataType_Encoding_DefaultBinary((int) 21150L),
  WriterGroupDataType_Encoding_DefaultJson((int) 21198L),
  WriterGroupDataType_Encoding_DefaultXml((int) 21174L),
  WriterGroupMessageDataType((int) 15616L),
  WriterGroupMessageDataType_Encoding_DefaultBinary((int) 15693L),
  WriterGroupMessageDataType_Encoding_DefaultJson((int) 16280L),
  WriterGroupMessageDataType_Encoding_DefaultXml((int) 15991L),
  WriterGroupMessageType((int) 17998L),
  WriterGroupTransportDataType((int) 15611L),
  WriterGroupTransportDataType_Encoding_DefaultBinary((int) 15691L),
  WriterGroupTransportDataType_Encoding_DefaultJson((int) 16161L),
  WriterGroupTransportDataType_Encoding_DefaultXml((int) 15990L),
  WriterGroupTransportType((int) 17997L),
  WriterGroupType((int) 17725L),
  X509IdentityToken((int) 325L),
  X509IdentityToken_Encoding_DefaultBinary((int) 327L),
  X509IdentityToken_Encoding_DefaultJson((int) 15143L),
  X509IdentityToken_Encoding_DefaultXml((int) 326L),
  XmlElement((int) 16L),
  XmlSchema_TypeSystem((int) 92L),
  XVType((int) 12080L),
  XVType_Encoding_DefaultBinary((int) 12090L),
  XVType_Encoding_DefaultJson((int) 15380L),
  XVType_Encoding_DefaultXml((int) 12082L),
  XYArrayItemType((int) 12038L),
  YArrayItemType((int) 12029L);
  private static final Map<Integer, OpcuaNodeIdServices> map;

  static {
    map = new HashMap<>();
    for (OpcuaNodeIdServices value : OpcuaNodeIdServices.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private int value;

  OpcuaNodeIdServices(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static OpcuaNodeIdServices enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
