/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class NodeTypeDescription extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "575";
  }

  // Properties.
  protected final ExpandedNodeId typeDefinitionNode;
  protected final boolean includeSubTypes;
  protected final int noOfDataToReturn;
  protected final List<ExtensionObjectDefinition> dataToReturn;
  // Reserved Fields
  private Short reservedField0;

  public NodeTypeDescription(
      ExpandedNodeId typeDefinitionNode,
      boolean includeSubTypes,
      int noOfDataToReturn,
      List<ExtensionObjectDefinition> dataToReturn) {
    super();
    this.typeDefinitionNode = typeDefinitionNode;
    this.includeSubTypes = includeSubTypes;
    this.noOfDataToReturn = noOfDataToReturn;
    this.dataToReturn = dataToReturn;
  }

  public ExpandedNodeId getTypeDefinitionNode() {
    return typeDefinitionNode;
  }

  public boolean getIncludeSubTypes() {
    return includeSubTypes;
  }

  public int getNoOfDataToReturn() {
    return noOfDataToReturn;
  }

  public List<ExtensionObjectDefinition> getDataToReturn() {
    return dataToReturn;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("NodeTypeDescription");

    // Simple Field (typeDefinitionNode)
    writeSimpleField(
        "typeDefinitionNode", typeDefinitionNode, new DataWriterComplexDefault<>(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (short) 0x00,
        writeUnsignedShort(writeBuffer, 7));

    // Simple Field (includeSubTypes)
    writeSimpleField("includeSubTypes", includeSubTypes, writeBoolean(writeBuffer));

    // Simple Field (noOfDataToReturn)
    writeSimpleField("noOfDataToReturn", noOfDataToReturn, writeSignedInt(writeBuffer, 32));

    // Array Field (dataToReturn)
    writeComplexTypeArrayField("dataToReturn", dataToReturn, writeBuffer);

    writeBuffer.popContext("NodeTypeDescription");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    NodeTypeDescription _value = this;

    // Simple field (typeDefinitionNode)
    lengthInBits += typeDefinitionNode.getLengthInBits();

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (includeSubTypes)
    lengthInBits += 1;

    // Simple field (noOfDataToReturn)
    lengthInBits += 32;

    // Array field
    if (dataToReturn != null) {
      int i = 0;
      for (ExtensionObjectDefinition element : dataToReturn) {
        boolean last = ++i >= dataToReturn.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static NodeTypeDescriptionBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("NodeTypeDescription");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    ExpandedNodeId typeDefinitionNode =
        readSimpleField(
            "typeDefinitionNode",
            new DataReaderComplexDefault<>(
                () -> ExpandedNodeId.staticParse(readBuffer), readBuffer));

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 7), (short) 0x00);

    boolean includeSubTypes = readSimpleField("includeSubTypes", readBoolean(readBuffer));

    int noOfDataToReturn = readSimpleField("noOfDataToReturn", readSignedInt(readBuffer, 32));

    List<ExtensionObjectDefinition> dataToReturn =
        readCountArrayField(
            "dataToReturn",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("572")),
                readBuffer),
            noOfDataToReturn);

    readBuffer.closeContext("NodeTypeDescription");
    // Create the instance
    return new NodeTypeDescriptionBuilder(
        typeDefinitionNode, includeSubTypes, noOfDataToReturn, dataToReturn, reservedField0);
  }

  public static class NodeTypeDescriptionBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExpandedNodeId typeDefinitionNode;
    private final boolean includeSubTypes;
    private final int noOfDataToReturn;
    private final List<ExtensionObjectDefinition> dataToReturn;
    private final Short reservedField0;

    public NodeTypeDescriptionBuilder(
        ExpandedNodeId typeDefinitionNode,
        boolean includeSubTypes,
        int noOfDataToReturn,
        List<ExtensionObjectDefinition> dataToReturn,
        Short reservedField0) {
      this.typeDefinitionNode = typeDefinitionNode;
      this.includeSubTypes = includeSubTypes;
      this.noOfDataToReturn = noOfDataToReturn;
      this.dataToReturn = dataToReturn;
      this.reservedField0 = reservedField0;
    }

    public NodeTypeDescription build() {
      NodeTypeDescription nodeTypeDescription =
          new NodeTypeDescription(
              typeDefinitionNode, includeSubTypes, noOfDataToReturn, dataToReturn);
      nodeTypeDescription.reservedField0 = reservedField0;
      return nodeTypeDescription;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof NodeTypeDescription)) {
      return false;
    }
    NodeTypeDescription that = (NodeTypeDescription) o;
    return (getTypeDefinitionNode() == that.getTypeDefinitionNode())
        && (getIncludeSubTypes() == that.getIncludeSubTypes())
        && (getNoOfDataToReturn() == that.getNoOfDataToReturn())
        && (getDataToReturn() == that.getDataToReturn())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getTypeDefinitionNode(),
        getIncludeSubTypes(),
        getNoOfDataToReturn(),
        getDataToReturn());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
