/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum NodeAttributesMask {
  nodeAttributesMaskNone((long) 0L),
  nodeAttributesMaskAccessLevel((long) 1L),
  nodeAttributesMaskArrayDimensions((long) 2L),
  nodeAttributesMaskBrowseName((long) 4L),
  nodeAttributesMaskContainsNoLoops((long) 8L),
  nodeAttributesMaskDataType((long) 16L),
  nodeAttributesMaskDescription((long) 32L),
  nodeAttributesMaskDisplayName((long) 64L),
  nodeAttributesMaskEventNotifier((long) 128L),
  nodeAttributesMaskExecutable((long) 256L),
  nodeAttributesMaskHistorizing((long) 512L),
  nodeAttributesMaskInverseName((long) 1024L),
  nodeAttributesMaskIsAbstract((long) 2048L),
  nodeAttributesMaskMinimumSamplingInterval((long) 4096L),
  nodeAttributesMaskNodeClass((long) 8192L),
  nodeAttributesMaskNodeId((long) 16384L),
  nodeAttributesMaskSymmetric((long) 32768L),
  nodeAttributesMaskUserAccessLevel((long) 65536L),
  nodeAttributesMaskUserExecutable((long) 131072L),
  nodeAttributesMaskUserWriteMask((long) 262144L),
  nodeAttributesMaskValueRank((long) 524288L),
  nodeAttributesMaskWriteMask((long) 1048576L),
  nodeAttributesMaskValue((long) 2097152L),
  nodeAttributesMaskDataTypeDefinition((long) 4194304L),
  nodeAttributesMaskRolePermissions((long) 8388608L),
  nodeAttributesMaskAccessRestrictions((long) 16777216L),
  nodeAttributesMaskAll((long) 33554431L),
  nodeAttributesMaskBaseNode((long) 26501220L),
  nodeAttributesMaskObject((long) 26501348L),
  nodeAttributesMaskObjectType((long) 26503268L),
  nodeAttributesMaskVariable((long) 26571383L),
  nodeAttributesMaskVariableType((long) 28600438L),
  nodeAttributesMaskMethod((long) 26632548L),
  nodeAttributesMaskReferenceType((long) 26537060L),
  nodeAttributesMaskView((long) 26501356L);
  private static final Map<Long, NodeAttributesMask> map;

  static {
    map = new HashMap<>();
    for (NodeAttributesMask value : NodeAttributesMask.values()) {
      map.put((long) value.getValue(), value);
    }
  }

  private long value;

  NodeAttributesMask(long value) {
    this.value = value;
  }

  public long getValue() {
    return value;
  }

  public static NodeAttributesMask enumForValue(long value) {
    return map.get(value);
  }

  public static Boolean isDefined(long value) {
    return map.containsKey(value);
  }
}
