/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class IssuedIdentityToken extends UserIdentityTokenDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "identity";
  }

  // Properties.
  protected final PascalByteString tokenData;
  protected final PascalString encryptionAlgorithm;

  public IssuedIdentityToken(PascalByteString tokenData, PascalString encryptionAlgorithm) {
    super();
    this.tokenData = tokenData;
    this.encryptionAlgorithm = encryptionAlgorithm;
  }

  public PascalByteString getTokenData() {
    return tokenData;
  }

  public PascalString getEncryptionAlgorithm() {
    return encryptionAlgorithm;
  }

  @Override
  protected void serializeUserIdentityTokenDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("IssuedIdentityToken");

    // Simple Field (tokenData)
    writeSimpleField("tokenData", tokenData, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (encryptionAlgorithm)
    writeSimpleField(
        "encryptionAlgorithm", encryptionAlgorithm, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("IssuedIdentityToken");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    IssuedIdentityToken _value = this;

    // Simple field (tokenData)
    lengthInBits += tokenData.getLengthInBits();

    // Simple field (encryptionAlgorithm)
    lengthInBits += encryptionAlgorithm.getLengthInBits();

    return lengthInBits;
  }

  public static IssuedIdentityTokenBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("IssuedIdentityToken");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    PascalByteString tokenData =
        readSimpleField(
            "tokenData",
            new DataReaderComplexDefault<>(
                () -> PascalByteString.staticParse(readBuffer), readBuffer));

    PascalString encryptionAlgorithm =
        readSimpleField(
            "encryptionAlgorithm",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("IssuedIdentityToken");
    // Create the instance
    return new IssuedIdentityTokenBuilder(tokenData, encryptionAlgorithm);
  }

  public static class IssuedIdentityTokenBuilder
      implements UserIdentityTokenDefinition.UserIdentityTokenDefinitionBuilder {
    private final PascalByteString tokenData;
    private final PascalString encryptionAlgorithm;

    public IssuedIdentityTokenBuilder(
        PascalByteString tokenData, PascalString encryptionAlgorithm) {

      this.tokenData = tokenData;
      this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public IssuedIdentityToken build() {
      IssuedIdentityToken issuedIdentityToken =
          new IssuedIdentityToken(tokenData, encryptionAlgorithm);
      return issuedIdentityToken;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof IssuedIdentityToken)) {
      return false;
    }
    IssuedIdentityToken that = (IssuedIdentityToken) o;
    return (getTokenData() == that.getTokenData())
        && (getEncryptionAlgorithm() == that.getEncryptionAlgorithm())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getTokenData(), getEncryptionAlgorithm());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
