/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class EndpointType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "15530";
  }

  // Properties.
  protected final PascalString endpointUrl;
  protected final MessageSecurityMode securityMode;
  protected final PascalString securityPolicyUri;
  protected final PascalString transportProfileUri;

  public EndpointType(
      PascalString endpointUrl,
      MessageSecurityMode securityMode,
      PascalString securityPolicyUri,
      PascalString transportProfileUri) {
    super();
    this.endpointUrl = endpointUrl;
    this.securityMode = securityMode;
    this.securityPolicyUri = securityPolicyUri;
    this.transportProfileUri = transportProfileUri;
  }

  public PascalString getEndpointUrl() {
    return endpointUrl;
  }

  public MessageSecurityMode getSecurityMode() {
    return securityMode;
  }

  public PascalString getSecurityPolicyUri() {
    return securityPolicyUri;
  }

  public PascalString getTransportProfileUri() {
    return transportProfileUri;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("EndpointType");

    // Simple Field (endpointUrl)
    writeSimpleField("endpointUrl", endpointUrl, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (securityMode)
    writeSimpleEnumField(
        "securityMode",
        "MessageSecurityMode",
        securityMode,
        new DataWriterEnumDefault<>(
            MessageSecurityMode::getValue,
            MessageSecurityMode::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (securityPolicyUri)
    writeSimpleField(
        "securityPolicyUri", securityPolicyUri, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (transportProfileUri)
    writeSimpleField(
        "transportProfileUri", transportProfileUri, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("EndpointType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    EndpointType _value = this;

    // Simple field (endpointUrl)
    lengthInBits += endpointUrl.getLengthInBits();

    // Simple field (securityMode)
    lengthInBits += 32;

    // Simple field (securityPolicyUri)
    lengthInBits += securityPolicyUri.getLengthInBits();

    // Simple field (transportProfileUri)
    lengthInBits += transportProfileUri.getLengthInBits();

    return lengthInBits;
  }

  public static EndpointTypeBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier)
      throws ParseException {
    readBuffer.pullContext("EndpointType");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    PascalString endpointUrl =
        readSimpleField(
            "endpointUrl",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    MessageSecurityMode securityMode =
        readEnumField(
            "securityMode",
            "MessageSecurityMode",
            new DataReaderEnumDefault<>(
                MessageSecurityMode::enumForValue, readUnsignedLong(readBuffer, 32)));

    PascalString securityPolicyUri =
        readSimpleField(
            "securityPolicyUri",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString transportProfileUri =
        readSimpleField(
            "transportProfileUri",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("EndpointType");
    // Create the instance
    return new EndpointTypeBuilder(
        endpointUrl, securityMode, securityPolicyUri, transportProfileUri);
  }

  public static class EndpointTypeBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString endpointUrl;
    private final MessageSecurityMode securityMode;
    private final PascalString securityPolicyUri;
    private final PascalString transportProfileUri;

    public EndpointTypeBuilder(
        PascalString endpointUrl,
        MessageSecurityMode securityMode,
        PascalString securityPolicyUri,
        PascalString transportProfileUri) {

      this.endpointUrl = endpointUrl;
      this.securityMode = securityMode;
      this.securityPolicyUri = securityPolicyUri;
      this.transportProfileUri = transportProfileUri;
    }

    public EndpointType build() {
      EndpointType endpointType =
          new EndpointType(endpointUrl, securityMode, securityPolicyUri, transportProfileUri);
      return endpointType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof EndpointType)) {
      return false;
    }
    EndpointType that = (EndpointType) o;
    return (getEndpointUrl() == that.getEndpointUrl())
        && (getSecurityMode() == that.getSecurityMode())
        && (getSecurityPolicyUri() == that.getSecurityPolicyUri())
        && (getTransportProfileUri() == that.getTransportProfileUri())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getEndpointUrl(),
        getSecurityMode(),
        getSecurityPolicyUri(),
        getTransportProfileUri());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
