/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ContentFilterElement extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "585";
  }

  // Properties.
  protected final FilterOperator filterOperator;
  protected final int noOfFilterOperands;
  protected final List<ExtensionObject> filterOperands;

  public ContentFilterElement(
      FilterOperator filterOperator, int noOfFilterOperands, List<ExtensionObject> filterOperands) {
    super();
    this.filterOperator = filterOperator;
    this.noOfFilterOperands = noOfFilterOperands;
    this.filterOperands = filterOperands;
  }

  public FilterOperator getFilterOperator() {
    return filterOperator;
  }

  public int getNoOfFilterOperands() {
    return noOfFilterOperands;
  }

  public List<ExtensionObject> getFilterOperands() {
    return filterOperands;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("ContentFilterElement");

    // Simple Field (filterOperator)
    writeSimpleEnumField(
        "filterOperator",
        "FilterOperator",
        filterOperator,
        new DataWriterEnumDefault<>(
            FilterOperator::getValue, FilterOperator::name, writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (noOfFilterOperands)
    writeSimpleField("noOfFilterOperands", noOfFilterOperands, writeSignedInt(writeBuffer, 32));

    // Array Field (filterOperands)
    writeComplexTypeArrayField("filterOperands", filterOperands, writeBuffer);

    writeBuffer.popContext("ContentFilterElement");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ContentFilterElement _value = this;

    // Simple field (filterOperator)
    lengthInBits += 32;

    // Simple field (noOfFilterOperands)
    lengthInBits += 32;

    // Array field
    if (filterOperands != null) {
      int i = 0;
      for (ExtensionObject element : filterOperands) {
        boolean last = ++i >= filterOperands.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ContentFilterElementBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("ContentFilterElement");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    FilterOperator filterOperator =
        readEnumField(
            "filterOperator",
            "FilterOperator",
            new DataReaderEnumDefault<>(
                FilterOperator::enumForValue, readUnsignedLong(readBuffer, 32)));

    int noOfFilterOperands = readSimpleField("noOfFilterOperands", readSignedInt(readBuffer, 32));

    List<ExtensionObject> filterOperands =
        readCountArrayField(
            "filterOperands",
            new DataReaderComplexDefault<>(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer),
            noOfFilterOperands);

    readBuffer.closeContext("ContentFilterElement");
    // Create the instance
    return new ContentFilterElementBuilder(filterOperator, noOfFilterOperands, filterOperands);
  }

  public static class ContentFilterElementBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final FilterOperator filterOperator;
    private final int noOfFilterOperands;
    private final List<ExtensionObject> filterOperands;

    public ContentFilterElementBuilder(
        FilterOperator filterOperator,
        int noOfFilterOperands,
        List<ExtensionObject> filterOperands) {

      this.filterOperator = filterOperator;
      this.noOfFilterOperands = noOfFilterOperands;
      this.filterOperands = filterOperands;
    }

    public ContentFilterElement build() {
      ContentFilterElement contentFilterElement =
          new ContentFilterElement(filterOperator, noOfFilterOperands, filterOperands);
      return contentFilterElement;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ContentFilterElement)) {
      return false;
    }
    ContentFilterElement that = (ContentFilterElement) o;
    return (getFilterOperator() == that.getFilterOperator())
        && (getNoOfFilterOperands() == that.getNoOfFilterOperands())
        && (getFilterOperands() == that.getFilterOperands())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getFilterOperator(), getNoOfFilterOperands(), getFilterOperands());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
