/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BrowsePath extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "545";
  }

  // Properties.
  protected final NodeId startingNode;
  protected final ExtensionObjectDefinition relativePath;

  public BrowsePath(NodeId startingNode, ExtensionObjectDefinition relativePath) {
    super();
    this.startingNode = startingNode;
    this.relativePath = relativePath;
  }

  public NodeId getStartingNode() {
    return startingNode;
  }

  public ExtensionObjectDefinition getRelativePath() {
    return relativePath;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("BrowsePath");

    // Simple Field (startingNode)
    writeSimpleField("startingNode", startingNode, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (relativePath)
    writeSimpleField("relativePath", relativePath, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BrowsePath");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BrowsePath _value = this;

    // Simple field (startingNode)
    lengthInBits += startingNode.getLengthInBits();

    // Simple field (relativePath)
    lengthInBits += relativePath.getLengthInBits();

    return lengthInBits;
  }

  public static BrowsePathBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier)
      throws ParseException {
    readBuffer.pullContext("BrowsePath");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    NodeId startingNode =
        readSimpleField(
            "startingNode",
            new DataReaderComplexDefault<>(() -> NodeId.staticParse(readBuffer), readBuffer));

    ExtensionObjectDefinition relativePath =
        readSimpleField(
            "relativePath",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("542")),
                readBuffer));

    readBuffer.closeContext("BrowsePath");
    // Create the instance
    return new BrowsePathBuilder(startingNode, relativePath);
  }

  public static class BrowsePathBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final NodeId startingNode;
    private final ExtensionObjectDefinition relativePath;

    public BrowsePathBuilder(NodeId startingNode, ExtensionObjectDefinition relativePath) {

      this.startingNode = startingNode;
      this.relativePath = relativePath;
    }

    public BrowsePath build() {
      BrowsePath browsePath = new BrowsePath(startingNode, relativePath);
      return browsePath;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BrowsePath)) {
      return false;
    }
    BrowsePath that = (BrowsePath) o;
    return (getStartingNode() == that.getStartingNode())
        && (getRelativePath() == that.getRelativePath())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getStartingNode(), getRelativePath());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
