/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.base.tag;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.modbus.base.tag.ModbusTag;
import org.apache.plc4x.java.modbus.readwrite.ModbusDataType;
import org.apache.plc4x.java.spi.tag.TagConfigParser;

public class ModbusTagDiscreteInput
extends ModbusTag {
    public static final String ADDRESS_PREFIX = "1x";
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("discrete-input:" + ModbusTag.ADDRESS_PATTERN + TagConfigParser.TAG_CONFIG_PATTERN);
    public static final Pattern ADDRESS_SHORTER_PATTERN = Pattern.compile("1" + ModbusTag.FIXED_DIGIT_MODBUS_PATTERN + TagConfigParser.TAG_CONFIG_PATTERN);
    public static final Pattern ADDRESS_SHORT_PATTERN = Pattern.compile("1x" + ModbusTag.FIXED_DIGIT_MODBUS_PATTERN + TagConfigParser.TAG_CONFIG_PATTERN);
    protected static final int REGISTER_MAX_ADDRESS = 65535;

    public ModbusTagDiscreteInput(int address, Integer quantity, ModbusDataType dataType, Map<String, String> config) {
        super(address, quantity, dataType, config);
    }

    @Override
    protected String getAddressStringPrefix() {
        return ADDRESS_PREFIX;
    }

    @Override
    public int getLogicalAddress() {
        return this.getAddress() + 1;
    }

    public static boolean matches(String addressString) {
        return ADDRESS_PATTERN.matcher(addressString).matches() || ADDRESS_SHORTER_PATTERN.matcher(addressString).matches() || ADDRESS_SHORT_PATTERN.matcher(addressString).matches();
    }

    public static Matcher getMatcher(String addressString) {
        Matcher matcher = ADDRESS_PATTERN.matcher(addressString);
        if (matcher.matches()) {
            return matcher;
        }
        matcher = ADDRESS_SHORT_PATTERN.matcher(addressString);
        if (matcher.matches()) {
            return matcher;
        }
        matcher = ADDRESS_SHORTER_PATTERN.matcher(addressString);
        if (matcher.matches()) {
            return matcher;
        }
        throw new PlcInvalidTagException(addressString, ADDRESS_PATTERN);
    }

    public static ModbusTagDiscreteInput of(String addressString) {
        int quantity;
        Matcher matcher = ModbusTagDiscreteInput.getMatcher(addressString);
        int address = Integer.parseInt(matcher.group("address")) - 1;
        if (address > 65535) {
            throw new IllegalArgumentException("Address must be less than or equal to 65535. Was " + (address + 1));
        }
        String quantityString = matcher.group("quantity");
        int n = quantity = quantityString != null ? Integer.parseInt(quantityString) : 1;
        if (address + quantity > 65535) {
            throw new IllegalArgumentException("Last requested address is out of range, should be between 1 and 65535. Was " + (address + 1 + (quantity - 1)));
        }
        if (quantity > 2000) {
            throw new IllegalArgumentException("quantity may not be larger than 2000. Was " + quantity);
        }
        ModbusDataType dataType = matcher.group("datatype") != null ? ModbusDataType.valueOf(matcher.group("datatype")) : ModbusDataType.BOOL;
        return new ModbusTagDiscreteInput(address, quantity, dataType, TagConfigParser.parse((String)addressString));
    }
}

