/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.base.optimizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.modbus.base.context.ModbusContext;
import org.apache.plc4x.java.modbus.base.protocol.ModbusProtocolLogic;
import org.apache.plc4x.java.modbus.base.tag.ModbusTag;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagCoil;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagDiscreteInput;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagExtendedRegister;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagHoldingRegister;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagInputRegister;
import org.apache.plc4x.java.modbus.readwrite.DataItem;
import org.apache.plc4x.java.modbus.readwrite.ModbusDataType;
import org.apache.plc4x.java.modbus.types.ModbusByteOrder;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferXmlBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.PlcReader;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcResponseItem;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcTagItem;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.optimizer.SingleTagOptimizer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusOptimizer
extends SingleTagOptimizer {
    private final Logger logger = LoggerFactory.getLogger(ModbusOptimizer.class);

    protected List<PlcReadRequest> processReadRequest(PlcReadRequest readRequest, DriverContext driverContext) {
        ModbusContext modbusContext = (ModbusContext)driverContext;
        TreeSet<ModbusTag> coils = null;
        TreeSet<ModbusTag> holdingRegisters = null;
        TreeSet<ModbusTag> inputRegisters = null;
        TreeSet<ModbusTag> extendedRegisters = null;
        TreeSet<ModbusTag> discreteInputs = null;
        for (PlcTag tag : readRequest.getTags()) {
            if (tag instanceof ModbusTagCoil) {
                if (coils == null) {
                    coils = new TreeSet<ModbusTag>(Comparator.comparingInt(ModbusTag::getAddress));
                }
                coils.add((ModbusTagCoil)tag);
                continue;
            }
            if (tag instanceof ModbusTagHoldingRegister) {
                if (holdingRegisters == null) {
                    holdingRegisters = new TreeSet<ModbusTag>(Comparator.comparingInt(ModbusTag::getAddress));
                }
                holdingRegisters.add((ModbusTagHoldingRegister)tag);
                continue;
            }
            if (tag instanceof ModbusTagInputRegister) {
                if (inputRegisters == null) {
                    inputRegisters = new TreeSet<ModbusTag>(Comparator.comparingInt(ModbusTag::getAddress));
                }
                inputRegisters.add((ModbusTagInputRegister)tag);
                continue;
            }
            if (tag instanceof ModbusTagExtendedRegister) {
                if (extendedRegisters == null) {
                    extendedRegisters = new TreeSet<ModbusTag>(Comparator.comparingInt(ModbusTag::getAddress));
                }
                extendedRegisters.add((ModbusTagExtendedRegister)tag);
                continue;
            }
            if (!(tag instanceof ModbusTagDiscreteInput)) continue;
            if (discreteInputs == null) {
                discreteInputs = new TreeSet<ModbusTag>(Comparator.comparingInt(ModbusTag::getAddress));
            }
            discreteInputs.add((ModbusTagDiscreteInput)tag);
        }
        PlcReader reader = ((DefaultPlcReadRequest)readRequest).getReader();
        ArrayList<PlcReadRequest> subRequests = new ArrayList<PlcReadRequest>();
        if (coils != null) {
            subRequests.addAll(this.processCoilRequests(coils, reader, modbusContext));
        }
        if (holdingRegisters != null) {
            subRequests.addAll(this.processRegisterRequests(holdingRegisters, reader, (address, count, dataType) -> new ModbusTagHoldingRegister(address, count, dataType, Collections.emptyMap()), modbusContext));
        }
        if (inputRegisters != null) {
            subRequests.addAll(this.processRegisterRequests(inputRegisters, reader, (address, count, dataType) -> new ModbusTagInputRegister(address, count, dataType, Collections.emptyMap()), modbusContext));
        }
        if (extendedRegisters != null) {
            subRequests.addAll(this.processRegisterRequests(extendedRegisters, reader, (address, count, dataType) -> new ModbusTagExtendedRegister(address, count, dataType, Collections.emptyMap()), modbusContext));
        }
        if (discreteInputs != null) {
            subRequests.addAll(this.processRegisterRequests(discreteInputs, reader, (address, count, dataType) -> new ModbusTagDiscreteInput(address, count, dataType, Collections.emptyMap()), modbusContext));
        }
        return subRequests;
    }

    protected PlcReadResponse processReadResponses(PlcReadRequest readRequest, Map<PlcReadRequest, BaseOptimizer.SubResponse<PlcReadResponse>> readResponses, DriverContext driverContext) {
        ModbusContext modbusContext = (ModbusContext)driverContext;
        try {
            HashMap responses = new HashMap();
            for (PlcReadRequest optimizedReadRequest : readResponses.keySet()) {
                String tagName;
                PlcReadResponse optimizedReadResponse = (PlcReadResponse)readResponses.get(optimizedReadRequest).getResponse();
                if (optimizedReadResponse == null || (tagName = (String)optimizedReadRequest.getTagNames().stream().findFirst().orElse(null)) == null) continue;
                ModbusTag modbusTag = (ModbusTag)optimizedReadRequest.getTag(tagName);
                String tagType = modbusTag.getClass().getSimpleName().substring("ModbusTag".length());
                if (!responses.containsKey(tagType)) {
                    responses.put(tagType, new ArrayList());
                }
                PlcResponseCode responseCode = optimizedReadResponse.getResponseCode(tagName);
                int startingAddress = modbusTag.getAddress();
                int endingAddressRegister = modbusTag.getAddress() + modbusTag.getNumberOfElements();
                int endingAddressCoil = modbusTag.getAddress() + modbusTag.getNumberOfElements();
                byte[] responseData = responseCode == PlcResponseCode.OK ? optimizedReadResponse.getPlcValue(tagName).getRaw() : null;
                ((List)responses.get(tagType)).add(new Response(responseCode, startingAddress, endingAddressRegister, endingAddressCoil, responseData));
            }
            HashMap<String, DefaultPlcResponseItem> values = new HashMap<String, DefaultPlcResponseItem>();
            for (String tagName : readRequest.getTagNames()) {
                ModbusTag modbusTag = (ModbusTag)readRequest.getTag(tagName);
                String tagType = modbusTag.getClass().getSimpleName().substring("ModbusTag".length());
                if (!responses.containsKey(tagType)) {
                    values.put(tagName, new DefaultPlcResponseItem(PlcResponseCode.NOT_FOUND, null));
                    continue;
                }
                for (Response response : (List)responses.get(tagType)) {
                    if (modbusTag instanceof ModbusTagCoil || modbusTag instanceof ModbusTagDiscreteInput) {
                        int bitPositionInByte;
                        int bitPosition;
                        int bytePosition;
                        if (!response.matchesCoil(modbusTag)) continue;
                        if (response.getResponseCode() != PlcResponseCode.OK) {
                            values.put(tagName, new DefaultPlcResponseItem(response.getResponseCode(), null));
                            break;
                        }
                        byte[] responseData = response.getResponseData();
                        boolean isBitSet = (responseData[bytePosition = (bitPosition = modbusTag.getAddress() - response.startingAddress) / 8] & 1 << (bitPositionInByte = bitPosition % 8)) != 0;
                        values.put(tagName, new DefaultPlcResponseItem(PlcResponseCode.OK, (Object)new PlcBOOL(isBitSet)));
                        break;
                    }
                    if (!response.matchesRegister(modbusTag)) continue;
                    if (response.getResponseCode() != PlcResponseCode.OK) {
                        values.put(tagName, new DefaultPlcResponseItem(response.getResponseCode(), null));
                        break;
                    }
                    ModbusByteOrder byteOrder = modbusTag.getByteOrder() != null ? modbusTag.getByteOrder() : modbusContext.getByteOrder();
                    byte[] responseData = response.getResponseDataForTag(modbusTag);
                    ReadBuffer readBuffer = this.getReadBuffer(responseData, byteOrder);
                    try {
                        PlcValue plcValue = DataItem.staticParse(readBuffer, modbusTag.getDataType(), modbusTag.getNumberOfElements(), byteOrder == ModbusByteOrder.BIG_ENDIAN);
                        values.put(tagName, new DefaultPlcResponseItem(PlcResponseCode.OK, (Object)plcValue));
                    }
                    catch (ParseException e) {
                        values.put(tagName, new DefaultPlcResponseItem(PlcResponseCode.INTERNAL_ERROR, null));
                    }
                    break;
                }
                if (values.containsKey(tagName)) continue;
                values.put(tagName, new DefaultPlcResponseItem(PlcResponseCode.INTERNAL_ERROR, null));
            }
            return new DefaultPlcReadResponse(readRequest, values);
        }
        catch (Exception e) {
            try {
                this.logger.error("Error processing response:", (Throwable)e);
                WriteBufferXmlBased wb = new WriteBufferXmlBased();
                ((DefaultPlcReadRequest)readRequest).serialize((WriteBuffer)wb);
                this.logger.error("Original Request:\n{}", (Object)wb.getXmlString(), (Object)e);
                for (PlcReadRequest subRequest : readResponses.keySet()) {
                    BaseOptimizer.SubResponse<PlcReadResponse> subResponse = readResponses.get(subRequest);
                    WriteBufferXmlBased wbSubRequest = new WriteBufferXmlBased();
                    ((DefaultPlcReadRequest)subRequest).serialize((WriteBuffer)wbSubRequest);
                    this.logger.error("Sub Request:\n{}", (Object)wbSubRequest.getXmlString());
                    if (subResponse.isSuccess()) {
                        PlcReadResponse plcReadResponse = (PlcReadResponse)subResponse.getResponse();
                        WriteBufferXmlBased wbSubResponse = new WriteBufferXmlBased();
                        ((DefaultPlcReadResponse)plcReadResponse).serialize((WriteBuffer)wbSubResponse);
                        this.logger.error("Sub Response (Success):\n{}", (Object)wbSubResponse.getXmlString());
                        continue;
                    }
                    Throwable throwable = subResponse.getThrowable();
                    this.logger.error("Sub Response (Error):", throwable);
                }
            }
            catch (SerializationException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    protected List<PlcReadRequest> processCoilRequests(TreeSet<ModbusTag> tags, PlcReader reader, ModbusContext modbusContext) {
        ArrayList<PlcReadRequest> subRequests = new ArrayList<PlcReadRequest>();
        int firstCoil = -1;
        int lastCoil = -1;
        int maxCoilCurRequest = -1;
        for (ModbusTag tag : tags) {
            int sizeInCoils = tag.getDataType().getDataTypeSize() * 8;
            if (tag.getDataType() == ModbusDataType.BOOL) {
                sizeInCoils = 1;
            }
            if (firstCoil == -1) {
                firstCoil = tag.getAddress();
                lastCoil = tag.getAddress() + sizeInCoils * tag.getNumberOfElements();
                maxCoilCurRequest = tag.getAddress() + modbusContext.getMaxCoilsPerRequest();
            }
            if (tag.getAddress() + sizeInCoils * tag.getNumberOfElements() > maxCoilCurRequest) {
                LinkedHashMap<String, DefaultPlcTagItem> subTags = new LinkedHashMap<String, DefaultPlcTagItem>();
                subTags.put("coils" + subRequests.size(), new DefaultPlcTagItem((PlcTag)new ModbusTagCoil(firstCoil, lastCoil - firstCoil, ModbusDataType.BYTE, Collections.emptyMap())));
                subRequests.add((PlcReadRequest)new DefaultPlcReadRequest(reader, subTags));
                firstCoil = tag.getAddress();
                lastCoil = tag.getAddress() + sizeInCoils * tag.getNumberOfElements();
                maxCoilCurRequest = tag.getAddress() + modbusContext.getMaxCoilsPerRequest();
                continue;
            }
            lastCoil = tag.getAddress() + tag.getNumberOfElements();
        }
        LinkedHashMap<String, DefaultPlcTagItem> subTags = new LinkedHashMap<String, DefaultPlcTagItem>();
        subTags.put("coils" + subRequests.size(), new DefaultPlcTagItem((PlcTag)new ModbusTagCoil(firstCoil, lastCoil - firstCoil, ModbusDataType.BYTE, Collections.emptyMap())));
        subRequests.add((PlcReadRequest)new DefaultPlcReadRequest(reader, subTags));
        return subRequests;
    }

    protected List<PlcReadRequest> processRegisterRequests(TreeSet<ModbusTag> tags, PlcReader reader, TagFactory tagFactory, ModbusContext modbusContext) {
        ArrayList<PlcReadRequest> subRequests = new ArrayList<PlcReadRequest>();
        int firstRegister = -1;
        int lastRegister = -1;
        int maxRegisterCurRequest = -1;
        for (ModbusTag tag : tags) {
            int sizeInRegisters = (int)Math.ceil((double)tag.getDataType().getDataTypeSize() / 2.0);
            if (firstRegister == -1) {
                firstRegister = tag.getAddress();
                lastRegister = tag.getAddress() + sizeInRegisters * tag.getNumberOfElements();
                maxRegisterCurRequest = tag.getAddress() + modbusContext.getMaxRegistersPerRequest();
            }
            if (tag.getAddress() + sizeInRegisters * tag.getNumberOfElements() > maxRegisterCurRequest) {
                LinkedHashMap<String, DefaultPlcTagItem> subTags = new LinkedHashMap<String, DefaultPlcTagItem>();
                subTags.put("registers" + subRequests.size(), new DefaultPlcTagItem(tagFactory.createTag(firstRegister, lastRegister - firstRegister, ModbusDataType.WORD)));
                subRequests.add((PlcReadRequest)new DefaultPlcReadRequest(reader, subTags));
                firstRegister = tag.getAddress();
                lastRegister = tag.getAddress() + sizeInRegisters * tag.getNumberOfElements();
                maxRegisterCurRequest = tag.getAddress() + modbusContext.getMaxRegistersPerRequest();
                continue;
            }
            lastRegister = tag.getAddress() + sizeInRegisters * tag.getNumberOfElements();
        }
        LinkedHashMap<String, DefaultPlcTagItem> subTags = new LinkedHashMap<String, DefaultPlcTagItem>();
        subTags.put("registers" + subRequests.size(), new DefaultPlcTagItem(tagFactory.createTag(firstRegister, lastRegister - firstRegister, ModbusDataType.WORD)));
        subRequests.add((PlcReadRequest)new DefaultPlcReadRequest(reader, subTags));
        return subRequests;
    }

    private ReadBuffer getReadBuffer(byte[] data, ModbusByteOrder byteOrder) {
        switch (byteOrder) {
            case LITTLE_ENDIAN: {
                return new ReadBufferByteBased(data, ByteOrder.LITTLE_ENDIAN);
            }
            case BIG_ENDIAN_BYTE_SWAP: {
                byte[] reordered = ModbusProtocolLogic.byteSwap(data);
                return new ReadBufferByteBased(reordered, ByteOrder.BIG_ENDIAN);
            }
            case LITTLE_ENDIAN_BYTE_SWAP: {
                byte[] reordered = ModbusProtocolLogic.byteSwap(data);
                return new ReadBufferByteBased(reordered, ByteOrder.LITTLE_ENDIAN);
            }
        }
        return new ReadBufferByteBased(data, ByteOrder.BIG_ENDIAN);
    }

    protected static class Response {
        private final PlcResponseCode responseCode;
        private final int startingAddress;
        private final int endingAddressCoil;
        private final int endingAddressRegister;
        private final byte[] responseData;

        public Response(PlcResponseCode responseCode, int startingAddress, int endingAddressRegister, int endingAddressCoil, byte[] responseData) {
            this.responseCode = responseCode;
            this.startingAddress = startingAddress;
            this.responseData = responseData;
            this.endingAddressCoil = endingAddressRegister;
            this.endingAddressRegister = endingAddressCoil;
        }

        public boolean matchesCoil(ModbusTag modbusTag) {
            int tagStartingAddress = modbusTag.getAddress();
            int tagEndingAddress = modbusTag.getAddress() + modbusTag.getNumberOfElements();
            return tagStartingAddress >= this.startingAddress && tagEndingAddress <= this.endingAddressCoil;
        }

        public boolean matchesRegister(ModbusTag modbusTag) {
            int tagStartingAddress = modbusTag.getAddress();
            int tagEndingAddress = modbusTag.getAddress() + (int)Math.ceil((double)modbusTag.getLengthBytes() / 2.0);
            return tagStartingAddress >= this.startingAddress && tagEndingAddress <= this.endingAddressRegister;
        }

        public PlcResponseCode getResponseCode() {
            return this.responseCode;
        }

        public byte[] getResponseData() {
            return this.responseData;
        }

        public byte[] getResponseDataForTag(ModbusTag modbusTag) {
            byte[] itemData = new byte[modbusTag.getLengthBytes()];
            System.arraycopy(this.responseData, (modbusTag.getAddress() - this.startingAddress) * 2, itemData, 0, modbusTag.getLengthBytes());
            return itemData;
        }
    }

    protected static interface TagFactory {
        public PlcTag createTag(int var1, int var2, ModbusDataType var3);
    }
}

