/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.ascii;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.plc4x.java.modbus.ascii.config.ModbusAsciiConfiguration;
import org.apache.plc4x.java.modbus.ascii.context.ModbusAsciiContext;
import org.apache.plc4x.java.modbus.ascii.protocol.ModbusAsciiProtocolLogic;
import org.apache.plc4x.java.modbus.base.tag.ModbusTag;
import org.apache.plc4x.java.modbus.readwrite.DriverType;
import org.apache.plc4x.java.modbus.readwrite.ModbusAsciiADU;
import org.apache.plc4x.java.modbus.tcp.config.ModbusTcpTransportConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.generation.MessageInput;
import org.apache.plc4x.java.spi.generation.MessageOutput;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.optimizer.SingleTagOptimizer;

public class ModbusAsciiDriver
extends GeneratedDriverBase<ModbusAsciiADU> {
    public String getProtocolCode() {
        return "modbus-ascii";
    }

    public String getProtocolName() {
        return "Modbus ASCII";
    }

    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return ModbusAsciiConfiguration.class;
    }

    protected Optional<Class<? extends PlcTransportConfiguration>> getTransportConfigurationClass(String transportCode) {
        switch (transportCode) {
            case "tcp": {
                return Optional.of(ModbusTcpTransportConfiguration.class);
            }
        }
        return Optional.empty();
    }

    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("serial");
    }

    protected List<String> getSupportedTransportCodes() {
        return Arrays.asList("tcp", "serial");
    }

    protected boolean awaitSetupComplete() {
        return false;
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected boolean canPing() {
        return true;
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected BaseOptimizer getOptimizer() {
        return new SingleTagOptimizer();
    }

    protected ProtocolStackConfigurer<ModbusAsciiADU> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(ModbusAsciiADU.class, (MessageInput)new ModbusAsciiInput(), (MessageOutput)new ModbusAsciiOutput()).withProtocol(ModbusAsciiProtocolLogic.class).withDriverContext(ModbusAsciiContext.class).withPacketSizeEstimator(ByteLengthEstimator.class).withCorruptPacketRemover(CorruptPackageCleaner.class).build();
    }

    public ModbusTag prepareTag(String tagAddress) {
        return ModbusTag.of(tagAddress);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 9) {
                byte[] buf = new byte[byteBuf.readableBytes()];
                byteBuf.getBytes(byteBuf.readerIndex(), buf);
                ReadBufferByteBased reader = new ReadBufferByteBased(buf);
                try {
                    ModbusAsciiInput input = new ModbusAsciiInput();
                    ModbusAsciiADU modbusADU = input.parse((ReadBuffer)reader);
                    return modbusADU.getLengthInBytes() * 2 + 3;
                }
                catch (ParseException e) {
                    return -1;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    byteBuf.discardReadBytes();
                    return -1;
                }
            }
            return -1;
        }
    }

    public static class CorruptPackageCleaner
    implements Consumer<ByteBuf> {
        @Override
        public void accept(ByteBuf byteBuf) {
            while (byteBuf.getUnsignedByte(0) != 58) {
                byteBuf.readByte();
            }
        }
    }

    public static class ModbusAsciiInput
    implements MessageInput<ModbusAsciiADU> {
        public ModbusAsciiADU parse(ReadBuffer io) throws ParseException {
            short startChar = io.readShort(8, new WithReaderArgs[0]);
            if (startChar != 58) {
                throw new ParseException(String.format("Expected starting ':' character but got %c", startChar));
            }
            ReadBufferByteBased bufferByteBased = (ReadBufferByteBased)io;
            byte[] bytes = bufferByteBased.getBytes(bufferByteBased.getPos(), bufferByteBased.getTotalBytes() - 2);
            String inputString = new String(bytes, StandardCharsets.UTF_8);
            try {
                byte[] decodedBytes = Hex.decodeHex((String)inputString);
                ReadBufferByteBased readBuffer = new ReadBufferByteBased(decodedBytes);
                return (ModbusAsciiADU)ModbusAsciiADU.staticParse((ReadBuffer)readBuffer, DriverType.MODBUS_ASCII, true);
            }
            catch (DecoderException e) {
                throw new ParseException(String.format("Error parsing incoming message: %s", inputString), (Throwable)e);
            }
        }
    }

    public static class ModbusAsciiOutput
    implements MessageOutput<ModbusAsciiADU> {
        public WriteBufferByteBased serialize(ModbusAsciiADU value) throws SerializationException {
            WriteBufferByteBased writeBufferByteBased = new WriteBufferByteBased(value.getLengthInBytes());
            value.serialize((WriteBuffer)writeBufferByteBased);
            byte[] decodedBytes = writeBufferByteBased.getBytes();
            String hexString = Hex.encodeHexString((byte[])decodedBytes).toUpperCase();
            WriteBufferByteBased encodedWriteBuffer = new WriteBufferByteBased(hexString.length() + 3);
            encodedWriteBuffer.writeShort(8, (short)58, new WithWriterArgs[0]);
            encodedWriteBuffer.writeByteArray(hexString.getBytes(StandardCharsets.UTF_8), new WithWriterArgs[0]);
            encodedWriteBuffer.writeShort(8, (short)13, new WithWriterArgs[0]);
            encodedWriteBuffer.writeShort(8, (short)10, new WithWriterArgs[0]);
            return encodedWriteBuffer;
        }
    }
}

