/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.math.BigInteger;
import java.util.LinkedList;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.modbus.readwrite.ModbusDataType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcCHAR;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcDWORD;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcLWORD;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.apache.plc4x.java.spi.values.PlcWCHAR;
import org.apache.plc4x.java.spi.values.PlcWORD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataItem.class);

    public static PlcValue staticParse(ReadBuffer readBuffer, ModbusDataType dataType, Integer numberOfValues) throws ParseException {
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.BOOL)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            short reserved = readBuffer.readUnsignedShort("", 15, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.BOOL))) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcBOOL> value = new LinkedList<PlcBOOL>();
            int curItem = 0;
            while (curItem < itemCount) {
                value.add(new PlcBOOL(Boolean.valueOf(readBuffer.readBit("", new WithReaderArgs[0]))));
                ++curItem;
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.BYTE)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcBYTE(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.BYTE))) {
            if (numberOfValues * 8 > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues * 8 + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues * 8;
            LinkedList<PlcBOOL> value = new LinkedList<PlcBOOL>();
            int curItem = 0;
            while (curItem < itemCount) {
                value.add(new PlcBOOL(Boolean.valueOf(readBuffer.readBit("", new WithReaderArgs[0]))));
                ++curItem;
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.WORD))) {
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcWORD(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.DWORD))) {
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcDWORD(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.LWORD))) {
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcLWORD(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.SINT)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte value = readBuffer.readSignedByte("", 8, new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.SINT))) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            int curItem = 0;
            while (curItem < itemCount) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readSignedByte("", 8, new WithReaderArgs[0]))));
                ++curItem;
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.INT)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.INT))) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcINT> value = new LinkedList<PlcINT>();
            int curItem = 0;
            while (curItem < itemCount) {
                value.add(new PlcINT(Short.valueOf(readBuffer.readShort("", 16, new WithReaderArgs[0]))));
                ++curItem;
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.DINT)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.DINT))) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcDINT> value = new LinkedList<PlcDINT>();
            int curItem = 0;
            while (curItem < itemCount) {
                value.add(new PlcDINT(Integer.valueOf(readBuffer.readInt("", 32, new WithReaderArgs[0]))));
                ++curItem;
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.LINT)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Long value = readBuffer.readLong("", 64, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.LINT))) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcLINT> value = new LinkedList<PlcLINT>();
            int curItem = 0;
            while (curItem < itemCount) {
                value.add(new PlcLINT(Long.valueOf(readBuffer.readLong("", 64, new WithReaderArgs[0]))));
                ++curItem;
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.USINT)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.USINT))) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcUSINT> value = new LinkedList<PlcUSINT>();
            int curItem = 0;
            while (curItem < itemCount) {
                value.add(new PlcUSINT(Short.valueOf(readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]))));
                ++curItem;
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.UINT)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.UINT))) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcUINT> value = new LinkedList<PlcUINT>();
            int curItem = 0;
            while (curItem < itemCount) {
                value.add(new PlcUINT(Integer.valueOf(readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]))));
                ++curItem;
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.UDINT)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.UDINT))) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcUDINT> value = new LinkedList<PlcUDINT>();
            int curItem = 0;
            while (curItem < itemCount) {
                value.add(new PlcUDINT(Long.valueOf(readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]))));
                ++curItem;
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.ULINT)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.ULINT))) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcULINT> value = new LinkedList<PlcULINT>();
            int curItem = 0;
            while (curItem < itemCount) {
                value.add(new PlcULINT(readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0])));
                ++curItem;
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.REAL)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.REAL))) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcREAL> value = new LinkedList<PlcREAL>();
            int curItem = 0;
            while (curItem < itemCount) {
                value.add(new PlcREAL(Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]))));
                ++curItem;
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.LREAL)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Double value = readBuffer.readDouble("", 64, new WithReaderArgs[0]);
            return new PlcLREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.LREAL))) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcLREAL> value = new LinkedList<PlcLREAL>();
            int curItem = 0;
            while (curItem < itemCount) {
                value.add(new PlcLREAL(Double.valueOf(readBuffer.readDouble("", 64, new WithReaderArgs[0]))));
                ++curItem;
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.CHAR)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            String value = readBuffer.readString("", 8, new WithReaderArgs[]{WithOption.WithEncoding((String)"UTF-8")});
            return new PlcCHAR(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.CHAR))) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcSTRING> value = new LinkedList<PlcSTRING>();
            int curItem = 0;
            while (curItem < itemCount) {
                value.add(new PlcSTRING(readBuffer.readString("", 8, new WithReaderArgs[]{WithOption.WithEncoding((String)"UTF-8")})));
                ++curItem;
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.WCHAR)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            String value = readBuffer.readString("", 16, new WithReaderArgs[]{WithOption.WithEncoding((String)"UTF-16")});
            return new PlcWCHAR(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.WCHAR))) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcSTRING> value = new LinkedList<PlcSTRING>();
            int curItem = 0;
            while (curItem < itemCount) {
                value.add(new PlcSTRING(readBuffer.readString("", 16, new WithReaderArgs[]{WithOption.WithEncoding((String)"UTF-16")})));
                ++curItem;
            }
            return new PlcList(value);
        }
        return null;
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, ModbusDataType dataType, Integer numberOfValues) throws SerializationException {
        DataItem.staticSerialize(writeBuffer, _value, dataType, numberOfValues, ByteOrder.BIG_ENDIAN);
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, ModbusDataType dataType, Integer numberOfValues, ByteOrder byteOrder) throws SerializationException {
        block15: {
            block44: {
                block43: {
                    block42: {
                        block41: {
                            block40: {
                                block39: {
                                    block38: {
                                        block37: {
                                            block36: {
                                                block35: {
                                                    block34: {
                                                        block33: {
                                                            block32: {
                                                                block31: {
                                                                    block30: {
                                                                        block29: {
                                                                            block28: {
                                                                                block27: {
                                                                                    block26: {
                                                                                        block25: {
                                                                                            block24: {
                                                                                                block23: {
                                                                                                    block22: {
                                                                                                        block21: {
                                                                                                            block20: {
                                                                                                                block19: {
                                                                                                                    block18: {
                                                                                                                        block17: {
                                                                                                                            block16: {
                                                                                                                                block14: {
                                                                                                                                    if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.BOOL)) || !EvaluationHelper.equals((Object)numberOfValues, (Object)1)) break block14;
                                                                                                                                    writeBuffer.writeUnsignedShort("", 15, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                    boolean value = _value.getBoolean();
                                                                                                                                    writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                    break block15;
                                                                                                                                }
                                                                                                                                if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.BOOL))) break block16;
                                                                                                                                PlcList values = (PlcList)_value;
                                                                                                                                for (PlcValue val : values.getList()) {
                                                                                                                                    Boolean value = val.getBoolean();
                                                                                                                                    writeBuffer.writeBit("", value.booleanValue(), new WithWriterArgs[0]);
                                                                                                                                }
                                                                                                                                break block15;
                                                                                                                            }
                                                                                                                            if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.BYTE)) || !EvaluationHelper.equals((Object)numberOfValues, (Object)1)) break block17;
                                                                                                                            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                            short value = _value.getShort();
                                                                                                                            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
                                                                                                                            break block15;
                                                                                                                        }
                                                                                                                        if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.BYTE))) break block18;
                                                                                                                        PlcList values = (PlcList)_value;
                                                                                                                        for (PlcValue val : values.getList()) {
                                                                                                                            Boolean value = val.getBoolean();
                                                                                                                            writeBuffer.writeBit("", value.booleanValue(), new WithWriterArgs[0]);
                                                                                                                        }
                                                                                                                        break block15;
                                                                                                                    }
                                                                                                                    if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.WORD))) break block19;
                                                                                                                    int value = _value.getInt();
                                                                                                                    writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
                                                                                                                    break block15;
                                                                                                                }
                                                                                                                if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.DWORD))) break block20;
                                                                                                                long value = _value.getLong();
                                                                                                                writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
                                                                                                                break block15;
                                                                                                            }
                                                                                                            if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.LWORD))) break block21;
                                                                                                            BigInteger value = _value.getBigInteger();
                                                                                                            writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
                                                                                                            break block15;
                                                                                                        }
                                                                                                        if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.SINT)) || !EvaluationHelper.equals((Object)numberOfValues, (Object)1)) break block22;
                                                                                                        writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                        byte value = _value.getByte();
                                                                                                        writeBuffer.writeSignedByte("", 8, ((Number)value).byteValue(), new WithWriterArgs[0]);
                                                                                                        break block15;
                                                                                                    }
                                                                                                    if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.SINT))) break block23;
                                                                                                    PlcList values = (PlcList)_value;
                                                                                                    for (PlcValue val : values.getList()) {
                                                                                                        Byte value = val.getByte();
                                                                                                        writeBuffer.writeSignedByte("", 8, ((Number)value).byteValue(), new WithWriterArgs[0]);
                                                                                                    }
                                                                                                    break block15;
                                                                                                }
                                                                                                if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.INT)) || !EvaluationHelper.equals((Object)numberOfValues, (Object)1)) break block24;
                                                                                                short value = _value.getShort();
                                                                                                writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
                                                                                                break block15;
                                                                                            }
                                                                                            if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.INT))) break block25;
                                                                                            PlcList values = (PlcList)_value;
                                                                                            for (PlcValue val : values.getList()) {
                                                                                                Short value = val.getShort();
                                                                                                writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
                                                                                            }
                                                                                            break block15;
                                                                                        }
                                                                                        if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.DINT)) || !EvaluationHelper.equals((Object)numberOfValues, (Object)1)) break block26;
                                                                                        int value = _value.getInt();
                                                                                        writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
                                                                                        break block15;
                                                                                    }
                                                                                    if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.DINT))) break block27;
                                                                                    PlcList values = (PlcList)_value;
                                                                                    for (PlcValue val : values.getList()) {
                                                                                        Integer value = val.getInteger();
                                                                                        writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
                                                                                    }
                                                                                    break block15;
                                                                                }
                                                                                if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.LINT)) || !EvaluationHelper.equals((Object)numberOfValues, (Object)1)) break block28;
                                                                                long value = _value.getLong();
                                                                                writeBuffer.writeLong("", 64, ((Number)value).longValue(), new WithWriterArgs[0]);
                                                                                break block15;
                                                                            }
                                                                            if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.LINT))) break block29;
                                                                            PlcList values = (PlcList)_value;
                                                                            for (PlcValue val : values.getList()) {
                                                                                Long value = val.getLong();
                                                                                writeBuffer.writeLong("", 64, ((Number)value).longValue(), new WithWriterArgs[0]);
                                                                            }
                                                                            break block15;
                                                                        }
                                                                        if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.USINT)) || !EvaluationHelper.equals((Object)numberOfValues, (Object)1)) break block30;
                                                                        writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                        short value = _value.getShort();
                                                                        writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
                                                                        break block15;
                                                                    }
                                                                    if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.USINT))) break block31;
                                                                    PlcList values = (PlcList)_value;
                                                                    for (PlcValue val : values.getList()) {
                                                                        Short value = val.getShort();
                                                                        writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
                                                                    }
                                                                    break block15;
                                                                }
                                                                if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.UINT)) || !EvaluationHelper.equals((Object)numberOfValues, (Object)1)) break block32;
                                                                int value = _value.getInt();
                                                                writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
                                                                break block15;
                                                            }
                                                            if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.UINT))) break block33;
                                                            PlcList values = (PlcList)_value;
                                                            for (PlcValue val : values.getList()) {
                                                                Integer value = val.getInteger();
                                                                writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
                                                            }
                                                            break block15;
                                                        }
                                                        if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.UDINT)) || !EvaluationHelper.equals((Object)numberOfValues, (Object)1)) break block34;
                                                        long value = _value.getLong();
                                                        writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
                                                        break block15;
                                                    }
                                                    if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.UDINT))) break block35;
                                                    PlcList values = (PlcList)_value;
                                                    for (PlcValue val : values.getList()) {
                                                        Long value = val.getLong();
                                                        writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
                                                    }
                                                    break block15;
                                                }
                                                if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.ULINT)) || !EvaluationHelper.equals((Object)numberOfValues, (Object)1)) break block36;
                                                BigInteger value = _value.getBigInteger();
                                                writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
                                                break block15;
                                            }
                                            if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.ULINT))) break block37;
                                            PlcList values = (PlcList)_value;
                                            for (PlcValue val : values.getList()) {
                                                BigInteger value = val.getBigInteger();
                                                writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
                                            }
                                            break block15;
                                        }
                                        if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.REAL)) || !EvaluationHelper.equals((Object)numberOfValues, (Object)1)) break block38;
                                        float value = _value.getFloat();
                                        writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
                                        break block15;
                                    }
                                    if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.REAL))) break block39;
                                    PlcList values = (PlcList)_value;
                                    for (PlcValue val : values.getList()) {
                                        Float value = Float.valueOf(val.getFloat());
                                        writeBuffer.writeFloat("", 32, value.floatValue(), new WithWriterArgs[0]);
                                    }
                                    break block15;
                                }
                                if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.LREAL)) || !EvaluationHelper.equals((Object)numberOfValues, (Object)1)) break block40;
                                double value = _value.getDouble();
                                writeBuffer.writeDouble("", 64, value, new WithWriterArgs[0]);
                                break block15;
                            }
                            if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.LREAL))) break block41;
                            PlcList values = (PlcList)_value;
                            for (PlcValue val : values.getList()) {
                                Double value = val.getDouble();
                                writeBuffer.writeDouble("", 64, value.doubleValue(), new WithWriterArgs[0]);
                            }
                            break block15;
                        }
                        if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.CHAR)) || !EvaluationHelper.equals((Object)numberOfValues, (Object)1)) break block42;
                        String value = _value.getString();
                        writeBuffer.writeString("", 8, value, new WithWriterArgs[]{WithOption.WithEncoding((String)"UTF-8")});
                        break block15;
                    }
                    if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.CHAR))) break block43;
                    PlcList values = (PlcList)_value;
                    for (PlcValue val : values.getList()) {
                        String value = val.getString();
                        writeBuffer.writeString("", 8, value, new WithWriterArgs[]{WithOption.WithEncoding((String)"UTF-8")});
                    }
                    break block15;
                }
                if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.WCHAR)) || !EvaluationHelper.equals((Object)numberOfValues, (Object)1)) break block44;
                String value = _value.getString();
                writeBuffer.writeString("", 16, value, new WithWriterArgs[]{WithOption.WithEncoding((String)"UTF-16")});
                break block15;
            }
            if (!EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.WCHAR))) break block15;
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                String value = val.getString();
                writeBuffer.writeString("", 16, value, new WithWriterArgs[]{WithOption.WithEncoding((String)"UTF-16")});
            }
        }
    }

    public static int getLengthInBytes(PlcValue _value, ModbusDataType dataType, Integer numberOfValues) {
        return (int)Math.ceil((double)DataItem.getLengthInBits(_value, dataType, numberOfValues) / 8.0);
    }

    public static int getLengthInBits(PlcValue _value, ModbusDataType dataType, Integer numberOfValues) {
        int sizeInBits = 0;
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.BOOL)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 15;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.BOOL))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 1;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.BYTE)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.BYTE))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 1;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.WORD))) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.DWORD))) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.LWORD))) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.SINT)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.SINT))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.INT)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.INT))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 16;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.DINT)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.DINT))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 32;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.LINT)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.LINT))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 64;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.USINT)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.USINT))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.UINT)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.UINT))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 16;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.UDINT)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.UDINT))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 32;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.ULINT)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.ULINT))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 64;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.REAL)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.REAL))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 32;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.LREAL)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.LREAL))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 64;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.CHAR)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.CHAR))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.WCHAR)) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)ModbusDataType.WCHAR))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 16;
        }
        return sizeInBits;
    }
}

