/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ModbusPDUWriteFileRecordRequestItem
implements Message {
    protected final short referenceType;
    protected final int fileNumber;
    protected final int recordNumber;
    protected final byte[] recordData;

    public ModbusPDUWriteFileRecordRequestItem(short referenceType, int fileNumber, int recordNumber, byte[] recordData) {
        this.referenceType = referenceType;
        this.fileNumber = fileNumber;
        this.recordNumber = recordNumber;
        this.recordData = recordData;
    }

    public short getReferenceType() {
        return this.referenceType;
    }

    public int getFileNumber() {
        return this.fileNumber;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public byte[] getRecordData() {
        return this.recordData;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("ModbusPDUWriteFileRecordRequestItem", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"referenceType", (Object)this.referenceType, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"fileNumber", (Object)this.fileNumber, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"recordNumber", (Object)this.recordNumber, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        int recordLength = StaticHelper.COUNT((Object)this.getRecordData()) / 2;
        FieldWriterFactory.writeImplicitField((String)"recordLength", (Object)recordLength, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"recordData", (byte[])this.recordData, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ModbusPDUWriteFileRecordRequestItem", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        ModbusPDUWriteFileRecordRequestItem _value = this;
        lengthInBits += 8;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 16;
        if (this.recordData != null) {
            lengthInBits += 8 * this.recordData.length;
        }
        return lengthInBits;
    }

    public static ModbusPDUWriteFileRecordRequestItem staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return ModbusPDUWriteFileRecordRequestItem.staticParse(readBuffer);
    }

    public static ModbusPDUWriteFileRecordRequestItem staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("ModbusPDUWriteFileRecordRequestItem", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        short referenceType = (Short)FieldReaderFactory.readSimpleField((String)"referenceType", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        int fileNumber = (Integer)FieldReaderFactory.readSimpleField((String)"fileNumber", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        int recordNumber = (Integer)FieldReaderFactory.readSimpleField((String)"recordNumber", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        int recordLength = (Integer)FieldReaderFactory.readImplicitField((String)"recordLength", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] recordData = readBuffer.readByteArray("recordData", Math.toIntExact(recordLength * 2), new WithReaderArgs[0]);
        readBuffer.closeContext("ModbusPDUWriteFileRecordRequestItem", new WithReaderArgs[0]);
        ModbusPDUWriteFileRecordRequestItem _modbusPDUWriteFileRecordRequestItem = new ModbusPDUWriteFileRecordRequestItem(referenceType, fileNumber, recordNumber, recordData);
        return _modbusPDUWriteFileRecordRequestItem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusPDUWriteFileRecordRequestItem)) {
            return false;
        }
        ModbusPDUWriteFileRecordRequestItem that = (ModbusPDUWriteFileRecordRequestItem)o;
        return this.getReferenceType() == that.getReferenceType() && this.getFileNumber() == that.getFileNumber() && this.getRecordNumber() == that.getRecordNumber() && this.getRecordData() == that.getRecordData();
    }

    public int hashCode() {
        return Objects.hash(this.getReferenceType(), this.getFileNumber(), this.getRecordNumber(), this.getRecordData());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

