/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.modbus.readwrite.ModbusDeviceInformationConformityLevel;
import org.apache.plc4x.java.modbus.readwrite.ModbusDeviceInformationLevel;
import org.apache.plc4x.java.modbus.readwrite.ModbusDeviceInformationMoreFollows;
import org.apache.plc4x.java.modbus.readwrite.ModbusDeviceInformationObject;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ModbusPDUReadDeviceIdentificationResponse
extends ModbusPDU
implements Message {
    public static final Short MEITYPE = 14;
    protected final ModbusDeviceInformationLevel level;
    protected final boolean individualAccess;
    protected final ModbusDeviceInformationConformityLevel conformityLevel;
    protected final ModbusDeviceInformationMoreFollows moreFollows;
    protected final short nextObjectId;
    protected final List<ModbusDeviceInformationObject> objects;

    @Override
    public Boolean getErrorFlag() {
        return false;
    }

    @Override
    public Short getFunctionFlag() {
        return (short)43;
    }

    @Override
    public Boolean getResponse() {
        return true;
    }

    public ModbusPDUReadDeviceIdentificationResponse(ModbusDeviceInformationLevel level, boolean individualAccess, ModbusDeviceInformationConformityLevel conformityLevel, ModbusDeviceInformationMoreFollows moreFollows, short nextObjectId, List<ModbusDeviceInformationObject> objects) {
        this.level = level;
        this.individualAccess = individualAccess;
        this.conformityLevel = conformityLevel;
        this.moreFollows = moreFollows;
        this.nextObjectId = nextObjectId;
        this.objects = objects;
    }

    public ModbusDeviceInformationLevel getLevel() {
        return this.level;
    }

    public boolean getIndividualAccess() {
        return this.individualAccess;
    }

    public ModbusDeviceInformationConformityLevel getConformityLevel() {
        return this.conformityLevel;
    }

    public ModbusDeviceInformationMoreFollows getMoreFollows() {
        return this.moreFollows;
    }

    public short getNextObjectId() {
        return this.nextObjectId;
    }

    public List<ModbusDeviceInformationObject> getObjects() {
        return this.objects;
    }

    public short getMeiType() {
        return MEITYPE;
    }

    @Override
    protected void serializeModbusPDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("ModbusPDUReadDeviceIdentificationResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField((String)"meiType", (Object)MEITYPE, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"level", (String)"ModbusDeviceInformationLevel", (Object)((Object)this.level), (DataWriter)new DataWriterEnumDefault(ModbusDeviceInformationLevel::getValue, Enum::name, DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"individualAccess", (Object)this.individualAccess, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"conformityLevel", (String)"ModbusDeviceInformationConformityLevel", (Object)((Object)this.conformityLevel), (DataWriter)new DataWriterEnumDefault(ModbusDeviceInformationConformityLevel::getValue, Enum::name, DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)7)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"moreFollows", (String)"ModbusDeviceInformationMoreFollows", (Object)((Object)this.moreFollows), (DataWriter)new DataWriterEnumDefault(ModbusDeviceInformationMoreFollows::getValue, Enum::name, DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"nextObjectId", (Object)this.nextObjectId, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        short numberOfObjects = (short)StaticHelper.COUNT(this.getObjects());
        FieldWriterFactory.writeImplicitField((String)"numberOfObjects", (Object)numberOfObjects, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"objects", this.objects, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ModbusPDUReadDeviceIdentificationResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ModbusPDUReadDeviceIdentificationResponse _value = this;
        lengthInBits += 8;
        lengthInBits += 8;
        ++lengthInBits;
        lengthInBits += 7;
        lengthInBits += 8;
        lengthInBits += 8;
        lengthInBits += 8;
        if (this.objects != null) {
            int i = 0;
            for (ModbusDeviceInformationObject element : this.objects) {
                boolean last = ++i >= this.objects.size();
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ModbusPDUReadDeviceIdentificationResponseBuilder staticParseBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("ModbusPDUReadDeviceIdentificationResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        short meiType = (Short)FieldReaderFactory.readConstField((String)"meiType", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (Object)MEITYPE, (WithReaderArgs[])new WithReaderArgs[0]);
        ModbusDeviceInformationLevel level = (ModbusDeviceInformationLevel)((Object)FieldReaderFactory.readEnumField((String)"level", (String)"ModbusDeviceInformationLevel", (DataReader)new DataReaderEnumDefault(ModbusDeviceInformationLevel::enumForValue, DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8)), (WithReaderArgs[])new WithReaderArgs[0]));
        boolean individualAccess = (Boolean)FieldReaderFactory.readSimpleField((String)"individualAccess", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        ModbusDeviceInformationConformityLevel conformityLevel = (ModbusDeviceInformationConformityLevel)((Object)FieldReaderFactory.readEnumField((String)"conformityLevel", (String)"ModbusDeviceInformationConformityLevel", (DataReader)new DataReaderEnumDefault(ModbusDeviceInformationConformityLevel::enumForValue, DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)7)), (WithReaderArgs[])new WithReaderArgs[0]));
        ModbusDeviceInformationMoreFollows moreFollows = (ModbusDeviceInformationMoreFollows)((Object)FieldReaderFactory.readEnumField((String)"moreFollows", (String)"ModbusDeviceInformationMoreFollows", (DataReader)new DataReaderEnumDefault(ModbusDeviceInformationMoreFollows::enumForValue, DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8)), (WithReaderArgs[])new WithReaderArgs[0]));
        short nextObjectId = (Short)FieldReaderFactory.readSimpleField((String)"nextObjectId", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        short numberOfObjects = (Short)FieldReaderFactory.readImplicitField((String)"numberOfObjects", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        List objects = FieldReaderFactory.readCountArrayField((String)"objects", (DataReader)new DataReaderComplexDefault(() -> ModbusDeviceInformationObject.staticParse(readBuffer), readBuffer), (long)numberOfObjects, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ModbusPDUReadDeviceIdentificationResponse", new WithReaderArgs[0]);
        return new ModbusPDUReadDeviceIdentificationResponseBuilder(level, individualAccess, conformityLevel, moreFollows, nextObjectId, objects);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusPDUReadDeviceIdentificationResponse)) {
            return false;
        }
        ModbusPDUReadDeviceIdentificationResponse that = (ModbusPDUReadDeviceIdentificationResponse)o;
        return this.getLevel() == that.getLevel() && this.getIndividualAccess() == that.getIndividualAccess() && this.getConformityLevel() == that.getConformityLevel() && this.getMoreFollows() == that.getMoreFollows() && this.getNextObjectId() == that.getNextObjectId() && this.getObjects() == that.getObjects() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getLevel(), this.getIndividualAccess(), this.getConformityLevel(), this.getMoreFollows(), this.getNextObjectId(), this.getObjects()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ModbusPDUReadDeviceIdentificationResponseBuilder
    implements ModbusPDU.ModbusPDUBuilder {
        private final ModbusDeviceInformationLevel level;
        private final boolean individualAccess;
        private final ModbusDeviceInformationConformityLevel conformityLevel;
        private final ModbusDeviceInformationMoreFollows moreFollows;
        private final short nextObjectId;
        private final List<ModbusDeviceInformationObject> objects;

        public ModbusPDUReadDeviceIdentificationResponseBuilder(ModbusDeviceInformationLevel level, boolean individualAccess, ModbusDeviceInformationConformityLevel conformityLevel, ModbusDeviceInformationMoreFollows moreFollows, short nextObjectId, List<ModbusDeviceInformationObject> objects) {
            this.level = level;
            this.individualAccess = individualAccess;
            this.conformityLevel = conformityLevel;
            this.moreFollows = moreFollows;
            this.nextObjectId = nextObjectId;
            this.objects = objects;
        }

        @Override
        public ModbusPDUReadDeviceIdentificationResponse build() {
            ModbusPDUReadDeviceIdentificationResponse modbusPDUReadDeviceIdentificationResponse = new ModbusPDUReadDeviceIdentificationResponse(this.level, this.individualAccess, this.conformityLevel, this.moreFollows, this.nextObjectId, this.objects);
            return modbusPDUReadDeviceIdentificationResponse;
        }
    }
}

