/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.modbus.readwrite.DriverType;
import org.apache.plc4x.java.modbus.readwrite.ModbusAsciiADU;
import org.apache.plc4x.java.modbus.readwrite.ModbusRtuADU;
import org.apache.plc4x.java.modbus.readwrite.ModbusTcpADU;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class ModbusADU
implements Message {
    protected final Boolean response;

    public abstract DriverType getDriverType();

    public ModbusADU(Boolean response) {
        this.response = response;
    }

    protected abstract void serializeModbusADUChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("ModbusADU", new WithWriterArgs[0]);
        this.serializeModbusADUChild(writeBuffer);
        writeBuffer.popContext("ModbusADU", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        ModbusADU _value = this;
        return lengthInBits;
    }

    public static ModbusADU staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Boolean response;
        DriverType driverType;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 2) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 2, but got " + args.length);
        }
        if (args[0] instanceof DriverType) {
            driverType = (DriverType)((Object)args[0]);
        } else if (args[0] instanceof String) {
            driverType = DriverType.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type DriverType or a string which is parseable but was " + args[0].getClass().getName());
        }
        if (args[1] instanceof Boolean) {
            response = (Boolean)args[1];
        } else if (args[1] instanceof String) {
            response = Boolean.valueOf((String)args[1]);
        } else {
            throw new PlcRuntimeException("Argument 1 expected to be of type Boolean or a string which is parseable but was " + args[1].getClass().getName());
        }
        return ModbusADU.staticParse(readBuffer, driverType, response);
    }

    public static ModbusADU staticParse(ReadBuffer readBuffer, DriverType driverType, Boolean response) throws ParseException {
        readBuffer.pullContext("ModbusADU", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        ModbusADUBuilder builder = null;
        if (EvaluationHelper.equals((Object)((Object)driverType), (Object)((Object)DriverType.MODBUS_TCP))) {
            builder = ModbusTcpADU.staticParseBuilder(readBuffer, driverType, response);
        } else if (EvaluationHelper.equals((Object)((Object)driverType), (Object)((Object)DriverType.MODBUS_RTU))) {
            builder = ModbusRtuADU.staticParseBuilder(readBuffer, driverType, response);
        } else if (EvaluationHelper.equals((Object)((Object)driverType), (Object)((Object)DriverType.MODBUS_ASCII))) {
            builder = ModbusAsciiADU.staticParseBuilder(readBuffer, driverType, response);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [driverType=" + (Object)((Object)driverType) + "]");
        }
        readBuffer.closeContext("ModbusADU", new WithReaderArgs[0]);
        ModbusADU _modbusADU = builder.build(response);
        return _modbusADU;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusADU)) {
            return false;
        }
        ModbusADU that = (ModbusADU)o;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface ModbusADUBuilder {
        public ModbusADU build(Boolean var1);
    }
}

