/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum KnxDatapointType {
  DPT_UNKNOWN(
      (long) 0L, (int) 0, (String) "Unknown Datapoint Subtype", KnxDatapointMainType.DPT_UNKNOWN),
  BOOL((long) 1L, (int) 0, (String) "BOOL", KnxDatapointMainType.DPT_1_BIT),
  BYTE((long) 2L, (int) 0, (String) "BYTE", KnxDatapointMainType.DPT_8_BIT_SET),
  WORD((long) 3L, (int) 0, (String) "WORD", KnxDatapointMainType.DPT_16_BIT_SET),
  DWORD((long) 4L, (int) 0, (String) "DWORD", KnxDatapointMainType.DPT_32_BIT_SET),
  LWORD((long) 5L, (int) 0, (String) "LWORD", KnxDatapointMainType.DPT_64_BIT_SET),
  USINT((long) 6L, (int) 0, (String) "USINT", KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
  SINT((long) 7L, (int) 0, (String) "SINT", KnxDatapointMainType.DPT_8_BIT_SIGNED_VALUE),
  UINT((long) 8L, (int) 0, (String) "UINT", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  INT((long) 9L, (int) 0, (String) "INT", KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  UDINT((long) 10L, (int) 0, (String) "UDINT", KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  DINT((long) 11L, (int) 0, (String) "DINT", KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  ULINT((long) 12L, (int) 0, (String) "ULINT", KnxDatapointMainType.DPT_8_BYTE_UNSIGNED_VALUE),
  LINT((long) 13L, (int) 0, (String) "LINT", KnxDatapointMainType.DPT_8_BYTE_SIGNED_VALUE),
  REAL((long) 14L, (int) 0, (String) "REAL", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  LREAL((long) 15L, (int) 0, (String) "LREAL", KnxDatapointMainType.DPT_8_BYTE_FLOAT_VALUE),
  CHAR((long) 16L, (int) 0, (String) "CHAR", KnxDatapointMainType.DPT_CHARACTER),
  WCHAR((long) 17L, (int) 0, (String) "WCHAR", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  STRING((long) 18L, (int) 0, (String) "STRING", KnxDatapointMainType.DPT_UNKNOWN),
  WSTRING((long) 19L, (int) 0, (String) "WSTRING", KnxDatapointMainType.DPT_UNKNOWN),
  TIME((long) 20L, (int) 0, (String) "TIME", KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  LTIME((long) 21L, (int) 0, (String) "LTIME", KnxDatapointMainType.DPT_8_BYTE_UNSIGNED_VALUE),
  DATE((long) 22L, (int) 0, (String) "DATE", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  TIME_OF_DAY(
      (long) 23L, (int) 0, (String) "TIME_OF_DAY", KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  TOD((long) 24L, (int) 0, (String) "TOD", KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  DATE_AND_TIME(
      (long) 25L, (int) 0, (String) "DATE_AND_TIME", KnxDatapointMainType.DPT_12_BYTE_SIGNED_VALUE),
  DT((long) 26L, (int) 0, (String) "DT", KnxDatapointMainType.DPT_12_BYTE_SIGNED_VALUE),
  DPT_Switch((long) 27L, (int) 1, (String) "switch", KnxDatapointMainType.DPT_1_BIT),
  DPT_Bool((long) 28L, (int) 2, (String) "boolean", KnxDatapointMainType.DPT_1_BIT),
  DPT_Enable((long) 29L, (int) 3, (String) "enable", KnxDatapointMainType.DPT_1_BIT),
  DPT_Ramp((long) 30L, (int) 4, (String) "ramp", KnxDatapointMainType.DPT_1_BIT),
  DPT_Alarm((long) 31L, (int) 5, (String) "alarm", KnxDatapointMainType.DPT_1_BIT),
  DPT_BinaryValue((long) 32L, (int) 6, (String) "binary value", KnxDatapointMainType.DPT_1_BIT),
  DPT_Step((long) 33L, (int) 7, (String) "step", KnxDatapointMainType.DPT_1_BIT),
  DPT_UpDown((long) 34L, (int) 8, (String) "up/down", KnxDatapointMainType.DPT_1_BIT),
  DPT_OpenClose((long) 35L, (int) 9, (String) "open/close", KnxDatapointMainType.DPT_1_BIT),
  DPT_Start((long) 36L, (int) 10, (String) "start/stop", KnxDatapointMainType.DPT_1_BIT),
  DPT_State((long) 37L, (int) 11, (String) "state", KnxDatapointMainType.DPT_1_BIT),
  DPT_Invert((long) 38L, (int) 12, (String) "invert", KnxDatapointMainType.DPT_1_BIT),
  DPT_DimSendStyle((long) 39L, (int) 13, (String) "dim send style", KnxDatapointMainType.DPT_1_BIT),
  DPT_InputSource((long) 40L, (int) 14, (String) "input source", KnxDatapointMainType.DPT_1_BIT),
  DPT_Reset((long) 41L, (int) 15, (String) "reset", KnxDatapointMainType.DPT_1_BIT),
  DPT_Ack((long) 42L, (int) 16, (String) "acknowledge", KnxDatapointMainType.DPT_1_BIT),
  DPT_Trigger((long) 43L, (int) 17, (String) "trigger", KnxDatapointMainType.DPT_1_BIT),
  DPT_Occupancy((long) 44L, (int) 18, (String) "occupancy", KnxDatapointMainType.DPT_1_BIT),
  DPT_Window_Door((long) 45L, (int) 19, (String) "window/door", KnxDatapointMainType.DPT_1_BIT),
  DPT_LogicalFunction(
      (long) 46L, (int) 21, (String) "logical function", KnxDatapointMainType.DPT_1_BIT),
  DPT_Scene_AB((long) 47L, (int) 22, (String) "scene", KnxDatapointMainType.DPT_1_BIT),
  DPT_ShutterBlinds_Mode(
      (long) 48L, (int) 23, (String) "shutter/blinds mode", KnxDatapointMainType.DPT_1_BIT),
  DPT_DayNight((long) 49L, (int) 24, (String) "day/night", KnxDatapointMainType.DPT_1_BIT),
  DPT_Heat_Cool((long) 50L, (int) 100, (String) "cooling/heating", KnxDatapointMainType.DPT_1_BIT),
  DPT_Switch_Control(
      (long) 51L, (int) 1, (String) "switch control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Bool_Control(
      (long) 52L, (int) 2, (String) "boolean control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Enable_Control(
      (long) 53L, (int) 3, (String) "enable control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Ramp_Control(
      (long) 54L, (int) 4, (String) "ramp control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Alarm_Control(
      (long) 55L, (int) 5, (String) "alarm control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_BinaryValue_Control(
      (long) 56L,
      (int) 6,
      (String) "binary value control",
      KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Step_Control(
      (long) 57L, (int) 7, (String) "step control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Direction1_Control(
      (long) 58L,
      (int) 8,
      (String) "direction control 1",
      KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Direction2_Control(
      (long) 59L,
      (int) 9,
      (String) "direction control 2",
      KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Start_Control(
      (long) 60L, (int) 10, (String) "start control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_State_Control(
      (long) 61L, (int) 11, (String) "state control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Invert_Control(
      (long) 62L, (int) 12, (String) "invert control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Control_Dimming(
      (long) 63L, (int) 7, (String) "dimming control", KnxDatapointMainType.DPT_3_BIT_CONTROLLED),
  DPT_Control_Blinds(
      (long) 64L, (int) 8, (String) "blind control", KnxDatapointMainType.DPT_3_BIT_CONTROLLED),
  DPT_Char_ASCII(
      (long) 65L, (int) 1, (String) "character (ASCII)", KnxDatapointMainType.DPT_CHARACTER),
  DPT_Char_8859_1(
      (long) 66L, (int) 2, (String) "character (ISO 8859-1)", KnxDatapointMainType.DPT_CHARACTER),
  DPT_Scaling(
      (long) 67L,
      (int) 1,
      (String) "percentage (0..100%)",
      KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
  DPT_Angle(
      (long) 68L,
      (int) 3,
      (String) "angle (degrees)",
      KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
  DPT_Percent_U8(
      (long) 69L,
      (int) 4,
      (String) "percentage (0..255%)",
      KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
  DPT_DecimalFactor(
      (long) 70L,
      (int) 5,
      (String) "ratio (0..255)",
      KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
  DPT_Tariff(
      (long) 71L,
      (int) 6,
      (String) "tariff (0..255)",
      KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
  DPT_Value_1_Ucount(
      (long) 72L,
      (int) 10,
      (String) "counter pulses (0..255)",
      KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
  DPT_FanStage(
      (long) 73L,
      (int) 100,
      (String) "fan stage (0..255)",
      KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
  DPT_Percent_V8(
      (long) 74L,
      (int) 1,
      (String) "percentage (-128..127%)",
      KnxDatapointMainType.DPT_8_BIT_SIGNED_VALUE),
  DPT_Value_1_Count(
      (long) 75L,
      (int) 10,
      (String) "counter pulses (-128..127)",
      KnxDatapointMainType.DPT_8_BIT_SIGNED_VALUE),
  DPT_Status_Mode3(
      (long) 76L,
      (int) 20,
      (String) "status with mode",
      KnxDatapointMainType.DPT_8_BIT_SIGNED_VALUE),
  DPT_Value_2_Ucount(
      (long) 77L, (int) 1, (String) "pulses", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_TimePeriodMsec(
      (long) 78L, (int) 2, (String) "time (ms)", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_TimePeriod10Msec(
      (long) 79L, (int) 3, (String) "time (10 ms)", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_TimePeriod100Msec(
      (long) 80L,
      (int) 4,
      (String) "time (100 ms)",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_TimePeriodSec(
      (long) 81L, (int) 5, (String) "time (s)", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_TimePeriodMin(
      (long) 82L, (int) 6, (String) "time (min)", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_TimePeriodHrs(
      (long) 83L, (int) 7, (String) "time (h)", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_PropDataType(
      (long) 84L,
      (int) 10,
      (String) "property data type",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_Length_mm(
      (long) 85L, (int) 11, (String) "length (mm)", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_UElCurrentmA(
      (long) 86L,
      (int) 12,
      (String) "current (mA)",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_Brightness(
      (long) 87L,
      (int) 13,
      (String) "brightness (lux)",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_Absolute_Colour_Temperature(
      (long) 88L,
      (int) 600,
      (String) "absolute colour temperature (K)",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_Value_2_Count(
      (long) 89L,
      (int) 1,
      (String) "pulses difference",
      KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_DeltaTimeMsec(
      (long) 90L, (int) 2, (String) "time lag (ms)", KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_DeltaTime10Msec(
      (long) 91L,
      (int) 3,
      (String) "time lag(10 ms)",
      KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_DeltaTime100Msec(
      (long) 92L,
      (int) 4,
      (String) "time lag (100 ms)",
      KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_DeltaTimeSec(
      (long) 93L, (int) 5, (String) "time lag (s)", KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_DeltaTimeMin(
      (long) 94L, (int) 6, (String) "time lag (min)", KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_DeltaTimeHrs(
      (long) 95L, (int) 7, (String) "time lag (h)", KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_Percent_V16(
      (long) 96L,
      (int) 10,
      (String) "percentage difference (%)",
      KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_Rotation_Angle(
      (long) 97L,
      (int) 11,
      (String) "rotation angle (°)",
      KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_Length_m(
      (long) 98L, (int) 12, (String) "length (m)", KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_Value_Temp(
      (long) 99L,
      (int) 1,
      (String) "temperature (°C)",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Tempd(
      (long) 100L,
      (int) 2,
      (String) "temperature difference (K)",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Tempa(
      (long) 101L,
      (int) 3,
      (String) "kelvin/hour (K/h)",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Lux(
      (long) 102L, (int) 4, (String) "lux (Lux)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Wsp(
      (long) 103L, (int) 5, (String) "speed (m/s)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Pres(
      (long) 104L, (int) 6, (String) "pressure (Pa)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Humidity(
      (long) 105L, (int) 7, (String) "humidity (%)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_AirQuality(
      (long) 106L,
      (int) 8,
      (String) "parts/million (ppm)",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_AirFlow(
      (long) 107L,
      (int) 9,
      (String) "air flow (m³/h)",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Time1(
      (long) 108L, (int) 10, (String) "time (s)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Time2(
      (long) 109L, (int) 11, (String) "time (ms)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Volt(
      (long) 110L, (int) 20, (String) "voltage (mV)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Curr(
      (long) 111L, (int) 21, (String) "current (mA)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_PowerDensity(
      (long) 112L,
      (int) 22,
      (String) "power density (W/m²)",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_KelvinPerPercent(
      (long) 113L,
      (int) 23,
      (String) "kelvin/percent (K/%)",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Power(
      (long) 114L, (int) 24, (String) "power (kW)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Volume_Flow(
      (long) 115L,
      (int) 25,
      (String) "volume flow (l/h)",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Rain_Amount(
      (long) 116L,
      (int) 26,
      (String) "rain amount (l/m²)",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Temp_F(
      (long) 117L,
      (int) 27,
      (String) "temperature (°F)",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Wsp_kmh(
      (long) 118L,
      (int) 28,
      (String) "wind speed (km/h)",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Absolute_Humidity(
      (long) 119L,
      (int) 29,
      (String) "absolute humidity (g/m³)",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Concentration_ygm3(
      (long) 120L,
      (int) 30,
      (String) "concentration (µg/m³)",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Coefficient(
      (long) 121L, (int) 31, (String) "coefficient", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_TimeOfDay((long) 122L, (int) 1, (String) "time of day", KnxDatapointMainType.DPT_TIME),
  DPT_Date((long) 123L, (int) 1, (String) "date", KnxDatapointMainType.DPT_DATE),
  DPT_Value_4_Ucount(
      (long) 124L,
      (int) 1,
      (String) "counter pulses (unsigned)",
      KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  DPT_LongTimePeriod_Sec(
      (long) 125L,
      (int) 100,
      (String) "counter timesec (s)",
      KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  DPT_LongTimePeriod_Min(
      (long) 126L,
      (int) 101,
      (String) "counter timemin (min)",
      KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  DPT_LongTimePeriod_Hrs(
      (long) 127L,
      (int) 102,
      (String) "counter timehrs (h)",
      KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  DPT_VolumeLiquid_Litre(
      (long) 128L,
      (int) 1200,
      (String) "volume liquid (l)",
      KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  DPT_Volume_m_3(
      (long) 129L,
      (int) 1201,
      (String) "volume (m³)",
      KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  DPT_Value_4_Count(
      (long) 130L,
      (int) 1,
      (String) "counter pulses (signed)",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_FlowRate_m3h(
      (long) 131L,
      (int) 2,
      (String) "flow rate (m³/h)",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_ActiveEnergy(
      (long) 132L,
      (int) 10,
      (String) "active energy (Wh)",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_ApparantEnergy(
      (long) 133L,
      (int) 11,
      (String) "apparant energy (VAh)",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_ReactiveEnergy(
      (long) 134L,
      (int) 12,
      (String) "reactive energy (VARh)",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_ActiveEnergy_kWh(
      (long) 135L,
      (int) 13,
      (String) "active energy (kWh)",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_ApparantEnergy_kVAh(
      (long) 136L,
      (int) 14,
      (String) "apparant energy (kVAh)",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_ReactiveEnergy_kVARh(
      (long) 137L,
      (int) 15,
      (String) "reactive energy (kVARh)",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_ActiveEnergy_MWh(
      (long) 138L,
      (int) 16,
      (String) "active energy (MWh)",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_LongDeltaTimeSec(
      (long) 139L,
      (int) 100,
      (String) "time lag (s)",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_DeltaVolumeLiquid_Litre(
      (long) 140L,
      (int) 1200,
      (String) "delta volume liquid (l)",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_DeltaVolume_m_3(
      (long) 141L,
      (int) 1201,
      (String) "delta volume (m³)",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_Value_Acceleration(
      (long) 142L,
      (int) 0,
      (String) "acceleration (m/s²)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Acceleration_Angular(
      (long) 143L,
      (int) 1,
      (String) "angular acceleration (rad/s²)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Activation_Energy(
      (long) 144L,
      (int) 2,
      (String) "activation energy (J/mol)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Activity(
      (long) 145L,
      (int) 3,
      (String) "radioactive activity (1/s)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Mol(
      (long) 146L,
      (int) 4,
      (String) "amount of substance (mol)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Amplitude(
      (long) 147L, (int) 5, (String) "amplitude", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_AngleRad(
      (long) 148L,
      (int) 6,
      (String) "angle (radiant)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_AngleDeg(
      (long) 149L, (int) 7, (String) "angle (degree)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Angular_Momentum(
      (long) 150L,
      (int) 8,
      (String) "angular momentum (Js)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Angular_Velocity(
      (long) 151L,
      (int) 9,
      (String) "angular velocity (rad/s)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Area(
      (long) 152L, (int) 10, (String) "area (m*m)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Capacitance(
      (long) 153L,
      (int) 11,
      (String) "capacitance (F)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Charge_DensitySurface(
      (long) 154L,
      (int) 12,
      (String) "flux density (C/m²)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Charge_DensityVolume(
      (long) 155L,
      (int) 13,
      (String) "charge density (C/m³)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Compressibility(
      (long) 156L,
      (int) 14,
      (String) "compressibility (m²/N)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Conductance(
      (long) 157L,
      (int) 15,
      (String) "conductance (S)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electrical_Conductivity(
      (long) 158L,
      (int) 16,
      (String) "conductivity (S/m)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Density(
      (long) 159L,
      (int) 17,
      (String) "density (kg/m³)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_Charge(
      (long) 160L,
      (int) 18,
      (String) "electric charge (C)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_Current(
      (long) 161L,
      (int) 19,
      (String) "electric current (A)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_CurrentDensity(
      (long) 162L,
      (int) 20,
      (String) "electric current density (A/m²)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_DipoleMoment(
      (long) 163L,
      (int) 21,
      (String) "electric dipole moment (Cm)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_Displacement(
      (long) 164L,
      (int) 22,
      (String) "electric displacement (C/m²)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_FieldStrength(
      (long) 165L,
      (int) 23,
      (String) "electric field strength (V/m)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_Flux(
      (long) 166L,
      (int) 24,
      (String) "electric flux (C)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_FluxDensity(
      (long) 167L,
      (int) 25,
      (String) "electric flux density (C/m²)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_Polarization(
      (long) 168L,
      (int) 26,
      (String) "electric polarization (C/m²)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_Potential(
      (long) 169L,
      (int) 27,
      (String) "electric potential (V)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_PotentialDifference(
      (long) 170L,
      (int) 28,
      (String) "electric potential difference (V)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_ElectromagneticMoment(
      (long) 171L,
      (int) 29,
      (String) "electromagnetic moment (Am²)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electromotive_Force(
      (long) 172L,
      (int) 30,
      (String) "electromotive force (V)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Energy(
      (long) 173L, (int) 31, (String) "energy (J)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Force(
      (long) 174L, (int) 32, (String) "force (N)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Frequency(
      (long) 175L,
      (int) 33,
      (String) "frequency (Hz)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Angular_Frequency(
      (long) 176L,
      (int) 34,
      (String) "angular frequency (rad/s)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Heat_Capacity(
      (long) 177L,
      (int) 35,
      (String) "heat capacity (J/K)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Heat_FlowRate(
      (long) 178L,
      (int) 36,
      (String) "heat flow rate (W)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Heat_Quantity(
      (long) 179L, (int) 37, (String) "heat quantity", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Impedance(
      (long) 180L, (int) 38, (String) "impedance (Ω)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Length(
      (long) 181L, (int) 39, (String) "length (m)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Light_Quantity(
      (long) 182L,
      (int) 40,
      (String) "light quantity (J)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Luminance(
      (long) 183L,
      (int) 41,
      (String) "luminance (cd/m²)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Luminous_Flux(
      (long) 184L,
      (int) 42,
      (String) "luminous flux (lm)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Luminous_Intensity(
      (long) 185L,
      (int) 43,
      (String) "luminous intensity (cd)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Magnetic_FieldStrength(
      (long) 186L,
      (int) 44,
      (String) "magnetic field strength (A/m)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Magnetic_Flux(
      (long) 187L,
      (int) 45,
      (String) "magnetic flux (Wb)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Magnetic_FluxDensity(
      (long) 188L,
      (int) 46,
      (String) "magnetic flux density (T)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Magnetic_Moment(
      (long) 189L,
      (int) 47,
      (String) "magnetic moment (Am²)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Magnetic_Polarization(
      (long) 190L,
      (int) 48,
      (String) "magnetic polarization (T)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Magnetization(
      (long) 191L,
      (int) 49,
      (String) "magnetization (A/m)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_MagnetomotiveForce(
      (long) 192L,
      (int) 50,
      (String) "magnetomotive force (A)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Mass(
      (long) 193L, (int) 51, (String) "mass (kg)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_MassFlux(
      (long) 194L,
      (int) 52,
      (String) "mass flux (kg/s)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Momentum(
      (long) 195L,
      (int) 53,
      (String) "momentum (N/s)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Phase_AngleRad(
      (long) 196L,
      (int) 54,
      (String) "phase angle (rad)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Phase_AngleDeg(
      (long) 197L,
      (int) 55,
      (String) "phase angle (°)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Power(
      (long) 198L, (int) 56, (String) "power (W)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Power_Factor(
      (long) 199L,
      (int) 57,
      (String) "power factor (cos Φ)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Pressure(
      (long) 200L, (int) 58, (String) "pressure (Pa)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Reactance(
      (long) 201L, (int) 59, (String) "reactance (Ω)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Resistance(
      (long) 202L,
      (int) 60,
      (String) "resistance (Ω)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Resistivity(
      (long) 203L,
      (int) 61,
      (String) "resistivity (Ωm)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_SelfInductance(
      (long) 204L,
      (int) 62,
      (String) "self inductance (H)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_SolidAngle(
      (long) 205L,
      (int) 63,
      (String) "solid angle (sr)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Sound_Intensity(
      (long) 206L,
      (int) 64,
      (String) "sound intensity (W/m²)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Speed(
      (long) 207L, (int) 65, (String) "speed (m/s)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Stress(
      (long) 208L, (int) 66, (String) "stress (Pa)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Surface_Tension(
      (long) 209L,
      (int) 67,
      (String) "surface tension (N/m)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Common_Temperature(
      (long) 210L,
      (int) 68,
      (String) "temperature (°C)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Absolute_Temperature(
      (long) 211L,
      (int) 69,
      (String) "temperature absolute (K)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_TemperatureDifference(
      (long) 212L,
      (int) 70,
      (String) "temperature difference (K)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Thermal_Capacity(
      (long) 213L,
      (int) 71,
      (String) "thermal capacity (J/K)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Thermal_Conductivity(
      (long) 214L,
      (int) 72,
      (String) "thermal conductivity (W/mK)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_ThermoelectricPower(
      (long) 215L,
      (int) 73,
      (String) "thermoelectric power (V/K)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Time(
      (long) 216L, (int) 74, (String) "time (s)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Torque(
      (long) 217L, (int) 75, (String) "torque (Nm)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Volume(
      (long) 218L, (int) 76, (String) "volume (m³)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Volume_Flux(
      (long) 219L,
      (int) 77,
      (String) "volume flux (m³/s)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Weight(
      (long) 220L, (int) 78, (String) "weight (N)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Work(
      (long) 221L, (int) 79, (String) "work (J)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_ApparentPower(
      (long) 222L,
      (int) 80,
      (String) "apparent power (VA)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Volume_Flux_Meter(
      (long) 223L,
      (int) 1200,
      (String) "volume flux for meters (m³/h)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Volume_Flux_ls(
      (long) 224L,
      (int) 1201,
      (String) "volume flux for meters (1/ls)",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Access_Data(
      (long) 225L, (int) 0, (String) "entrance access", KnxDatapointMainType.DPT_ENTRANCE_ACCESS),
  DPT_String_ASCII(
      (long) 226L,
      (int) 0,
      (String) "Character String (ASCII)",
      KnxDatapointMainType.DPT_CHARACTER_STRING),
  DPT_String_8859_1(
      (long) 227L,
      (int) 1,
      (String) "Character String (ISO 8859-1)",
      KnxDatapointMainType.DPT_CHARACTER_STRING),
  DPT_SceneNumber(
      (long) 228L, (int) 1, (String) "scene number", KnxDatapointMainType.DPT_SCENE_NUMBER),
  DPT_SceneControl(
      (long) 229L, (int) 1, (String) "scene control", KnxDatapointMainType.DPT_SCENE_CONTROL),
  DPT_DateTime((long) 230L, (int) 1, (String) "date time", KnxDatapointMainType.DPT_DATE_TIME),
  DPT_SCLOMode((long) 231L, (int) 1, (String) "SCLO mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_BuildingMode((long) 232L, (int) 2, (String) "building mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_OccMode((long) 233L, (int) 3, (String) "occupied", KnxDatapointMainType.DPT_1_BYTE),
  DPT_Priority((long) 234L, (int) 4, (String) "priority", KnxDatapointMainType.DPT_1_BYTE),
  DPT_LightApplicationMode(
      (long) 235L, (int) 5, (String) "light application mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_ApplicationArea(
      (long) 236L, (int) 6, (String) "light application area", KnxDatapointMainType.DPT_1_BYTE),
  DPT_AlarmClassType((long) 237L, (int) 7, (String) "alarm class", KnxDatapointMainType.DPT_1_BYTE),
  DPT_PSUMode((long) 238L, (int) 8, (String) "PSU mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_ErrorClass_System(
      (long) 239L, (int) 11, (String) "system error class", KnxDatapointMainType.DPT_1_BYTE),
  DPT_ErrorClass_HVAC(
      (long) 240L, (int) 12, (String) "HVAC error class", KnxDatapointMainType.DPT_1_BYTE),
  DPT_Time_Delay((long) 241L, (int) 13, (String) "time delay", KnxDatapointMainType.DPT_1_BYTE),
  DPT_Beaufort_Wind_Force_Scale(
      (long) 242L, (int) 14, (String) "wind force scale (0..12)", KnxDatapointMainType.DPT_1_BYTE),
  DPT_SensorSelect((long) 243L, (int) 17, (String) "sensor mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_ActuatorConnectType(
      (long) 244L, (int) 20, (String) "actuator connect type", KnxDatapointMainType.DPT_1_BYTE),
  DPT_Cloud_Cover((long) 245L, (int) 21, (String) "cloud cover", KnxDatapointMainType.DPT_1_BYTE),
  DPT_PowerReturnMode(
      (long) 246L, (int) 22, (String) "power return mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_FuelType((long) 247L, (int) 100, (String) "fuel type", KnxDatapointMainType.DPT_1_BYTE),
  DPT_BurnerType((long) 248L, (int) 101, (String) "burner type", KnxDatapointMainType.DPT_1_BYTE),
  DPT_HVACMode((long) 249L, (int) 102, (String) "HVAC mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_DHWMode((long) 250L, (int) 103, (String) "DHW mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_LoadPriority(
      (long) 251L, (int) 104, (String) "load priority", KnxDatapointMainType.DPT_1_BYTE),
  DPT_HVACContrMode(
      (long) 252L, (int) 105, (String) "HVAC control mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_HVACEmergMode(
      (long) 253L, (int) 106, (String) "HVAC emergency mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_ChangeoverMode(
      (long) 254L, (int) 107, (String) "changeover mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_ValveMode((long) 255L, (int) 108, (String) "valve mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_DamperMode((long) 256L, (int) 109, (String) "damper mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_HeaterMode((long) 257L, (int) 110, (String) "heater mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_FanMode((long) 258L, (int) 111, (String) "fan mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_MasterSlaveMode(
      (long) 259L, (int) 112, (String) "master/slave mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_StatusRoomSetp(
      (long) 260L, (int) 113, (String) "status room setpoint", KnxDatapointMainType.DPT_1_BYTE),
  DPT_Metering_DeviceType(
      (long) 261L, (int) 114, (String) "metering device type", KnxDatapointMainType.DPT_1_BYTE),
  DPT_HumDehumMode(
      (long) 262L, (int) 115, (String) "hum dehum mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_EnableHCStage(
      (long) 263L, (int) 116, (String) "enable H/C stage", KnxDatapointMainType.DPT_1_BYTE),
  DPT_ADAType((long) 264L, (int) 120, (String) "ADA type", KnxDatapointMainType.DPT_1_BYTE),
  DPT_BackupMode((long) 265L, (int) 121, (String) "backup mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_StartSynchronization(
      (long) 266L,
      (int) 122,
      (String) "start syncronization type",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_Behaviour_Lock_Unlock(
      (long) 267L, (int) 600, (String) "behavior lock/unlock", KnxDatapointMainType.DPT_1_BYTE),
  DPT_Behaviour_Bus_Power_Up_Down(
      (long) 268L,
      (int) 601,
      (String) "behavior bus power up/down",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_DALI_Fade_Time(
      (long) 269L, (int) 602, (String) "dali fade time", KnxDatapointMainType.DPT_1_BYTE),
  DPT_BlinkingMode((long) 270L, (int) 603, (String) "blink mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_LightControlMode(
      (long) 271L, (int) 604, (String) "light control mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_SwitchPBModel(
      (long) 272L, (int) 605, (String) "PB switch mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_PBAction((long) 273L, (int) 606, (String) "PB action mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_DimmPBModel((long) 274L, (int) 607, (String) "PB dimm mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_SwitchOnMode(
      (long) 275L, (int) 608, (String) "switch on mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_LoadTypeSet((long) 276L, (int) 609, (String) "load type", KnxDatapointMainType.DPT_1_BYTE),
  DPT_LoadTypeDetected(
      (long) 277L, (int) 610, (String) "load type detection", KnxDatapointMainType.DPT_1_BYTE),
  DPT_Converter_Test_Control(
      (long) 278L, (int) 611, (String) "converter test control", KnxDatapointMainType.DPT_1_BYTE),
  DPT_SABExcept_Behaviour(
      (long) 279L, (int) 801, (String) "SAB except behavior", KnxDatapointMainType.DPT_1_BYTE),
  DPT_SABBehaviour_Lock_Unlock(
      (long) 280L,
      (int) 802,
      (String) "SAB behavior on lock/unlock",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_SSSBMode((long) 281L, (int) 803, (String) "SSSB mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_BlindsControlMode(
      (long) 282L, (int) 804, (String) "blinds control mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_CommMode(
      (long) 283L, (int) 1000, (String) "communication mode", KnxDatapointMainType.DPT_1_BYTE),
  DPT_AddInfoTypes(
      (long) 284L,
      (int) 1001,
      (String) "additional information type",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_RF_ModeSelect(
      (long) 285L, (int) 1002, (String) "RF mode selection", KnxDatapointMainType.DPT_1_BYTE),
  DPT_RF_FilterSelect(
      (long) 286L,
      (int) 1003,
      (String) "RF filter mode selection",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_StatusGen(
      (long) 287L, (int) 1, (String) "general status", KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_Device_Control(
      (long) 288L, (int) 2, (String) "device control", KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_ForceSign(
      (long) 289L, (int) 100, (String) "forcing signal", KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_ForceSignCool(
      (long) 290L, (int) 101, (String) "forcing signal cool", KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_StatusRHC(
      (long) 291L,
      (int) 102,
      (String) "room heating controller status",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_StatusSDHWC(
      (long) 292L,
      (int) 103,
      (String) "solar DHW controller status",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_FuelTypeSet(
      (long) 293L, (int) 104, (String) "fuel type set", KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_StatusRCC(
      (long) 294L,
      (int) 105,
      (String) "room cooling controller status",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_StatusAHU(
      (long) 295L,
      (int) 106,
      (String) "ventilation controller status",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_CombinedStatus_RTSM(
      (long) 296L, (int) 107, (String) "combined status RTSM", KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_LightActuatorErrorInfo(
      (long) 297L,
      (int) 601,
      (String) "lighting actuator error information",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_RF_ModeInfo(
      (long) 298L,
      (int) 1000,
      (String) "RF communication mode info",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_RF_FilterInfo(
      (long) 299L,
      (int) 1001,
      (String) "cEMI server supported RF filtering modes",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_Channel_Activation_8(
      (long) 300L,
      (int) 1010,
      (String) "channel activation for 8 channels",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_StatusDHWC(
      (long) 301L,
      (int) 100,
      (String) "DHW controller status",
      KnxDatapointMainType.DPT_16_BIT_SET),
  DPT_StatusRHCC(
      (long) 302L, (int) 101, (String) "RHCC status", KnxDatapointMainType.DPT_16_BIT_SET),
  DPT_CombinedStatus_HVA(
      (long) 303L, (int) 102, (String) "combined status HVA", KnxDatapointMainType.DPT_16_BIT_SET),
  DPT_CombinedStatus_RTC(
      (long) 304L, (int) 103, (String) "combined status RTC", KnxDatapointMainType.DPT_16_BIT_SET),
  DPT_Media((long) 305L, (int) 1000, (String) "media", KnxDatapointMainType.DPT_16_BIT_SET),
  DPT_Channel_Activation_16(
      (long) 306L,
      (int) 1010,
      (String) "channel activation for 16 channels",
      KnxDatapointMainType.DPT_16_BIT_SET),
  DPT_OnOffAction(
      (long) 307L, (int) 1, (String) "on/off action", KnxDatapointMainType.DPT_2_BIT_SET),
  DPT_Alarm_Reaction(
      (long) 308L, (int) 2, (String) "alarm reaction", KnxDatapointMainType.DPT_2_BIT_SET),
  DPT_UpDown_Action(
      (long) 309L, (int) 3, (String) "up/down action", KnxDatapointMainType.DPT_2_BIT_SET),
  DPT_HVAC_PB_Action(
      (long) 310L,
      (int) 102,
      (String) "HVAC push button action",
      KnxDatapointMainType.DPT_2_BIT_SET),
  DPT_DoubleNibble(
      (long) 311L,
      (int) 1000,
      (String) "busy/nak repetitions",
      KnxDatapointMainType.DPT_2_NIBBLE_SET),
  DPT_SceneInfo(
      (long) 312L, (int) 1, (String) "scene information", KnxDatapointMainType.DPT_8_BIT_SET_2),
  DPT_CombinedInfoOnOff(
      (long) 313L,
      (int) 1,
      (String) "bit-combined info on/off",
      KnxDatapointMainType.DPT_32_BIT_SET),
  DPT_ActiveEnergy_V64(
      (long) 314L,
      (int) 10,
      (String) "active energy (Wh)",
      KnxDatapointMainType.DPT_ELECTRICAL_ENERGY),
  DPT_ApparantEnergy_V64(
      (long) 315L,
      (int) 11,
      (String) "apparant energy (VAh)",
      KnxDatapointMainType.DPT_ELECTRICAL_ENERGY),
  DPT_ReactiveEnergy_V64(
      (long) 316L,
      (int) 12,
      (String) "reactive energy (VARh)",
      KnxDatapointMainType.DPT_ELECTRICAL_ENERGY),
  DPT_Channel_Activation_24(
      (long) 317L,
      (int) 1010,
      (String) "activation state 0..23",
      KnxDatapointMainType.DPT_24_TIMES_CHANNEL_ACTIVATION),
  DPT_HVACModeNext(
      (long) 318L,
      (int) 100,
      (String) "time delay & HVAC mode",
      KnxDatapointMainType.DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM),
  DPT_DHWModeNext(
      (long) 319L,
      (int) 102,
      (String) "time delay & DHW mode",
      KnxDatapointMainType.DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM),
  DPT_OccModeNext(
      (long) 320L,
      (int) 104,
      (String) "time delay & occupancy mode",
      KnxDatapointMainType.DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM),
  DPT_BuildingModeNext(
      (long) 321L,
      (int) 105,
      (String) "time delay & building mode",
      KnxDatapointMainType.DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM),
  DPT_StatusLightingActuator(
      (long) 322L,
      (int) 600,
      (String) "Status Lighting Actuator",
      KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM),
  DPT_Version(
      (long) 323L,
      (int) 1,
      (String) "DPT version",
      KnxDatapointMainType.DPT_DATAPOINT_TYPE_VERSION),
  DPT_AlarmInfo((long) 324L, (int) 1, (String) "alarm info", KnxDatapointMainType.DPT_ALARM_INFO),
  DPT_TempRoomSetpSetF16_3(
      (long) 325L,
      (int) 100,
      (String) "room temperature setpoint",
      KnxDatapointMainType.DPT_3X_2_BYTE_FLOAT_VALUE),
  DPT_TempRoomSetpSetShiftF16_3(
      (long) 326L,
      (int) 101,
      (String) "room temperature setpoint shift",
      KnxDatapointMainType.DPT_3X_2_BYTE_FLOAT_VALUE),
  DPT_Scaling_Speed(
      (long) 327L, (int) 1, (String) "scaling speed", KnxDatapointMainType.DPT_SCALING_SPEED),
  DPT_Scaling_Step_Time(
      (long) 328L, (int) 2, (String) "scaling step time", KnxDatapointMainType.DPT_SCALING_SPEED),
  DPT_MeteringValue(
      (long) 329L,
      (int) 1,
      (String) "metering value (value,encoding,cmd)",
      KnxDatapointMainType.DPT_4_1_1_BYTE_COMBINED_INFORMATION),
  DPT_MBus_Address(
      (long) 330L, (int) 1000, (String) "MBus address", KnxDatapointMainType.DPT_MBUS_ADDRESS),
  DPT_Colour_RGB(
      (long) 331L,
      (int) 600,
      (String) "RGB value 3x(0..255)",
      KnxDatapointMainType.DPT_3_BYTE_COLOUR_RGB),
  DPT_LanguageCodeAlpha2_ASCII(
      (long) 332L,
      (int) 1,
      (String) "language code (ASCII)",
      KnxDatapointMainType.DPT_LANGUAGE_CODE_ISO_639_1),
  DPT_Tariff_ActiveEnergy(
      (long) 333L,
      (int) 1,
      (String) "electrical energy with tariff",
      KnxDatapointMainType.DPT_SIGNED_VALUE_WITH_CLASSIFICATION_AND_VALIDITY),
  DPT_Prioritised_Mode_Control(
      (long) 334L,
      (int) 1,
      (String) "priority control",
      KnxDatapointMainType.DPT_PRIORITISED_MODE_CONTROL),
  DPT_DALI_Control_Gear_Diagnostic(
      (long) 335L,
      (int) 600,
      (String) "diagnostic value",
      KnxDatapointMainType.DPT_CONFIGURATION_DIAGNOSTICS_16_BIT),
  DPT_DALI_Diagnostics(
      (long) 336L,
      (int) 600,
      (String) "diagnostic value",
      KnxDatapointMainType.DPT_CONFIGURATION_DIAGNOSTICS_8_BIT),
  DPT_CombinedPosition(
      (long) 337L, (int) 800, (String) "combined position", KnxDatapointMainType.DPT_POSITIONS),
  DPT_StatusSAB(
      (long) 338L,
      (int) 800,
      (String) "status sunblind & shutter actuator",
      KnxDatapointMainType.DPT_STATUS_32_BIT),
  DPT_Colour_xyY(
      (long) 339L, (int) 600, (String) "colour xyY", KnxDatapointMainType.DPT_STATUS_48_BIT),
  DPT_Converter_Status(
      (long) 340L,
      (int) 600,
      (String) "DALI converter status",
      KnxDatapointMainType.DPT_CONVERTER_STATUS),
  DPT_Converter_Test_Result(
      (long) 341L,
      (int) 600,
      (String) "DALI converter test result",
      KnxDatapointMainType.DPT_CONVERTER_TEST_RESULT),
  DPT_Battery_Info(
      (long) 342L,
      (int) 600,
      (String) "Battery Information",
      KnxDatapointMainType.DPT_BATTERY_INFORMATION),
  DPT_Brightness_Colour_Temperature_Transition(
      (long) 343L,
      (int) 600,
      (String) "brightness colour temperature transition",
      KnxDatapointMainType.DPT_BRIGHTNESS_COLOUR_TEMPERATURE_TRANSITION),
  DPT_Brightness_Colour_Temperature_Control(
      (long) 344L,
      (int) 600,
      (String) "brightness colour temperature control",
      KnxDatapointMainType.DPT_STATUS_24_BIT),
  DPT_Colour_RGBW(
      (long) 345L,
      (int) 600,
      (String) "RGBW value 4x(0..100%)",
      KnxDatapointMainType.DPT_COLOUR_RGBW),
  DPT_Relative_Control_RGBW(
      (long) 346L,
      (int) 600,
      (String) "RGBW relative control",
      KnxDatapointMainType.DPT_RELATIVE_CONTROL_RGBW),
  DPT_Relative_Control_RGB(
      (long) 347L,
      (int) 600,
      (String) "RGB relative control",
      KnxDatapointMainType.DPT_RELATIVE_CONTROL_RGB),
  DPT_GeographicalLocation(
      (long) 348L,
      (int) 1,
      (String) "geographical location (longitude and latitude) expressed in degrees",
      KnxDatapointMainType.DPT_F32F32),
  DPT_TempRoomSetpSetF16_4(
      (long) 349L,
      (int) 100,
      (String) "Temperature setpoint setting for 4 HVAC Modes",
      KnxDatapointMainType.DPT_F16F16F16F16),
  DPT_TempRoomSetpSetShiftF16_4(
      (long) 350L,
      (int) 101,
      (String) "Temperature setpoint shift setting for 4 HVAC Modes",
      KnxDatapointMainType.DPT_F16F16F16F16);
  private static final Map<Long, KnxDatapointType> map;

  static {
    map = new HashMap<>();
    for (KnxDatapointType value : KnxDatapointType.values()) {
      map.put((long) value.getValue(), value);
    }
  }

  private final long value;
  private final int number;
  private final String name;
  private final KnxDatapointMainType datapointMainType;

  KnxDatapointType(long value, int number, String name, KnxDatapointMainType datapointMainType) {
    this.value = value;
    this.number = number;
    this.name = name;
    this.datapointMainType = datapointMainType;
  }

  public long getValue() {
    return value;
  }

  public int getNumber() {
    return number;
  }

  public static KnxDatapointType firstEnumForFieldNumber(int fieldValue) {
    for (KnxDatapointType _val : KnxDatapointType.values()) {
      if (_val.getNumber() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxDatapointType> enumsForFieldNumber(int fieldValue) {
    List<KnxDatapointType> _values = new ArrayList<>();
    for (KnxDatapointType _val : KnxDatapointType.values()) {
      if (_val.getNumber() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public String getName() {
    return name;
  }

  public static KnxDatapointType firstEnumForFieldName(String fieldValue) {
    for (KnxDatapointType _val : KnxDatapointType.values()) {
      if (_val.getName().equals(fieldValue)) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxDatapointType> enumsForFieldName(String fieldValue) {
    List<KnxDatapointType> _values = new ArrayList<>();
    for (KnxDatapointType _val : KnxDatapointType.values()) {
      if (_val.getName().equals(fieldValue)) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public KnxDatapointMainType getDatapointMainType() {
    return datapointMainType;
  }

  public static KnxDatapointType firstEnumForFieldDatapointMainType(
      KnxDatapointMainType fieldValue) {
    for (KnxDatapointType _val : KnxDatapointType.values()) {
      if (_val.getDatapointMainType() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxDatapointType> enumsForFieldDatapointMainType(
      KnxDatapointMainType fieldValue) {
    List<KnxDatapointType> _values = new ArrayList<>();
    for (KnxDatapointType _val : KnxDatapointType.values()) {
      if (_val.getDatapointMainType() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static KnxDatapointType enumForValue(long value) {
    return map.get(value);
  }

  public static Boolean isDefined(long value) {
    return map.containsKey(value);
  }
}
