/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.math.BigInteger;
import java.time.*;
import java.time.temporal.ChronoField;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;
import org.apache.plc4x.java.spi.values.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

// Code generated by code-generation. DO NOT EDIT.

public class KnxDatapoint {

  private static final Logger LOGGER = LoggerFactory.getLogger(KnxDatapoint.class);

  public static PlcValue staticParse(ReadBuffer readBuffer, KnxDatapointType datapointType)
      throws ParseException {
    if (EvaluationHelper.equals(datapointType, KnxDatapointType.BOOL)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.BYTE)) { // BYTE
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcBYTE(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.WORD)) { // WORD
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readUnsignedInt(readBuffer, 16));
      return new PlcWORD(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DWORD)) { // DWORD
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      long value = readSimpleField("value", readUnsignedLong(readBuffer, 32));
      return new PlcDWORD(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LWORD)) { // LWORD
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      BigInteger value = readSimpleField("value", readUnsignedBigInteger(readBuffer, 64));
      return new PlcLWORD(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.USINT)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.SINT)) { // SINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      byte value = readSimpleField("value", readSignedByte(readBuffer, 8));
      return new PlcSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.UINT)) { // UINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readUnsignedInt(readBuffer, 16));
      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.INT)) { // INT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readSignedShort(readBuffer, 16));
      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.UDINT)) { // UDINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      long value = readSimpleField("value", readUnsignedLong(readBuffer, 32));
      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DINT)) { // DINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readSignedInt(readBuffer, 32));
      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.ULINT)) { // ULINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      BigInteger value = readSimpleField("value", readUnsignedBigInteger(readBuffer, 64));
      return new PlcULINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LINT)) { // LINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      long value = readSimpleField("value", readSignedLong(readBuffer, 64));
      return new PlcLINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.REAL)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LREAL)) { // LREAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      double value = readSimpleField("value", readDouble(readBuffer, 64));
      return new PlcLREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.CHAR)) { // CHAR
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      String value =
          readSimpleField("value", readString(readBuffer, 8), WithOption.WithEncoding("UTF-8"));
      return new PlcCHAR(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.WCHAR)) { // WCHAR
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      String value =
          readSimpleField("value", readString(readBuffer, 16), WithOption.WithEncoding("UTF-16"));
      return new PlcWCHAR(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.TIME)) { // TIME
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      long milliseconds = readSimpleField("milliseconds", readUnsignedLong(readBuffer, 32));
      return PlcTIME.ofMilliseconds(milliseconds);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LTIME)) { // LTIME
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      BigInteger nanoseconds =
          readSimpleField("nanoseconds", readUnsignedBigInteger(readBuffer, 64));
      return PlcLTIME.ofNanoseconds(nanoseconds);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DATE)) { // DATE
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      long secondsSinceEpoch =
          readSimpleField("secondsSinceEpoch", readUnsignedLong(readBuffer, 32));
      return PlcDATE.ofSecondsSinceEpoch(secondsSinceEpoch);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.TIME_OF_DAY)) { // TIME_OF_DAY
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      long millisecondsSinceMidnight =
          readSimpleField("millisecondsSinceMidnight", readUnsignedLong(readBuffer, 32));
      return PlcTIME_OF_DAY.ofMillisecondsSinceMidnight(millisecondsSinceMidnight);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.TOD)) { // TIME_OF_DAY
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      long millisecondsSinceMidnight =
          readSimpleField("millisecondsSinceMidnight", readUnsignedLong(readBuffer, 32));
      return PlcTIME_OF_DAY.ofMillisecondsSinceMidnight(millisecondsSinceMidnight);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DATE_AND_TIME)) { // DATE_AND_TIME
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int year = readSimpleField("year", readUnsignedInt(readBuffer, 16));

      short month = readSimpleField("month", readUnsignedShort(readBuffer, 8));

      short day = readSimpleField("day", readUnsignedShort(readBuffer, 8));

      short dayOfWeek = readSimpleField("dayOfWeek", readUnsignedShort(readBuffer, 8));

      short hour = readSimpleField("hour", readUnsignedShort(readBuffer, 8));

      short minutes = readSimpleField("minutes", readUnsignedShort(readBuffer, 8));

      short seconds = readSimpleField("seconds", readUnsignedShort(readBuffer, 8));

      long nanoseconds = readSimpleField("nanoseconds", readUnsignedLong(readBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DT)) { // DATE_AND_TIME
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int year = readSimpleField("year", readUnsignedInt(readBuffer, 16));

      short month = readSimpleField("month", readUnsignedShort(readBuffer, 8));

      short day = readSimpleField("day", readUnsignedShort(readBuffer, 8));

      short dayOfWeek = readSimpleField("dayOfWeek", readUnsignedShort(readBuffer, 8));

      short hour = readSimpleField("hour", readUnsignedShort(readBuffer, 8));

      short minutes = readSimpleField("minutes", readUnsignedShort(readBuffer, 8));

      short seconds = readSimpleField("seconds", readUnsignedShort(readBuffer, 8));

      long nanoseconds = readSimpleField("nanoseconds", readUnsignedLong(readBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Switch)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Bool)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Enable)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Ramp)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Alarm)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BinaryValue)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Step)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_UpDown)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OpenClose)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Start)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_State)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Invert)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DimSendStyle)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_InputSource)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Reset)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Ack)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Trigger)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Occupancy)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Window_Door)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LogicalFunction)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Scene_AB)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ShutterBlinds_Mode)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DayNight)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Heat_Cool)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Switch_Control)) { // Struct
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      boolean control = readSimpleField("control", readBoolean(readBuffer));

      boolean on = readSimpleField("on", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("on", new PlcBOOL(on));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Bool_Control)) { // Struct
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      boolean control = readSimpleField("control", readBoolean(readBuffer));

      boolean valueTrue = readSimpleField("valueTrue", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("valueTrue", new PlcBOOL(valueTrue));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Enable_Control)) { // Struct
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      boolean control = readSimpleField("control", readBoolean(readBuffer));

      boolean enable = readSimpleField("enable", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("enable", new PlcBOOL(enable));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Ramp_Control)) { // Struct
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      boolean control = readSimpleField("control", readBoolean(readBuffer));

      boolean ramp = readSimpleField("ramp", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("ramp", new PlcBOOL(ramp));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Alarm_Control)) { // Struct
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      boolean control = readSimpleField("control", readBoolean(readBuffer));

      boolean alarm = readSimpleField("alarm", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("alarm", new PlcBOOL(alarm));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_BinaryValue_Control)) { // Struct
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      boolean control = readSimpleField("control", readBoolean(readBuffer));

      boolean high = readSimpleField("high", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("high", new PlcBOOL(high));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Step_Control)) { // Struct
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      boolean control = readSimpleField("control", readBoolean(readBuffer));

      boolean increase = readSimpleField("increase", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("increase", new PlcBOOL(increase));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Direction1_Control)) { // Struct
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      boolean control = readSimpleField("control", readBoolean(readBuffer));

      boolean down = readSimpleField("down", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("down", new PlcBOOL(down));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Direction2_Control)) { // Struct
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      boolean control = readSimpleField("control", readBoolean(readBuffer));

      boolean close = readSimpleField("close", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("close", new PlcBOOL(close));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Start_Control)) { // Struct
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      boolean control = readSimpleField("control", readBoolean(readBuffer));

      boolean start = readSimpleField("start", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("start", new PlcBOOL(start));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_State_Control)) { // Struct
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      boolean control = readSimpleField("control", readBoolean(readBuffer));

      boolean active = readSimpleField("active", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("active", new PlcBOOL(active));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Invert_Control)) { // Struct
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      boolean control = readSimpleField("control", readBoolean(readBuffer));

      boolean inverted = readSimpleField("inverted", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("inverted", new PlcBOOL(inverted));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Control_Dimming)) { // Struct
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      boolean increase = readSimpleField("increase", readBoolean(readBuffer));

      byte stepcode = readSimpleField("stepcode", readUnsignedByte(readBuffer, 3));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("increase", new PlcBOOL(increase));
      _map.put("stepcode", new PlcUSINT(stepcode));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Control_Blinds)) { // Struct
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      boolean down = readSimpleField("down", readBoolean(readBuffer));

      byte stepcode = readSimpleField("stepcode", readUnsignedByte(readBuffer, 3));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("down", new PlcBOOL(down));
      _map.put("stepcode", new PlcUSINT(stepcode));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Char_ASCII)) { // STRING
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      String value =
          readSimpleField("value", readString(readBuffer, 8), WithOption.WithEncoding("ASCII"));
      return new PlcSTRING(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Char_8859_1)) { // STRING
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      String value =
          readSimpleField(
              "value", readString(readBuffer, 8), WithOption.WithEncoding("ISO-8859-1"));
      return new PlcSTRING(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Scaling)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Angle)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_U8)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DecimalFactor)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Tariff)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_1_Ucount)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FanStage)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_V8)) { // SINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      byte value = readSimpleField("value", readSignedByte(readBuffer, 8));
      return new PlcSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_1_Count)) { // SINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      byte value = readSimpleField("value", readSignedByte(readBuffer, 8));
      return new PlcSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Status_Mode3)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      boolean statusA = readSimpleField("statusA", readBoolean(readBuffer));

      boolean statusB = readSimpleField("statusB", readBoolean(readBuffer));

      boolean statusC = readSimpleField("statusC", readBoolean(readBuffer));

      boolean statusD = readSimpleField("statusD", readBoolean(readBuffer));

      boolean statusE = readSimpleField("statusE", readBoolean(readBuffer));

      byte mode = readSimpleField("mode", readUnsignedByte(readBuffer, 3));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("statusA", new PlcBOOL(statusA));
      _map.put("statusB", new PlcBOOL(statusB));
      _map.put("statusC", new PlcBOOL(statusC));
      _map.put("statusD", new PlcBOOL(statusD));
      _map.put("statusE", new PlcBOOL(statusE));
      _map.put("mode", new PlcUSINT(mode));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_2_Ucount)) { // UINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readUnsignedInt(readBuffer, 16));
      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriodMsec)) { // UINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readUnsignedInt(readBuffer, 16));
      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriod10Msec)) { // UINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readUnsignedInt(readBuffer, 16));
      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriod100Msec)) { // UINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readUnsignedInt(readBuffer, 16));
      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodSec)) { // UINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readUnsignedInt(readBuffer, 16));
      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodMin)) { // UINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readUnsignedInt(readBuffer, 16));
      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodHrs)) { // UINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readUnsignedInt(readBuffer, 16));
      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PropDataType)) { // UINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readUnsignedInt(readBuffer, 16));
      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Length_mm)) { // UINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readUnsignedInt(readBuffer, 16));
      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_UElCurrentmA)) { // UINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readUnsignedInt(readBuffer, 16));
      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Brightness)) { // UINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readUnsignedInt(readBuffer, 16));
      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Absolute_Colour_Temperature)) { // UINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readUnsignedInt(readBuffer, 16));
      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_2_Count)) { // INT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readSignedShort(readBuffer, 16));
      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeMsec)) { // INT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readSignedShort(readBuffer, 16));
      return new PlcINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaTime10Msec)) { // INT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readSignedShort(readBuffer, 16));
      return new PlcINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaTime100Msec)) { // INT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readSignedShort(readBuffer, 16));
      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeSec)) { // INT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readSignedShort(readBuffer, 16));
      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeMin)) { // INT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readSignedShort(readBuffer, 16));
      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeHrs)) { // INT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readSignedShort(readBuffer, 16));
      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_V16)) { // INT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readSignedShort(readBuffer, 16));
      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Rotation_Angle)) { // INT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readSignedShort(readBuffer, 16));
      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Length_m)) { // INT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readSignedShort(readBuffer, 16));
      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Temp)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Tempd)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Tempa)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Lux)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Wsp)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Pres)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Humidity)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AirQuality)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_AirFlow)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time1)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time2)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Volt)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Curr)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PowerDensity)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_KelvinPerPercent)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Power)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Volume_Flow)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Rain_Amount)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Temp_F)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Wsp_kmh)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Absolute_Humidity)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Concentration_ygm3)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Coefficient)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimeOfDay)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      byte day = readSimpleField("day", readUnsignedByte(readBuffer, 3));

      byte hour = readSimpleField("hour", readUnsignedByte(readBuffer, 5));

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 2), (byte) 0x00);

      byte minutes = readSimpleField("minutes", readUnsignedByte(readBuffer, 6));

      Byte reservedField2 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 2), (byte) 0x00);

      byte seconds = readSimpleField("seconds", readUnsignedByte(readBuffer, 6));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("day", new PlcUSINT(day));
      _map.put("hour", new PlcUSINT(hour));
      _map.put("minutes", new PlcUSINT(minutes));
      _map.put("seconds", new PlcUSINT(seconds));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Date)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 3), (byte) 0x00);

      byte dayOfMonth = readSimpleField("dayOfMonth", readUnsignedByte(readBuffer, 5));

      Byte reservedField2 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      byte month = readSimpleField("month", readUnsignedByte(readBuffer, 4));

      Byte reservedField3 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 1), (byte) 0x00);

      byte year = readSimpleField("year", readUnsignedByte(readBuffer, 7));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("dayOfMonth", new PlcUSINT(dayOfMonth));
      _map.put("month", new PlcUSINT(month));
      _map.put("year", new PlcUSINT(year));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_4_Ucount)) { // UDINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      long value = readSimpleField("value", readUnsignedLong(readBuffer, 32));
      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Sec)) { // UDINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      long value = readSimpleField("value", readUnsignedLong(readBuffer, 32));
      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Min)) { // UDINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      long value = readSimpleField("value", readUnsignedLong(readBuffer, 32));
      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Hrs)) { // UDINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      long value = readSimpleField("value", readUnsignedLong(readBuffer, 32));
      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_VolumeLiquid_Litre)) { // UDINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      long value = readSimpleField("value", readUnsignedLong(readBuffer, 32));
      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Volume_m_3)) { // UDINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      long value = readSimpleField("value", readUnsignedLong(readBuffer, 32));
      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_4_Count)) { // DINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readSignedInt(readBuffer, 32));
      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FlowRate_m3h)) { // DINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readSignedInt(readBuffer, 32));
      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ActiveEnergy)) { // DINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readSignedInt(readBuffer, 32));
      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy)) { // DINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readSignedInt(readBuffer, 32));
      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy)) { // DINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readSignedInt(readBuffer, 32));
      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_kWh)) { // DINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readSignedInt(readBuffer, 32));
      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy_kVAh)) { // DINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readSignedInt(readBuffer, 32));
      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy_kVARh)) { // DINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readSignedInt(readBuffer, 32));
      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_MWh)) { // DINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readSignedInt(readBuffer, 32));
      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongDeltaTimeSec)) { // DINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readSignedInt(readBuffer, 32));
      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaVolumeLiquid_Litre)) { // DINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readSignedInt(readBuffer, 32));
      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaVolume_m_3)) { // DINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int value = readSimpleField("value", readSignedInt(readBuffer, 32));
      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Acceleration)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Acceleration_Angular)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Activation_Energy)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Activity)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Mol)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Amplitude)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AngleRad)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AngleDeg)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Momentum)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Velocity)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Area)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Capacitance)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Charge_DensitySurface)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Charge_DensityVolume)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Compressibility)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Conductance)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electrical_Conductivity)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Density)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Charge)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Current)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_CurrentDensity)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_DipoleMoment)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Displacement)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_FieldStrength)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Flux)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_FluxDensity)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Polarization)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Potential)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_PotentialDifference)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_ElectromagneticMoment)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electromotive_Force)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Energy)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Force)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Frequency)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Frequency)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_Capacity)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_FlowRate)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_Quantity)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Impedance)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Length)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Light_Quantity)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminance)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminous_Flux)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminous_Intensity)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_FieldStrength)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Flux)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_FluxDensity)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Moment)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Polarization)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetization)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_MagnetomotiveForce)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Mass)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_MassFlux)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Momentum)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Phase_AngleRad)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Phase_AngleDeg)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Power)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Power_Factor)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Pressure)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Reactance)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Resistance)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Resistivity)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_SelfInductance)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_SolidAngle)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Sound_Intensity)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Speed)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Stress)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Surface_Tension)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Common_Temperature)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Absolute_Temperature)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_TemperatureDifference)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Thermal_Capacity)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Thermal_Conductivity)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_ThermoelectricPower)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Torque)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Volume)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Volume_Flux)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Weight)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Work)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_ApparentPower)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value = readSimpleField("value", readFloat(readBuffer, 32));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Volume_Flux_Meter)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Volume_Flux_ls)) { // REAL
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float value =
          readSimpleField("value", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));
      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Access_Data)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      byte hurz = readSimpleField("hurz", readUnsignedByte(readBuffer, 4));

      byte value1 = readSimpleField("value1", readUnsignedByte(readBuffer, 4));

      byte value2 = readSimpleField("value2", readUnsignedByte(readBuffer, 4));

      byte value3 = readSimpleField("value3", readUnsignedByte(readBuffer, 4));

      byte value4 = readSimpleField("value4", readUnsignedByte(readBuffer, 4));

      byte value5 = readSimpleField("value5", readUnsignedByte(readBuffer, 4));

      boolean detectionError = readSimpleField("detectionError", readBoolean(readBuffer));

      boolean permission = readSimpleField("permission", readBoolean(readBuffer));

      boolean readDirection = readSimpleField("readDirection", readBoolean(readBuffer));

      boolean encryptionOfAccessInformation =
          readSimpleField("encryptionOfAccessInformation", readBoolean(readBuffer));

      byte indexOfAccessIdentificationCode =
          readSimpleField("indexOfAccessIdentificationCode", readUnsignedByte(readBuffer, 4));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("hurz", new PlcUSINT(hurz));
      _map.put("value1", new PlcUSINT(value1));
      _map.put("value2", new PlcUSINT(value2));
      _map.put("value3", new PlcUSINT(value3));
      _map.put("value4", new PlcUSINT(value4));
      _map.put("value5", new PlcUSINT(value5));
      _map.put("detectionError", new PlcBOOL(detectionError));
      _map.put("permission", new PlcBOOL(permission));
      _map.put("readDirection", new PlcBOOL(readDirection));
      _map.put("encryptionOfAccessInformation", new PlcBOOL(encryptionOfAccessInformation));
      _map.put("indexOfAccessIdentificationCode", new PlcUSINT(indexOfAccessIdentificationCode));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_String_ASCII)) { // STRING
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      String value =
          readSimpleField("value", readString(readBuffer, 112), WithOption.WithEncoding("ASCII"));
      return new PlcSTRING(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_String_8859_1)) { // STRING
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      String value =
          readSimpleField(
              "value", readString(readBuffer, 112), WithOption.WithEncoding("ISO-8859-1"));
      return new PlcSTRING(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SceneNumber)) { // USINT
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 2), (byte) 0x00);

      byte value = readSimpleField("value", readUnsignedByte(readBuffer, 6));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SceneControl)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      boolean learnTheSceneCorrespondingToTheFieldSceneNumber =
          readSimpleField(
              "learnTheSceneCorrespondingToTheFieldSceneNumber", readBoolean(readBuffer));

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 1), (byte) 0x00);

      byte sceneNumber = readSimpleField("sceneNumber", readUnsignedByte(readBuffer, 6));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put(
          "learnTheSceneCorrespondingToTheFieldSceneNumber",
          new PlcBOOL(learnTheSceneCorrespondingToTheFieldSceneNumber));
      _map.put("sceneNumber", new PlcUSINT(sceneNumber));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DateTime)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short year = readSimpleField("year", readUnsignedShort(readBuffer, 8));

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      byte month = readSimpleField("month", readUnsignedByte(readBuffer, 4));

      Byte reservedField2 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 3), (byte) 0x00);

      byte dayofmonth = readSimpleField("dayofmonth", readUnsignedByte(readBuffer, 5));

      byte dayofweek = readSimpleField("dayofweek", readUnsignedByte(readBuffer, 3));

      byte hourofday = readSimpleField("hourofday", readUnsignedByte(readBuffer, 5));

      Byte reservedField3 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 2), (byte) 0x00);

      byte minutes = readSimpleField("minutes", readUnsignedByte(readBuffer, 6));

      Byte reservedField4 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 2), (byte) 0x00);

      byte seconds = readSimpleField("seconds", readUnsignedByte(readBuffer, 6));

      boolean fault = readSimpleField("fault", readBoolean(readBuffer));

      boolean workingDay = readSimpleField("workingDay", readBoolean(readBuffer));

      boolean noWd = readSimpleField("noWd", readBoolean(readBuffer));

      boolean noYear = readSimpleField("noYear", readBoolean(readBuffer));

      boolean noDate = readSimpleField("noDate", readBoolean(readBuffer));

      boolean noDayOfWeek = readSimpleField("noDayOfWeek", readBoolean(readBuffer));

      boolean noTime = readSimpleField("noTime", readBoolean(readBuffer));

      boolean standardSummerTime = readSimpleField("standardSummerTime", readBoolean(readBuffer));

      boolean qualityOfClock = readSimpleField("qualityOfClock", readBoolean(readBuffer));

      Byte reservedField5 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("year", new PlcUSINT(year));
      _map.put("month", new PlcUSINT(month));
      _map.put("dayofmonth", new PlcUSINT(dayofmonth));
      _map.put("dayofweek", new PlcUSINT(dayofweek));
      _map.put("hourofday", new PlcUSINT(hourofday));
      _map.put("minutes", new PlcUSINT(minutes));
      _map.put("seconds", new PlcUSINT(seconds));
      _map.put("fault", new PlcBOOL(fault));
      _map.put("workingDay", new PlcBOOL(workingDay));
      _map.put("noWd", new PlcBOOL(noWd));
      _map.put("noYear", new PlcBOOL(noYear));
      _map.put("noDate", new PlcBOOL(noDate));
      _map.put("noDayOfWeek", new PlcBOOL(noDayOfWeek));
      _map.put("noTime", new PlcBOOL(noTime));
      _map.put("standardSummerTime", new PlcBOOL(standardSummerTime));
      _map.put("qualityOfClock", new PlcBOOL(qualityOfClock));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SCLOMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BuildingMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OccMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Priority)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LightApplicationMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApplicationArea)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_AlarmClassType)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PSUMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ErrorClass_System)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ErrorClass_HVAC)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Time_Delay)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Beaufort_Wind_Force_Scale)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SensorSelect)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActuatorConnectType)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Cloud_Cover)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_PowerReturnMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FuelType)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BurnerType)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HVACMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DHWMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_LoadPriority)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVACContrMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVACEmergMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ChangeoverMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ValveMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DamperMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HeaterMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FanMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_MasterSlaveMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_StatusRoomSetp)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Metering_DeviceType)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HumDehumMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_EnableHCStage)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ADAType)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BackupMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_StartSynchronization)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Behaviour_Lock_Unlock)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Behaviour_Bus_Power_Up_Down)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DALI_Fade_Time)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BlinkingMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LightControlMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SwitchPBModel)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PBAction)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DimmPBModel)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SwitchOnMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_LoadTypeSet)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LoadTypeDetected)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Converter_Test_Control)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SABExcept_Behaviour)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SABBehaviour_Lock_Unlock)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SSSBMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_BlindsControlMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_CommMode)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_AddInfoTypes)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_RF_ModeSelect)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_RF_FilterSelect)) { // USINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short value = readSimpleField("value", readUnsignedShort(readBuffer, 8));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusGen)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 3), (byte) 0x00);

      boolean alarmStatusOfCorrespondingDatapointIsNotAcknowledged =
          readSimpleField(
              "alarmStatusOfCorrespondingDatapointIsNotAcknowledged", readBoolean(readBuffer));

      boolean correspondingDatapointIsInAlarm =
          readSimpleField("correspondingDatapointIsInAlarm", readBoolean(readBuffer));

      boolean correspondingDatapointMainValueIsOverridden =
          readSimpleField("correspondingDatapointMainValueIsOverridden", readBoolean(readBuffer));

      boolean correspondingDatapointMainValueIsCorruptedDueToFailure =
          readSimpleField(
              "correspondingDatapointMainValueIsCorruptedDueToFailure", readBoolean(readBuffer));

      boolean correspondingDatapointValueIsOutOfService =
          readSimpleField("correspondingDatapointValueIsOutOfService", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put(
          "alarmStatusOfCorrespondingDatapointIsNotAcknowledged",
          new PlcBOOL(alarmStatusOfCorrespondingDatapointIsNotAcknowledged));
      _map.put("correspondingDatapointIsInAlarm", new PlcBOOL(correspondingDatapointIsInAlarm));
      _map.put(
          "correspondingDatapointMainValueIsOverridden",
          new PlcBOOL(correspondingDatapointMainValueIsOverridden));
      _map.put(
          "correspondingDatapointMainValueIsCorruptedDueToFailure",
          new PlcBOOL(correspondingDatapointMainValueIsCorruptedDueToFailure));
      _map.put(
          "correspondingDatapointValueIsOutOfService",
          new PlcBOOL(correspondingDatapointValueIsOutOfService));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Device_Control)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 5), (byte) 0x00);

      boolean verifyModeIsOn = readSimpleField("verifyModeIsOn", readBoolean(readBuffer));

      boolean aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived =
          readSimpleField(
              "aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived",
              readBoolean(readBuffer));

      boolean theUserApplicationIsStopped =
          readSimpleField("theUserApplicationIsStopped", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("verifyModeIsOn", new PlcBOOL(verifyModeIsOn));
      _map.put(
          "aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived",
          new PlcBOOL(aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived));
      _map.put("theUserApplicationIsStopped", new PlcBOOL(theUserApplicationIsStopped));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ForceSign)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      boolean roomhmax = readSimpleField("roomhmax", readBoolean(readBuffer));

      boolean roomhconf = readSimpleField("roomhconf", readBoolean(readBuffer));

      boolean dhwlegio = readSimpleField("dhwlegio", readBoolean(readBuffer));

      boolean dhwnorm = readSimpleField("dhwnorm", readBoolean(readBuffer));

      boolean overrun = readSimpleField("overrun", readBoolean(readBuffer));

      boolean oversupply = readSimpleField("oversupply", readBoolean(readBuffer));

      boolean protection = readSimpleField("protection", readBoolean(readBuffer));

      boolean forcerequest = readSimpleField("forcerequest", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("roomhmax", new PlcBOOL(roomhmax));
      _map.put("roomhconf", new PlcBOOL(roomhconf));
      _map.put("dhwlegio", new PlcBOOL(dhwlegio));
      _map.put("dhwnorm", new PlcBOOL(dhwnorm));
      _map.put("overrun", new PlcBOOL(overrun));
      _map.put("oversupply", new PlcBOOL(oversupply));
      _map.put("protection", new PlcBOOL(protection));
      _map.put("forcerequest", new PlcBOOL(forcerequest));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ForceSignCool)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusRHC)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      boolean summermode = readSimpleField("summermode", readBoolean(readBuffer));

      boolean statusstopoptim = readSimpleField("statusstopoptim", readBoolean(readBuffer));

      boolean statusstartoptim = readSimpleField("statusstartoptim", readBoolean(readBuffer));

      boolean statusmorningboost = readSimpleField("statusmorningboost", readBoolean(readBuffer));

      boolean tempreturnlimit = readSimpleField("tempreturnlimit", readBoolean(readBuffer));

      boolean tempflowlimit = readSimpleField("tempflowlimit", readBoolean(readBuffer));

      boolean satuseco = readSimpleField("satuseco", readBoolean(readBuffer));

      boolean fault = readSimpleField("fault", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("summermode", new PlcBOOL(summermode));
      _map.put("statusstopoptim", new PlcBOOL(statusstopoptim));
      _map.put("statusstartoptim", new PlcBOOL(statusstartoptim));
      _map.put("statusmorningboost", new PlcBOOL(statusmorningboost));
      _map.put("tempreturnlimit", new PlcBOOL(tempreturnlimit));
      _map.put("tempflowlimit", new PlcBOOL(tempflowlimit));
      _map.put("satuseco", new PlcBOOL(satuseco));
      _map.put("fault", new PlcBOOL(fault));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusSDHWC)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 5), (byte) 0x00);

      boolean solarloadsufficient = readSimpleField("solarloadsufficient", readBoolean(readBuffer));

      boolean sdhwloadactive = readSimpleField("sdhwloadactive", readBoolean(readBuffer));

      boolean fault = readSimpleField("fault", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("solarloadsufficient", new PlcBOOL(solarloadsufficient));
      _map.put("sdhwloadactive", new PlcBOOL(sdhwloadactive));
      _map.put("fault", new PlcBOOL(fault));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FuelTypeSet)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 5), (byte) 0x00);

      boolean solidstate = readSimpleField("solidstate", readBoolean(readBuffer));

      boolean gas = readSimpleField("gas", readBoolean(readBuffer));

      boolean oil = readSimpleField("oil", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("solidstate", new PlcBOOL(solidstate));
      _map.put("gas", new PlcBOOL(gas));
      _map.put("oil", new PlcBOOL(oil));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusRCC)) { // BOOL
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean value = readSimpleField("value", readBoolean(readBuffer));
      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusAHU)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      boolean cool = readSimpleField("cool", readBoolean(readBuffer));

      boolean heat = readSimpleField("heat", readBoolean(readBuffer));

      boolean fanactive = readSimpleField("fanactive", readBoolean(readBuffer));

      boolean fault = readSimpleField("fault", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("cool", new PlcBOOL(cool));
      _map.put("heat", new PlcBOOL(heat));
      _map.put("fanactive", new PlcBOOL(fanactive));
      _map.put("fault", new PlcBOOL(fault));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedStatus_RTSM)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 3), (byte) 0x00);

      boolean statusOfHvacModeUser =
          readSimpleField("statusOfHvacModeUser", readBoolean(readBuffer));

      boolean statusOfComfortProlongationUser =
          readSimpleField("statusOfComfortProlongationUser", readBoolean(readBuffer));

      boolean effectiveValueOfTheComfortPushButton =
          readSimpleField("effectiveValueOfTheComfortPushButton", readBoolean(readBuffer));

      boolean effectiveValueOfThePresenceStatus =
          readSimpleField("effectiveValueOfThePresenceStatus", readBoolean(readBuffer));

      boolean effectiveValueOfTheWindowStatus =
          readSimpleField("effectiveValueOfTheWindowStatus", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("statusOfHvacModeUser", new PlcBOOL(statusOfHvacModeUser));
      _map.put("statusOfComfortProlongationUser", new PlcBOOL(statusOfComfortProlongationUser));
      _map.put(
          "effectiveValueOfTheComfortPushButton",
          new PlcBOOL(effectiveValueOfTheComfortPushButton));
      _map.put("effectiveValueOfThePresenceStatus", new PlcBOOL(effectiveValueOfThePresenceStatus));
      _map.put("effectiveValueOfTheWindowStatus", new PlcBOOL(effectiveValueOfTheWindowStatus));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LightActuatorErrorInfo)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 1), (byte) 0x00);

      boolean overheat = readSimpleField("overheat", readBoolean(readBuffer));

      boolean lampfailure = readSimpleField("lampfailure", readBoolean(readBuffer));

      boolean defectiveload = readSimpleField("defectiveload", readBoolean(readBuffer));

      boolean underload = readSimpleField("underload", readBoolean(readBuffer));

      boolean overcurrent = readSimpleField("overcurrent", readBoolean(readBuffer));

      boolean undervoltage = readSimpleField("undervoltage", readBoolean(readBuffer));

      boolean loaddetectionerror = readSimpleField("loaddetectionerror", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("overheat", new PlcBOOL(overheat));
      _map.put("lampfailure", new PlcBOOL(lampfailure));
      _map.put("defectiveload", new PlcBOOL(defectiveload));
      _map.put("underload", new PlcBOOL(underload));
      _map.put("overcurrent", new PlcBOOL(overcurrent));
      _map.put("undervoltage", new PlcBOOL(undervoltage));
      _map.put("loaddetectionerror", new PlcBOOL(loaddetectionerror));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_RF_ModeInfo)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 5), (byte) 0x00);

      boolean bibatSlave = readSimpleField("bibatSlave", readBoolean(readBuffer));

      boolean bibatMaster = readSimpleField("bibatMaster", readBoolean(readBuffer));

      boolean asynchronous = readSimpleField("asynchronous", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("bibatSlave", new PlcBOOL(bibatSlave));
      _map.put("bibatMaster", new PlcBOOL(bibatMaster));
      _map.put("asynchronous", new PlcBOOL(asynchronous));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_RF_FilterInfo)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 5), (byte) 0x00);

      boolean doa = readSimpleField("doa", readBoolean(readBuffer));

      boolean knxSn = readSimpleField("knxSn", readBoolean(readBuffer));

      boolean doaAndKnxSn = readSimpleField("doaAndKnxSn", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("doa", new PlcBOOL(doa));
      _map.put("knxSn", new PlcBOOL(knxSn));
      _map.put("doaAndKnxSn", new PlcBOOL(doaAndKnxSn));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Channel_Activation_8)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      boolean activationStateOfChannel1 =
          readSimpleField("activationStateOfChannel1", readBoolean(readBuffer));

      boolean activationStateOfChannel2 =
          readSimpleField("activationStateOfChannel2", readBoolean(readBuffer));

      boolean activationStateOfChannel3 =
          readSimpleField("activationStateOfChannel3", readBoolean(readBuffer));

      boolean activationStateOfChannel4 =
          readSimpleField("activationStateOfChannel4", readBoolean(readBuffer));

      boolean activationStateOfChannel5 =
          readSimpleField("activationStateOfChannel5", readBoolean(readBuffer));

      boolean activationStateOfChannel6 =
          readSimpleField("activationStateOfChannel6", readBoolean(readBuffer));

      boolean activationStateOfChannel7 =
          readSimpleField("activationStateOfChannel7", readBoolean(readBuffer));

      boolean activationStateOfChannel8 =
          readSimpleField("activationStateOfChannel8", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("activationStateOfChannel1", new PlcBOOL(activationStateOfChannel1));
      _map.put("activationStateOfChannel2", new PlcBOOL(activationStateOfChannel2));
      _map.put("activationStateOfChannel3", new PlcBOOL(activationStateOfChannel3));
      _map.put("activationStateOfChannel4", new PlcBOOL(activationStateOfChannel4));
      _map.put("activationStateOfChannel5", new PlcBOOL(activationStateOfChannel5));
      _map.put("activationStateOfChannel6", new PlcBOOL(activationStateOfChannel6));
      _map.put("activationStateOfChannel7", new PlcBOOL(activationStateOfChannel7));
      _map.put("activationStateOfChannel8", new PlcBOOL(activationStateOfChannel8));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusDHWC)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Short reservedField1 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      boolean tempoptimshiftactive =
          readSimpleField("tempoptimshiftactive", readBoolean(readBuffer));

      boolean solarenergysupport = readSimpleField("solarenergysupport", readBoolean(readBuffer));

      boolean solarenergyonly = readSimpleField("solarenergyonly", readBoolean(readBuffer));

      boolean otherenergysourceactive =
          readSimpleField("otherenergysourceactive", readBoolean(readBuffer));

      boolean dhwpushactive = readSimpleField("dhwpushactive", readBoolean(readBuffer));

      boolean legioprotactive = readSimpleField("legioprotactive", readBoolean(readBuffer));

      boolean dhwloadactive = readSimpleField("dhwloadactive", readBoolean(readBuffer));

      boolean fault = readSimpleField("fault", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("tempoptimshiftactive", new PlcBOOL(tempoptimshiftactive));
      _map.put("solarenergysupport", new PlcBOOL(solarenergysupport));
      _map.put("solarenergyonly", new PlcBOOL(solarenergyonly));
      _map.put("otherenergysourceactive", new PlcBOOL(otherenergysourceactive));
      _map.put("dhwpushactive", new PlcBOOL(dhwpushactive));
      _map.put("legioprotactive", new PlcBOOL(legioprotactive));
      _map.put("dhwloadactive", new PlcBOOL(dhwloadactive));
      _map.put("fault", new PlcBOOL(fault));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusRHCC)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 1), (byte) 0x00);

      boolean overheatalarm = readSimpleField("overheatalarm", readBoolean(readBuffer));

      boolean frostalarm = readSimpleField("frostalarm", readBoolean(readBuffer));

      boolean dewpointstatus = readSimpleField("dewpointstatus", readBoolean(readBuffer));

      boolean coolingdisabled = readSimpleField("coolingdisabled", readBoolean(readBuffer));

      boolean statusprecool = readSimpleField("statusprecool", readBoolean(readBuffer));

      boolean statusecoc = readSimpleField("statusecoc", readBoolean(readBuffer));

      boolean heatcoolmode = readSimpleField("heatcoolmode", readBoolean(readBuffer));

      boolean heatingdiabled = readSimpleField("heatingdiabled", readBoolean(readBuffer));

      boolean statusstopoptim = readSimpleField("statusstopoptim", readBoolean(readBuffer));

      boolean statusstartoptim = readSimpleField("statusstartoptim", readBoolean(readBuffer));

      boolean statusmorningboosth = readSimpleField("statusmorningboosth", readBoolean(readBuffer));

      boolean tempflowreturnlimit = readSimpleField("tempflowreturnlimit", readBoolean(readBuffer));

      boolean tempflowlimit = readSimpleField("tempflowlimit", readBoolean(readBuffer));

      boolean statusecoh = readSimpleField("statusecoh", readBoolean(readBuffer));

      boolean fault = readSimpleField("fault", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("overheatalarm", new PlcBOOL(overheatalarm));
      _map.put("frostalarm", new PlcBOOL(frostalarm));
      _map.put("dewpointstatus", new PlcBOOL(dewpointstatus));
      _map.put("coolingdisabled", new PlcBOOL(coolingdisabled));
      _map.put("statusprecool", new PlcBOOL(statusprecool));
      _map.put("statusecoc", new PlcBOOL(statusecoc));
      _map.put("heatcoolmode", new PlcBOOL(heatcoolmode));
      _map.put("heatingdiabled", new PlcBOOL(heatingdiabled));
      _map.put("statusstopoptim", new PlcBOOL(statusstopoptim));
      _map.put("statusstartoptim", new PlcBOOL(statusstartoptim));
      _map.put("statusmorningboosth", new PlcBOOL(statusmorningboosth));
      _map.put("tempflowreturnlimit", new PlcBOOL(tempflowreturnlimit));
      _map.put("tempflowlimit", new PlcBOOL(tempflowlimit));
      _map.put("statusecoh", new PlcBOOL(statusecoh));
      _map.put("fault", new PlcBOOL(fault));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedStatus_HVA)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean calibrationMode = readSimpleField("calibrationMode", readBoolean(readBuffer));

      boolean lockedPosition = readSimpleField("lockedPosition", readBoolean(readBuffer));

      boolean forcedPosition = readSimpleField("forcedPosition", readBoolean(readBuffer));

      boolean manuaOperationOverridden =
          readSimpleField("manuaOperationOverridden", readBoolean(readBuffer));

      boolean serviceMode = readSimpleField("serviceMode", readBoolean(readBuffer));

      boolean valveKick = readSimpleField("valveKick", readBoolean(readBuffer));

      boolean overload = readSimpleField("overload", readBoolean(readBuffer));

      boolean shortCircuit = readSimpleField("shortCircuit", readBoolean(readBuffer));

      boolean currentValvePosition =
          readSimpleField("currentValvePosition", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("calibrationMode", new PlcBOOL(calibrationMode));
      _map.put("lockedPosition", new PlcBOOL(lockedPosition));
      _map.put("forcedPosition", new PlcBOOL(forcedPosition));
      _map.put("manuaOperationOverridden", new PlcBOOL(manuaOperationOverridden));
      _map.put("serviceMode", new PlcBOOL(serviceMode));
      _map.put("valveKick", new PlcBOOL(valveKick));
      _map.put("overload", new PlcBOOL(overload));
      _map.put("shortCircuit", new PlcBOOL(shortCircuit));
      _map.put("currentValvePosition", new PlcBOOL(currentValvePosition));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedStatus_RTC)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

      boolean coolingModeEnabled = readSimpleField("coolingModeEnabled", readBoolean(readBuffer));

      boolean heatingModeEnabled = readSimpleField("heatingModeEnabled", readBoolean(readBuffer));

      boolean additionalHeatingCoolingStage2Stage =
          readSimpleField("additionalHeatingCoolingStage2Stage", readBoolean(readBuffer));

      boolean controllerInactive = readSimpleField("controllerInactive", readBoolean(readBuffer));

      boolean overheatAlarm = readSimpleField("overheatAlarm", readBoolean(readBuffer));

      boolean frostAlarm = readSimpleField("frostAlarm", readBoolean(readBuffer));

      boolean dewPointStatus = readSimpleField("dewPointStatus", readBoolean(readBuffer));

      boolean activeMode = readSimpleField("activeMode", readBoolean(readBuffer));

      boolean generalFailureInformation =
          readSimpleField("generalFailureInformation", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("coolingModeEnabled", new PlcBOOL(coolingModeEnabled));
      _map.put("heatingModeEnabled", new PlcBOOL(heatingModeEnabled));
      _map.put(
          "additionalHeatingCoolingStage2Stage", new PlcBOOL(additionalHeatingCoolingStage2Stage));
      _map.put("controllerInactive", new PlcBOOL(controllerInactive));
      _map.put("overheatAlarm", new PlcBOOL(overheatAlarm));
      _map.put("frostAlarm", new PlcBOOL(frostAlarm));
      _map.put("dewPointStatus", new PlcBOOL(dewPointStatus));
      _map.put("activeMode", new PlcBOOL(activeMode));
      _map.put("generalFailureInformation", new PlcBOOL(generalFailureInformation));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Media)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Short reservedField1 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 10), (short) 0x00);

      boolean knxIp = readSimpleField("knxIp", readBoolean(readBuffer));

      boolean rf = readSimpleField("rf", readBoolean(readBuffer));

      Byte reservedField2 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 1), (byte) 0x00);

      boolean pl110 = readSimpleField("pl110", readBoolean(readBuffer));

      boolean tp1 = readSimpleField("tp1", readBoolean(readBuffer));

      Byte reservedField3 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 1), (byte) 0x00);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("knxIp", new PlcBOOL(knxIp));
      _map.put("rf", new PlcBOOL(rf));
      _map.put("pl110", new PlcBOOL(pl110));
      _map.put("tp1", new PlcBOOL(tp1));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Channel_Activation_16)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      boolean activationStateOfChannel1 =
          readSimpleField("activationStateOfChannel1", readBoolean(readBuffer));

      boolean activationStateOfChannel2 =
          readSimpleField("activationStateOfChannel2", readBoolean(readBuffer));

      boolean activationStateOfChannel3 =
          readSimpleField("activationStateOfChannel3", readBoolean(readBuffer));

      boolean activationStateOfChannel4 =
          readSimpleField("activationStateOfChannel4", readBoolean(readBuffer));

      boolean activationStateOfChannel5 =
          readSimpleField("activationStateOfChannel5", readBoolean(readBuffer));

      boolean activationStateOfChannel6 =
          readSimpleField("activationStateOfChannel6", readBoolean(readBuffer));

      boolean activationStateOfChannel7 =
          readSimpleField("activationStateOfChannel7", readBoolean(readBuffer));

      boolean activationStateOfChannel8 =
          readSimpleField("activationStateOfChannel8", readBoolean(readBuffer));

      boolean activationStateOfChannel9 =
          readSimpleField("activationStateOfChannel9", readBoolean(readBuffer));

      boolean activationStateOfChannel10 =
          readSimpleField("activationStateOfChannel10", readBoolean(readBuffer));

      boolean activationStateOfChannel11 =
          readSimpleField("activationStateOfChannel11", readBoolean(readBuffer));

      boolean activationStateOfChannel12 =
          readSimpleField("activationStateOfChannel12", readBoolean(readBuffer));

      boolean activationStateOfChannel13 =
          readSimpleField("activationStateOfChannel13", readBoolean(readBuffer));

      boolean activationStateOfChannel14 =
          readSimpleField("activationStateOfChannel14", readBoolean(readBuffer));

      boolean activationStateOfChannel15 =
          readSimpleField("activationStateOfChannel15", readBoolean(readBuffer));

      boolean activationStateOfChannel16 =
          readSimpleField("activationStateOfChannel16", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("activationStateOfChannel1", new PlcBOOL(activationStateOfChannel1));
      _map.put("activationStateOfChannel2", new PlcBOOL(activationStateOfChannel2));
      _map.put("activationStateOfChannel3", new PlcBOOL(activationStateOfChannel3));
      _map.put("activationStateOfChannel4", new PlcBOOL(activationStateOfChannel4));
      _map.put("activationStateOfChannel5", new PlcBOOL(activationStateOfChannel5));
      _map.put("activationStateOfChannel6", new PlcBOOL(activationStateOfChannel6));
      _map.put("activationStateOfChannel7", new PlcBOOL(activationStateOfChannel7));
      _map.put("activationStateOfChannel8", new PlcBOOL(activationStateOfChannel8));
      _map.put("activationStateOfChannel9", new PlcBOOL(activationStateOfChannel9));
      _map.put("activationStateOfChannel10", new PlcBOOL(activationStateOfChannel10));
      _map.put("activationStateOfChannel11", new PlcBOOL(activationStateOfChannel11));
      _map.put("activationStateOfChannel12", new PlcBOOL(activationStateOfChannel12));
      _map.put("activationStateOfChannel13", new PlcBOOL(activationStateOfChannel13));
      _map.put("activationStateOfChannel14", new PlcBOOL(activationStateOfChannel14));
      _map.put("activationStateOfChannel15", new PlcBOOL(activationStateOfChannel15));
      _map.put("activationStateOfChannel16", new PlcBOOL(activationStateOfChannel16));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OnOffAction)) { // USINT
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      byte value = readSimpleField("value", readUnsignedByte(readBuffer, 2));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Alarm_Reaction)) { // USINT
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      byte value = readSimpleField("value", readUnsignedByte(readBuffer, 2));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_UpDown_Action)) { // USINT
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      byte value = readSimpleField("value", readUnsignedByte(readBuffer, 2));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVAC_PB_Action)) { // USINT
      Byte reservedField0 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      byte value = readSimpleField("value", readUnsignedByte(readBuffer, 2));
      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DoubleNibble)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      byte busy = readSimpleField("busy", readUnsignedByte(readBuffer, 4));

      byte nak = readSimpleField("nak", readUnsignedByte(readBuffer, 4));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("busy", new PlcUSINT(busy));
      _map.put("nak", new PlcUSINT(nak));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SceneInfo)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 1), (byte) 0x00);

      boolean sceneIsInactive = readSimpleField("sceneIsInactive", readBoolean(readBuffer));

      byte scenenumber = readSimpleField("scenenumber", readUnsignedByte(readBuffer, 6));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("sceneIsInactive", new PlcBOOL(sceneIsInactive));
      _map.put("scenenumber", new PlcUSINT(scenenumber));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedInfoOnOff)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      boolean maskBitInfoOnOffOutput16 =
          readSimpleField("maskBitInfoOnOffOutput16", readBoolean(readBuffer));

      boolean maskBitInfoOnOffOutput15 =
          readSimpleField("maskBitInfoOnOffOutput15", readBoolean(readBuffer));

      boolean maskBitInfoOnOffOutput14 =
          readSimpleField("maskBitInfoOnOffOutput14", readBoolean(readBuffer));

      boolean maskBitInfoOnOffOutput13 =
          readSimpleField("maskBitInfoOnOffOutput13", readBoolean(readBuffer));

      boolean maskBitInfoOnOffOutput12 =
          readSimpleField("maskBitInfoOnOffOutput12", readBoolean(readBuffer));

      boolean maskBitInfoOnOffOutput11 =
          readSimpleField("maskBitInfoOnOffOutput11", readBoolean(readBuffer));

      boolean maskBitInfoOnOffOutput10 =
          readSimpleField("maskBitInfoOnOffOutput10", readBoolean(readBuffer));

      boolean maskBitInfoOnOffOutput9 =
          readSimpleField("maskBitInfoOnOffOutput9", readBoolean(readBuffer));

      boolean maskBitInfoOnOffOutput8 =
          readSimpleField("maskBitInfoOnOffOutput8", readBoolean(readBuffer));

      boolean maskBitInfoOnOffOutput7 =
          readSimpleField("maskBitInfoOnOffOutput7", readBoolean(readBuffer));

      boolean maskBitInfoOnOffOutput6 =
          readSimpleField("maskBitInfoOnOffOutput6", readBoolean(readBuffer));

      boolean maskBitInfoOnOffOutput5 =
          readSimpleField("maskBitInfoOnOffOutput5", readBoolean(readBuffer));

      boolean maskBitInfoOnOffOutput4 =
          readSimpleField("maskBitInfoOnOffOutput4", readBoolean(readBuffer));

      boolean maskBitInfoOnOffOutput3 =
          readSimpleField("maskBitInfoOnOffOutput3", readBoolean(readBuffer));

      boolean maskBitInfoOnOffOutput2 =
          readSimpleField("maskBitInfoOnOffOutput2", readBoolean(readBuffer));

      boolean maskBitInfoOnOffOutput1 =
          readSimpleField("maskBitInfoOnOffOutput1", readBoolean(readBuffer));

      boolean infoOnOffOutput16 = readSimpleField("infoOnOffOutput16", readBoolean(readBuffer));

      boolean infoOnOffOutput15 = readSimpleField("infoOnOffOutput15", readBoolean(readBuffer));

      boolean infoOnOffOutput14 = readSimpleField("infoOnOffOutput14", readBoolean(readBuffer));

      boolean infoOnOffOutput13 = readSimpleField("infoOnOffOutput13", readBoolean(readBuffer));

      boolean infoOnOffOutput12 = readSimpleField("infoOnOffOutput12", readBoolean(readBuffer));

      boolean infoOnOffOutput11 = readSimpleField("infoOnOffOutput11", readBoolean(readBuffer));

      boolean infoOnOffOutput10 = readSimpleField("infoOnOffOutput10", readBoolean(readBuffer));

      boolean infoOnOffOutput9 = readSimpleField("infoOnOffOutput9", readBoolean(readBuffer));

      boolean infoOnOffOutput8 = readSimpleField("infoOnOffOutput8", readBoolean(readBuffer));

      boolean infoOnOffOutput7 = readSimpleField("infoOnOffOutput7", readBoolean(readBuffer));

      boolean infoOnOffOutput6 = readSimpleField("infoOnOffOutput6", readBoolean(readBuffer));

      boolean infoOnOffOutput5 = readSimpleField("infoOnOffOutput5", readBoolean(readBuffer));

      boolean infoOnOffOutput4 = readSimpleField("infoOnOffOutput4", readBoolean(readBuffer));

      boolean infoOnOffOutput3 = readSimpleField("infoOnOffOutput3", readBoolean(readBuffer));

      boolean infoOnOffOutput2 = readSimpleField("infoOnOffOutput2", readBoolean(readBuffer));

      boolean infoOnOffOutput1 = readSimpleField("infoOnOffOutput1", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("maskBitInfoOnOffOutput16", new PlcBOOL(maskBitInfoOnOffOutput16));
      _map.put("maskBitInfoOnOffOutput15", new PlcBOOL(maskBitInfoOnOffOutput15));
      _map.put("maskBitInfoOnOffOutput14", new PlcBOOL(maskBitInfoOnOffOutput14));
      _map.put("maskBitInfoOnOffOutput13", new PlcBOOL(maskBitInfoOnOffOutput13));
      _map.put("maskBitInfoOnOffOutput12", new PlcBOOL(maskBitInfoOnOffOutput12));
      _map.put("maskBitInfoOnOffOutput11", new PlcBOOL(maskBitInfoOnOffOutput11));
      _map.put("maskBitInfoOnOffOutput10", new PlcBOOL(maskBitInfoOnOffOutput10));
      _map.put("maskBitInfoOnOffOutput9", new PlcBOOL(maskBitInfoOnOffOutput9));
      _map.put("maskBitInfoOnOffOutput8", new PlcBOOL(maskBitInfoOnOffOutput8));
      _map.put("maskBitInfoOnOffOutput7", new PlcBOOL(maskBitInfoOnOffOutput7));
      _map.put("maskBitInfoOnOffOutput6", new PlcBOOL(maskBitInfoOnOffOutput6));
      _map.put("maskBitInfoOnOffOutput5", new PlcBOOL(maskBitInfoOnOffOutput5));
      _map.put("maskBitInfoOnOffOutput4", new PlcBOOL(maskBitInfoOnOffOutput4));
      _map.put("maskBitInfoOnOffOutput3", new PlcBOOL(maskBitInfoOnOffOutput3));
      _map.put("maskBitInfoOnOffOutput2", new PlcBOOL(maskBitInfoOnOffOutput2));
      _map.put("maskBitInfoOnOffOutput1", new PlcBOOL(maskBitInfoOnOffOutput1));
      _map.put("infoOnOffOutput16", new PlcBOOL(infoOnOffOutput16));
      _map.put("infoOnOffOutput15", new PlcBOOL(infoOnOffOutput15));
      _map.put("infoOnOffOutput14", new PlcBOOL(infoOnOffOutput14));
      _map.put("infoOnOffOutput13", new PlcBOOL(infoOnOffOutput13));
      _map.put("infoOnOffOutput12", new PlcBOOL(infoOnOffOutput12));
      _map.put("infoOnOffOutput11", new PlcBOOL(infoOnOffOutput11));
      _map.put("infoOnOffOutput10", new PlcBOOL(infoOnOffOutput10));
      _map.put("infoOnOffOutput9", new PlcBOOL(infoOnOffOutput9));
      _map.put("infoOnOffOutput8", new PlcBOOL(infoOnOffOutput8));
      _map.put("infoOnOffOutput7", new PlcBOOL(infoOnOffOutput7));
      _map.put("infoOnOffOutput6", new PlcBOOL(infoOnOffOutput6));
      _map.put("infoOnOffOutput5", new PlcBOOL(infoOnOffOutput5));
      _map.put("infoOnOffOutput4", new PlcBOOL(infoOnOffOutput4));
      _map.put("infoOnOffOutput3", new PlcBOOL(infoOnOffOutput3));
      _map.put("infoOnOffOutput2", new PlcBOOL(infoOnOffOutput2));
      _map.put("infoOnOffOutput1", new PlcBOOL(infoOnOffOutput1));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_V64)) { // LINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      long value = readSimpleField("value", readSignedLong(readBuffer, 64));
      return new PlcLINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy_V64)) { // LINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      long value = readSimpleField("value", readSignedLong(readBuffer, 64));
      return new PlcLINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy_V64)) { // LINT
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      long value = readSimpleField("value", readSignedLong(readBuffer, 64));
      return new PlcLINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Channel_Activation_24)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      boolean activationStateOfChannel1 =
          readSimpleField("activationStateOfChannel1", readBoolean(readBuffer));

      boolean activationStateOfChannel2 =
          readSimpleField("activationStateOfChannel2", readBoolean(readBuffer));

      boolean activationStateOfChannel3 =
          readSimpleField("activationStateOfChannel3", readBoolean(readBuffer));

      boolean activationStateOfChannel4 =
          readSimpleField("activationStateOfChannel4", readBoolean(readBuffer));

      boolean activationStateOfChannel5 =
          readSimpleField("activationStateOfChannel5", readBoolean(readBuffer));

      boolean activationStateOfChannel6 =
          readSimpleField("activationStateOfChannel6", readBoolean(readBuffer));

      boolean activationStateOfChannel7 =
          readSimpleField("activationStateOfChannel7", readBoolean(readBuffer));

      boolean activationStateOfChannel8 =
          readSimpleField("activationStateOfChannel8", readBoolean(readBuffer));

      boolean activationStateOfChannel9 =
          readSimpleField("activationStateOfChannel9", readBoolean(readBuffer));

      boolean activationStateOfChannel10 =
          readSimpleField("activationStateOfChannel10", readBoolean(readBuffer));

      boolean activationStateOfChannel11 =
          readSimpleField("activationStateOfChannel11", readBoolean(readBuffer));

      boolean activationStateOfChannel12 =
          readSimpleField("activationStateOfChannel12", readBoolean(readBuffer));

      boolean activationStateOfChannel13 =
          readSimpleField("activationStateOfChannel13", readBoolean(readBuffer));

      boolean activationStateOfChannel14 =
          readSimpleField("activationStateOfChannel14", readBoolean(readBuffer));

      boolean activationStateOfChannel15 =
          readSimpleField("activationStateOfChannel15", readBoolean(readBuffer));

      boolean activationStateOfChannel16 =
          readSimpleField("activationStateOfChannel16", readBoolean(readBuffer));

      boolean activationStateOfChannel17 =
          readSimpleField("activationStateOfChannel17", readBoolean(readBuffer));

      boolean activationStateOfChannel18 =
          readSimpleField("activationStateOfChannel18", readBoolean(readBuffer));

      boolean activationStateOfChannel19 =
          readSimpleField("activationStateOfChannel19", readBoolean(readBuffer));

      boolean activationStateOfChannel20 =
          readSimpleField("activationStateOfChannel20", readBoolean(readBuffer));

      boolean activationStateOfChannel21 =
          readSimpleField("activationStateOfChannel21", readBoolean(readBuffer));

      boolean activationStateOfChannel22 =
          readSimpleField("activationStateOfChannel22", readBoolean(readBuffer));

      boolean activationStateOfChannel23 =
          readSimpleField("activationStateOfChannel23", readBoolean(readBuffer));

      boolean activationStateOfChannel24 =
          readSimpleField("activationStateOfChannel24", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("activationStateOfChannel1", new PlcBOOL(activationStateOfChannel1));
      _map.put("activationStateOfChannel2", new PlcBOOL(activationStateOfChannel2));
      _map.put("activationStateOfChannel3", new PlcBOOL(activationStateOfChannel3));
      _map.put("activationStateOfChannel4", new PlcBOOL(activationStateOfChannel4));
      _map.put("activationStateOfChannel5", new PlcBOOL(activationStateOfChannel5));
      _map.put("activationStateOfChannel6", new PlcBOOL(activationStateOfChannel6));
      _map.put("activationStateOfChannel7", new PlcBOOL(activationStateOfChannel7));
      _map.put("activationStateOfChannel8", new PlcBOOL(activationStateOfChannel8));
      _map.put("activationStateOfChannel9", new PlcBOOL(activationStateOfChannel9));
      _map.put("activationStateOfChannel10", new PlcBOOL(activationStateOfChannel10));
      _map.put("activationStateOfChannel11", new PlcBOOL(activationStateOfChannel11));
      _map.put("activationStateOfChannel12", new PlcBOOL(activationStateOfChannel12));
      _map.put("activationStateOfChannel13", new PlcBOOL(activationStateOfChannel13));
      _map.put("activationStateOfChannel14", new PlcBOOL(activationStateOfChannel14));
      _map.put("activationStateOfChannel15", new PlcBOOL(activationStateOfChannel15));
      _map.put("activationStateOfChannel16", new PlcBOOL(activationStateOfChannel16));
      _map.put("activationStateOfChannel17", new PlcBOOL(activationStateOfChannel17));
      _map.put("activationStateOfChannel18", new PlcBOOL(activationStateOfChannel18));
      _map.put("activationStateOfChannel19", new PlcBOOL(activationStateOfChannel19));
      _map.put("activationStateOfChannel20", new PlcBOOL(activationStateOfChannel20));
      _map.put("activationStateOfChannel21", new PlcBOOL(activationStateOfChannel21));
      _map.put("activationStateOfChannel22", new PlcBOOL(activationStateOfChannel22));
      _map.put("activationStateOfChannel23", new PlcBOOL(activationStateOfChannel23));
      _map.put("activationStateOfChannel24", new PlcBOOL(activationStateOfChannel24));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVACModeNext)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int delayTimeMin = readSimpleField("delayTimeMin", readUnsignedInt(readBuffer, 16));

      short hvacMode = readSimpleField("hvacMode", readUnsignedShort(readBuffer, 8));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("delayTimeMin", new PlcUINT(delayTimeMin));
      _map.put("hvacMode", new PlcUSINT(hvacMode));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DHWModeNext)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int delayTimeMin = readSimpleField("delayTimeMin", readUnsignedInt(readBuffer, 16));

      short dhwMode = readSimpleField("dhwMode", readUnsignedShort(readBuffer, 8));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("delayTimeMin", new PlcUINT(delayTimeMin));
      _map.put("dhwMode", new PlcUSINT(dhwMode));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OccModeNext)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int delayTimeMin = readSimpleField("delayTimeMin", readUnsignedInt(readBuffer, 16));

      short occupancyMode = readSimpleField("occupancyMode", readUnsignedShort(readBuffer, 8));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("delayTimeMin", new PlcUINT(delayTimeMin));
      _map.put("occupancyMode", new PlcUSINT(occupancyMode));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_BuildingModeNext)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int delayTimeMin = readSimpleField("delayTimeMin", readUnsignedInt(readBuffer, 16));

      short buildingMode = readSimpleField("buildingMode", readUnsignedShort(readBuffer, 8));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("delayTimeMin", new PlcUINT(delayTimeMin));
      _map.put("buildingMode", new PlcUSINT(buildingMode));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_StatusLightingActuator)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      boolean validactualvalue = readSimpleField("validactualvalue", readBoolean(readBuffer));

      boolean locked = readSimpleField("locked", readBoolean(readBuffer));

      boolean forced = readSimpleField("forced", readBoolean(readBuffer));

      boolean nightmodeactive = readSimpleField("nightmodeactive", readBoolean(readBuffer));

      boolean staircaselightingFunction =
          readSimpleField("staircaselightingFunction", readBoolean(readBuffer));

      boolean dimming = readSimpleField("dimming", readBoolean(readBuffer));

      boolean localoverride = readSimpleField("localoverride", readBoolean(readBuffer));

      boolean failure = readSimpleField("failure", readBoolean(readBuffer));

      short actualvalue = readSimpleField("actualvalue", readUnsignedShort(readBuffer, 8));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("validactualvalue", new PlcBOOL(validactualvalue));
      _map.put("locked", new PlcBOOL(locked));
      _map.put("forced", new PlcBOOL(forced));
      _map.put("nightmodeactive", new PlcBOOL(nightmodeactive));
      _map.put("staircaselightingFunction", new PlcBOOL(staircaselightingFunction));
      _map.put("dimming", new PlcBOOL(dimming));
      _map.put("localoverride", new PlcBOOL(localoverride));
      _map.put("failure", new PlcBOOL(failure));
      _map.put("actualvalue", new PlcUSINT(actualvalue));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Version)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      byte magicNumber = readSimpleField("magicNumber", readUnsignedByte(readBuffer, 5));

      byte versionNumber = readSimpleField("versionNumber", readUnsignedByte(readBuffer, 5));

      byte revisionNumber = readSimpleField("revisionNumber", readUnsignedByte(readBuffer, 6));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("magicNumber", new PlcUSINT(magicNumber));
      _map.put("versionNumber", new PlcUSINT(versionNumber));
      _map.put("revisionNumber", new PlcUSINT(revisionNumber));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_AlarmInfo)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short logNumber = readSimpleField("logNumber", readUnsignedShort(readBuffer, 8));

      short alarmPriority = readSimpleField("alarmPriority", readUnsignedShort(readBuffer, 8));

      short applicationArea = readSimpleField("applicationArea", readUnsignedShort(readBuffer, 8));

      short errorClass = readSimpleField("errorClass", readUnsignedShort(readBuffer, 8));

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      boolean errorcodeSup = readSimpleField("errorcodeSup", readBoolean(readBuffer));

      boolean alarmtextSup = readSimpleField("alarmtextSup", readBoolean(readBuffer));

      boolean timestampSup = readSimpleField("timestampSup", readBoolean(readBuffer));

      boolean ackSup = readSimpleField("ackSup", readBoolean(readBuffer));

      Byte reservedField2 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 5), (byte) 0x00);

      boolean locked = readSimpleField("locked", readBoolean(readBuffer));

      boolean alarmunack = readSimpleField("alarmunack", readBoolean(readBuffer));

      boolean inalarm = readSimpleField("inalarm", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("logNumber", new PlcUSINT(logNumber));
      _map.put("alarmPriority", new PlcUSINT(alarmPriority));
      _map.put("applicationArea", new PlcUSINT(applicationArea));
      _map.put("errorClass", new PlcUSINT(errorClass));
      _map.put("errorcodeSup", new PlcBOOL(errorcodeSup));
      _map.put("alarmtextSup", new PlcBOOL(alarmtextSup));
      _map.put("timestampSup", new PlcBOOL(timestampSup));
      _map.put("ackSup", new PlcBOOL(ackSup));
      _map.put("locked", new PlcBOOL(locked));
      _map.put("alarmunack", new PlcBOOL(alarmunack));
      _map.put("inalarm", new PlcBOOL(inalarm));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetF16_3)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float tempsetpcomf =
          readSimpleField(
              "tempsetpcomf", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));

      float tempsetpstdby =
          readSimpleField(
              "tempsetpstdby", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));

      float tempsetpeco =
          readSimpleField(
              "tempsetpeco", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("tempsetpcomf", new PlcREAL(tempsetpcomf));
      _map.put("tempsetpstdby", new PlcREAL(tempsetpstdby));
      _map.put("tempsetpeco", new PlcREAL(tempsetpeco));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetShiftF16_3)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float tempsetpshiftcomf =
          readSimpleField(
              "tempsetpshiftcomf", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));

      float tempsetpshiftstdby =
          readSimpleField(
              "tempsetpshiftstdby", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));

      float tempsetpshifteco =
          readSimpleField(
              "tempsetpshifteco", readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat"));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("tempsetpshiftcomf", new PlcREAL(tempsetpshiftcomf));
      _map.put("tempsetpshiftstdby", new PlcREAL(tempsetpshiftstdby));
      _map.put("tempsetpshifteco", new PlcREAL(tempsetpshifteco));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Scaling_Speed)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int timePeriod = readSimpleField("timePeriod", readUnsignedInt(readBuffer, 16));

      short percent = readSimpleField("percent", readUnsignedShort(readBuffer, 8));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("timePeriod", new PlcUINT(timePeriod));
      _map.put("percent", new PlcUSINT(percent));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Scaling_Step_Time)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int timePeriod = readSimpleField("timePeriod", readUnsignedInt(readBuffer, 16));

      short percent = readSimpleField("percent", readUnsignedShort(readBuffer, 8));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("timePeriod", new PlcUINT(timePeriod));
      _map.put("percent", new PlcUSINT(percent));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_MeteringValue)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int countval = readSimpleField("countval", readSignedInt(readBuffer, 32));

      short valinffield = readSimpleField("valinffield", readUnsignedShort(readBuffer, 8));

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 3), (byte) 0x00);

      boolean alarmunack = readSimpleField("alarmunack", readBoolean(readBuffer));

      boolean inalarm = readSimpleField("inalarm", readBoolean(readBuffer));

      boolean overridden = readSimpleField("overridden", readBoolean(readBuffer));

      boolean fault = readSimpleField("fault", readBoolean(readBuffer));

      boolean outofservice = readSimpleField("outofservice", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("countval", new PlcDINT(countval));
      _map.put("valinffield", new PlcUSINT(valinffield));
      _map.put("alarmunack", new PlcBOOL(alarmunack));
      _map.put("inalarm", new PlcBOOL(inalarm));
      _map.put("overridden", new PlcBOOL(overridden));
      _map.put("fault", new PlcBOOL(fault));
      _map.put("outofservice", new PlcBOOL(outofservice));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_MBus_Address)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int manufactid = readSimpleField("manufactid", readUnsignedInt(readBuffer, 16));

      long identnumber = readSimpleField("identnumber", readUnsignedLong(readBuffer, 32));

      short version = readSimpleField("version", readUnsignedShort(readBuffer, 8));

      short medium = readSimpleField("medium", readUnsignedShort(readBuffer, 8));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("manufactid", new PlcUINT(manufactid));
      _map.put("identnumber", new PlcUDINT(identnumber));
      _map.put("version", new PlcUSINT(version));
      _map.put("medium", new PlcUSINT(medium));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Colour_RGB)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short r = readSimpleField("r", readUnsignedShort(readBuffer, 8));

      short g = readSimpleField("g", readUnsignedShort(readBuffer, 8));

      short b = readSimpleField("b", readUnsignedShort(readBuffer, 8));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("r", new PlcUSINT(r));
      _map.put("g", new PlcUSINT(g));
      _map.put("b", new PlcUSINT(b));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LanguageCodeAlpha2_ASCII)) { // STRING
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      String value =
          readSimpleField("value", readString(readBuffer, 16), WithOption.WithEncoding("ASCII"));
      return new PlcSTRING(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Tariff_ActiveEnergy)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int activeelectricalenergy =
          readSimpleField("activeelectricalenergy", readSignedInt(readBuffer, 32));

      short tariff = readSimpleField("tariff", readUnsignedShort(readBuffer, 8));

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      boolean electricalengergyvalidity =
          readSimpleField("electricalengergyvalidity", readBoolean(readBuffer));

      boolean tariffvalidity = readSimpleField("tariffvalidity", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("activeelectricalenergy", new PlcDINT(activeelectricalenergy));
      _map.put("tariff", new PlcUSINT(tariff));
      _map.put("electricalengergyvalidity", new PlcBOOL(electricalengergyvalidity));
      _map.put("tariffvalidity", new PlcBOOL(tariffvalidity));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Prioritised_Mode_Control)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      boolean deactivationOfPriority =
          readSimpleField("deactivationOfPriority", readBoolean(readBuffer));

      byte priorityLevel = readSimpleField("priorityLevel", readUnsignedByte(readBuffer, 3));

      byte modeLevel = readSimpleField("modeLevel", readUnsignedByte(readBuffer, 4));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("deactivationOfPriority", new PlcBOOL(deactivationOfPriority));
      _map.put("priorityLevel", new PlcUSINT(priorityLevel));
      _map.put("modeLevel", new PlcUSINT(modeLevel));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DALI_Control_Gear_Diagnostic)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 5), (byte) 0x00);

      boolean convertorError = readSimpleField("convertorError", readBoolean(readBuffer));

      boolean ballastFailure = readSimpleField("ballastFailure", readBoolean(readBuffer));

      boolean lampFailure = readSimpleField("lampFailure", readBoolean(readBuffer));

      boolean readOrResponse = readSimpleField("readOrResponse", readBoolean(readBuffer));

      boolean addressIndicator = readSimpleField("addressIndicator", readBoolean(readBuffer));

      byte daliDeviceAddressOrDaliGroupAddress =
          readSimpleField("daliDeviceAddressOrDaliGroupAddress", readUnsignedByte(readBuffer, 6));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("convertorError", new PlcBOOL(convertorError));
      _map.put("ballastFailure", new PlcBOOL(ballastFailure));
      _map.put("lampFailure", new PlcBOOL(lampFailure));
      _map.put("readOrResponse", new PlcBOOL(readOrResponse));
      _map.put("addressIndicator", new PlcBOOL(addressIndicator));
      _map.put(
          "daliDeviceAddressOrDaliGroupAddress", new PlcUSINT(daliDeviceAddressOrDaliGroupAddress));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DALI_Diagnostics)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      boolean ballastFailure = readSimpleField("ballastFailure", readBoolean(readBuffer));

      boolean lampFailure = readSimpleField("lampFailure", readBoolean(readBuffer));

      byte deviceAddress = readSimpleField("deviceAddress", readUnsignedByte(readBuffer, 6));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("ballastFailure", new PlcBOOL(ballastFailure));
      _map.put("lampFailure", new PlcBOOL(lampFailure));
      _map.put("deviceAddress", new PlcUSINT(deviceAddress));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedPosition)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short heightPosition = readSimpleField("heightPosition", readUnsignedShort(readBuffer, 8));

      short slatsPosition = readSimpleField("slatsPosition", readUnsignedShort(readBuffer, 8));

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      boolean validitySlatsPosition =
          readSimpleField("validitySlatsPosition", readBoolean(readBuffer));

      boolean validityHeightPosition =
          readSimpleField("validityHeightPosition", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("heightPosition", new PlcUSINT(heightPosition));
      _map.put("slatsPosition", new PlcUSINT(slatsPosition));
      _map.put("validitySlatsPosition", new PlcBOOL(validitySlatsPosition));
      _map.put("validityHeightPosition", new PlcBOOL(validityHeightPosition));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusSAB)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short heightPosition = readSimpleField("heightPosition", readUnsignedShort(readBuffer, 8));

      short slatsPosition = readSimpleField("slatsPosition", readUnsignedShort(readBuffer, 8));

      boolean upperEndPosReached = readSimpleField("upperEndPosReached", readBoolean(readBuffer));

      boolean lowerEndPosReached = readSimpleField("lowerEndPosReached", readBoolean(readBuffer));

      boolean lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent =
          readSimpleField(
              "lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent",
              readBoolean(readBuffer));

      boolean targetPosDrive = readSimpleField("targetPosDrive", readBoolean(readBuffer));

      boolean restrictionOfTargetHeightPosPosCanNotBeReached =
          readSimpleField(
              "restrictionOfTargetHeightPosPosCanNotBeReached", readBoolean(readBuffer));

      boolean restrictionOfSlatsHeightPosPosCanNotBeReached =
          readSimpleField("restrictionOfSlatsHeightPosPosCanNotBeReached", readBoolean(readBuffer));

      boolean atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm =
          readSimpleField(
              "atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm", readBoolean(readBuffer));

      boolean upDownPositionIsForcedByMoveupdownforcedInput =
          readSimpleField("upDownPositionIsForcedByMoveupdownforcedInput", readBoolean(readBuffer));

      boolean movementIsLockedEGByDevicelockedInput =
          readSimpleField("movementIsLockedEGByDevicelockedInput", readBoolean(readBuffer));

      boolean actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface =
          readSimpleField(
              "actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface",
              readBoolean(readBuffer));

      boolean generalFailureOfTheActuatorOrTheDrive =
          readSimpleField("generalFailureOfTheActuatorOrTheDrive", readBoolean(readBuffer));

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 3), (byte) 0x00);

      boolean validityHeightPos = readSimpleField("validityHeightPos", readBoolean(readBuffer));

      boolean validitySlatsPos = readSimpleField("validitySlatsPos", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("heightPosition", new PlcUSINT(heightPosition));
      _map.put("slatsPosition", new PlcUSINT(slatsPosition));
      _map.put("upperEndPosReached", new PlcBOOL(upperEndPosReached));
      _map.put("lowerEndPosReached", new PlcBOOL(lowerEndPosReached));
      _map.put(
          "lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent",
          new PlcBOOL(lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent));
      _map.put("targetPosDrive", new PlcBOOL(targetPosDrive));
      _map.put(
          "restrictionOfTargetHeightPosPosCanNotBeReached",
          new PlcBOOL(restrictionOfTargetHeightPosPosCanNotBeReached));
      _map.put(
          "restrictionOfSlatsHeightPosPosCanNotBeReached",
          new PlcBOOL(restrictionOfSlatsHeightPosPosCanNotBeReached));
      _map.put(
          "atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm",
          new PlcBOOL(atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm));
      _map.put(
          "upDownPositionIsForcedByMoveupdownforcedInput",
          new PlcBOOL(upDownPositionIsForcedByMoveupdownforcedInput));
      _map.put(
          "movementIsLockedEGByDevicelockedInput",
          new PlcBOOL(movementIsLockedEGByDevicelockedInput));
      _map.put(
          "actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface",
          new PlcBOOL(actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface));
      _map.put(
          "generalFailureOfTheActuatorOrTheDrive",
          new PlcBOOL(generalFailureOfTheActuatorOrTheDrive));
      _map.put("validityHeightPos", new PlcBOOL(validityHeightPos));
      _map.put("validitySlatsPos", new PlcBOOL(validitySlatsPos));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Colour_xyY)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int xAxis = readSimpleField("xAxis", readUnsignedInt(readBuffer, 16));

      int yAxis = readSimpleField("yAxis", readUnsignedInt(readBuffer, 16));

      short brightness = readSimpleField("brightness", readUnsignedShort(readBuffer, 8));

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      boolean validityXy = readSimpleField("validityXy", readBoolean(readBuffer));

      boolean validityBrightness = readSimpleField("validityBrightness", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("xAxis", new PlcUINT(xAxis));
      _map.put("yAxis", new PlcUINT(yAxis));
      _map.put("brightness", new PlcUSINT(brightness));
      _map.put("validityXy", new PlcBOOL(validityXy));
      _map.put("validityBrightness", new PlcBOOL(validityBrightness));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Converter_Status)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      byte converterModeAccordingToTheDaliConverterStateMachine =
          readSimpleField(
              "converterModeAccordingToTheDaliConverterStateMachine",
              readUnsignedByte(readBuffer, 4));

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 2), (byte) 0x00);

      boolean hardwiredSwitchIsActive =
          readSimpleField("hardwiredSwitchIsActive", readBoolean(readBuffer));

      boolean hardwiredInhibitIsActive =
          readSimpleField("hardwiredInhibitIsActive", readBoolean(readBuffer));

      byte functionTestPending =
          readSimpleField("functionTestPending", readUnsignedByte(readBuffer, 2));

      byte durationTestPending =
          readSimpleField("durationTestPending", readUnsignedByte(readBuffer, 2));

      byte partialDurationTestPending =
          readSimpleField("partialDurationTestPending", readUnsignedByte(readBuffer, 2));

      byte converterFailure = readSimpleField("converterFailure", readUnsignedByte(readBuffer, 2));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put(
          "converterModeAccordingToTheDaliConverterStateMachine",
          new PlcUSINT(converterModeAccordingToTheDaliConverterStateMachine));
      _map.put("hardwiredSwitchIsActive", new PlcBOOL(hardwiredSwitchIsActive));
      _map.put("hardwiredInhibitIsActive", new PlcBOOL(hardwiredInhibitIsActive));
      _map.put("functionTestPending", new PlcUSINT(functionTestPending));
      _map.put("durationTestPending", new PlcUSINT(durationTestPending));
      _map.put("partialDurationTestPending", new PlcUSINT(partialDurationTestPending));
      _map.put("converterFailure", new PlcUSINT(converterFailure));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Converter_Test_Result)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      byte ltrf = readSimpleField("ltrf", readUnsignedByte(readBuffer, 4));

      byte ltrd = readSimpleField("ltrd", readUnsignedByte(readBuffer, 4));

      byte ltrp = readSimpleField("ltrp", readUnsignedByte(readBuffer, 4));

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      byte sf = readSimpleField("sf", readUnsignedByte(readBuffer, 2));

      byte sd = readSimpleField("sd", readUnsignedByte(readBuffer, 2));

      byte sp = readSimpleField("sp", readUnsignedByte(readBuffer, 2));

      Byte reservedField2 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 2), (byte) 0x00);

      int ldtr = readSimpleField("ldtr", readUnsignedInt(readBuffer, 16));

      short lpdtr = readSimpleField("lpdtr", readUnsignedShort(readBuffer, 8));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("ltrf", new PlcUSINT(ltrf));
      _map.put("ltrd", new PlcUSINT(ltrd));
      _map.put("ltrp", new PlcUSINT(ltrp));
      _map.put("sf", new PlcUSINT(sf));
      _map.put("sd", new PlcUSINT(sd));
      _map.put("sp", new PlcUSINT(sp));
      _map.put("ldtr", new PlcUINT(ldtr));
      _map.put("lpdtr", new PlcUSINT(lpdtr));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Battery_Info)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 5), (byte) 0x00);

      boolean batteryFailure = readSimpleField("batteryFailure", readBoolean(readBuffer));

      boolean batteryDurationFailure =
          readSimpleField("batteryDurationFailure", readBoolean(readBuffer));

      boolean batteryFullyCharged = readSimpleField("batteryFullyCharged", readBoolean(readBuffer));

      short batteryChargeLevel =
          readSimpleField("batteryChargeLevel", readUnsignedShort(readBuffer, 8));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("batteryFailure", new PlcBOOL(batteryFailure));
      _map.put("batteryDurationFailure", new PlcBOOL(batteryDurationFailure));
      _map.put("batteryFullyCharged", new PlcBOOL(batteryFullyCharged));
      _map.put("batteryChargeLevel", new PlcUSINT(batteryChargeLevel));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Brightness_Colour_Temperature_Transition)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      int ms = readSimpleField("ms", readUnsignedInt(readBuffer, 16));

      int temperatureK = readSimpleField("temperatureK", readUnsignedInt(readBuffer, 16));

      short percent = readSimpleField("percent", readUnsignedShort(readBuffer, 8));

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 5), (byte) 0x00);

      boolean validityOfTheTimePeriod =
          readSimpleField("validityOfTheTimePeriod", readBoolean(readBuffer));

      boolean validityOfTheAbsoluteColourTemperature =
          readSimpleField("validityOfTheAbsoluteColourTemperature", readBoolean(readBuffer));

      boolean validityOfTheAbsoluteBrightness =
          readSimpleField("validityOfTheAbsoluteBrightness", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("ms", new PlcUINT(ms));
      _map.put("temperatureK", new PlcUINT(temperatureK));
      _map.put("percent", new PlcUSINT(percent));
      _map.put("validityOfTheTimePeriod", new PlcBOOL(validityOfTheTimePeriod));
      _map.put(
          "validityOfTheAbsoluteColourTemperature",
          new PlcBOOL(validityOfTheAbsoluteColourTemperature));
      _map.put("validityOfTheAbsoluteBrightness", new PlcBOOL(validityOfTheAbsoluteBrightness));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Brightness_Colour_Temperature_Control)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      boolean cct = readSimpleField("cct", readBoolean(readBuffer));

      byte stepCodeColourTemperature =
          readSimpleField("stepCodeColourTemperature", readUnsignedByte(readBuffer, 3));

      Byte reservedField2 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      boolean cb = readSimpleField("cb", readBoolean(readBuffer));

      byte stepCodeBrightness =
          readSimpleField("stepCodeBrightness", readUnsignedByte(readBuffer, 3));

      Byte reservedField3 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 6), (byte) 0x00);

      boolean cctAndStepCodeColourValidity =
          readSimpleField("cctAndStepCodeColourValidity", readBoolean(readBuffer));

      boolean cbAndStepCodeBrightnessValidity =
          readSimpleField("cbAndStepCodeBrightnessValidity", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("cct", new PlcBOOL(cct));
      _map.put("stepCodeColourTemperature", new PlcUSINT(stepCodeColourTemperature));
      _map.put("cb", new PlcBOOL(cb));
      _map.put("stepCodeBrightness", new PlcUSINT(stepCodeBrightness));
      _map.put("cctAndStepCodeColourValidity", new PlcBOOL(cctAndStepCodeColourValidity));
      _map.put("cbAndStepCodeBrightnessValidity", new PlcBOOL(cbAndStepCodeBrightnessValidity));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Colour_RGBW)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      short colourLevelRed = readSimpleField("colourLevelRed", readUnsignedShort(readBuffer, 8));

      short colourLevelGreen =
          readSimpleField("colourLevelGreen", readUnsignedShort(readBuffer, 8));

      short colourLevelBlue = readSimpleField("colourLevelBlue", readUnsignedShort(readBuffer, 8));

      short colourLevelWhite =
          readSimpleField("colourLevelWhite", readUnsignedShort(readBuffer, 8));

      Short reservedField1 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField2 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      boolean mr = readSimpleField("mr", readBoolean(readBuffer));

      boolean mg = readSimpleField("mg", readBoolean(readBuffer));

      boolean mb = readSimpleField("mb", readBoolean(readBuffer));

      boolean mw = readSimpleField("mw", readBoolean(readBuffer));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("colourLevelRed", new PlcUSINT(colourLevelRed));
      _map.put("colourLevelGreen", new PlcUSINT(colourLevelGreen));
      _map.put("colourLevelBlue", new PlcUSINT(colourLevelBlue));
      _map.put("colourLevelWhite", new PlcUSINT(colourLevelWhite));
      _map.put("mr", new PlcBOOL(mr));
      _map.put("mg", new PlcBOOL(mg));
      _map.put("mb", new PlcBOOL(mb));
      _map.put("mw", new PlcBOOL(mw));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Relative_Control_RGBW)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      boolean maskcw = readSimpleField("maskcw", readBoolean(readBuffer));

      boolean maskcb = readSimpleField("maskcb", readBoolean(readBuffer));

      boolean maskcg = readSimpleField("maskcg", readBoolean(readBuffer));

      boolean maskcr = readSimpleField("maskcr", readBoolean(readBuffer));

      Byte reservedField2 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      boolean cw = readSimpleField("cw", readBoolean(readBuffer));

      byte stepCodeColourWhite =
          readSimpleField("stepCodeColourWhite", readUnsignedByte(readBuffer, 3));

      Byte reservedField3 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      boolean cb = readSimpleField("cb", readBoolean(readBuffer));

      byte stepCodeColourBlue =
          readSimpleField("stepCodeColourBlue", readUnsignedByte(readBuffer, 3));

      Byte reservedField4 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      boolean cg = readSimpleField("cg", readBoolean(readBuffer));

      byte stepCodeColourGreen =
          readSimpleField("stepCodeColourGreen", readUnsignedByte(readBuffer, 3));

      Byte reservedField5 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      boolean cr = readSimpleField("cr", readBoolean(readBuffer));

      byte stepCodeColourRed =
          readSimpleField("stepCodeColourRed", readUnsignedByte(readBuffer, 3));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("maskcw", new PlcBOOL(maskcw));
      _map.put("maskcb", new PlcBOOL(maskcb));
      _map.put("maskcg", new PlcBOOL(maskcg));
      _map.put("maskcr", new PlcBOOL(maskcr));
      _map.put("cw", new PlcBOOL(cw));
      _map.put("stepCodeColourWhite", new PlcUSINT(stepCodeColourWhite));
      _map.put("cb", new PlcBOOL(cb));
      _map.put("stepCodeColourBlue", new PlcUSINT(stepCodeColourBlue));
      _map.put("cg", new PlcBOOL(cg));
      _map.put("stepCodeColourGreen", new PlcUSINT(stepCodeColourGreen));
      _map.put("cr", new PlcBOOL(cr));
      _map.put("stepCodeColourRed", new PlcUSINT(stepCodeColourRed));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Relative_Control_RGB)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      Byte reservedField1 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      boolean cb = readSimpleField("cb", readBoolean(readBuffer));

      byte stepCodeColourBlue =
          readSimpleField("stepCodeColourBlue", readUnsignedByte(readBuffer, 3));

      Byte reservedField2 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      boolean cg = readSimpleField("cg", readBoolean(readBuffer));

      byte stepCodeColourGreen =
          readSimpleField("stepCodeColourGreen", readUnsignedByte(readBuffer, 3));

      Byte reservedField3 =
          readReservedField("reserved", readUnsignedByte(readBuffer, 4), (byte) 0x00);

      boolean cr = readSimpleField("cr", readBoolean(readBuffer));

      byte stepCodeColourRed =
          readSimpleField("stepCodeColourRed", readUnsignedByte(readBuffer, 3));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("cb", new PlcBOOL(cb));
      _map.put("stepCodeColourBlue", new PlcUSINT(stepCodeColourBlue));
      _map.put("cg", new PlcBOOL(cg));
      _map.put("stepCodeColourGreen", new PlcUSINT(stepCodeColourGreen));
      _map.put("cr", new PlcBOOL(cr));
      _map.put("stepCodeColourRed", new PlcUSINT(stepCodeColourRed));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_GeographicalLocation)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float longitude = readSimpleField("longitude", readFloat(readBuffer, 32));

      float latitude = readSimpleField("latitude", readFloat(readBuffer, 32));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("longitude", new PlcREAL(longitude));
      _map.put("latitude", new PlcREAL(latitude));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetF16_4)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float roomTemperatureSetpointComfort =
          readSimpleField(
              "roomTemperatureSetpointComfort",
              readFloat(readBuffer, 16),
              WithOption.WithEncoding("KNXFloat"));

      float roomTemperatureSetpointStandby =
          readSimpleField(
              "roomTemperatureSetpointStandby",
              readFloat(readBuffer, 16),
              WithOption.WithEncoding("KNXFloat"));

      float roomTemperatureSetpointEconomy =
          readSimpleField(
              "roomTemperatureSetpointEconomy",
              readFloat(readBuffer, 16),
              WithOption.WithEncoding("KNXFloat"));

      float roomTemperatureSetpointBuildingProtection =
          readSimpleField(
              "roomTemperatureSetpointBuildingProtection",
              readFloat(readBuffer, 16),
              WithOption.WithEncoding("KNXFloat"));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("roomTemperatureSetpointComfort", new PlcREAL(roomTemperatureSetpointComfort));
      _map.put("roomTemperatureSetpointStandby", new PlcREAL(roomTemperatureSetpointStandby));
      _map.put("roomTemperatureSetpointEconomy", new PlcREAL(roomTemperatureSetpointEconomy));
      _map.put(
          "roomTemperatureSetpointBuildingProtection",
          new PlcREAL(roomTemperatureSetpointBuildingProtection));
      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetShiftF16_4)) { // Struct
      Short reservedField0 =
          readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

      float roomTemperatureSetpointShiftComfort =
          readSimpleField(
              "roomTemperatureSetpointShiftComfort",
              readFloat(readBuffer, 16),
              WithOption.WithEncoding("KNXFloat"));

      float roomTemperatureSetpointShiftStandby =
          readSimpleField(
              "roomTemperatureSetpointShiftStandby",
              readFloat(readBuffer, 16),
              WithOption.WithEncoding("KNXFloat"));

      float roomTemperatureSetpointShiftEconomy =
          readSimpleField(
              "roomTemperatureSetpointShiftEconomy",
              readFloat(readBuffer, 16),
              WithOption.WithEncoding("KNXFloat"));

      float roomTemperatureSetpointShiftBuildingProtection =
          readSimpleField(
              "roomTemperatureSetpointShiftBuildingProtection",
              readFloat(readBuffer, 16),
              WithOption.WithEncoding("KNXFloat"));

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put(
          "roomTemperatureSetpointShiftComfort", new PlcREAL(roomTemperatureSetpointShiftComfort));
      _map.put(
          "roomTemperatureSetpointShiftStandby", new PlcREAL(roomTemperatureSetpointShiftStandby));
      _map.put(
          "roomTemperatureSetpointShiftEconomy", new PlcREAL(roomTemperatureSetpointShiftEconomy));
      _map.put(
          "roomTemperatureSetpointShiftBuildingProtection",
          new PlcREAL(roomTemperatureSetpointShiftBuildingProtection));
      return new PlcStruct(_map);
    }
    return null;
  }

  public static int getLengthInBytes(PlcValue _value, KnxDatapointType datapointType) {
    return (int) Math.ceil((float) getLengthInBits(_value, datapointType) / 8.0);
  }

  public static int getLengthInBits(PlcValue _value, KnxDatapointType datapointType) {
    int lengthInBits = 0;
    if (EvaluationHelper.equals(datapointType, KnxDatapointType.BOOL)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.BYTE)) { // BYTE
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.WORD)) { // WORD
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DWORD)) { // DWORD
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LWORD)) { // LWORD
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 64;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.USINT)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.SINT)) { // SINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.UINT)) { // UINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.INT)) { // INT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.UDINT)) { // UDINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DINT)) { // DINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.ULINT)) { // ULINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 64;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LINT)) { // LINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 64;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.REAL)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LREAL)) { // LREAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 64;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.CHAR)) { // CHAR
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.WCHAR)) { // WCHAR
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.TIME)) { // TIME
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (milliseconds)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LTIME)) { // LTIME
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (nanoseconds)
      lengthInBits += 64;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DATE)) { // DATE
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (secondsSinceEpoch)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.TIME_OF_DAY)) { // TIME_OF_DAY
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (millisecondsSinceMidnight)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.TOD)) { // TIME_OF_DAY
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (millisecondsSinceMidnight)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DATE_AND_TIME)) { // DATE_AND_TIME
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (year)
      lengthInBits += 16;

      // Simple field (month)
      lengthInBits += 8;

      // Simple field (day)
      lengthInBits += 8;

      // Simple field (dayOfWeek)
      lengthInBits += 8;

      // Simple field (hour)
      lengthInBits += 8;

      // Simple field (minutes)
      lengthInBits += 8;

      // Simple field (seconds)
      lengthInBits += 8;

      // Simple field (nanoseconds)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DT)) { // DATE_AND_TIME
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (year)
      lengthInBits += 16;

      // Simple field (month)
      lengthInBits += 8;

      // Simple field (day)
      lengthInBits += 8;

      // Simple field (dayOfWeek)
      lengthInBits += 8;

      // Simple field (hour)
      lengthInBits += 8;

      // Simple field (minutes)
      lengthInBits += 8;

      // Simple field (seconds)
      lengthInBits += 8;

      // Simple field (nanoseconds)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Switch)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Bool)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Enable)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Ramp)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Alarm)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BinaryValue)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Step)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_UpDown)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OpenClose)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Start)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_State)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Invert)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DimSendStyle)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_InputSource)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Reset)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Ack)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Trigger)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Occupancy)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Window_Door)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LogicalFunction)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Scene_AB)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ShutterBlinds_Mode)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DayNight)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Heat_Cool)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Switch_Control)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (control)
      lengthInBits += 1;

      // Simple field (on)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Bool_Control)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (control)
      lengthInBits += 1;

      // Simple field (valueTrue)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Enable_Control)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (control)
      lengthInBits += 1;

      // Simple field (enable)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Ramp_Control)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (control)
      lengthInBits += 1;

      // Simple field (ramp)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Alarm_Control)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (control)
      lengthInBits += 1;

      // Simple field (alarm)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_BinaryValue_Control)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (control)
      lengthInBits += 1;

      // Simple field (high)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Step_Control)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (control)
      lengthInBits += 1;

      // Simple field (increase)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Direction1_Control)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (control)
      lengthInBits += 1;

      // Simple field (down)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Direction2_Control)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (control)
      lengthInBits += 1;

      // Simple field (close)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Start_Control)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (control)
      lengthInBits += 1;

      // Simple field (start)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_State_Control)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (control)
      lengthInBits += 1;

      // Simple field (active)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Invert_Control)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (control)
      lengthInBits += 1;

      // Simple field (inverted)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Control_Dimming)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (increase)
      lengthInBits += 1;

      // Simple field (stepcode)
      lengthInBits += 3;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Control_Blinds)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (down)
      lengthInBits += 1;

      // Simple field (stepcode)
      lengthInBits += 3;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Char_ASCII)) { // STRING
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Char_8859_1)) { // STRING
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Scaling)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Angle)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_U8)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DecimalFactor)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Tariff)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_1_Ucount)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FanStage)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_V8)) { // SINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_1_Count)) { // SINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Status_Mode3)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (statusA)
      lengthInBits += 1;

      // Simple field (statusB)
      lengthInBits += 1;

      // Simple field (statusC)
      lengthInBits += 1;

      // Simple field (statusD)
      lengthInBits += 1;

      // Simple field (statusE)
      lengthInBits += 1;

      // Simple field (mode)
      lengthInBits += 3;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_2_Ucount)) { // UINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriodMsec)) { // UINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriod10Msec)) { // UINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriod100Msec)) { // UINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodSec)) { // UINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodMin)) { // UINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodHrs)) { // UINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PropDataType)) { // UINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Length_mm)) { // UINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_UElCurrentmA)) { // UINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Brightness)) { // UINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Absolute_Colour_Temperature)) { // UINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_2_Count)) { // INT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeMsec)) { // INT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaTime10Msec)) { // INT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaTime100Msec)) { // INT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeSec)) { // INT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeMin)) { // INT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeHrs)) { // INT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_V16)) { // INT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Rotation_Angle)) { // INT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Length_m)) { // INT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Temp)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Tempd)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Tempa)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Lux)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Wsp)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Pres)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Humidity)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AirQuality)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_AirFlow)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time1)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time2)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Volt)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Curr)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PowerDensity)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_KelvinPerPercent)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Power)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Volume_Flow)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Rain_Amount)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Temp_F)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Wsp_kmh)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Absolute_Humidity)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Concentration_ygm3)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Coefficient)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimeOfDay)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (day)
      lengthInBits += 3;

      // Simple field (hour)
      lengthInBits += 5;

      // Reserved Field (reserved)
      lengthInBits += 2;

      // Simple field (minutes)
      lengthInBits += 6;

      // Reserved Field (reserved)
      lengthInBits += 2;

      // Simple field (seconds)
      lengthInBits += 6;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Date)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 3;

      // Simple field (dayOfMonth)
      lengthInBits += 5;

      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (month)
      lengthInBits += 4;

      // Reserved Field (reserved)
      lengthInBits += 1;

      // Simple field (year)
      lengthInBits += 7;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_4_Ucount)) { // UDINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Sec)) { // UDINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Min)) { // UDINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Hrs)) { // UDINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_VolumeLiquid_Litre)) { // UDINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Volume_m_3)) { // UDINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_4_Count)) { // DINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FlowRate_m3h)) { // DINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ActiveEnergy)) { // DINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy)) { // DINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy)) { // DINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_kWh)) { // DINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy_kVAh)) { // DINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy_kVARh)) { // DINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_MWh)) { // DINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongDeltaTimeSec)) { // DINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaVolumeLiquid_Litre)) { // DINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaVolume_m_3)) { // DINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Acceleration)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Acceleration_Angular)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Activation_Energy)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Activity)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Mol)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Amplitude)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AngleRad)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AngleDeg)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Momentum)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Velocity)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Area)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Capacitance)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Charge_DensitySurface)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Charge_DensityVolume)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Compressibility)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Conductance)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electrical_Conductivity)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Density)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Charge)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Current)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_CurrentDensity)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_DipoleMoment)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Displacement)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_FieldStrength)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Flux)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_FluxDensity)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Polarization)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Potential)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_PotentialDifference)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_ElectromagneticMoment)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electromotive_Force)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Energy)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Force)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Frequency)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Frequency)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_Capacity)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_FlowRate)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_Quantity)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Impedance)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Length)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Light_Quantity)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminance)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminous_Flux)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminous_Intensity)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_FieldStrength)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Flux)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_FluxDensity)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Moment)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Polarization)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetization)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_MagnetomotiveForce)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Mass)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_MassFlux)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Momentum)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Phase_AngleRad)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Phase_AngleDeg)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Power)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Power_Factor)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Pressure)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Reactance)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Resistance)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Resistivity)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_SelfInductance)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_SolidAngle)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Sound_Intensity)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Speed)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Stress)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Surface_Tension)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Common_Temperature)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Absolute_Temperature)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_TemperatureDifference)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Thermal_Capacity)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Thermal_Conductivity)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_ThermoelectricPower)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Torque)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Volume)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Volume_Flux)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Weight)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Work)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_ApparentPower)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Volume_Flux_Meter)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Volume_Flux_ls)) { // REAL
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Access_Data)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (hurz)
      lengthInBits += 4;

      // Simple field (value1)
      lengthInBits += 4;

      // Simple field (value2)
      lengthInBits += 4;

      // Simple field (value3)
      lengthInBits += 4;

      // Simple field (value4)
      lengthInBits += 4;

      // Simple field (value5)
      lengthInBits += 4;

      // Simple field (detectionError)
      lengthInBits += 1;

      // Simple field (permission)
      lengthInBits += 1;

      // Simple field (readDirection)
      lengthInBits += 1;

      // Simple field (encryptionOfAccessInformation)
      lengthInBits += 1;

      // Simple field (indexOfAccessIdentificationCode)
      lengthInBits += 4;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_String_ASCII)) { // STRING
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 112;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_String_8859_1)) { // STRING
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 112;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SceneNumber)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 2;

      // Simple field (value)
      lengthInBits += 6;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SceneControl)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (learnTheSceneCorrespondingToTheFieldSceneNumber)
      lengthInBits += 1;

      // Reserved Field (reserved)
      lengthInBits += 1;

      // Simple field (sceneNumber)
      lengthInBits += 6;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DateTime)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (year)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (month)
      lengthInBits += 4;

      // Reserved Field (reserved)
      lengthInBits += 3;

      // Simple field (dayofmonth)
      lengthInBits += 5;

      // Simple field (dayofweek)
      lengthInBits += 3;

      // Simple field (hourofday)
      lengthInBits += 5;

      // Reserved Field (reserved)
      lengthInBits += 2;

      // Simple field (minutes)
      lengthInBits += 6;

      // Reserved Field (reserved)
      lengthInBits += 2;

      // Simple field (seconds)
      lengthInBits += 6;

      // Simple field (fault)
      lengthInBits += 1;

      // Simple field (workingDay)
      lengthInBits += 1;

      // Simple field (noWd)
      lengthInBits += 1;

      // Simple field (noYear)
      lengthInBits += 1;

      // Simple field (noDate)
      lengthInBits += 1;

      // Simple field (noDayOfWeek)
      lengthInBits += 1;

      // Simple field (noTime)
      lengthInBits += 1;

      // Simple field (standardSummerTime)
      lengthInBits += 1;

      // Simple field (qualityOfClock)
      lengthInBits += 1;

      // Reserved Field (reserved)
      lengthInBits += 7;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SCLOMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BuildingMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OccMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Priority)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LightApplicationMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApplicationArea)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_AlarmClassType)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PSUMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ErrorClass_System)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ErrorClass_HVAC)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Time_Delay)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Beaufort_Wind_Force_Scale)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SensorSelect)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActuatorConnectType)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Cloud_Cover)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_PowerReturnMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FuelType)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BurnerType)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HVACMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DHWMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_LoadPriority)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVACContrMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVACEmergMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ChangeoverMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ValveMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DamperMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HeaterMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FanMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_MasterSlaveMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_StatusRoomSetp)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Metering_DeviceType)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HumDehumMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_EnableHCStage)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ADAType)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BackupMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_StartSynchronization)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Behaviour_Lock_Unlock)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Behaviour_Bus_Power_Up_Down)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DALI_Fade_Time)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BlinkingMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LightControlMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SwitchPBModel)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PBAction)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DimmPBModel)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SwitchOnMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_LoadTypeSet)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LoadTypeDetected)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Converter_Test_Control)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SABExcept_Behaviour)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SABBehaviour_Lock_Unlock)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SSSBMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_BlindsControlMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_CommMode)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_AddInfoTypes)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_RF_ModeSelect)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_RF_FilterSelect)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusGen)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 3;

      // Simple field (alarmStatusOfCorrespondingDatapointIsNotAcknowledged)
      lengthInBits += 1;

      // Simple field (correspondingDatapointIsInAlarm)
      lengthInBits += 1;

      // Simple field (correspondingDatapointMainValueIsOverridden)
      lengthInBits += 1;

      // Simple field (correspondingDatapointMainValueIsCorruptedDueToFailure)
      lengthInBits += 1;

      // Simple field (correspondingDatapointValueIsOutOfService)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Device_Control)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 5;

      // Simple field (verifyModeIsOn)
      lengthInBits += 1;

      // Simple field (aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived)
      lengthInBits += 1;

      // Simple field (theUserApplicationIsStopped)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ForceSign)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (roomhmax)
      lengthInBits += 1;

      // Simple field (roomhconf)
      lengthInBits += 1;

      // Simple field (dhwlegio)
      lengthInBits += 1;

      // Simple field (dhwnorm)
      lengthInBits += 1;

      // Simple field (overrun)
      lengthInBits += 1;

      // Simple field (oversupply)
      lengthInBits += 1;

      // Simple field (protection)
      lengthInBits += 1;

      // Simple field (forcerequest)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ForceSignCool)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusRHC)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (summermode)
      lengthInBits += 1;

      // Simple field (statusstopoptim)
      lengthInBits += 1;

      // Simple field (statusstartoptim)
      lengthInBits += 1;

      // Simple field (statusmorningboost)
      lengthInBits += 1;

      // Simple field (tempreturnlimit)
      lengthInBits += 1;

      // Simple field (tempflowlimit)
      lengthInBits += 1;

      // Simple field (satuseco)
      lengthInBits += 1;

      // Simple field (fault)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusSDHWC)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 5;

      // Simple field (solarloadsufficient)
      lengthInBits += 1;

      // Simple field (sdhwloadactive)
      lengthInBits += 1;

      // Simple field (fault)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FuelTypeSet)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 5;

      // Simple field (solidstate)
      lengthInBits += 1;

      // Simple field (gas)
      lengthInBits += 1;

      // Simple field (oil)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusRCC)) { // BOOL
      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (value)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusAHU)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (cool)
      lengthInBits += 1;

      // Simple field (heat)
      lengthInBits += 1;

      // Simple field (fanactive)
      lengthInBits += 1;

      // Simple field (fault)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedStatus_RTSM)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 3;

      // Simple field (statusOfHvacModeUser)
      lengthInBits += 1;

      // Simple field (statusOfComfortProlongationUser)
      lengthInBits += 1;

      // Simple field (effectiveValueOfTheComfortPushButton)
      lengthInBits += 1;

      // Simple field (effectiveValueOfThePresenceStatus)
      lengthInBits += 1;

      // Simple field (effectiveValueOfTheWindowStatus)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LightActuatorErrorInfo)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 1;

      // Simple field (overheat)
      lengthInBits += 1;

      // Simple field (lampfailure)
      lengthInBits += 1;

      // Simple field (defectiveload)
      lengthInBits += 1;

      // Simple field (underload)
      lengthInBits += 1;

      // Simple field (overcurrent)
      lengthInBits += 1;

      // Simple field (undervoltage)
      lengthInBits += 1;

      // Simple field (loaddetectionerror)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_RF_ModeInfo)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 5;

      // Simple field (bibatSlave)
      lengthInBits += 1;

      // Simple field (bibatMaster)
      lengthInBits += 1;

      // Simple field (asynchronous)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_RF_FilterInfo)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 5;

      // Simple field (doa)
      lengthInBits += 1;

      // Simple field (knxSn)
      lengthInBits += 1;

      // Simple field (doaAndKnxSn)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Channel_Activation_8)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (activationStateOfChannel1)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel2)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel3)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel4)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel5)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel6)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel7)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel8)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusDHWC)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (tempoptimshiftactive)
      lengthInBits += 1;

      // Simple field (solarenergysupport)
      lengthInBits += 1;

      // Simple field (solarenergyonly)
      lengthInBits += 1;

      // Simple field (otherenergysourceactive)
      lengthInBits += 1;

      // Simple field (dhwpushactive)
      lengthInBits += 1;

      // Simple field (legioprotactive)
      lengthInBits += 1;

      // Simple field (dhwloadactive)
      lengthInBits += 1;

      // Simple field (fault)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusRHCC)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 1;

      // Simple field (overheatalarm)
      lengthInBits += 1;

      // Simple field (frostalarm)
      lengthInBits += 1;

      // Simple field (dewpointstatus)
      lengthInBits += 1;

      // Simple field (coolingdisabled)
      lengthInBits += 1;

      // Simple field (statusprecool)
      lengthInBits += 1;

      // Simple field (statusecoc)
      lengthInBits += 1;

      // Simple field (heatcoolmode)
      lengthInBits += 1;

      // Simple field (heatingdiabled)
      lengthInBits += 1;

      // Simple field (statusstopoptim)
      lengthInBits += 1;

      // Simple field (statusstartoptim)
      lengthInBits += 1;

      // Simple field (statusmorningboosth)
      lengthInBits += 1;

      // Simple field (tempflowreturnlimit)
      lengthInBits += 1;

      // Simple field (tempflowlimit)
      lengthInBits += 1;

      // Simple field (statusecoh)
      lengthInBits += 1;

      // Simple field (fault)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedStatus_HVA)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (calibrationMode)
      lengthInBits += 1;

      // Simple field (lockedPosition)
      lengthInBits += 1;

      // Simple field (forcedPosition)
      lengthInBits += 1;

      // Simple field (manuaOperationOverridden)
      lengthInBits += 1;

      // Simple field (serviceMode)
      lengthInBits += 1;

      // Simple field (valveKick)
      lengthInBits += 1;

      // Simple field (overload)
      lengthInBits += 1;

      // Simple field (shortCircuit)
      lengthInBits += 1;

      // Simple field (currentValvePosition)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedStatus_RTC)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 7;

      // Simple field (coolingModeEnabled)
      lengthInBits += 1;

      // Simple field (heatingModeEnabled)
      lengthInBits += 1;

      // Simple field (additionalHeatingCoolingStage2Stage)
      lengthInBits += 1;

      // Simple field (controllerInactive)
      lengthInBits += 1;

      // Simple field (overheatAlarm)
      lengthInBits += 1;

      // Simple field (frostAlarm)
      lengthInBits += 1;

      // Simple field (dewPointStatus)
      lengthInBits += 1;

      // Simple field (activeMode)
      lengthInBits += 1;

      // Simple field (generalFailureInformation)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Media)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 10;

      // Simple field (knxIp)
      lengthInBits += 1;

      // Simple field (rf)
      lengthInBits += 1;

      // Reserved Field (reserved)
      lengthInBits += 1;

      // Simple field (pl110)
      lengthInBits += 1;

      // Simple field (tp1)
      lengthInBits += 1;

      // Reserved Field (reserved)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Channel_Activation_16)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (activationStateOfChannel1)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel2)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel3)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel4)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel5)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel6)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel7)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel8)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel9)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel10)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel11)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel12)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel13)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel14)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel15)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel16)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OnOffAction)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (value)
      lengthInBits += 2;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Alarm_Reaction)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (value)
      lengthInBits += 2;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_UpDown_Action)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (value)
      lengthInBits += 2;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVAC_PB_Action)) { // USINT
      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (value)
      lengthInBits += 2;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DoubleNibble)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (busy)
      lengthInBits += 4;

      // Simple field (nak)
      lengthInBits += 4;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SceneInfo)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 1;

      // Simple field (sceneIsInactive)
      lengthInBits += 1;

      // Simple field (scenenumber)
      lengthInBits += 6;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedInfoOnOff)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (maskBitInfoOnOffOutput16)
      lengthInBits += 1;

      // Simple field (maskBitInfoOnOffOutput15)
      lengthInBits += 1;

      // Simple field (maskBitInfoOnOffOutput14)
      lengthInBits += 1;

      // Simple field (maskBitInfoOnOffOutput13)
      lengthInBits += 1;

      // Simple field (maskBitInfoOnOffOutput12)
      lengthInBits += 1;

      // Simple field (maskBitInfoOnOffOutput11)
      lengthInBits += 1;

      // Simple field (maskBitInfoOnOffOutput10)
      lengthInBits += 1;

      // Simple field (maskBitInfoOnOffOutput9)
      lengthInBits += 1;

      // Simple field (maskBitInfoOnOffOutput8)
      lengthInBits += 1;

      // Simple field (maskBitInfoOnOffOutput7)
      lengthInBits += 1;

      // Simple field (maskBitInfoOnOffOutput6)
      lengthInBits += 1;

      // Simple field (maskBitInfoOnOffOutput5)
      lengthInBits += 1;

      // Simple field (maskBitInfoOnOffOutput4)
      lengthInBits += 1;

      // Simple field (maskBitInfoOnOffOutput3)
      lengthInBits += 1;

      // Simple field (maskBitInfoOnOffOutput2)
      lengthInBits += 1;

      // Simple field (maskBitInfoOnOffOutput1)
      lengthInBits += 1;

      // Simple field (infoOnOffOutput16)
      lengthInBits += 1;

      // Simple field (infoOnOffOutput15)
      lengthInBits += 1;

      // Simple field (infoOnOffOutput14)
      lengthInBits += 1;

      // Simple field (infoOnOffOutput13)
      lengthInBits += 1;

      // Simple field (infoOnOffOutput12)
      lengthInBits += 1;

      // Simple field (infoOnOffOutput11)
      lengthInBits += 1;

      // Simple field (infoOnOffOutput10)
      lengthInBits += 1;

      // Simple field (infoOnOffOutput9)
      lengthInBits += 1;

      // Simple field (infoOnOffOutput8)
      lengthInBits += 1;

      // Simple field (infoOnOffOutput7)
      lengthInBits += 1;

      // Simple field (infoOnOffOutput6)
      lengthInBits += 1;

      // Simple field (infoOnOffOutput5)
      lengthInBits += 1;

      // Simple field (infoOnOffOutput4)
      lengthInBits += 1;

      // Simple field (infoOnOffOutput3)
      lengthInBits += 1;

      // Simple field (infoOnOffOutput2)
      lengthInBits += 1;

      // Simple field (infoOnOffOutput1)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_V64)) { // LINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 64;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy_V64)) { // LINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 64;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy_V64)) { // LINT
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 64;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Channel_Activation_24)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (activationStateOfChannel1)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel2)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel3)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel4)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel5)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel6)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel7)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel8)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel9)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel10)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel11)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel12)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel13)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel14)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel15)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel16)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel17)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel18)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel19)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel20)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel21)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel22)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel23)
      lengthInBits += 1;

      // Simple field (activationStateOfChannel24)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVACModeNext)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (delayTimeMin)
      lengthInBits += 16;

      // Simple field (hvacMode)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DHWModeNext)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (delayTimeMin)
      lengthInBits += 16;

      // Simple field (dhwMode)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OccModeNext)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (delayTimeMin)
      lengthInBits += 16;

      // Simple field (occupancyMode)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_BuildingModeNext)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (delayTimeMin)
      lengthInBits += 16;

      // Simple field (buildingMode)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_StatusLightingActuator)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (validactualvalue)
      lengthInBits += 1;

      // Simple field (locked)
      lengthInBits += 1;

      // Simple field (forced)
      lengthInBits += 1;

      // Simple field (nightmodeactive)
      lengthInBits += 1;

      // Simple field (staircaselightingFunction)
      lengthInBits += 1;

      // Simple field (dimming)
      lengthInBits += 1;

      // Simple field (localoverride)
      lengthInBits += 1;

      // Simple field (failure)
      lengthInBits += 1;

      // Simple field (actualvalue)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Version)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (magicNumber)
      lengthInBits += 5;

      // Simple field (versionNumber)
      lengthInBits += 5;

      // Simple field (revisionNumber)
      lengthInBits += 6;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_AlarmInfo)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (logNumber)
      lengthInBits += 8;

      // Simple field (alarmPriority)
      lengthInBits += 8;

      // Simple field (applicationArea)
      lengthInBits += 8;

      // Simple field (errorClass)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (errorcodeSup)
      lengthInBits += 1;

      // Simple field (alarmtextSup)
      lengthInBits += 1;

      // Simple field (timestampSup)
      lengthInBits += 1;

      // Simple field (ackSup)
      lengthInBits += 1;

      // Reserved Field (reserved)
      lengthInBits += 5;

      // Simple field (locked)
      lengthInBits += 1;

      // Simple field (alarmunack)
      lengthInBits += 1;

      // Simple field (inalarm)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetF16_3)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (tempsetpcomf)
      lengthInBits += 16;

      // Simple field (tempsetpstdby)
      lengthInBits += 16;

      // Simple field (tempsetpeco)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetShiftF16_3)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (tempsetpshiftcomf)
      lengthInBits += 16;

      // Simple field (tempsetpshiftstdby)
      lengthInBits += 16;

      // Simple field (tempsetpshifteco)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Scaling_Speed)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (timePeriod)
      lengthInBits += 16;

      // Simple field (percent)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Scaling_Step_Time)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (timePeriod)
      lengthInBits += 16;

      // Simple field (percent)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_MeteringValue)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (countval)
      lengthInBits += 32;

      // Simple field (valinffield)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 3;

      // Simple field (alarmunack)
      lengthInBits += 1;

      // Simple field (inalarm)
      lengthInBits += 1;

      // Simple field (overridden)
      lengthInBits += 1;

      // Simple field (fault)
      lengthInBits += 1;

      // Simple field (outofservice)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_MBus_Address)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (manufactid)
      lengthInBits += 16;

      // Simple field (identnumber)
      lengthInBits += 32;

      // Simple field (version)
      lengthInBits += 8;

      // Simple field (medium)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Colour_RGB)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (r)
      lengthInBits += 8;

      // Simple field (g)
      lengthInBits += 8;

      // Simple field (b)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LanguageCodeAlpha2_ASCII)) { // STRING
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (value)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Tariff_ActiveEnergy)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (activeelectricalenergy)
      lengthInBits += 32;

      // Simple field (tariff)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (electricalengergyvalidity)
      lengthInBits += 1;

      // Simple field (tariffvalidity)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Prioritised_Mode_Control)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (deactivationOfPriority)
      lengthInBits += 1;

      // Simple field (priorityLevel)
      lengthInBits += 3;

      // Simple field (modeLevel)
      lengthInBits += 4;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DALI_Control_Gear_Diagnostic)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 5;

      // Simple field (convertorError)
      lengthInBits += 1;

      // Simple field (ballastFailure)
      lengthInBits += 1;

      // Simple field (lampFailure)
      lengthInBits += 1;

      // Simple field (readOrResponse)
      lengthInBits += 1;

      // Simple field (addressIndicator)
      lengthInBits += 1;

      // Simple field (daliDeviceAddressOrDaliGroupAddress)
      lengthInBits += 6;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DALI_Diagnostics)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (ballastFailure)
      lengthInBits += 1;

      // Simple field (lampFailure)
      lengthInBits += 1;

      // Simple field (deviceAddress)
      lengthInBits += 6;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedPosition)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (heightPosition)
      lengthInBits += 8;

      // Simple field (slatsPosition)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (validitySlatsPosition)
      lengthInBits += 1;

      // Simple field (validityHeightPosition)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusSAB)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (heightPosition)
      lengthInBits += 8;

      // Simple field (slatsPosition)
      lengthInBits += 8;

      // Simple field (upperEndPosReached)
      lengthInBits += 1;

      // Simple field (lowerEndPosReached)
      lengthInBits += 1;

      // Simple field (lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent)
      lengthInBits += 1;

      // Simple field (targetPosDrive)
      lengthInBits += 1;

      // Simple field (restrictionOfTargetHeightPosPosCanNotBeReached)
      lengthInBits += 1;

      // Simple field (restrictionOfSlatsHeightPosPosCanNotBeReached)
      lengthInBits += 1;

      // Simple field (atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm)
      lengthInBits += 1;

      // Simple field (upDownPositionIsForcedByMoveupdownforcedInput)
      lengthInBits += 1;

      // Simple field (movementIsLockedEGByDevicelockedInput)
      lengthInBits += 1;

      // Simple field (actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface)
      lengthInBits += 1;

      // Simple field (generalFailureOfTheActuatorOrTheDrive)
      lengthInBits += 1;

      // Reserved Field (reserved)
      lengthInBits += 3;

      // Simple field (validityHeightPos)
      lengthInBits += 1;

      // Simple field (validitySlatsPos)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Colour_xyY)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (xAxis)
      lengthInBits += 16;

      // Simple field (yAxis)
      lengthInBits += 16;

      // Simple field (brightness)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (validityXy)
      lengthInBits += 1;

      // Simple field (validityBrightness)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Converter_Status)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (converterModeAccordingToTheDaliConverterStateMachine)
      lengthInBits += 4;

      // Reserved Field (reserved)
      lengthInBits += 2;

      // Simple field (hardwiredSwitchIsActive)
      lengthInBits += 1;

      // Simple field (hardwiredInhibitIsActive)
      lengthInBits += 1;

      // Simple field (functionTestPending)
      lengthInBits += 2;

      // Simple field (durationTestPending)
      lengthInBits += 2;

      // Simple field (partialDurationTestPending)
      lengthInBits += 2;

      // Simple field (converterFailure)
      lengthInBits += 2;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Converter_Test_Result)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (ltrf)
      lengthInBits += 4;

      // Simple field (ltrd)
      lengthInBits += 4;

      // Simple field (ltrp)
      lengthInBits += 4;

      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (sf)
      lengthInBits += 2;

      // Simple field (sd)
      lengthInBits += 2;

      // Simple field (sp)
      lengthInBits += 2;

      // Reserved Field (reserved)
      lengthInBits += 2;

      // Simple field (ldtr)
      lengthInBits += 16;

      // Simple field (lpdtr)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Battery_Info)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 5;

      // Simple field (batteryFailure)
      lengthInBits += 1;

      // Simple field (batteryDurationFailure)
      lengthInBits += 1;

      // Simple field (batteryFullyCharged)
      lengthInBits += 1;

      // Simple field (batteryChargeLevel)
      lengthInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Brightness_Colour_Temperature_Transition)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (ms)
      lengthInBits += 16;

      // Simple field (temperatureK)
      lengthInBits += 16;

      // Simple field (percent)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 5;

      // Simple field (validityOfTheTimePeriod)
      lengthInBits += 1;

      // Simple field (validityOfTheAbsoluteColourTemperature)
      lengthInBits += 1;

      // Simple field (validityOfTheAbsoluteBrightness)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Brightness_Colour_Temperature_Control)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (cct)
      lengthInBits += 1;

      // Simple field (stepCodeColourTemperature)
      lengthInBits += 3;

      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (cb)
      lengthInBits += 1;

      // Simple field (stepCodeBrightness)
      lengthInBits += 3;

      // Reserved Field (reserved)
      lengthInBits += 6;

      // Simple field (cctAndStepCodeColourValidity)
      lengthInBits += 1;

      // Simple field (cbAndStepCodeBrightnessValidity)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Colour_RGBW)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (colourLevelRed)
      lengthInBits += 8;

      // Simple field (colourLevelGreen)
      lengthInBits += 8;

      // Simple field (colourLevelBlue)
      lengthInBits += 8;

      // Simple field (colourLevelWhite)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (mr)
      lengthInBits += 1;

      // Simple field (mg)
      lengthInBits += 1;

      // Simple field (mb)
      lengthInBits += 1;

      // Simple field (mw)
      lengthInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Relative_Control_RGBW)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (maskcw)
      lengthInBits += 1;

      // Simple field (maskcb)
      lengthInBits += 1;

      // Simple field (maskcg)
      lengthInBits += 1;

      // Simple field (maskcr)
      lengthInBits += 1;

      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (cw)
      lengthInBits += 1;

      // Simple field (stepCodeColourWhite)
      lengthInBits += 3;

      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (cb)
      lengthInBits += 1;

      // Simple field (stepCodeColourBlue)
      lengthInBits += 3;

      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (cg)
      lengthInBits += 1;

      // Simple field (stepCodeColourGreen)
      lengthInBits += 3;

      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (cr)
      lengthInBits += 1;

      // Simple field (stepCodeColourRed)
      lengthInBits += 3;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Relative_Control_RGB)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (cb)
      lengthInBits += 1;

      // Simple field (stepCodeColourBlue)
      lengthInBits += 3;

      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (cg)
      lengthInBits += 1;

      // Simple field (stepCodeColourGreen)
      lengthInBits += 3;

      // Reserved Field (reserved)
      lengthInBits += 4;

      // Simple field (cr)
      lengthInBits += 1;

      // Simple field (stepCodeColourRed)
      lengthInBits += 3;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_GeographicalLocation)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (longitude)
      lengthInBits += 32;

      // Simple field (latitude)
      lengthInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetF16_4)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (roomTemperatureSetpointComfort)
      lengthInBits += 16;

      // Simple field (roomTemperatureSetpointStandby)
      lengthInBits += 16;

      // Simple field (roomTemperatureSetpointEconomy)
      lengthInBits += 16;

      // Simple field (roomTemperatureSetpointBuildingProtection)
      lengthInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetShiftF16_4)) { // Struct
      // Reserved Field (reserved)
      lengthInBits += 8;

      // Simple field (roomTemperatureSetpointShiftComfort)
      lengthInBits += 16;

      // Simple field (roomTemperatureSetpointShiftStandby)
      lengthInBits += 16;

      // Simple field (roomTemperatureSetpointShiftEconomy)
      lengthInBits += 16;

      // Simple field (roomTemperatureSetpointShiftBuildingProtection)
      lengthInBits += 16;
    }

    return lengthInBits;
  }

  public static void staticSerialize(
      WriteBuffer writeBuffer, PlcValue _value, KnxDatapointType datapointType)
      throws SerializationException {
    staticSerialize(writeBuffer, _value, datapointType, ByteOrder.BIG_ENDIAN);
  }

  public static void staticSerialize(
      WriteBuffer writeBuffer, PlcValue _value, KnxDatapointType datapointType, ByteOrder byteOrder)
      throws SerializationException {
    if (EvaluationHelper.equals(datapointType, KnxDatapointType.BOOL)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.BYTE)) { // BYTE
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.WORD)) { // WORD
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeUnsignedInt(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DWORD)) { // DWORD
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeUnsignedLong(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LWORD)) { // LWORD
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value", (BigInteger) _value.getBigInteger(), writeUnsignedBigInteger(writeBuffer, 64));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.USINT)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.SINT)) { // SINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (byte) _value.getByte(), writeSignedByte(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.UINT)) { // UINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeUnsignedInt(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.INT)) { // INT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeSignedShort(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.UDINT)) { // UDINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeUnsignedLong(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DINT)) { // DINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeSignedInt(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.ULINT)) { // ULINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value", (BigInteger) _value.getBigInteger(), writeUnsignedBigInteger(writeBuffer, 64));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LINT)) { // LINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeSignedLong(writeBuffer, 64));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.REAL)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LREAL)) { // LREAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (double) _value.getDouble(), writeDouble(writeBuffer, 64));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.CHAR)) { // CHAR
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (String) _value.getString(),
          writeString(writeBuffer, 8),
          WithOption.WithEncoding("UTF-8"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.WCHAR)) { // WCHAR
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (String) _value.getString(),
          writeString(writeBuffer, 16),
          WithOption.WithEncoding("UTF-16"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.TIME)) { // TIME
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (milliseconds)
      writeSimpleField(
          "milliseconds",
          (long) _value.getDuration().toMillis(),
          writeUnsignedLong(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LTIME)) { // LTIME
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (nanoseconds)
      writeSimpleField(
          "nanoseconds",
          (BigInteger) BigInteger.valueOf(_value.getDuration().toNanos()),
          writeUnsignedBigInteger(writeBuffer, 64));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DATE)) { // DATE
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (secondsSinceEpoch)
      writeSimpleField(
          "secondsSinceEpoch",
          (long) _value.getDateTime().toEpochSecond(ZoneOffset.UTC),
          writeUnsignedLong(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.TIME_OF_DAY)) { // TIME_OF_DAY
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (millisecondsSinceMidnight)
      writeSimpleField(
          "millisecondsSinceMidnight",
          (long) _value.getTime().getLong(ChronoField.MILLI_OF_DAY),
          writeUnsignedLong(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.TOD)) { // TIME_OF_DAY
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (millisecondsSinceMidnight)
      writeSimpleField(
          "millisecondsSinceMidnight",
          (long) _value.getTime().getLong(ChronoField.MILLI_OF_DAY),
          writeUnsignedLong(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DATE_AND_TIME)) { // DATE_AND_TIME
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (year)
      writeSimpleField("year", (int) _value.getDate().getYear(), writeUnsignedInt(writeBuffer, 16));

      // Simple Field (month)
      writeSimpleField(
          "month", (short) _value.getDate().getMonthValue(), writeUnsignedShort(writeBuffer, 8));

      // Simple Field (day)
      writeSimpleField(
          "day", (short) _value.getDate().getDayOfMonth(), writeUnsignedShort(writeBuffer, 8));

      // Simple Field (dayOfWeek)
      writeSimpleField(
          "dayOfWeek",
          (short) _value.getDate().getDayOfWeek().getValue(),
          writeUnsignedShort(writeBuffer, 8));

      // Simple Field (hour)
      writeSimpleField(
          "hour", (short) _value.getTime().getHour(), writeUnsignedShort(writeBuffer, 8));

      // Simple Field (minutes)
      writeSimpleField(
          "minutes", (short) _value.getTime().getMinute(), writeUnsignedShort(writeBuffer, 8));

      // Simple Field (seconds)
      writeSimpleField(
          "seconds", (short) _value.getTime().getSecond(), writeUnsignedShort(writeBuffer, 8));

      // Simple Field (nanoseconds)
      writeSimpleField(
          "nanoseconds", (long) _value.getDuration().toNanos(), writeUnsignedLong(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DT)) { // DATE_AND_TIME
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (year)
      writeSimpleField("year", (int) _value.getDate().getYear(), writeUnsignedInt(writeBuffer, 16));

      // Simple Field (month)
      writeSimpleField(
          "month", (short) _value.getDate().getMonthValue(), writeUnsignedShort(writeBuffer, 8));

      // Simple Field (day)
      writeSimpleField(
          "day", (short) _value.getDate().getDayOfMonth(), writeUnsignedShort(writeBuffer, 8));

      // Simple Field (dayOfWeek)
      writeSimpleField(
          "dayOfWeek",
          (short) _value.getDate().getDayOfWeek().getValue(),
          writeUnsignedShort(writeBuffer, 8));

      // Simple Field (hour)
      writeSimpleField(
          "hour", (short) _value.getTime().getHour(), writeUnsignedShort(writeBuffer, 8));

      // Simple Field (minutes)
      writeSimpleField(
          "minutes", (short) _value.getTime().getMinute(), writeUnsignedShort(writeBuffer, 8));

      // Simple Field (seconds)
      writeSimpleField(
          "seconds", (short) _value.getTime().getSecond(), writeUnsignedShort(writeBuffer, 8));

      // Simple Field (nanoseconds)
      writeSimpleField(
          "nanoseconds", (long) _value.getDuration().toNanos(), writeUnsignedLong(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Switch)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Bool)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Enable)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Ramp)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Alarm)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BinaryValue)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Step)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_UpDown)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OpenClose)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Start)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_State)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Invert)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DimSendStyle)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_InputSource)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Reset)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Ack)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Trigger)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Occupancy)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Window_Door)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LogicalFunction)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Scene_AB)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ShutterBlinds_Mode)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DayNight)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Heat_Cool)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Switch_Control)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_Bool_Control)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Enable_Control)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_Ramp_Control)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_Alarm_Control)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_BinaryValue_Control)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_Step_Control)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Direction1_Control)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Direction2_Control)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_Start_Control)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_State_Control)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Invert_Control)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Control_Dimming)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Control_Blinds)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Char_ASCII)) { // STRING
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (String) _value.getString(),
          writeString(writeBuffer, 8),
          WithOption.WithEncoding("ASCII"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Char_8859_1)) { // STRING
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (String) _value.getString(),
          writeString(writeBuffer, 8),
          WithOption.WithEncoding("ISO-8859-1"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Scaling)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Angle)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_U8)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DecimalFactor)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Tariff)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_1_Ucount)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FanStage)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_V8)) { // SINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (byte) _value.getByte(), writeSignedByte(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_1_Count)) { // SINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (byte) _value.getByte(), writeSignedByte(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_Status_Mode3)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_2_Ucount)) { // UINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeUnsignedInt(writeBuffer, 16));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriodMsec)) { // UINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeUnsignedInt(writeBuffer, 16));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriod10Msec)) { // UINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeUnsignedInt(writeBuffer, 16));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriod100Msec)) { // UINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeUnsignedInt(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodSec)) { // UINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeUnsignedInt(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodMin)) { // UINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeUnsignedInt(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodHrs)) { // UINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeUnsignedInt(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PropDataType)) { // UINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeUnsignedInt(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Length_mm)) { // UINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeUnsignedInt(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_UElCurrentmA)) { // UINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeUnsignedInt(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Brightness)) { // UINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeUnsignedInt(writeBuffer, 16));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Absolute_Colour_Temperature)) { // UINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeUnsignedInt(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_2_Count)) { // INT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeSignedShort(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeMsec)) { // INT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeSignedShort(writeBuffer, 16));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaTime10Msec)) { // INT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeSignedShort(writeBuffer, 16));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaTime100Msec)) { // INT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeSignedShort(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeSec)) { // INT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeSignedShort(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeMin)) { // INT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeSignedShort(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeHrs)) { // INT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeSignedShort(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_V16)) { // INT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeSignedShort(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Rotation_Angle)) { // INT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeSignedShort(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Length_m)) { // INT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeSignedShort(writeBuffer, 16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Temp)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Tempd)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Tempa)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Lux)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Wsp)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Pres)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Humidity)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AirQuality)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_AirFlow)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time1)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time2)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Volt)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Curr)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PowerDensity)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_KelvinPerPercent)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Power)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Volume_Flow)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Rain_Amount)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Temp_F)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Wsp_kmh)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Absolute_Humidity)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Concentration_ygm3)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Coefficient)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_TimeOfDay)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_Date)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_4_Ucount)) { // UDINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeUnsignedLong(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Sec)) { // UDINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeUnsignedLong(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Min)) { // UDINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeUnsignedLong(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Hrs)) { // UDINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeUnsignedLong(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_VolumeLiquid_Litre)) { // UDINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeUnsignedLong(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Volume_m_3)) { // UDINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeUnsignedLong(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_4_Count)) { // DINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeSignedInt(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FlowRate_m3h)) { // DINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeSignedInt(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ActiveEnergy)) { // DINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeSignedInt(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy)) { // DINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeSignedInt(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy)) { // DINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeSignedInt(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_kWh)) { // DINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeSignedInt(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy_kVAh)) { // DINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeSignedInt(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy_kVARh)) { // DINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeSignedInt(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_MWh)) { // DINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeSignedInt(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongDeltaTimeSec)) { // DINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeSignedInt(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaVolumeLiquid_Litre)) { // DINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeSignedInt(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaVolume_m_3)) { // DINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (int) _value.getInteger(), writeSignedInt(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Acceleration)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Acceleration_Angular)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Activation_Energy)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Activity)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Mol)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Amplitude)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AngleRad)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AngleDeg)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Momentum)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Velocity)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Area)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Capacitance)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Charge_DensitySurface)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Charge_DensityVolume)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Compressibility)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Conductance)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electrical_Conductivity)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Density)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Charge)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Current)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_CurrentDensity)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_DipoleMoment)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Displacement)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_FieldStrength)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Flux)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_FluxDensity)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Polarization)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Potential)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_PotentialDifference)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_ElectromagneticMoment)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electromotive_Force)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Energy)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Force)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Frequency)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Frequency)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_Capacity)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_FlowRate)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_Quantity)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Impedance)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Length)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Light_Quantity)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminance)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminous_Flux)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminous_Intensity)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_FieldStrength)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Flux)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_FluxDensity)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Moment)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Polarization)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetization)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_MagnetomotiveForce)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Mass)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_MassFlux)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Momentum)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Phase_AngleRad)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Phase_AngleDeg)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Power)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Power_Factor)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Pressure)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Reactance)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Resistance)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Resistivity)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_SelfInductance)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_SolidAngle)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Sound_Intensity)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Speed)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Stress)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Surface_Tension)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Common_Temperature)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Absolute_Temperature)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_TemperatureDifference)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Thermal_Capacity)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Thermal_Conductivity)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_ThermoelectricPower)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Torque)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Volume)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Volume_Flux)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Weight)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Work)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_ApparentPower)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (float) _value.getFloat(), writeFloat(writeBuffer, 32));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Volume_Flux_Meter)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Volume_Flux_ls)) { // REAL
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (float) _value.getFloat(),
          writeFloat(writeBuffer, 16),
          WithOption.WithEncoding("KNXFloat"));
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_Access_Data)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_String_ASCII)) { // STRING
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (String) _value.getString(),
          writeString(writeBuffer, 112),
          WithOption.WithEncoding("ASCII"));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_String_8859_1)) { // STRING
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (String) _value.getString(),
          writeString(writeBuffer, 112),
          WithOption.WithEncoding("ISO-8859-1"));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SceneNumber)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 2));

      // Simple Field (value)
      writeSimpleField("value", (byte) _value.getByte(), writeUnsignedByte(writeBuffer, 6));
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_SceneControl)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_DateTime)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SCLOMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BuildingMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OccMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Priority)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LightApplicationMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApplicationArea)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_AlarmClassType)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PSUMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ErrorClass_System)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ErrorClass_HVAC)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Time_Delay)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Beaufort_Wind_Force_Scale)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SensorSelect)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActuatorConnectType)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Cloud_Cover)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_PowerReturnMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FuelType)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BurnerType)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HVACMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DHWMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_LoadPriority)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVACContrMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVACEmergMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ChangeoverMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ValveMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DamperMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HeaterMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FanMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_MasterSlaveMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_StatusRoomSetp)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Metering_DeviceType)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HumDehumMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_EnableHCStage)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ADAType)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BackupMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_StartSynchronization)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Behaviour_Lock_Unlock)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Behaviour_Bus_Power_Up_Down)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DALI_Fade_Time)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BlinkingMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LightControlMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SwitchPBModel)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PBAction)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DimmPBModel)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SwitchOnMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_LoadTypeSet)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LoadTypeDetected)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Converter_Test_Control)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SABExcept_Behaviour)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SABBehaviour_Lock_Unlock)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SSSBMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_BlindsControlMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_CommMode)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_AddInfoTypes)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_RF_ModeSelect)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_RF_FilterSelect)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (short) _value.getShort(), writeUnsignedShort(writeBuffer, 8));
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_StatusGen)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Device_Control)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_ForceSign)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ForceSignCool)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_StatusRHC)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_StatusSDHWC)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_FuelTypeSet)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusRCC)) { // BOOL
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

      // Simple Field (value)
      writeSimpleField("value", (boolean) _value.getBoolean(), writeBoolean(writeBuffer));
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_StatusAHU)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_CombinedStatus_RTSM)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_LightActuatorErrorInfo)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_RF_ModeInfo)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_RF_FilterInfo)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Channel_Activation_8)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_StatusDHWC)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_StatusRHCC)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_CombinedStatus_HVA)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_CombinedStatus_RTC)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_Media)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Channel_Activation_16)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OnOffAction)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 6));

      // Simple Field (value)
      writeSimpleField("value", (byte) _value.getByte(), writeUnsignedByte(writeBuffer, 2));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Alarm_Reaction)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 6));

      // Simple Field (value)
      writeSimpleField("value", (byte) _value.getByte(), writeUnsignedByte(writeBuffer, 2));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_UpDown_Action)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 6));

      // Simple Field (value)
      writeSimpleField("value", (byte) _value.getByte(), writeUnsignedByte(writeBuffer, 2));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVAC_PB_Action)) { // USINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 6));

      // Simple Field (value)
      writeSimpleField("value", (byte) _value.getByte(), writeUnsignedByte(writeBuffer, 2));
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_DoubleNibble)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_SceneInfo)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_CombinedInfoOnOff)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_V64)) { // LINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeSignedLong(writeBuffer, 64));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy_V64)) { // LINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeSignedLong(writeBuffer, 64));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy_V64)) { // LINT
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField("value", (long) _value.getLong(), writeSignedLong(writeBuffer, 64));
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Channel_Activation_24)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_HVACModeNext)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_DHWModeNext)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_OccModeNext)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_BuildingModeNext)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_StatusLightingActuator)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_Version)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_AlarmInfo)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_TempRoomSetpSetF16_3)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_TempRoomSetpSetShiftF16_3)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_Scaling_Speed)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Scaling_Step_Time)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_MeteringValue)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_MBus_Address)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_Colour_RGB)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LanguageCodeAlpha2_ASCII)) { // STRING
      // Reserved Field (reserved)
      writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

      // Simple Field (value)
      writeSimpleField(
          "value",
          (String) _value.getString(),
          writeString(writeBuffer, 16),
          WithOption.WithEncoding("ASCII"));
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Tariff_ActiveEnergy)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Prioritised_Mode_Control)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_DALI_Control_Gear_Diagnostic)) { // Struct                // Output something here
                                                  // ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_DALI_Diagnostics)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_CombinedPosition)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_StatusSAB)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_Colour_xyY)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Converter_Status)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Converter_Test_Result)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_Battery_Info)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Brightness_Colour_Temperature_Transition)) { // Struct                // Output
                                                              // something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Brightness_Colour_Temperature_Control)) { // Struct                // Output
                                                           // something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType.DPT_Colour_RGBW)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Relative_Control_RGBW)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_Relative_Control_RGB)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_GeographicalLocation)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_TempRoomSetpSetF16_4)) { // Struct                // Output something here ...
    } else if (EvaluationHelper.equals(
        datapointType,
        KnxDatapointType
            .DPT_TempRoomSetpSetShiftF16_4)) { // Struct                // Output something here ...
    }
  }
}
