/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.plc4x.java.knxnetip.readwrite.KnxInterfaceObjectType;
import org.apache.plc4x.java.knxnetip.readwrite.KnxPropertyDataType;

public enum KnxInterfaceObjectProperty {
    PID_UNKNOWN(0L, KnxPropertyDataType.PDT_UNKNOWN, "Unknown Interface Object Property", 0, KnxInterfaceObjectType.OT_UNKNOWN),
    PID_GENERAL_OBJECT_TYPE(1L, KnxPropertyDataType.PDT_UNSIGNED_INT, "Interface Object Type", 1, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_OBJECT_NAME(2L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "Interface Object Name", 2, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_SEMAPHOR(3L, KnxPropertyDataType.PDT_UNKNOWN, "Semaphor", 3, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_GROUP_OBJECT_REFERENCE(4L, KnxPropertyDataType.PDT_UNKNOWN, "Group Object Reference", 4, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_LOAD_STATE_CONTROL(5L, KnxPropertyDataType.PDT_CONTROL, "Load Control", 5, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_RUN_STATE_CONTROL(6L, KnxPropertyDataType.PDT_CONTROL, "Run Control", 6, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_TABLE_REFERENCE(7L, KnxPropertyDataType.PDT_UNSIGNED_INT, "Table Reference", 7, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_SERVICE_CONTROL(8L, KnxPropertyDataType.PDT_UNSIGNED_INT, "Service Control", 8, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_FIRMWARE_REVISION(9L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "Firmware Revision", 9, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_SERVICES_SUPPORTED(10L, KnxPropertyDataType.PDT_UNKNOWN, "Services Supported", 10, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_SERIAL_NUMBER(11L, KnxPropertyDataType.PDT_GENERIC_06, "KNX Serial Number", 11, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_MANUFACTURER_ID(12L, KnxPropertyDataType.PDT_UNSIGNED_INT, "Manufacturer Identifier", 12, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_PROGRAM_VERSION(13L, KnxPropertyDataType.PDT_GENERIC_05, "Application Version", 13, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_DEVICE_CONTROL(14L, KnxPropertyDataType.PDT_BITSET8, "Device Control", 14, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_ORDER_INFO(15L, KnxPropertyDataType.PDT_GENERIC_10, "Order Info", 15, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_PEI_TYPE(16L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "PEI Type", 16, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_PORT_CONFIGURATION(17L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "PortADDR", 17, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_POLL_GROUP_SETTINGS(18L, KnxPropertyDataType.PDT_POLL_GROUP_SETTINGS, "Polling Group Settings", 18, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_MANUFACTURER_DATA(19L, KnxPropertyDataType.PDT_GENERIC_04, "Manufacturer Data", 19, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_ENABLE(20L, KnxPropertyDataType.PDT_UNKNOWN, "", 20, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_DESCRIPTION(21L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "Description", 21, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_FILE(22L, KnxPropertyDataType.PDT_UNKNOWN, "", 22, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_TABLE(23L, KnxPropertyDataType.PDT_UNSIGNED_INT, "Table", 23, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_ENROL(24L, KnxPropertyDataType.PDT_FUNCTION, "Interface Object Link", 24, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_VERSION(25L, KnxPropertyDataType.PDT_VERSION, "Version", 25, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_GROUP_OBJECT_LINK(26L, KnxPropertyDataType.PDT_FUNCTION, "Group Address Assignment", 26, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_MCB_TABLE(27L, KnxPropertyDataType.PDT_GENERIC_08, "Memory Control Table", 27, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_ERROR_CODE(28L, KnxPropertyDataType.PDT_GENERIC_01, "Error Code", 28, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_OBJECT_INDEX(29L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "Object Index", 29, KnxInterfaceObjectType.OT_GENERAL),
    PID_GENERAL_DOWNLOAD_COUNTER(30L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "Download Counter", 30, KnxInterfaceObjectType.OT_GENERAL),
    PID_DEVICE_ROUTING_COUNT(31L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "Routing Count", 51, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_MAX_RETRY_COUNT(32L, KnxPropertyDataType.PDT_GENERIC_01, "Maximum Retry Count", 52, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_ERROR_FLAGS(33L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "Error Flags", 53, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_PROGMODE(34L, KnxPropertyDataType.PDT_BITSET8, "Programming Mode", 54, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_PRODUCT_ID(35L, KnxPropertyDataType.PDT_GENERIC_10, "Product Identification", 55, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_MAX_APDULENGTH(36L, KnxPropertyDataType.PDT_UNSIGNED_INT, "Max. APDU-Length", 56, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_SUBNET_ADDR(37L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "Subnetwork Address", 57, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_DEVICE_ADDR(38L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "Device Address", 58, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_PB_CONFIG(39L, KnxPropertyDataType.PDT_GENERIC_04, "Config Link", 59, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_ADDR_REPORT(40L, KnxPropertyDataType.PDT_GENERIC_06, "", 60, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_ADDR_CHECK(41L, KnxPropertyDataType.PDT_GENERIC_01, "", 61, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_OBJECT_VALUE(42L, KnxPropertyDataType.PDT_FUNCTION, "", 62, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_OBJECTLINK(43L, KnxPropertyDataType.PDT_FUNCTION, "", 63, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_APPLICATION(44L, KnxPropertyDataType.PDT_FUNCTION, "", 64, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_PARAMETER(45L, KnxPropertyDataType.PDT_FUNCTION, "", 65, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_OBJECTADDRESS(46L, KnxPropertyDataType.PDT_FUNCTION, "", 66, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_PSU_TYPE(47L, KnxPropertyDataType.PDT_UNSIGNED_INT, "", 67, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_PSU_STATUS(48L, KnxPropertyDataType.PDT_BINARY_INFORMATION, "", 68, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_PSU_ENABLE(49L, KnxPropertyDataType.PDT_ENUM8, "", 69, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_DOMAIN_ADDRESS(50L, KnxPropertyDataType.PDT_UNSIGNED_INT, "Domain Address", 70, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_IO_LIST(51L, KnxPropertyDataType.PDT_UNSIGNED_INT, "", 71, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_MGT_DESCRIPTOR_01(52L, KnxPropertyDataType.PDT_GENERIC_10, "Management Descriptor 1", 72, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_PL110_PARAM(53L, KnxPropertyDataType.PDT_GENERIC_01, "PL110 Parameters", 73, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_RF_REPEAT_COUNTER(54L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "", 74, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_RECEIVE_BLOCK_TABLE(55L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "", 75, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_RANDOM_PAUSE_TABLE(56L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "", 76, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_RECEIVE_BLOCK_NR(57L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "", 77, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_HARDWARE_TYPE(58L, KnxPropertyDataType.PDT_GENERIC_06, "Hardware Type", 78, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_RETRANSMITTER_NUMBER(59L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "", 79, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_SERIAL_NR_TABLE(60L, KnxPropertyDataType.PDT_GENERIC_06, "", 80, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_BIBATMASTER_ADDRESS(61L, KnxPropertyDataType.PDT_UNSIGNED_INT, "", 81, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_RF_DOMAIN_ADDRESS(62L, KnxPropertyDataType.PDT_GENERIC_06, "RF Domain Address", 82, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_DEVICE_DESCRIPTOR(63L, KnxPropertyDataType.PDT_GENERIC_02, "", 83, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_METERING_FILTER_TABLE(64L, KnxPropertyDataType.PDT_GENERIC_08, "", 84, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_GROUP_TELEGR_RATE_LIMIT_TIME_BASE(65L, KnxPropertyDataType.PDT_UNSIGNED_INT, "", 85, KnxInterfaceObjectType.OT_DEVICE),
    PID_DEVICE_GROUP_TELEGR_RATE_LIMIT_NO_OF_TELEGR(66L, KnxPropertyDataType.PDT_UNSIGNED_INT, "", 86, KnxInterfaceObjectType.OT_DEVICE),
    PID_GROUP_OBJECT_TABLE_GRPOBJTABLE(67L, KnxPropertyDataType.PDT_GENERIC_06, "", 51, KnxInterfaceObjectType.OT_GROUP_OBJECT_TABLE),
    PID_GROUP_OBJECT_TABLE_EXT_GRPOBJREFERENCE(68L, KnxPropertyDataType.PDT_GENERIC_08, "", 52, KnxInterfaceObjectType.OT_GROUP_OBJECT_TABLE),
    PID_ROUTER_LINE_STATUS(69L, KnxPropertyDataType.PDT_GENERIC_01, "", 51, KnxInterfaceObjectType.OT_ROUTER),
    PID_ROUTER_MAIN_LCCONFIG(70L, KnxPropertyDataType.PDT_GENERIC_01, "", 52, KnxInterfaceObjectType.OT_ROUTER),
    PID_ROUTER_SUB_LCCONFIG(71L, KnxPropertyDataType.PDT_GENERIC_01, "", 53, KnxInterfaceObjectType.OT_ROUTER),
    PID_ROUTER_MAIN_LCGRPCONFIG(72L, KnxPropertyDataType.PDT_GENERIC_01, "", 54, KnxInterfaceObjectType.OT_ROUTER),
    PID_ROUTER_SUB_LCGRPCONFIG(73L, KnxPropertyDataType.PDT_GENERIC_01, "", 55, KnxInterfaceObjectType.OT_ROUTER),
    PID_ROUTER_ROUTETABLE_CONTROL(74L, KnxPropertyDataType.PDT_FUNCTION, "", 56, KnxInterfaceObjectType.OT_ROUTER),
    PID_ROUTER_COUPL_SERV_CONTROL(75L, KnxPropertyDataType.PDT_GENERIC_01, "", 57, KnxInterfaceObjectType.OT_ROUTER),
    PID_ROUTER_MAX_ROUTER_APDU_LENGTH(76L, KnxPropertyDataType.PDT_UNSIGNED_INT, "", 58, KnxInterfaceObjectType.OT_ROUTER),
    PID_ROUTER_MEDIUM(77L, KnxPropertyDataType.PDT_ENUM8, "", 63, KnxInterfaceObjectType.OT_ROUTER),
    PID_ROUTER_FILTER_TABLE_USE(78L, KnxPropertyDataType.PDT_BINARY_INFORMATION, "", 67, KnxInterfaceObjectType.OT_ROUTER),
    PID_ROUTER_RF_ENABLE_SBC(79L, KnxPropertyDataType.PDT_FUNCTION, "", 112, KnxInterfaceObjectType.OT_ROUTER),
    PID_KNXIP_PARAMETER_PROJECT_INSTALLATION_ID(80L, KnxPropertyDataType.PDT_UNSIGNED_INT, "Project Installation Identification", 51, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_KNX_INDIVIDUAL_ADDRESS(81L, KnxPropertyDataType.PDT_UNSIGNED_INT, "KNX Individual Address", 52, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_ADDITIONAL_INDIVIDUAL_ADDRESSES(82L, KnxPropertyDataType.PDT_UNSIGNED_INT, "Additional Individual Addresses", 53, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_CURRENT_IP_ASSIGNMENT_METHOD(83L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "", 54, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_IP_ASSIGNMENT_METHOD(84L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "", 55, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_IP_CAPABILITIES(85L, KnxPropertyDataType.PDT_BITSET8, "", 56, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_CURRENT_IP_ADDRESS(86L, KnxPropertyDataType.PDT_UNSIGNED_LONG, "", 57, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_CURRENT_SUBNET_MASK(87L, KnxPropertyDataType.PDT_UNSIGNED_LONG, "", 58, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_CURRENT_DEFAULT_GATEWAY(88L, KnxPropertyDataType.PDT_UNSIGNED_LONG, "", 59, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_IP_ADDRESS(89L, KnxPropertyDataType.PDT_UNSIGNED_LONG, "", 60, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_SUBNET_MASK(90L, KnxPropertyDataType.PDT_UNSIGNED_LONG, "", 61, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_DEFAULT_GATEWAY(91L, KnxPropertyDataType.PDT_UNSIGNED_LONG, "", 62, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_DHCP_BOOTP_SERVER(92L, KnxPropertyDataType.PDT_UNSIGNED_LONG, "", 63, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_MAC_ADDRESS(93L, KnxPropertyDataType.PDT_GENERIC_06, "", 64, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_SYSTEM_SETUP_MULTICAST_ADDRESS(94L, KnxPropertyDataType.PDT_UNSIGNED_LONG, "", 65, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_ROUTING_MULTICAST_ADDRESS(95L, KnxPropertyDataType.PDT_UNSIGNED_LONG, "", 66, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_TTL(96L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "", 67, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_KNXNETIP_DEVICE_CAPABILITIES(97L, KnxPropertyDataType.PDT_BITSET16, "", 68, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_KNXNETIP_DEVICE_STATE(98L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "", 69, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_KNXNETIP_ROUTING_CAPABILITIES(99L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "", 70, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_PRIORITY_FIFO_ENABLED(100L, KnxPropertyDataType.PDT_BINARY_INFORMATION, "", 71, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_QUEUE_OVERFLOW_TO_IP(101L, KnxPropertyDataType.PDT_UNSIGNED_INT, "", 72, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_QUEUE_OVERFLOW_TO_KNX(102L, KnxPropertyDataType.PDT_UNSIGNED_INT, "", 73, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_MSG_TRANSMIT_TO_IP(103L, KnxPropertyDataType.PDT_UNSIGNED_LONG, "", 74, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_MSG_TRANSMIT_TO_KNX(104L, KnxPropertyDataType.PDT_UNSIGNED_LONG, "", 75, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_FRIENDLY_NAME(105L, KnxPropertyDataType.PDT_UNSIGNED_CHAR, "", 76, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_BACKBONE_KEY(106L, KnxPropertyDataType.PDT_GENERIC_16, "", 91, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_DEVICE_AUTHENTICATION_CODE(107L, KnxPropertyDataType.PDT_GENERIC_16, "", 92, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_PASSWORD_HASHES(108L, KnxPropertyDataType.PDT_GENERIC_16, "", 93, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_SECURED_SERVICE_FAMILIES(109L, KnxPropertyDataType.PDT_FUNCTION, "", 94, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_MULTICAST_LATENCY_TOLERANCE(110L, KnxPropertyDataType.PDT_UNSIGNED_INT, "", 95, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_SYNC_LATENCY_FRACTION(111L, KnxPropertyDataType.PDT_SCALING, "", 96, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_KNXIP_PARAMETER_TUNNELLING_USERS(112L, KnxPropertyDataType.PDT_GENERIC_02, "", 97, KnxInterfaceObjectType.OT_KNXIP_PARAMETER),
    PID_SECURITY_SECURITY_MODE(113L, KnxPropertyDataType.PDT_FUNCTION, "", 51, KnxInterfaceObjectType.OT_SECURITY),
    PID_SECURITY_P2P_KEY_TABLE(114L, KnxPropertyDataType.PDT_GENERIC_18, "", 52, KnxInterfaceObjectType.OT_SECURITY),
    PID_SECURITY_GRP_KEY_TABLE(115L, KnxPropertyDataType.PDT_GENERIC_18, "", 53, KnxInterfaceObjectType.OT_SECURITY),
    PID_SECURITY_SECURITY_INDIVIDUAL_ADDRESS_TABLE(116L, KnxPropertyDataType.PDT_GENERIC_08, "", 54, KnxInterfaceObjectType.OT_SECURITY),
    PID_SECURITY_SECURITY_FAILURES_LOG(117L, KnxPropertyDataType.PDT_FUNCTION, "", 55, KnxInterfaceObjectType.OT_SECURITY),
    PID_SECURITY_SKI_TOOL(118L, KnxPropertyDataType.PDT_GENERIC_16, "", 56, KnxInterfaceObjectType.OT_SECURITY),
    PID_SECURITY_SECURITY_REPORT(119L, KnxPropertyDataType.PDT_BITSET8, "", 57, KnxInterfaceObjectType.OT_SECURITY),
    PID_SECURITY_SECURITY_REPORT_CONTROL(120L, KnxPropertyDataType.PDT_BINARY_INFORMATION, "", 58, KnxInterfaceObjectType.OT_SECURITY),
    PID_SECURITY_SEQUENCE_NUMBER_SENDING(121L, KnxPropertyDataType.PDT_GENERIC_06, "", 59, KnxInterfaceObjectType.OT_SECURITY),
    PID_SECURITY_ZONE_KEYS_TABLE(122L, KnxPropertyDataType.PDT_GENERIC_19, "", 60, KnxInterfaceObjectType.OT_SECURITY),
    PID_SECURITY_GO_SECURITY_FLAGS(123L, KnxPropertyDataType.PDT_GENERIC_01, "", 61, KnxInterfaceObjectType.OT_SECURITY),
    PID_RF_MEDIUM_RF_MULTI_TYPE(124L, KnxPropertyDataType.PDT_GENERIC_01, "", 51, KnxInterfaceObjectType.OT_RF_MEDIUM),
    PID_RF_MEDIUM_RF_DOMAIN_ADDRESS(125L, KnxPropertyDataType.PDT_GENERIC_06, "", 56, KnxInterfaceObjectType.OT_RF_MEDIUM),
    PID_RF_MEDIUM_RF_RETRANSMITTER(126L, KnxPropertyDataType.PDT_BINARY_INFORMATION, "", 57, KnxInterfaceObjectType.OT_RF_MEDIUM),
    PID_RF_MEDIUM_SECURITY_REPORT_CONTROL(127L, KnxPropertyDataType.PDT_BINARY_INFORMATION, "", 58, KnxInterfaceObjectType.OT_RF_MEDIUM),
    PID_RF_MEDIUM_RF_FILTERING_MODE_SELECT(128L, KnxPropertyDataType.PDT_BITSET8, "", 59, KnxInterfaceObjectType.OT_RF_MEDIUM),
    PID_RF_MEDIUM_RF_BIDIR_TIMEOUT(129L, KnxPropertyDataType.PDT_FUNCTION, "", 60, KnxInterfaceObjectType.OT_RF_MEDIUM),
    PID_RF_MEDIUM_RF_DIAG_SA_FILTER_TABLE(130L, KnxPropertyDataType.PDT_GENERIC_03, "", 61, KnxInterfaceObjectType.OT_RF_MEDIUM),
    PID_RF_MEDIUM_RF_DIAG_QUALITY_TABLE(131L, KnxPropertyDataType.PDT_GENERIC_04, "", 62, KnxInterfaceObjectType.OT_RF_MEDIUM),
    PID_RF_MEDIUM_RF_DIAG_PROBE(132L, KnxPropertyDataType.PDT_FUNCTION, "", 63, KnxInterfaceObjectType.OT_RF_MEDIUM),
    PID_INDOOR_BRIGHTNESS_SENSOR_CHANGE_OF_VALUE(133L, KnxPropertyDataType.PDT_UNKNOWN, "", 110, KnxInterfaceObjectType.OT_INDOOR_BRIGHTNESS_SENSOR),
    PID_INDOOR_BRIGHTNESS_SENSOR_REPETITION_TIME(134L, KnxPropertyDataType.PDT_UNKNOWN, "", 111, KnxInterfaceObjectType.OT_INDOOR_BRIGHTNESS_SENSOR),
    PID_INDOOR_LUMINANCE_SENSOR_CHANGE_OF_VALUE(135L, KnxPropertyDataType.PDT_UNKNOWN, "", 110, KnxInterfaceObjectType.OT_INDOOR_LUMINANCE_SENSOR),
    PID_INDOOR_LUMINANCE_SENSOR_REPETITION_TIME(136L, KnxPropertyDataType.PDT_UNKNOWN, "", 111, KnxInterfaceObjectType.OT_INDOOR_LUMINANCE_SENSOR),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_ON_DELAY(137L, KnxPropertyDataType.PDT_UNKNOWN, "", 101, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_OFF_DELAY(138L, KnxPropertyDataType.PDT_UNKNOWN, "", 102, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TIMED_ON_DURATION(139L, KnxPropertyDataType.PDT_UNKNOWN, "", 103, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_PREWARNING_DURATION(140L, KnxPropertyDataType.PDT_UNKNOWN, "", 104, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TRANSMISSION_CYCLE_TIME(141L, KnxPropertyDataType.PDT_UNKNOWN, "", 105, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BUS_POWER_UP_MESSAGE_DELAY(142L, KnxPropertyDataType.PDT_UNKNOWN, "", 106, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_AT_LOCKING(143L, KnxPropertyDataType.PDT_UNKNOWN, "", 107, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_AT_UNLOCKING(144L, KnxPropertyDataType.PDT_UNKNOWN, "", 108, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP(145L, KnxPropertyDataType.PDT_UNKNOWN, "", 109, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_DOWN(146L, KnxPropertyDataType.PDT_UNKNOWN, "", 110, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_INVERT_OUTPUT_STATE(147L, KnxPropertyDataType.PDT_UNKNOWN, "", 111, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TIMED_ON_RETRIGGER_FUNCTION(148L, KnxPropertyDataType.PDT_UNKNOWN, "", 112, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_MANUAL_OFF_ENABLE(149L, KnxPropertyDataType.PDT_UNKNOWN, "", 113, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_INVERT_LOCK_DEVICE(150L, KnxPropertyDataType.PDT_UNKNOWN, "", 114, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_LOCK_STATE(151L, KnxPropertyDataType.PDT_UNKNOWN, "", 115, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_UNLOCK_STATE(152L, KnxPropertyDataType.PDT_UNKNOWN, "", 116, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_STATE_FOR_SCENE_NUMBER(153L, KnxPropertyDataType.PDT_UNKNOWN, "", 117, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_STORAGE_FUNCTION_FOR_SCENE(154L, KnxPropertyDataType.PDT_UNKNOWN, "", 118, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BUS_POWER_UP_STATE(155L, KnxPropertyDataType.PDT_UNKNOWN, "", 119, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP_2(156L, KnxPropertyDataType.PDT_UNKNOWN, "", 120, KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_ON_DELAY(157L, KnxPropertyDataType.PDT_UNKNOWN, "", 101, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_OFF_DELAY(158L, KnxPropertyDataType.PDT_UNKNOWN, "", 102, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_SWITCH_OFF_BRIGHTNESS_DELAY_TIME(159L, KnxPropertyDataType.PDT_UNKNOWN, "", 103, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_TIMED_ON_DURATION(160L, KnxPropertyDataType.PDT_UNKNOWN, "", 104, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_PREWARNING_DURATION(161L, KnxPropertyDataType.PDT_UNKNOWN, "", 105, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_TRANSMISSION_CYCLE_TIME(162L, KnxPropertyDataType.PDT_UNKNOWN, "", 106, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_BUS_POWER_UP_MESSAGE_DELAY(163L, KnxPropertyDataType.PDT_UNKNOWN, "", 107, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED(164L, KnxPropertyDataType.PDT_UNKNOWN, "", 108, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME(165L, KnxPropertyDataType.PDT_UNKNOWN, "", 109, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED_FOR_SWITCH_ON_SET_VALUE(166L, KnxPropertyDataType.PDT_UNKNOWN, "", 110, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED_FOR_SWITCH_OFF(167L, KnxPropertyDataType.PDT_UNKNOWN, "", 111, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME_FOR_SWITCH_ON_SET_VALUE(168L, KnxPropertyDataType.PDT_UNKNOWN, "", 112, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME_FOR_SWITCH_OFF(169L, KnxPropertyDataType.PDT_UNKNOWN, "", 113, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_SWITCFH_OFF_BRIGHTNESS(170L, KnxPropertyDataType.PDT_UNKNOWN, "", 114, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_MINIMUM_SET_VALUE(171L, KnxPropertyDataType.PDT_UNKNOWN, "", 115, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_MAXIMUM_SET_VALUE(172L, KnxPropertyDataType.PDT_UNKNOWN, "", 116, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_SWITCH_ON_SET_VALUE(173L, KnxPropertyDataType.PDT_UNKNOWN, "", 117, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_DIMM_MODE_SELECTION(174L, KnxPropertyDataType.PDT_UNKNOWN, "", 118, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_RELATIV_OFF_ENABLE(175L, KnxPropertyDataType.PDT_UNKNOWN, "", 119, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_MEMORY_FUNCTION(176L, KnxPropertyDataType.PDT_UNKNOWN, "", 120, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_TIMED_ON_RETRIGGER_FUNCTION(177L, KnxPropertyDataType.PDT_UNKNOWN, "", 121, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_MANUAL_OFF_ENABLE(178L, KnxPropertyDataType.PDT_UNKNOWN, "", 122, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_INVERT_LOCK_DEVICE(179L, KnxPropertyDataType.PDT_UNKNOWN, "", 123, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_AT_LOCKING(180L, KnxPropertyDataType.PDT_UNKNOWN, "", 124, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_AT_UNLOCKING(181L, KnxPropertyDataType.PDT_UNKNOWN, "", 125, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_LOCK_SETVALUE(182L, KnxPropertyDataType.PDT_UNKNOWN, "", 126, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_UNLOCK_SETVALUE(183L, KnxPropertyDataType.PDT_UNKNOWN, "", 127, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_BIGHTNESS_FOR_SCENE(184L, KnxPropertyDataType.PDT_UNKNOWN, "", 128, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_STORAGE_FUNCTION_FOR_SCENE(185L, KnxPropertyDataType.PDT_UNKNOWN, "", 129, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_DELTA_DIMMING_VALUE(186L, KnxPropertyDataType.PDT_UNKNOWN, "", 130, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP(187L, KnxPropertyDataType.PDT_UNKNOWN, "", 131, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP_SET_VALUE(188L, KnxPropertyDataType.PDT_UNKNOWN, "", 132, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_DOWN(189L, KnxPropertyDataType.PDT_UNKNOWN, "", 133, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_ACTUATOR_BASIC_BUS_POWER_DOWN_SET_VALUE(190L, KnxPropertyDataType.PDT_UNKNOWN, "", 134, KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC),
    PID_DIMMING_SENSOR_BASIC_ON_OFF_ACTION(191L, KnxPropertyDataType.PDT_UNKNOWN, "", 51, KnxInterfaceObjectType.OT_DIMMING_SENSOR_BASIC),
    PID_DIMMING_SENSOR_BASIC_ENABLE_TOGGLE_MODE(192L, KnxPropertyDataType.PDT_UNKNOWN, "", 52, KnxInterfaceObjectType.OT_DIMMING_SENSOR_BASIC),
    PID_DIMMING_SENSOR_BASIC_ABSOLUTE_SETVALUE(193L, KnxPropertyDataType.PDT_UNKNOWN, "", 53, KnxInterfaceObjectType.OT_DIMMING_SENSOR_BASIC),
    PID_SWITCHING_SENSOR_BASIC_ON_OFF_ACTION(194L, KnxPropertyDataType.PDT_UNKNOWN, "", 51, KnxInterfaceObjectType.OT_SWITCHING_SENSOR_BASIC),
    PID_SWITCHING_SENSOR_BASIC_ENABLE_TOGGLE_MODE(195L, KnxPropertyDataType.PDT_UNKNOWN, "", 52, KnxInterfaceObjectType.OT_SWITCHING_SENSOR_BASIC),
    PID_SUNBLIND_ACTUATOR_BASIC_REVERSION_PAUSE_TIME(196L, KnxPropertyDataType.PDT_UNKNOWN, "", 51, KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
    PID_SUNBLIND_ACTUATOR_BASIC_MOVE_UP_DOWN_TIME(197L, KnxPropertyDataType.PDT_UNKNOWN, "", 52, KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
    PID_SUNBLIND_ACTUATOR_BASIC_SLAT_STEP_TIME(198L, KnxPropertyDataType.PDT_UNKNOWN, "", 53, KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
    PID_SUNBLIND_ACTUATOR_BASIC_MOVE_PRESET_POSITION_TIME(199L, KnxPropertyDataType.PDT_UNKNOWN, "", 54, KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
    PID_SUNBLIND_ACTUATOR_BASIC_MOVE_TO_PRESET_POSITION_IN_PERCENT(200L, KnxPropertyDataType.PDT_UNKNOWN, "", 55, KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
    PID_SUNBLIND_ACTUATOR_BASIC_MOVE_TO_PRESET_POSITION_LENGTH(201L, KnxPropertyDataType.PDT_UNKNOWN, "", 57, KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
    PID_SUNBLIND_ACTUATOR_BASIC_PRESET_SLAT_POSITION_PERCENT(202L, KnxPropertyDataType.PDT_UNKNOWN, "", 58, KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
    PID_SUNBLIND_ACTUATOR_BASIC_PRESET_SLAT_POSITION_ANGLE(203L, KnxPropertyDataType.PDT_UNKNOWN, "", 60, KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
    PID_SUNBLIND_ACTUATOR_BASIC_REACTION_WIND_ALARM(204L, KnxPropertyDataType.PDT_UNKNOWN, "", 61, KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
    PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_WIND_ALARM(205L, KnxPropertyDataType.PDT_UNKNOWN, "", 62, KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
    PID_SUNBLIND_ACTUATOR_BASIC_REACTION_ON_RAIN_ALARM(206L, KnxPropertyDataType.PDT_UNKNOWN, "", 63, KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
    PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_RAIN_ALARM(207L, KnxPropertyDataType.PDT_UNKNOWN, "", 64, KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
    PID_SUNBLIND_ACTUATOR_BASIC_REACTION_FROST_ALARM(208L, KnxPropertyDataType.PDT_UNKNOWN, "", 65, KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
    PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_FROST_ALARM(209L, KnxPropertyDataType.PDT_UNKNOWN, "", 66, KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
    PID_SUNBLIND_ACTUATOR_BASIC_MAX_SLAT_MOVE_TIME(210L, KnxPropertyDataType.PDT_UNKNOWN, "", 67, KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
    PID_SUNBLIND_ACTUATOR_BASIC_ENABLE_BLINDS_MODE(211L, KnxPropertyDataType.PDT_UNKNOWN, "", 68, KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
    PID_SUNBLIND_ACTUATOR_BASIC_STORAGE_FUNCTIONS_FOR_SCENE(212L, KnxPropertyDataType.PDT_UNKNOWN, "", 69, KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC),
    PID_SUNBLIND_SENSOR_BASIC_ENABLE_BLINDS_MODE(213L, KnxPropertyDataType.PDT_UNKNOWN, "", 51, KnxInterfaceObjectType.OT_SUNBLIND_SENSOR_BASIC),
    PID_SUNBLIND_SENSOR_BASIC_UP_DOWN_ACTION(214L, KnxPropertyDataType.PDT_UNKNOWN, "", 52, KnxInterfaceObjectType.OT_SUNBLIND_SENSOR_BASIC),
    PID_SUNBLIND_SENSOR_BASIC_ENABLE_TOGGLE_MODE(215L, KnxPropertyDataType.PDT_UNKNOWN, "", 53, KnxInterfaceObjectType.OT_SUNBLIND_SENSOR_BASIC);

    private static final Map<Long, KnxInterfaceObjectProperty> map;
    private final long value;
    private final KnxPropertyDataType propertyDataType;
    private final String name;
    private final short propertyId;
    private final KnxInterfaceObjectType objectType;

    static {
        map = new HashMap<Long, KnxInterfaceObjectProperty>();
        KnxInterfaceObjectProperty[] knxInterfaceObjectPropertyArray = KnxInterfaceObjectProperty.values();
        int n = knxInterfaceObjectPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnxInterfaceObjectProperty value = knxInterfaceObjectPropertyArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private KnxInterfaceObjectProperty(long value, KnxPropertyDataType propertyDataType, String name, short propertyId, KnxInterfaceObjectType objectType) {
        this.value = value;
        this.propertyDataType = propertyDataType;
        this.name = name;
        this.propertyId = propertyId;
        this.objectType = objectType;
    }

    public long getValue() {
        return this.value;
    }

    public KnxPropertyDataType getPropertyDataType() {
        return this.propertyDataType;
    }

    public static KnxInterfaceObjectProperty firstEnumForFieldPropertyDataType(KnxPropertyDataType fieldValue) {
        KnxInterfaceObjectProperty[] knxInterfaceObjectPropertyArray = KnxInterfaceObjectProperty.values();
        int n = knxInterfaceObjectPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnxInterfaceObjectProperty _val = knxInterfaceObjectPropertyArray[n2];
            if (_val.getPropertyDataType() == fieldValue) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<KnxInterfaceObjectProperty> enumsForFieldPropertyDataType(KnxPropertyDataType fieldValue) {
        ArrayList<KnxInterfaceObjectProperty> _values = new ArrayList<KnxInterfaceObjectProperty>();
        KnxInterfaceObjectProperty[] knxInterfaceObjectPropertyArray = KnxInterfaceObjectProperty.values();
        int n = knxInterfaceObjectPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnxInterfaceObjectProperty _val = knxInterfaceObjectPropertyArray[n2];
            if (_val.getPropertyDataType() == fieldValue) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public String getName() {
        return this.name;
    }

    public static KnxInterfaceObjectProperty firstEnumForFieldName(String fieldValue) {
        KnxInterfaceObjectProperty[] knxInterfaceObjectPropertyArray = KnxInterfaceObjectProperty.values();
        int n = knxInterfaceObjectPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnxInterfaceObjectProperty _val = knxInterfaceObjectPropertyArray[n2];
            if (_val.getName().equals(fieldValue)) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<KnxInterfaceObjectProperty> enumsForFieldName(String fieldValue) {
        ArrayList<KnxInterfaceObjectProperty> _values = new ArrayList<KnxInterfaceObjectProperty>();
        KnxInterfaceObjectProperty[] knxInterfaceObjectPropertyArray = KnxInterfaceObjectProperty.values();
        int n = knxInterfaceObjectPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnxInterfaceObjectProperty _val = knxInterfaceObjectPropertyArray[n2];
            if (_val.getName().equals(fieldValue)) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public short getPropertyId() {
        return this.propertyId;
    }

    public static KnxInterfaceObjectProperty firstEnumForFieldPropertyId(short fieldValue) {
        KnxInterfaceObjectProperty[] knxInterfaceObjectPropertyArray = KnxInterfaceObjectProperty.values();
        int n = knxInterfaceObjectPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnxInterfaceObjectProperty _val = knxInterfaceObjectPropertyArray[n2];
            if (_val.getPropertyId() == fieldValue) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<KnxInterfaceObjectProperty> enumsForFieldPropertyId(short fieldValue) {
        ArrayList<KnxInterfaceObjectProperty> _values = new ArrayList<KnxInterfaceObjectProperty>();
        KnxInterfaceObjectProperty[] knxInterfaceObjectPropertyArray = KnxInterfaceObjectProperty.values();
        int n = knxInterfaceObjectPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnxInterfaceObjectProperty _val = knxInterfaceObjectPropertyArray[n2];
            if (_val.getPropertyId() == fieldValue) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public KnxInterfaceObjectType getObjectType() {
        return this.objectType;
    }

    public static KnxInterfaceObjectProperty firstEnumForFieldObjectType(KnxInterfaceObjectType fieldValue) {
        KnxInterfaceObjectProperty[] knxInterfaceObjectPropertyArray = KnxInterfaceObjectProperty.values();
        int n = knxInterfaceObjectPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnxInterfaceObjectProperty _val = knxInterfaceObjectPropertyArray[n2];
            if (_val.getObjectType() == fieldValue) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<KnxInterfaceObjectProperty> enumsForFieldObjectType(KnxInterfaceObjectType fieldValue) {
        ArrayList<KnxInterfaceObjectProperty> _values = new ArrayList<KnxInterfaceObjectProperty>();
        KnxInterfaceObjectProperty[] knxInterfaceObjectPropertyArray = KnxInterfaceObjectProperty.values();
        int n = knxInterfaceObjectPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnxInterfaceObjectProperty _val = knxInterfaceObjectPropertyArray[n2];
            if (_val.getObjectType() == fieldValue) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public static KnxInterfaceObjectProperty enumForValue(long value) {
        return map.get(value);
    }

    public static Boolean isDefined(long value) {
        return map.containsKey(value);
    }
}

