/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.plc4x.java.knxnetip.readwrite.KnxDatapointMainType;

public enum KnxDatapointType {
    DPT_UNKNOWN(0L, 0, "Unknown Datapoint Subtype", KnxDatapointMainType.DPT_UNKNOWN),
    BOOL(1L, 0, "BOOL", KnxDatapointMainType.DPT_1_BIT),
    BYTE(2L, 0, "BYTE", KnxDatapointMainType.DPT_8_BIT_SET),
    WORD(3L, 0, "WORD", KnxDatapointMainType.DPT_16_BIT_SET),
    DWORD(4L, 0, "DWORD", KnxDatapointMainType.DPT_32_BIT_SET),
    LWORD(5L, 0, "LWORD", KnxDatapointMainType.DPT_64_BIT_SET),
    USINT(6L, 0, "USINT", KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
    SINT(7L, 0, "SINT", KnxDatapointMainType.DPT_8_BIT_SIGNED_VALUE),
    UINT(8L, 0, "UINT", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
    INT(9L, 0, "INT", KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
    UDINT(10L, 0, "UDINT", KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
    DINT(11L, 0, "DINT", KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
    ULINT(12L, 0, "ULINT", KnxDatapointMainType.DPT_8_BYTE_UNSIGNED_VALUE),
    LINT(13L, 0, "LINT", KnxDatapointMainType.DPT_8_BYTE_SIGNED_VALUE),
    REAL(14L, 0, "REAL", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    LREAL(15L, 0, "LREAL", KnxDatapointMainType.DPT_8_BYTE_FLOAT_VALUE),
    CHAR(16L, 0, "CHAR", KnxDatapointMainType.DPT_CHARACTER),
    WCHAR(17L, 0, "WCHAR", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
    STRING(18L, 0, "STRING", KnxDatapointMainType.DPT_UNKNOWN),
    WSTRING(19L, 0, "WSTRING", KnxDatapointMainType.DPT_UNKNOWN),
    TIME(20L, 0, "TIME", KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
    LTIME(21L, 0, "LTIME", KnxDatapointMainType.DPT_8_BYTE_UNSIGNED_VALUE),
    DATE(22L, 0, "DATE", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
    TIME_OF_DAY(23L, 0, "TIME_OF_DAY", KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
    TOD(24L, 0, "TOD", KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
    DATE_AND_TIME(25L, 0, "DATE_AND_TIME", KnxDatapointMainType.DPT_12_BYTE_SIGNED_VALUE),
    DT(26L, 0, "DT", KnxDatapointMainType.DPT_12_BYTE_SIGNED_VALUE),
    DPT_Switch(27L, 1, "switch", KnxDatapointMainType.DPT_1_BIT),
    DPT_Bool(28L, 2, "boolean", KnxDatapointMainType.DPT_1_BIT),
    DPT_Enable(29L, 3, "enable", KnxDatapointMainType.DPT_1_BIT),
    DPT_Ramp(30L, 4, "ramp", KnxDatapointMainType.DPT_1_BIT),
    DPT_Alarm(31L, 5, "alarm", KnxDatapointMainType.DPT_1_BIT),
    DPT_BinaryValue(32L, 6, "binary value", KnxDatapointMainType.DPT_1_BIT),
    DPT_Step(33L, 7, "step", KnxDatapointMainType.DPT_1_BIT),
    DPT_UpDown(34L, 8, "up/down", KnxDatapointMainType.DPT_1_BIT),
    DPT_OpenClose(35L, 9, "open/close", KnxDatapointMainType.DPT_1_BIT),
    DPT_Start(36L, 10, "start/stop", KnxDatapointMainType.DPT_1_BIT),
    DPT_State(37L, 11, "state", KnxDatapointMainType.DPT_1_BIT),
    DPT_Invert(38L, 12, "invert", KnxDatapointMainType.DPT_1_BIT),
    DPT_DimSendStyle(39L, 13, "dim send style", KnxDatapointMainType.DPT_1_BIT),
    DPT_InputSource(40L, 14, "input source", KnxDatapointMainType.DPT_1_BIT),
    DPT_Reset(41L, 15, "reset", KnxDatapointMainType.DPT_1_BIT),
    DPT_Ack(42L, 16, "acknowledge", KnxDatapointMainType.DPT_1_BIT),
    DPT_Trigger(43L, 17, "trigger", KnxDatapointMainType.DPT_1_BIT),
    DPT_Occupancy(44L, 18, "occupancy", KnxDatapointMainType.DPT_1_BIT),
    DPT_Window_Door(45L, 19, "window/door", KnxDatapointMainType.DPT_1_BIT),
    DPT_LogicalFunction(46L, 21, "logical function", KnxDatapointMainType.DPT_1_BIT),
    DPT_Scene_AB(47L, 22, "scene", KnxDatapointMainType.DPT_1_BIT),
    DPT_ShutterBlinds_Mode(48L, 23, "shutter/blinds mode", KnxDatapointMainType.DPT_1_BIT),
    DPT_DayNight(49L, 24, "day/night", KnxDatapointMainType.DPT_1_BIT),
    DPT_Heat_Cool(50L, 100, "cooling/heating", KnxDatapointMainType.DPT_1_BIT),
    DPT_Switch_Control(51L, 1, "switch control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
    DPT_Bool_Control(52L, 2, "boolean control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
    DPT_Enable_Control(53L, 3, "enable control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
    DPT_Ramp_Control(54L, 4, "ramp control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
    DPT_Alarm_Control(55L, 5, "alarm control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
    DPT_BinaryValue_Control(56L, 6, "binary value control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
    DPT_Step_Control(57L, 7, "step control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
    DPT_Direction1_Control(58L, 8, "direction control 1", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
    DPT_Direction2_Control(59L, 9, "direction control 2", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
    DPT_Start_Control(60L, 10, "start control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
    DPT_State_Control(61L, 11, "state control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
    DPT_Invert_Control(62L, 12, "invert control", KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
    DPT_Control_Dimming(63L, 7, "dimming control", KnxDatapointMainType.DPT_3_BIT_CONTROLLED),
    DPT_Control_Blinds(64L, 8, "blind control", KnxDatapointMainType.DPT_3_BIT_CONTROLLED),
    DPT_Char_ASCII(65L, 1, "character (ASCII)", KnxDatapointMainType.DPT_CHARACTER),
    DPT_Char_8859_1(66L, 2, "character (ISO 8859-1)", KnxDatapointMainType.DPT_CHARACTER),
    DPT_Scaling(67L, 1, "percentage (0..100%)", KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
    DPT_Angle(68L, 3, "angle (degrees)", KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
    DPT_Percent_U8(69L, 4, "percentage (0..255%)", KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
    DPT_DecimalFactor(70L, 5, "ratio (0..255)", KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
    DPT_Tariff(71L, 6, "tariff (0..255)", KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
    DPT_Value_1_Ucount(72L, 10, "counter pulses (0..255)", KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
    DPT_FanStage(73L, 100, "fan stage (0..255)", KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
    DPT_Percent_V8(74L, 1, "percentage (-128..127%)", KnxDatapointMainType.DPT_8_BIT_SIGNED_VALUE),
    DPT_Value_1_Count(75L, 10, "counter pulses (-128..127)", KnxDatapointMainType.DPT_8_BIT_SIGNED_VALUE),
    DPT_Status_Mode3(76L, 20, "status with mode", KnxDatapointMainType.DPT_8_BIT_SIGNED_VALUE),
    DPT_Value_2_Ucount(77L, 1, "pulses", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
    DPT_TimePeriodMsec(78L, 2, "time (ms)", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
    DPT_TimePeriod10Msec(79L, 3, "time (10 ms)", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
    DPT_TimePeriod100Msec(80L, 4, "time (100 ms)", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
    DPT_TimePeriodSec(81L, 5, "time (s)", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
    DPT_TimePeriodMin(82L, 6, "time (min)", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
    DPT_TimePeriodHrs(83L, 7, "time (h)", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
    DPT_PropDataType(84L, 10, "property data type", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
    DPT_Length_mm(85L, 11, "length (mm)", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
    DPT_UElCurrentmA(86L, 12, "current (mA)", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
    DPT_Brightness(87L, 13, "brightness (lux)", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
    DPT_Absolute_Colour_Temperature(88L, 600, "absolute colour temperature (K)", KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
    DPT_Value_2_Count(89L, 1, "pulses difference", KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
    DPT_DeltaTimeMsec(90L, 2, "time lag (ms)", KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
    DPT_DeltaTime10Msec(91L, 3, "time lag(10 ms)", KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
    DPT_DeltaTime100Msec(92L, 4, "time lag (100 ms)", KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
    DPT_DeltaTimeSec(93L, 5, "time lag (s)", KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
    DPT_DeltaTimeMin(94L, 6, "time lag (min)", KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
    DPT_DeltaTimeHrs(95L, 7, "time lag (h)", KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
    DPT_Percent_V16(96L, 10, "percentage difference (%)", KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
    DPT_Rotation_Angle(97L, 11, "rotation angle (\u00b0)", KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
    DPT_Length_m(98L, 12, "length (m)", KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
    DPT_Value_Temp(99L, 1, "temperature (\u00b0C)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Value_Tempd(100L, 2, "temperature difference (K)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Value_Tempa(101L, 3, "kelvin/hour (K/h)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Value_Lux(102L, 4, "lux (Lux)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Value_Wsp(103L, 5, "speed (m/s)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Value_Pres(104L, 6, "pressure (Pa)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Value_Humidity(105L, 7, "humidity (%)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Value_AirQuality(106L, 8, "parts/million (ppm)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Value_AirFlow(107L, 9, "air flow (m\u00b3/h)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Value_Time1(108L, 10, "time (s)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Value_Time2(109L, 11, "time (ms)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Value_Volt(110L, 20, "voltage (mV)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Value_Curr(111L, 21, "current (mA)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_PowerDensity(112L, 22, "power density (W/m\u00b2)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_KelvinPerPercent(113L, 23, "kelvin/percent (K/%)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Power(114L, 24, "power (kW)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Value_Volume_Flow(115L, 25, "volume flow (l/h)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Rain_Amount(116L, 26, "rain amount (l/m\u00b2)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Value_Temp_F(117L, 27, "temperature (\u00b0F)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Value_Wsp_kmh(118L, 28, "wind speed (km/h)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Value_Absolute_Humidity(119L, 29, "absolute humidity (g/m\u00b3)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Concentration_ygm3(120L, 30, "concentration (\u00b5g/m\u00b3)", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_Coefficient(121L, 31, "coefficient", KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
    DPT_TimeOfDay(122L, 1, "time of day", KnxDatapointMainType.DPT_TIME),
    DPT_Date(123L, 1, "date", KnxDatapointMainType.DPT_DATE),
    DPT_Value_4_Ucount(124L, 1, "counter pulses (unsigned)", KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
    DPT_LongTimePeriod_Sec(125L, 100, "counter timesec (s)", KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
    DPT_LongTimePeriod_Min(126L, 101, "counter timemin (min)", KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
    DPT_LongTimePeriod_Hrs(127L, 102, "counter timehrs (h)", KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
    DPT_VolumeLiquid_Litre(128L, 1200, "volume liquid (l)", KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
    DPT_Volume_m_3(129L, 1201, "volume (m\u00b3)", KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
    DPT_Value_4_Count(130L, 1, "counter pulses (signed)", KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
    DPT_FlowRate_m3h(131L, 2, "flow rate (m\u00b3/h)", KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
    DPT_ActiveEnergy(132L, 10, "active energy (Wh)", KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
    DPT_ApparantEnergy(133L, 11, "apparant energy (VAh)", KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
    DPT_ReactiveEnergy(134L, 12, "reactive energy (VARh)", KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
    DPT_ActiveEnergy_kWh(135L, 13, "active energy (kWh)", KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
    DPT_ApparantEnergy_kVAh(136L, 14, "apparant energy (kVAh)", KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
    DPT_ReactiveEnergy_kVARh(137L, 15, "reactive energy (kVARh)", KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
    DPT_ActiveEnergy_MWh(138L, 16, "active energy (MWh)", KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
    DPT_LongDeltaTimeSec(139L, 100, "time lag (s)", KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
    DPT_DeltaVolumeLiquid_Litre(140L, 1200, "delta volume liquid (l)", KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
    DPT_DeltaVolume_m_3(141L, 1201, "delta volume (m\u00b3)", KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
    DPT_Value_Acceleration(142L, 0, "acceleration (m/s\u00b2)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Acceleration_Angular(143L, 1, "angular acceleration (rad/s\u00b2)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Activation_Energy(144L, 2, "activation energy (J/mol)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Activity(145L, 3, "radioactive activity (1/s)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Mol(146L, 4, "amount of substance (mol)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Amplitude(147L, 5, "amplitude", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_AngleRad(148L, 6, "angle (radiant)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_AngleDeg(149L, 7, "angle (degree)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Angular_Momentum(150L, 8, "angular momentum (Js)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Angular_Velocity(151L, 9, "angular velocity (rad/s)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Area(152L, 10, "area (m*m)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Capacitance(153L, 11, "capacitance (F)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Charge_DensitySurface(154L, 12, "flux density (C/m\u00b2)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Charge_DensityVolume(155L, 13, "charge density (C/m\u00b3)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Compressibility(156L, 14, "compressibility (m\u00b2/N)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Conductance(157L, 15, "conductance (S)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Electrical_Conductivity(158L, 16, "conductivity (S/m)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Density(159L, 17, "density (kg/m\u00b3)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Electric_Charge(160L, 18, "electric charge (C)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Electric_Current(161L, 19, "electric current (A)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Electric_CurrentDensity(162L, 20, "electric current density (A/m\u00b2)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Electric_DipoleMoment(163L, 21, "electric dipole moment (Cm)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Electric_Displacement(164L, 22, "electric displacement (C/m\u00b2)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Electric_FieldStrength(165L, 23, "electric field strength (V/m)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Electric_Flux(166L, 24, "electric flux (C)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Electric_FluxDensity(167L, 25, "electric flux density (C/m\u00b2)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Electric_Polarization(168L, 26, "electric polarization (C/m\u00b2)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Electric_Potential(169L, 27, "electric potential (V)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Electric_PotentialDifference(170L, 28, "electric potential difference (V)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_ElectromagneticMoment(171L, 29, "electromagnetic moment (Am\u00b2)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Electromotive_Force(172L, 30, "electromotive force (V)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Energy(173L, 31, "energy (J)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Force(174L, 32, "force (N)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Frequency(175L, 33, "frequency (Hz)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Angular_Frequency(176L, 34, "angular frequency (rad/s)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Heat_Capacity(177L, 35, "heat capacity (J/K)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Heat_FlowRate(178L, 36, "heat flow rate (W)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Heat_Quantity(179L, 37, "heat quantity", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Impedance(180L, 38, "impedance (\u03a9)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Length(181L, 39, "length (m)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Light_Quantity(182L, 40, "light quantity (J)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Luminance(183L, 41, "luminance (cd/m\u00b2)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Luminous_Flux(184L, 42, "luminous flux (lm)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Luminous_Intensity(185L, 43, "luminous intensity (cd)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Magnetic_FieldStrength(186L, 44, "magnetic field strength (A/m)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Magnetic_Flux(187L, 45, "magnetic flux (Wb)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Magnetic_FluxDensity(188L, 46, "magnetic flux density (T)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Magnetic_Moment(189L, 47, "magnetic moment (Am\u00b2)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Magnetic_Polarization(190L, 48, "magnetic polarization (T)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Magnetization(191L, 49, "magnetization (A/m)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_MagnetomotiveForce(192L, 50, "magnetomotive force (A)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Mass(193L, 51, "mass (kg)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_MassFlux(194L, 52, "mass flux (kg/s)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Momentum(195L, 53, "momentum (N/s)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Phase_AngleRad(196L, 54, "phase angle (rad)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Phase_AngleDeg(197L, 55, "phase angle (\u00b0)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Power(198L, 56, "power (W)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Power_Factor(199L, 57, "power factor (cos \u03a6)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Pressure(200L, 58, "pressure (Pa)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Reactance(201L, 59, "reactance (\u03a9)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Resistance(202L, 60, "resistance (\u03a9)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Resistivity(203L, 61, "resistivity (\u03a9m)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_SelfInductance(204L, 62, "self inductance (H)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_SolidAngle(205L, 63, "solid angle (sr)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Sound_Intensity(206L, 64, "sound intensity (W/m\u00b2)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Speed(207L, 65, "speed (m/s)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Stress(208L, 66, "stress (Pa)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Surface_Tension(209L, 67, "surface tension (N/m)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Common_Temperature(210L, 68, "temperature (\u00b0C)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Absolute_Temperature(211L, 69, "temperature absolute (K)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_TemperatureDifference(212L, 70, "temperature difference (K)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Thermal_Capacity(213L, 71, "thermal capacity (J/K)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Thermal_Conductivity(214L, 72, "thermal conductivity (W/mK)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_ThermoelectricPower(215L, 73, "thermoelectric power (V/K)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Time(216L, 74, "time (s)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Torque(217L, 75, "torque (Nm)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Volume(218L, 76, "volume (m\u00b3)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Volume_Flux(219L, 77, "volume flux (m\u00b3/s)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Weight(220L, 78, "weight (N)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_Work(221L, 79, "work (J)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Value_ApparentPower(222L, 80, "apparent power (VA)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Volume_Flux_Meter(223L, 1200, "volume flux for meters (m\u00b3/h)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Volume_Flux_ls(224L, 1201, "volume flux for meters (1/ls)", KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
    DPT_Access_Data(225L, 0, "entrance access", KnxDatapointMainType.DPT_ENTRANCE_ACCESS),
    DPT_String_ASCII(226L, 0, "Character String (ASCII)", KnxDatapointMainType.DPT_CHARACTER_STRING),
    DPT_String_8859_1(227L, 1, "Character String (ISO 8859-1)", KnxDatapointMainType.DPT_CHARACTER_STRING),
    DPT_SceneNumber(228L, 1, "scene number", KnxDatapointMainType.DPT_SCENE_NUMBER),
    DPT_SceneControl(229L, 1, "scene control", KnxDatapointMainType.DPT_SCENE_CONTROL),
    DPT_DateTime(230L, 1, "date time", KnxDatapointMainType.DPT_DATE_TIME),
    DPT_SCLOMode(231L, 1, "SCLO mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_BuildingMode(232L, 2, "building mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_OccMode(233L, 3, "occupied", KnxDatapointMainType.DPT_1_BYTE),
    DPT_Priority(234L, 4, "priority", KnxDatapointMainType.DPT_1_BYTE),
    DPT_LightApplicationMode(235L, 5, "light application mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_ApplicationArea(236L, 6, "light application area", KnxDatapointMainType.DPT_1_BYTE),
    DPT_AlarmClassType(237L, 7, "alarm class", KnxDatapointMainType.DPT_1_BYTE),
    DPT_PSUMode(238L, 8, "PSU mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_ErrorClass_System(239L, 11, "system error class", KnxDatapointMainType.DPT_1_BYTE),
    DPT_ErrorClass_HVAC(240L, 12, "HVAC error class", KnxDatapointMainType.DPT_1_BYTE),
    DPT_Time_Delay(241L, 13, "time delay", KnxDatapointMainType.DPT_1_BYTE),
    DPT_Beaufort_Wind_Force_Scale(242L, 14, "wind force scale (0..12)", KnxDatapointMainType.DPT_1_BYTE),
    DPT_SensorSelect(243L, 17, "sensor mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_ActuatorConnectType(244L, 20, "actuator connect type", KnxDatapointMainType.DPT_1_BYTE),
    DPT_Cloud_Cover(245L, 21, "cloud cover", KnxDatapointMainType.DPT_1_BYTE),
    DPT_PowerReturnMode(246L, 22, "power return mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_FuelType(247L, 100, "fuel type", KnxDatapointMainType.DPT_1_BYTE),
    DPT_BurnerType(248L, 101, "burner type", KnxDatapointMainType.DPT_1_BYTE),
    DPT_HVACMode(249L, 102, "HVAC mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_DHWMode(250L, 103, "DHW mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_LoadPriority(251L, 104, "load priority", KnxDatapointMainType.DPT_1_BYTE),
    DPT_HVACContrMode(252L, 105, "HVAC control mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_HVACEmergMode(253L, 106, "HVAC emergency mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_ChangeoverMode(254L, 107, "changeover mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_ValveMode(255L, 108, "valve mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_DamperMode(256L, 109, "damper mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_HeaterMode(257L, 110, "heater mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_FanMode(258L, 111, "fan mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_MasterSlaveMode(259L, 112, "master/slave mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_StatusRoomSetp(260L, 113, "status room setpoint", KnxDatapointMainType.DPT_1_BYTE),
    DPT_Metering_DeviceType(261L, 114, "metering device type", KnxDatapointMainType.DPT_1_BYTE),
    DPT_HumDehumMode(262L, 115, "hum dehum mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_EnableHCStage(263L, 116, "enable H/C stage", KnxDatapointMainType.DPT_1_BYTE),
    DPT_ADAType(264L, 120, "ADA type", KnxDatapointMainType.DPT_1_BYTE),
    DPT_BackupMode(265L, 121, "backup mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_StartSynchronization(266L, 122, "start syncronization type", KnxDatapointMainType.DPT_1_BYTE),
    DPT_Behaviour_Lock_Unlock(267L, 600, "behavior lock/unlock", KnxDatapointMainType.DPT_1_BYTE),
    DPT_Behaviour_Bus_Power_Up_Down(268L, 601, "behavior bus power up/down", KnxDatapointMainType.DPT_1_BYTE),
    DPT_DALI_Fade_Time(269L, 602, "dali fade time", KnxDatapointMainType.DPT_1_BYTE),
    DPT_BlinkingMode(270L, 603, "blink mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_LightControlMode(271L, 604, "light control mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_SwitchPBModel(272L, 605, "PB switch mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_PBAction(273L, 606, "PB action mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_DimmPBModel(274L, 607, "PB dimm mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_SwitchOnMode(275L, 608, "switch on mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_LoadTypeSet(276L, 609, "load type", KnxDatapointMainType.DPT_1_BYTE),
    DPT_LoadTypeDetected(277L, 610, "load type detection", KnxDatapointMainType.DPT_1_BYTE),
    DPT_Converter_Test_Control(278L, 611, "converter test control", KnxDatapointMainType.DPT_1_BYTE),
    DPT_SABExcept_Behaviour(279L, 801, "SAB except behavior", KnxDatapointMainType.DPT_1_BYTE),
    DPT_SABBehaviour_Lock_Unlock(280L, 802, "SAB behavior on lock/unlock", KnxDatapointMainType.DPT_1_BYTE),
    DPT_SSSBMode(281L, 803, "SSSB mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_BlindsControlMode(282L, 804, "blinds control mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_CommMode(283L, 1000, "communication mode", KnxDatapointMainType.DPT_1_BYTE),
    DPT_AddInfoTypes(284L, 1001, "additional information type", KnxDatapointMainType.DPT_1_BYTE),
    DPT_RF_ModeSelect(285L, 1002, "RF mode selection", KnxDatapointMainType.DPT_1_BYTE),
    DPT_RF_FilterSelect(286L, 1003, "RF filter mode selection", KnxDatapointMainType.DPT_1_BYTE),
    DPT_StatusGen(287L, 1, "general status", KnxDatapointMainType.DPT_8_BIT_SET),
    DPT_Device_Control(288L, 2, "device control", KnxDatapointMainType.DPT_8_BIT_SET),
    DPT_ForceSign(289L, 100, "forcing signal", KnxDatapointMainType.DPT_8_BIT_SET),
    DPT_ForceSignCool(290L, 101, "forcing signal cool", KnxDatapointMainType.DPT_8_BIT_SET),
    DPT_StatusRHC(291L, 102, "room heating controller status", KnxDatapointMainType.DPT_8_BIT_SET),
    DPT_StatusSDHWC(292L, 103, "solar DHW controller status", KnxDatapointMainType.DPT_8_BIT_SET),
    DPT_FuelTypeSet(293L, 104, "fuel type set", KnxDatapointMainType.DPT_8_BIT_SET),
    DPT_StatusRCC(294L, 105, "room cooling controller status", KnxDatapointMainType.DPT_8_BIT_SET),
    DPT_StatusAHU(295L, 106, "ventilation controller status", KnxDatapointMainType.DPT_8_BIT_SET),
    DPT_CombinedStatus_RTSM(296L, 107, "combined status RTSM", KnxDatapointMainType.DPT_8_BIT_SET),
    DPT_LightActuatorErrorInfo(297L, 601, "lighting actuator error information", KnxDatapointMainType.DPT_8_BIT_SET),
    DPT_RF_ModeInfo(298L, 1000, "RF communication mode info", KnxDatapointMainType.DPT_8_BIT_SET),
    DPT_RF_FilterInfo(299L, 1001, "cEMI server supported RF filtering modes", KnxDatapointMainType.DPT_8_BIT_SET),
    DPT_Channel_Activation_8(300L, 1010, "channel activation for 8 channels", KnxDatapointMainType.DPT_8_BIT_SET),
    DPT_StatusDHWC(301L, 100, "DHW controller status", KnxDatapointMainType.DPT_16_BIT_SET),
    DPT_StatusRHCC(302L, 101, "RHCC status", KnxDatapointMainType.DPT_16_BIT_SET),
    DPT_CombinedStatus_HVA(303L, 102, "combined status HVA", KnxDatapointMainType.DPT_16_BIT_SET),
    DPT_CombinedStatus_RTC(304L, 103, "combined status RTC", KnxDatapointMainType.DPT_16_BIT_SET),
    DPT_Media(305L, 1000, "media", KnxDatapointMainType.DPT_16_BIT_SET),
    DPT_Channel_Activation_16(306L, 1010, "channel activation for 16 channels", KnxDatapointMainType.DPT_16_BIT_SET),
    DPT_OnOffAction(307L, 1, "on/off action", KnxDatapointMainType.DPT_2_BIT_SET),
    DPT_Alarm_Reaction(308L, 2, "alarm reaction", KnxDatapointMainType.DPT_2_BIT_SET),
    DPT_UpDown_Action(309L, 3, "up/down action", KnxDatapointMainType.DPT_2_BIT_SET),
    DPT_HVAC_PB_Action(310L, 102, "HVAC push button action", KnxDatapointMainType.DPT_2_BIT_SET),
    DPT_DoubleNibble(311L, 1000, "busy/nak repetitions", KnxDatapointMainType.DPT_2_NIBBLE_SET),
    DPT_SceneInfo(312L, 1, "scene information", KnxDatapointMainType.DPT_8_BIT_SET_2),
    DPT_CombinedInfoOnOff(313L, 1, "bit-combined info on/off", KnxDatapointMainType.DPT_32_BIT_SET),
    DPT_ActiveEnergy_V64(314L, 10, "active energy (Wh)", KnxDatapointMainType.DPT_ELECTRICAL_ENERGY),
    DPT_ApparantEnergy_V64(315L, 11, "apparant energy (VAh)", KnxDatapointMainType.DPT_ELECTRICAL_ENERGY),
    DPT_ReactiveEnergy_V64(316L, 12, "reactive energy (VARh)", KnxDatapointMainType.DPT_ELECTRICAL_ENERGY),
    DPT_Channel_Activation_24(317L, 1010, "activation state 0..23", KnxDatapointMainType.DPT_24_TIMES_CHANNEL_ACTIVATION),
    DPT_HVACModeNext(318L, 100, "time delay & HVAC mode", KnxDatapointMainType.DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM),
    DPT_DHWModeNext(319L, 102, "time delay & DHW mode", KnxDatapointMainType.DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM),
    DPT_OccModeNext(320L, 104, "time delay & occupancy mode", KnxDatapointMainType.DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM),
    DPT_BuildingModeNext(321L, 105, "time delay & building mode", KnxDatapointMainType.DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM),
    DPT_StatusLightingActuator(322L, 600, "Status Lighting Actuator", KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM),
    DPT_Version(323L, 1, "DPT version", KnxDatapointMainType.DPT_DATAPOINT_TYPE_VERSION),
    DPT_AlarmInfo(324L, 1, "alarm info", KnxDatapointMainType.DPT_ALARM_INFO),
    DPT_TempRoomSetpSetF16_3(325L, 100, "room temperature setpoint", KnxDatapointMainType.DPT_3X_2_BYTE_FLOAT_VALUE),
    DPT_TempRoomSetpSetShiftF16_3(326L, 101, "room temperature setpoint shift", KnxDatapointMainType.DPT_3X_2_BYTE_FLOAT_VALUE),
    DPT_Scaling_Speed(327L, 1, "scaling speed", KnxDatapointMainType.DPT_SCALING_SPEED),
    DPT_Scaling_Step_Time(328L, 2, "scaling step time", KnxDatapointMainType.DPT_SCALING_SPEED),
    DPT_MeteringValue(329L, 1, "metering value (value,encoding,cmd)", KnxDatapointMainType.DPT_4_1_1_BYTE_COMBINED_INFORMATION),
    DPT_MBus_Address(330L, 1000, "MBus address", KnxDatapointMainType.DPT_MBUS_ADDRESS),
    DPT_Colour_RGB(331L, 600, "RGB value 3x(0..255)", KnxDatapointMainType.DPT_3_BYTE_COLOUR_RGB),
    DPT_LanguageCodeAlpha2_ASCII(332L, 1, "language code (ASCII)", KnxDatapointMainType.DPT_LANGUAGE_CODE_ISO_639_1),
    DPT_Tariff_ActiveEnergy(333L, 1, "electrical energy with tariff", KnxDatapointMainType.DPT_SIGNED_VALUE_WITH_CLASSIFICATION_AND_VALIDITY),
    DPT_Prioritised_Mode_Control(334L, 1, "priority control", KnxDatapointMainType.DPT_PRIORITISED_MODE_CONTROL),
    DPT_DALI_Control_Gear_Diagnostic(335L, 600, "diagnostic value", KnxDatapointMainType.DPT_CONFIGURATION_DIAGNOSTICS_16_BIT),
    DPT_DALI_Diagnostics(336L, 600, "diagnostic value", KnxDatapointMainType.DPT_CONFIGURATION_DIAGNOSTICS_8_BIT),
    DPT_CombinedPosition(337L, 800, "combined position", KnxDatapointMainType.DPT_POSITIONS),
    DPT_StatusSAB(338L, 800, "status sunblind & shutter actuator", KnxDatapointMainType.DPT_STATUS_32_BIT),
    DPT_Colour_xyY(339L, 600, "colour xyY", KnxDatapointMainType.DPT_STATUS_48_BIT),
    DPT_Converter_Status(340L, 600, "DALI converter status", KnxDatapointMainType.DPT_CONVERTER_STATUS),
    DPT_Converter_Test_Result(341L, 600, "DALI converter test result", KnxDatapointMainType.DPT_CONVERTER_TEST_RESULT),
    DPT_Battery_Info(342L, 600, "Battery Information", KnxDatapointMainType.DPT_BATTERY_INFORMATION),
    DPT_Brightness_Colour_Temperature_Transition(343L, 600, "brightness colour temperature transition", KnxDatapointMainType.DPT_BRIGHTNESS_COLOUR_TEMPERATURE_TRANSITION),
    DPT_Brightness_Colour_Temperature_Control(344L, 600, "brightness colour temperature control", KnxDatapointMainType.DPT_STATUS_24_BIT),
    DPT_Colour_RGBW(345L, 600, "RGBW value 4x(0..100%)", KnxDatapointMainType.DPT_COLOUR_RGBW),
    DPT_Relative_Control_RGBW(346L, 600, "RGBW relative control", KnxDatapointMainType.DPT_RELATIVE_CONTROL_RGBW),
    DPT_Relative_Control_RGB(347L, 600, "RGB relative control", KnxDatapointMainType.DPT_RELATIVE_CONTROL_RGB),
    DPT_GeographicalLocation(348L, 1, "geographical location (longitude and latitude) expressed in degrees", KnxDatapointMainType.DPT_F32F32),
    DPT_TempRoomSetpSetF16_4(349L, 100, "Temperature setpoint setting for 4 HVAC Modes", KnxDatapointMainType.DPT_F16F16F16F16),
    DPT_TempRoomSetpSetShiftF16_4(350L, 101, "Temperature setpoint shift setting for 4 HVAC Modes", KnxDatapointMainType.DPT_F16F16F16F16);

    private static final Map<Long, KnxDatapointType> map;
    private final long value;
    private final int number;
    private final String name;
    private final KnxDatapointMainType datapointMainType;

    static {
        map = new HashMap<Long, KnxDatapointType>();
        KnxDatapointType[] knxDatapointTypeArray = KnxDatapointType.values();
        int n = knxDatapointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnxDatapointType value = knxDatapointTypeArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private KnxDatapointType(long value, int number, String name, KnxDatapointMainType datapointMainType) {
        this.value = value;
        this.number = number;
        this.name = name;
        this.datapointMainType = datapointMainType;
    }

    public long getValue() {
        return this.value;
    }

    public int getNumber() {
        return this.number;
    }

    public static KnxDatapointType firstEnumForFieldNumber(int fieldValue) {
        KnxDatapointType[] knxDatapointTypeArray = KnxDatapointType.values();
        int n = knxDatapointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnxDatapointType _val = knxDatapointTypeArray[n2];
            if (_val.getNumber() == fieldValue) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<KnxDatapointType> enumsForFieldNumber(int fieldValue) {
        ArrayList<KnxDatapointType> _values = new ArrayList<KnxDatapointType>();
        KnxDatapointType[] knxDatapointTypeArray = KnxDatapointType.values();
        int n = knxDatapointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnxDatapointType _val = knxDatapointTypeArray[n2];
            if (_val.getNumber() == fieldValue) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public String getName() {
        return this.name;
    }

    public static KnxDatapointType firstEnumForFieldName(String fieldValue) {
        KnxDatapointType[] knxDatapointTypeArray = KnxDatapointType.values();
        int n = knxDatapointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnxDatapointType _val = knxDatapointTypeArray[n2];
            if (_val.getName().equals(fieldValue)) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<KnxDatapointType> enumsForFieldName(String fieldValue) {
        ArrayList<KnxDatapointType> _values = new ArrayList<KnxDatapointType>();
        KnxDatapointType[] knxDatapointTypeArray = KnxDatapointType.values();
        int n = knxDatapointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnxDatapointType _val = knxDatapointTypeArray[n2];
            if (_val.getName().equals(fieldValue)) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public KnxDatapointMainType getDatapointMainType() {
        return this.datapointMainType;
    }

    public static KnxDatapointType firstEnumForFieldDatapointMainType(KnxDatapointMainType fieldValue) {
        KnxDatapointType[] knxDatapointTypeArray = KnxDatapointType.values();
        int n = knxDatapointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnxDatapointType _val = knxDatapointTypeArray[n2];
            if (_val.getDatapointMainType() == fieldValue) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<KnxDatapointType> enumsForFieldDatapointMainType(KnxDatapointMainType fieldValue) {
        ArrayList<KnxDatapointType> _values = new ArrayList<KnxDatapointType>();
        KnxDatapointType[] knxDatapointTypeArray = KnxDatapointType.values();
        int n = knxDatapointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KnxDatapointType _val = knxDatapointTypeArray[n2];
            if (_val.getDatapointMainType() == fieldValue) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public static KnxDatapointType enumForValue(long value) {
        return map.get(value);
    }

    public static Boolean isDefined(long value) {
        return map.containsKey(value);
    }
}

