/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.knxnetip.readwrite.ApduData;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ApduDataMemoryResponse
extends ApduData
implements Message {
    protected final int address;
    protected final byte[] data;

    @Override
    public Byte getApciType() {
        return (byte)9;
    }

    public ApduDataMemoryResponse(int address, byte[] data) {
        this.address = address;
        this.data = data;
    }

    public int getAddress() {
        return this.address;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected void serializeApduDataChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ApduDataMemoryResponse", new WithWriterArgs[0]);
        byte numBytes = (byte)StaticHelper.COUNT((Object)this.getData());
        FieldWriterFactory.writeImplicitField((String)"numBytes", (Object)numBytes, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)6), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"address", (Object)this.address, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"data", (byte[])this.data, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ApduDataMemoryResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ApduDataMemoryResponse _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 6;
        lengthInBits += 16;
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public static ApduData.ApduDataBuilder staticParseApduDataBuilder(ReadBuffer readBuffer, Short dataLength) throws ParseException {
        readBuffer.pullContext("ApduDataMemoryResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        byte numBytes = (Byte)FieldReaderFactory.readImplicitField((String)"numBytes", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)6), (WithReaderArgs[])new WithReaderArgs[0]);
        int address = (Integer)FieldReaderFactory.readSimpleField((String)"address", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(numBytes), new WithReaderArgs[0]);
        readBuffer.closeContext("ApduDataMemoryResponse", new WithReaderArgs[0]);
        return new ApduDataMemoryResponseBuilderImpl(address, data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApduDataMemoryResponse)) {
            return false;
        }
        ApduDataMemoryResponse that = (ApduDataMemoryResponse)o;
        return this.getAddress() == that.getAddress() && this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAddress(), this.getData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ApduDataMemoryResponseBuilderImpl
    implements ApduData.ApduDataBuilder {
        private final int address;
        private final byte[] data;

        public ApduDataMemoryResponseBuilderImpl(int address, byte[] data) {
            this.address = address;
            this.data = data;
        }

        @Override
        public ApduDataMemoryResponse build() {
            ApduDataMemoryResponse apduDataMemoryResponse = new ApduDataMemoryResponse(this.address, this.data);
            return apduDataMemoryResponse;
        }
    }
}

