/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum AccessLevel {
    Level0(0, "system manufacturer", true),
    Level1(1, "product manufacturer", true),
    Level2(2, "configuration", true),
    Level3(3, "end-user", false),
    Level15(15, "read access", false);

    private static final Map<Byte, AccessLevel> map;
    private final byte value;
    private final String purpose;
    private final boolean needsAuthentication;

    static {
        map = new HashMap<Byte, AccessLevel>();
        AccessLevel[] accessLevelArray = AccessLevel.values();
        int n = accessLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessLevel value = accessLevelArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private AccessLevel(byte value, String purpose, boolean needsAuthentication) {
        this.value = value;
        this.purpose = purpose;
        this.needsAuthentication = needsAuthentication;
    }

    public byte getValue() {
        return this.value;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public static AccessLevel firstEnumForFieldPurpose(String fieldValue) {
        AccessLevel[] accessLevelArray = AccessLevel.values();
        int n = accessLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessLevel _val = accessLevelArray[n2];
            if (_val.getPurpose().equals(fieldValue)) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<AccessLevel> enumsForFieldPurpose(String fieldValue) {
        ArrayList<AccessLevel> _values = new ArrayList<AccessLevel>();
        AccessLevel[] accessLevelArray = AccessLevel.values();
        int n = accessLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessLevel _val = accessLevelArray[n2];
            if (_val.getPurpose().equals(fieldValue)) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public boolean getNeedsAuthentication() {
        return this.needsAuthentication;
    }

    public static AccessLevel firstEnumForFieldNeedsAuthentication(boolean fieldValue) {
        AccessLevel[] accessLevelArray = AccessLevel.values();
        int n = accessLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessLevel _val = accessLevelArray[n2];
            if (_val.getNeedsAuthentication() == fieldValue) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<AccessLevel> enumsForFieldNeedsAuthentication(boolean fieldValue) {
        ArrayList<AccessLevel> _values = new ArrayList<AccessLevel>();
        AccessLevel[] accessLevelArray = AccessLevel.values();
        int n = accessLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessLevel _val = accessLevelArray[n2];
            if (_val.getNeedsAuthentication() == fieldValue) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public static AccessLevel enumForValue(byte value) {
        return map.get(value);
    }

    public static Boolean isDefined(byte value) {
        return map.containsKey(value);
    }
}

