/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.configuration;

import org.apache.plc4x.java.knxnetip.readwrite.KnxLayer;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.configuration.annotations.ConfigurationParameter;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.BooleanDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.FloatDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.IntDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.StringDefaultValue;
import org.apache.plc4x.java.spi.configuration.exceptions.ConfigurationException;
import org.apache.plc4x.java.transport.pcapreplay.PcapReplayTransportConfiguration;
import org.apache.plc4x.java.transport.rawsocket.RawSocketTransportConfiguration;
import org.apache.plc4x.java.transport.udp.UdpTransportConfiguration;
import org.apache.plc4x.java.utils.pcap.netty.handlers.PacketHandler;

public class KnxNetIpConfiguration
implements Configuration,
UdpTransportConfiguration,
PcapReplayTransportConfiguration,
RawSocketTransportConfiguration {
    @ConfigurationParameter(value="knxproj-file-path")
    public String knxprojFilePath;
    @ConfigurationParameter(value="knxproj-password")
    public String knxprojPassword;
    @ConfigurationParameter(value="group-address-num-levels")
    @IntDefaultValue(value=3)
    public int groupAddressNumLevels = 3;
    @ConfigurationParameter(value="connection-type")
    @StringDefaultValue(value="LINK_LAYER")
    public String connectionType = "LINK_LAYER";
    @ConfigurationParameter(value="replay-speed-factor")
    @FloatDefaultValue(value=1.0f)
    public float replaySpeedFactor = 1.0f;
    @ConfigurationParameter(value="loop")
    @BooleanDefaultValue(value=false)
    public boolean loop = false;

    public String getKnxprojFilePath() {
        return this.knxprojFilePath;
    }

    public void setKnxprojFilePath(String knxprojFilePath) {
        this.knxprojFilePath = knxprojFilePath;
    }

    public String getKnxprojPassword() {
        return this.knxprojPassword;
    }

    public void setKnxprojPassword(String knxprojPassword) {
        this.knxprojPassword = knxprojPassword;
    }

    public int getGroupAddressNumLevels() {
        return this.groupAddressNumLevels;
    }

    public void setGroupAddressNumLevels(int groupAddressNumLevels) {
        this.groupAddressNumLevels = groupAddressNumLevels;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(String connectionType) {
        try {
            KnxLayer.valueOf("TUNNEL_" + connectionType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Value provided for connection-type invalid.");
        }
        this.connectionType = connectionType.toUpperCase();
    }

    public float getReplaySpeedFactor() {
        return this.replaySpeedFactor;
    }

    public void setReplaySpeedFactor(float replaySpeedFactor) {
        this.replaySpeedFactor = replaySpeedFactor;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public int getDefaultPort() {
        return 3671;
    }

    public Integer getProtocolId() {
        return -1;
    }

    public PacketHandler getPcapPacketHandler() {
        return packet -> packet.getPayload().getPayload().getPayload().getRawData();
    }

    public String toString() {
        return "Configuration{knxprojFilePath=" + this.knxprojFilePath + ", " + "groupAddressNumLevels=" + this.groupAddressNumLevels + '}';
    }
}

