/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum KnxPropertyDataType {
    PDT_UNKNOWN(0, 0, 0, "Unknown Property Data Type"),
    PDT_CONTROL(1, 0, 10, "PDT_CONTROL"),
    PDT_CHAR(2, 1, 1, "PDT_CHAR"),
    PDT_UNSIGNED_CHAR(3, 2, 1, "PDT_UNSIGNED_CHAR"),
    PDT_INT(4, 3, 2, "PDT_INT"),
    PDT_UNSIGNED_INT(5, 4, 2, "PDT_UNSIGNED_INT"),
    PDT_KNX_FLOAT(6, 5, 2, "PDT_KNX_FLOAT"),
    PDT_DATE(7, 6, 3, "PDT_DATE"),
    PDT_TIME(8, 7, 3, "PDT_TIME"),
    PDT_LONG(9, 8, 4, "PDT_LONG"),
    PDT_UNSIGNED_LONG(10, 9, 4, "PDT_UNSIGNED_LONG"),
    PDT_FLOAT(11, 10, 4, "PDT_FLOAT"),
    PDT_DOUBLE(12, 11, 8, "PDT_DOUBLE"),
    PDT_CHAR_BLOCK(13, 12, 10, "PDT_CHAR_BLOCK"),
    PDT_POLL_GROUP_SETTINGS(14, 13, 3, "PDT_POLL_GROUP_SETTINGS"),
    PDT_SHORT_CHAR_BLOCK(15, 14, 5, "PDT_SHORT_CHAR_BLOCK"),
    PDT_DATE_TIME(16, 15, 8, "PDT_DATE_TIME"),
    PDT_VARIABLE_LENGTH(17, 16, 0, "PDT_VARIABLE_LENGTH"),
    PDT_GENERIC_01(18, 17, 1, "PDT_GENERIC_01"),
    PDT_GENERIC_02(19, 18, 2, "PDT_GENERIC_02"),
    PDT_GENERIC_03(20, 19, 3, "PDT_GENERIC_03"),
    PDT_GENERIC_04(21, 20, 4, "PDT_GENERIC_04"),
    PDT_GENERIC_05(22, 21, 5, "PDT_GENERIC_05"),
    PDT_GENERIC_06(23, 22, 6, "PDT_GENERIC_06"),
    PDT_GENERIC_07(24, 23, 7, "PDT_GENERIC_07"),
    PDT_GENERIC_08(25, 24, 8, "PDT_GENERIC_08"),
    PDT_GENERIC_09(26, 25, 9, "PDT_GENERIC_09"),
    PDT_GENERIC_10(27, 26, 10, "PDT_GENERIC_10"),
    PDT_GENERIC_11(28, 27, 11, "PDT_GENERIC_11"),
    PDT_GENERIC_12(29, 28, 12, "PDT_GENERIC_12"),
    PDT_GENERIC_13(30, 29, 13, "PDT_GENERIC_13"),
    PDT_GENERIC_14(31, 30, 14, "PDT_GENERIC_14"),
    PDT_GENERIC_15(32, 31, 15, "PDT_GENERIC_15"),
    PDT_GENERIC_16(33, 32, 16, "PDT_GENERIC_16"),
    PDT_GENERIC_17(34, 33, 17, "PDT_GENERIC_17"),
    PDT_GENERIC_18(35, 34, 18, "PDT_GENERIC_18"),
    PDT_GENERIC_19(36, 35, 19, "PDT_GENERIC_19"),
    PDT_GENERIC_20(37, 36, 20, "PDT_GENERIC_20"),
    PDT_UTF_8(38, 47, 0, "PDT_UTF-8"),
    PDT_VERSION(39, 48, 2, "PDT_VERSION"),
    PDT_ALARM_INFO(40, 49, 6, "PDT_ALARM_INFO"),
    PDT_BINARY_INFORMATION(41, 50, 1, "PDT_BINARY_INFORMATION"),
    PDT_BITSET8(42, 51, 1, "PDT_BITSET8"),
    PDT_BITSET16(43, 52, 2, "PDT_BITSET16"),
    PDT_ENUM8(44, 53, 1, "PDT_ENUM8"),
    PDT_SCALING(45, 54, 1, "PDT_SCALING"),
    PDT_NE_VL(46, 60, 0, "PDT_NE_VL"),
    PDT_NE_FL(47, 61, 0, "PDT_NE_FL"),
    PDT_FUNCTION(48, 62, 0, "PDT_FUNCTION"),
    PDT_ESCAPE(49, 63, 0, "PDT_ESCAPE");

    private static final Map<Short, KnxPropertyDataType> map;
    private short value;
    private short number;
    private short sizeInBytes;
    private String name;

    private KnxPropertyDataType(short value, short number, short sizeInBytes, String name) {
        this.value = value;
        this.number = number;
        this.sizeInBytes = sizeInBytes;
        this.name = name;
    }

    public short getValue() {
        return this.value;
    }

    public short getNumber() {
        return this.number;
    }

    public static KnxPropertyDataType firstEnumForFieldNumber(short fieldValue) {
        for (KnxPropertyDataType _val : KnxPropertyDataType.values()) {
            if (_val.getNumber() != fieldValue) continue;
            return _val;
        }
        return null;
    }

    public static List<KnxPropertyDataType> enumsForFieldNumber(short fieldValue) {
        ArrayList<KnxPropertyDataType> _values = new ArrayList<KnxPropertyDataType>();
        for (KnxPropertyDataType _val : KnxPropertyDataType.values()) {
            if (_val.getNumber() != fieldValue) continue;
            _values.add(_val);
        }
        return _values;
    }

    public short getSizeInBytes() {
        return this.sizeInBytes;
    }

    public static KnxPropertyDataType firstEnumForFieldSizeInBytes(short fieldValue) {
        for (KnxPropertyDataType _val : KnxPropertyDataType.values()) {
            if (_val.getSizeInBytes() != fieldValue) continue;
            return _val;
        }
        return null;
    }

    public static List<KnxPropertyDataType> enumsForFieldSizeInBytes(short fieldValue) {
        ArrayList<KnxPropertyDataType> _values = new ArrayList<KnxPropertyDataType>();
        for (KnxPropertyDataType _val : KnxPropertyDataType.values()) {
            if (_val.getSizeInBytes() != fieldValue) continue;
            _values.add(_val);
        }
        return _values;
    }

    public String getName() {
        return this.name;
    }

    public static KnxPropertyDataType firstEnumForFieldName(String fieldValue) {
        for (KnxPropertyDataType _val : KnxPropertyDataType.values()) {
            if (_val.getName() != fieldValue) continue;
            return _val;
        }
        return null;
    }

    public static List<KnxPropertyDataType> enumsForFieldName(String fieldValue) {
        ArrayList<KnxPropertyDataType> _values = new ArrayList<KnxPropertyDataType>();
        for (KnxPropertyDataType _val : KnxPropertyDataType.values()) {
            if (_val.getName() != fieldValue) continue;
            _values.add(_val);
        }
        return _values;
    }

    public static KnxPropertyDataType enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }

    static {
        map = new HashMap<Short, KnxPropertyDataType>();
        for (KnxPropertyDataType value : KnxPropertyDataType.values()) {
            map.put(value.getValue(), value);
        }
    }
}

