/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.HashMap;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.knxnetip.readwrite.KnxDatapointType;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcCHAR;
import org.apache.plc4x.java.spi.values.PlcDATE;
import org.apache.plc4x.java.spi.values.PlcDATE_AND_TIME;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcDWORD;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcLTIME;
import org.apache.plc4x.java.spi.values.PlcLWORD;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcStruct;
import org.apache.plc4x.java.spi.values.PlcTIME;
import org.apache.plc4x.java.spi.values.PlcTIME_OF_DAY;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.apache.plc4x.java.spi.values.PlcWCHAR;
import org.apache.plc4x.java.spi.values.PlcWORD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnxDatapoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnxDatapoint.class);

    /*
     * Opcode count of 20434 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static PlcValue staticParse(ReadBuffer readBuffer, KnxDatapointType datapointType) throws ParseException {
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.BOOL))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.BYTE))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcBYTE(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.WORD))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcWORD(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DWORD))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcDWORD(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LWORD))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcLWORD(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.USINT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.SINT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte value = readBuffer.readSignedByte("", 8, new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.UINT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.INT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.UDINT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DINT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.ULINT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LINT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readLong("", 64, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.REAL))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LREAL))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Double value = readBuffer.readDouble("", 64, new WithReaderArgs[0]);
            return new PlcLREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.CHAR))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            String value = readBuffer.readString("", 8, "UTF-8", new WithReaderArgs[0]);
            return new PlcCHAR(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.WCHAR))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            String value = readBuffer.readString("", 16, "UTF-16", new WithReaderArgs[0]);
            return new PlcWCHAR(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.TIME))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcTIME(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LTIME))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcLTIME(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DATE))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcDATE(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.TIME_OF_DAY))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcTIME_OF_DAY(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.TOD))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcTIME_OF_DAY(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DATE_AND_TIME))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer year = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short month = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short day = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short dayOfWeek = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short hour = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short minutes = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short seconds = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Long nanos = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            LocalDateTime value = LocalDateTime.of((int)year, month == 0 ? 1 : month.intValue(), day == 0 ? 1 : day.intValue(), hour.intValue(), minutes.intValue(), seconds.intValue(), nanos.intValue());
            return new PlcDATE_AND_TIME(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer year = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short month = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short day = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short dayOfWeek = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short hour = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short minutes = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short seconds = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Long nanos = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            LocalDateTime value = LocalDateTime.of((int)year, month == 0 ? 1 : month.intValue(), day == 0 ? 1 : day.intValue(), hour.intValue(), minutes.intValue(), seconds.intValue(), nanos.intValue());
            return new PlcDATE_AND_TIME(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Switch))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Bool))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Enable))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Ramp))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Alarm))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BinaryValue))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Step))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_UpDown))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_OpenClose))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Start))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_State))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Invert))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DimSendStyle))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_InputSource))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Reset))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Ack))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Trigger))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Occupancy))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Window_Door))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LogicalFunction))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Scene_AB))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ShutterBlinds_Mode))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DayNight))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Heat_Cool))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Switch_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean on = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("on", new PlcBOOL(on));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Bool_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean valueTrue = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("valueTrue", new PlcBOOL(valueTrue));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Enable_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean enable = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("enable", new PlcBOOL(enable));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Ramp_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean ramp = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("ramp", new PlcBOOL(ramp));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Alarm_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean alarm = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("alarm", new PlcBOOL(alarm));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BinaryValue_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean high = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("high", new PlcBOOL(high));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Step_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean increase = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("increase", new PlcBOOL(increase));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Direction1_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean down = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("down", new PlcBOOL(down));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Direction2_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean close = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("close", new PlcBOOL(close));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Start_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean start = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("start", new PlcBOOL(start));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_State_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean active = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("active", new PlcBOOL(active));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Invert_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean inverted = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("inverted", new PlcBOOL(inverted));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Control_Dimming))) {
            byte reserved = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean increase = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepcode = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("increase", new PlcBOOL(increase));
            _map.put("stepcode", new PlcSINT(stepcode));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Control_Blinds))) {
            byte reserved = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean down = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepcode = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("down", new PlcBOOL(down));
            _map.put("stepcode", new PlcSINT(stepcode));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Char_ASCII))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            String value = readBuffer.readString("", 8, "ASCII", new WithReaderArgs[0]);
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Char_8859_1))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            String value = readBuffer.readString("", 8, "ISO-8859-1", new WithReaderArgs[0]);
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Scaling))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Angle))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Percent_U8))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DecimalFactor))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Tariff))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_1_Ucount))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FanStage))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Percent_V8))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte value = readBuffer.readSignedByte("", 8, new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_1_Count))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte value = readBuffer.readSignedByte("", 8, new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Status_Mode3))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean statusA = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusB = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusC = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusD = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusE = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte mode = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("statusA", new PlcBOOL(statusA));
            _map.put("statusB", new PlcBOOL(statusB));
            _map.put("statusC", new PlcBOOL(statusC));
            _map.put("statusD", new PlcBOOL(statusD));
            _map.put("statusE", new PlcBOOL(statusE));
            _map.put("mode", new PlcSINT(mode));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_2_Ucount))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriodMsec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriod10Msec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriod100Msec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriodSec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriodMin))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriodHrs))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PropDataType))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Length_mm))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_UElCurrentmA))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Brightness))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Absolute_Colour_Temperature))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_2_Count))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTimeMsec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTime10Msec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTime100Msec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTimeSec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTimeMin))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTimeHrs))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Percent_V16))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Rotation_Angle))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Length_m))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Temp))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Tempd))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Tempa))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Lux))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Wsp))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Pres))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Humidity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_AirQuality))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_AirFlow))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Time1))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Time2))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Volt))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Curr))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PowerDensity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_KelvinPerPercent))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Power))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Volume_Flow))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Rain_Amount))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Temp_F))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Wsp_kmh))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Absolute_Humidity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Concentration_ygm3))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimeOfDay))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte day = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            Short hour = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0]);
            byte reserved2 = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved2 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved2 + " for reserved field.");
            }
            Short minutes = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            byte reserved3 = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved3 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved3 + " for reserved field.");
            }
            Short seconds = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("day", new PlcSINT(day));
            _map.put("hour", new PlcINT(hour));
            _map.put("minutes", new PlcINT(minutes));
            _map.put("seconds", new PlcINT(seconds));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Date))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short dayOfMonth = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0]);
            byte reserved4 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved4 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved4 + " for reserved field.");
            }
            Byte month = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            byte reserved5 = readBuffer.readUnsignedByte("", 1, new WithReaderArgs[0]);
            if (reserved5 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved5 + " for reserved field.");
            }
            Short year = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("dayOfMonth", new PlcINT(dayOfMonth));
            _map.put("month", new PlcSINT(month));
            _map.put("year", new PlcINT(year));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_4_Ucount))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LongTimePeriod_Sec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LongTimePeriod_Min))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LongTimePeriod_Hrs))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_VolumeLiquid_Litre))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Volume_m_3))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_4_Count))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FlowRate_m3h))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActiveEnergy))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ApparantEnergy))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ReactiveEnergy))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActiveEnergy_kWh))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ApparantEnergy_kVAh))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ReactiveEnergy_kVARh))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActiveEnergy_MWh))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LongDeltaTimeSec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaVolumeLiquid_Litre))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaVolume_m_3))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Acceleration))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Acceleration_Angular))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Activation_Energy))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Activity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Mol))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Amplitude))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_AngleRad))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_AngleDeg))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Angular_Momentum))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Angular_Velocity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Area))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Capacitance))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Charge_DensitySurface))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Charge_DensityVolume))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Compressibility))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Conductance))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electrical_Conductivity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Density))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Charge))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Current))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_CurrentDensity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_DipoleMoment))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Displacement))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_FieldStrength))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Flux))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_FluxDensity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Polarization))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Potential))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_PotentialDifference))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_ElectromagneticMoment))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electromotive_Force))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Energy))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Force))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Frequency))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Angular_Frequency))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Heat_Capacity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Heat_FlowRate))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Heat_Quantity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Impedance))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Length))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Light_Quantity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Luminance))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Luminous_Flux))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Luminous_Intensity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_FieldStrength))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_Flux))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_FluxDensity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_Moment))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_Polarization))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetization))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_MagnetomotiveForce))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Mass))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_MassFlux))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Momentum))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Phase_AngleRad))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Phase_AngleDeg))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Power))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Power_Factor))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Pressure))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Reactance))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Resistance))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Resistivity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_SelfInductance))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_SolidAngle))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Sound_Intensity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Speed))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Stress))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Surface_Tension))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Common_Temperature))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Absolute_Temperature))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_TemperatureDifference))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Thermal_Capacity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Thermal_Conductivity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_ThermoelectricPower))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Time))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Torque))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Volume))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Volume_Flux))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Weight))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Work))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Volume_Flux_Meter))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Volume_Flux_ls))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Access_Data))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte hurz = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Byte value1 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Byte value2 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Byte value3 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Byte value4 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Byte value5 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Boolean detectionError = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean permission = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean readDirection = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean encryptionOfAccessInformation = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte indexOfAccessIdentificationCode = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("hurz", new PlcSINT(hurz));
            _map.put("value1", new PlcSINT(value1));
            _map.put("value2", new PlcSINT(value2));
            _map.put("value3", new PlcSINT(value3));
            _map.put("value4", new PlcSINT(value4));
            _map.put("value5", new PlcSINT(value5));
            _map.put("detectionError", new PlcBOOL(detectionError));
            _map.put("permission", new PlcBOOL(permission));
            _map.put("readDirection", new PlcBOOL(readDirection));
            _map.put("encryptionOfAccessInformation", new PlcBOOL(encryptionOfAccessInformation));
            _map.put("indexOfAccessIdentificationCode", new PlcSINT(indexOfAccessIdentificationCode));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_String_ASCII))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            String value = readBuffer.readString("", 112, "ASCII", new WithReaderArgs[0]);
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_String_8859_1))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            String value = readBuffer.readString("", 112, "ISO-8859-1", new WithReaderArgs[0]);
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SceneNumber))) {
            byte reserved = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SceneControl))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean learnTheSceneCorrespondingToTheFieldSceneNumber = readBuffer.readBit("", new WithReaderArgs[0]);
            byte reserved6 = readBuffer.readUnsignedByte("", 1, new WithReaderArgs[0]);
            if (reserved6 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved6 + " for reserved field.");
            }
            Short sceneNumber = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("learnTheSceneCorrespondingToTheFieldSceneNumber", new PlcBOOL(learnTheSceneCorrespondingToTheFieldSceneNumber));
            _map.put("sceneNumber", new PlcINT(sceneNumber));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DateTime))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short year = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            byte reserved7 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved7 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved7 + " for reserved field.");
            }
            Byte month = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            byte reserved8 = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            if (reserved8 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved8 + " for reserved field.");
            }
            Short dayofmonth = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0]);
            Byte dayofweek = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            Short hourofday = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0]);
            byte reserved9 = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved9 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved9 + " for reserved field.");
            }
            Short minutes = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            byte reserved10 = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved10 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved10 + " for reserved field.");
            }
            Short seconds = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            Boolean fault = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean workingDay = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean noWd = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean noYear = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean noDate = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean noDayOfWeek = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean noTime = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean standardSummerTime = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean qualityOfClock = readBuffer.readBit("", new WithReaderArgs[0]);
            short reserved11 = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved11 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved11 + " for reserved field.");
            }
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("year", new PlcINT(year));
            _map.put("month", new PlcSINT(month));
            _map.put("dayofmonth", new PlcINT(dayofmonth));
            _map.put("dayofweek", new PlcSINT(dayofweek));
            _map.put("hourofday", new PlcINT(hourofday));
            _map.put("minutes", new PlcINT(minutes));
            _map.put("seconds", new PlcINT(seconds));
            _map.put("fault", new PlcBOOL(fault));
            _map.put("workingDay", new PlcBOOL(workingDay));
            _map.put("noWd", new PlcBOOL(noWd));
            _map.put("noYear", new PlcBOOL(noYear));
            _map.put("noDate", new PlcBOOL(noDate));
            _map.put("noDayOfWeek", new PlcBOOL(noDayOfWeek));
            _map.put("noTime", new PlcBOOL(noTime));
            _map.put("standardSummerTime", new PlcBOOL(standardSummerTime));
            _map.put("qualityOfClock", new PlcBOOL(qualityOfClock));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SCLOMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BuildingMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_OccMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Priority))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LightApplicationMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ApplicationArea))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_AlarmClassType))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PSUMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ErrorClass_System))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ErrorClass_HVAC))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Time_Delay))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Beaufort_Wind_Force_Scale))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SensorSelect))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActuatorConnectType))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Cloud_Cover))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PowerReturnMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FuelType))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BurnerType))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVACMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DHWMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LoadPriority))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVACContrMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVACEmergMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ChangeoverMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ValveMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DamperMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HeaterMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FanMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_MasterSlaveMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusRoomSetp))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Metering_DeviceType))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HumDehumMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_EnableHCStage))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ADAType))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BackupMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StartSynchronization))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Behaviour_Lock_Unlock))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Behaviour_Bus_Power_Up_Down))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DALI_Fade_Time))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BlinkingMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LightControlMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SwitchPBModel))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PBAction))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DimmPBModel))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SwitchOnMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LoadTypeSet))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LoadTypeDetected))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Converter_Test_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SABExcept_Behaviour))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SABBehaviour_Lock_Unlock))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SSSBMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BlindsControlMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CommMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_AddInfoTypes))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_RF_ModeSelect))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_RF_FilterSelect))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusGen))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean alarmStatusOfCorrespondingDatapointIsNotAcknowledged = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean correspondingDatapointIsInAlarm = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean correspondingDatapointMainValueIsOverridden = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean correspondingDatapointMainValueIsCorruptedDueToFailure = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean correspondingDatapointValueIsOutOfService = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("alarmStatusOfCorrespondingDatapointIsNotAcknowledged", new PlcBOOL(alarmStatusOfCorrespondingDatapointIsNotAcknowledged));
            _map.put("correspondingDatapointIsInAlarm", new PlcBOOL(correspondingDatapointIsInAlarm));
            _map.put("correspondingDatapointMainValueIsOverridden", new PlcBOOL(correspondingDatapointMainValueIsOverridden));
            _map.put("correspondingDatapointMainValueIsCorruptedDueToFailure", new PlcBOOL(correspondingDatapointMainValueIsCorruptedDueToFailure));
            _map.put("correspondingDatapointValueIsOutOfService", new PlcBOOL(correspondingDatapointValueIsOutOfService));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Device_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean verifyModeIsOn = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean theUserApplicationIsStopped = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("verifyModeIsOn", new PlcBOOL(verifyModeIsOn));
            _map.put("aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived", new PlcBOOL(aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived));
            _map.put("theUserApplicationIsStopped", new PlcBOOL(theUserApplicationIsStopped));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ForceSign))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean roomhmax = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean roomhconf = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean dhwlegio = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean dhwnorm = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean overrun = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean oversupply = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean protection = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean forcerequest = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("roomhmax", new PlcBOOL(roomhmax));
            _map.put("roomhconf", new PlcBOOL(roomhconf));
            _map.put("dhwlegio", new PlcBOOL(dhwlegio));
            _map.put("dhwnorm", new PlcBOOL(dhwnorm));
            _map.put("overrun", new PlcBOOL(overrun));
            _map.put("oversupply", new PlcBOOL(oversupply));
            _map.put("protection", new PlcBOOL(protection));
            _map.put("forcerequest", new PlcBOOL(forcerequest));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ForceSignCool))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusRHC))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean summermode = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusstopoptim = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusstartoptim = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusmorningboost = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean tempreturnlimit = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean tempflowlimit = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean satuseco = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean fault = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("summermode", new PlcBOOL(summermode));
            _map.put("statusstopoptim", new PlcBOOL(statusstopoptim));
            _map.put("statusstartoptim", new PlcBOOL(statusstartoptim));
            _map.put("statusmorningboost", new PlcBOOL(statusmorningboost));
            _map.put("tempreturnlimit", new PlcBOOL(tempreturnlimit));
            _map.put("tempflowlimit", new PlcBOOL(tempflowlimit));
            _map.put("satuseco", new PlcBOOL(satuseco));
            _map.put("fault", new PlcBOOL(fault));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusSDHWC))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean solarloadsufficient = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean sdhwloadactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean fault = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("solarloadsufficient", new PlcBOOL(solarloadsufficient));
            _map.put("sdhwloadactive", new PlcBOOL(sdhwloadactive));
            _map.put("fault", new PlcBOOL(fault));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FuelTypeSet))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean solidstate = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean gas = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean oil = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("solidstate", new PlcBOOL(solidstate));
            _map.put("gas", new PlcBOOL(gas));
            _map.put("oil", new PlcBOOL(oil));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusRCC))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusAHU))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean cool = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean heat = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean fanactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean fault = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("cool", new PlcBOOL(cool));
            _map.put("heat", new PlcBOOL(heat));
            _map.put("fanactive", new PlcBOOL(fanactive));
            _map.put("fault", new PlcBOOL(fault));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedStatus_RTSM))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean statusOfHvacModeUser = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusOfComfortProlongationUser = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean effectiveValueOfTheComfortPushButton = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean effectiveValueOfThePresenceStatus = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean effectiveValueOfTheWindowStatus = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("statusOfHvacModeUser", new PlcBOOL(statusOfHvacModeUser));
            _map.put("statusOfComfortProlongationUser", new PlcBOOL(statusOfComfortProlongationUser));
            _map.put("effectiveValueOfTheComfortPushButton", new PlcBOOL(effectiveValueOfTheComfortPushButton));
            _map.put("effectiveValueOfThePresenceStatus", new PlcBOOL(effectiveValueOfThePresenceStatus));
            _map.put("effectiveValueOfTheWindowStatus", new PlcBOOL(effectiveValueOfTheWindowStatus));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LightActuatorErrorInfo))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 1, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean overheat = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean lampfailure = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean defectiveload = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean underload = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean overcurrent = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean undervoltage = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean loaddetectionerror = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("overheat", new PlcBOOL(overheat));
            _map.put("lampfailure", new PlcBOOL(lampfailure));
            _map.put("defectiveload", new PlcBOOL(defectiveload));
            _map.put("underload", new PlcBOOL(underload));
            _map.put("overcurrent", new PlcBOOL(overcurrent));
            _map.put("undervoltage", new PlcBOOL(undervoltage));
            _map.put("loaddetectionerror", new PlcBOOL(loaddetectionerror));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_RF_ModeInfo))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean bibatSlave = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean bibatMaster = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean asynchronous = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("bibatSlave", new PlcBOOL(bibatSlave));
            _map.put("bibatMaster", new PlcBOOL(bibatMaster));
            _map.put("asynchronous", new PlcBOOL(asynchronous));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_RF_FilterInfo))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean doa = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean knxSn = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean doaAndKnxSn = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("doa", new PlcBOOL(doa));
            _map.put("knxSn", new PlcBOOL(knxSn));
            _map.put("doaAndKnxSn", new PlcBOOL(doaAndKnxSn));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Channel_Activation_8))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean activationStateOfChannel1 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel2 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel3 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel4 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel5 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel6 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel7 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel8 = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("activationStateOfChannel1", new PlcBOOL(activationStateOfChannel1));
            _map.put("activationStateOfChannel2", new PlcBOOL(activationStateOfChannel2));
            _map.put("activationStateOfChannel3", new PlcBOOL(activationStateOfChannel3));
            _map.put("activationStateOfChannel4", new PlcBOOL(activationStateOfChannel4));
            _map.put("activationStateOfChannel5", new PlcBOOL(activationStateOfChannel5));
            _map.put("activationStateOfChannel6", new PlcBOOL(activationStateOfChannel6));
            _map.put("activationStateOfChannel7", new PlcBOOL(activationStateOfChannel7));
            _map.put("activationStateOfChannel8", new PlcBOOL(activationStateOfChannel8));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusDHWC))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean tempoptimshiftactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean solarenergysupport = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean solarenergyonly = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean otherenergysourceactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean dhwpushactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean legioprotactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean dhwloadactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean fault = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("tempoptimshiftactive", new PlcBOOL(tempoptimshiftactive));
            _map.put("solarenergysupport", new PlcBOOL(solarenergysupport));
            _map.put("solarenergyonly", new PlcBOOL(solarenergyonly));
            _map.put("otherenergysourceactive", new PlcBOOL(otherenergysourceactive));
            _map.put("dhwpushactive", new PlcBOOL(dhwpushactive));
            _map.put("legioprotactive", new PlcBOOL(legioprotactive));
            _map.put("dhwloadactive", new PlcBOOL(dhwloadactive));
            _map.put("fault", new PlcBOOL(fault));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusRHCC))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 1, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean overheatalarm = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean frostalarm = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean dewpointstatus = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean coolingdisabled = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusprecool = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusecoc = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean heatcoolmode = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean heatingdiabled = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusstopoptim = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusstartoptim = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusmorningboosth = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean tempflowreturnlimit = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean tempflowlimit = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusecoh = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean fault = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("overheatalarm", new PlcBOOL(overheatalarm));
            _map.put("frostalarm", new PlcBOOL(frostalarm));
            _map.put("dewpointstatus", new PlcBOOL(dewpointstatus));
            _map.put("coolingdisabled", new PlcBOOL(coolingdisabled));
            _map.put("statusprecool", new PlcBOOL(statusprecool));
            _map.put("statusecoc", new PlcBOOL(statusecoc));
            _map.put("heatcoolmode", new PlcBOOL(heatcoolmode));
            _map.put("heatingdiabled", new PlcBOOL(heatingdiabled));
            _map.put("statusstopoptim", new PlcBOOL(statusstopoptim));
            _map.put("statusstartoptim", new PlcBOOL(statusstartoptim));
            _map.put("statusmorningboosth", new PlcBOOL(statusmorningboosth));
            _map.put("tempflowreturnlimit", new PlcBOOL(tempflowreturnlimit));
            _map.put("tempflowlimit", new PlcBOOL(tempflowlimit));
            _map.put("statusecoh", new PlcBOOL(statusecoh));
            _map.put("fault", new PlcBOOL(fault));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedStatus_HVA))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean calibrationMode = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean lockedPosition = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean forcedPosition = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean manuaOperationOverridden = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean serviceMode = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean valveKick = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean overload = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean shortCircuit = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean currentValvePosition = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("calibrationMode", new PlcBOOL(calibrationMode));
            _map.put("lockedPosition", new PlcBOOL(lockedPosition));
            _map.put("forcedPosition", new PlcBOOL(forcedPosition));
            _map.put("manuaOperationOverridden", new PlcBOOL(manuaOperationOverridden));
            _map.put("serviceMode", new PlcBOOL(serviceMode));
            _map.put("valveKick", new PlcBOOL(valveKick));
            _map.put("overload", new PlcBOOL(overload));
            _map.put("shortCircuit", new PlcBOOL(shortCircuit));
            _map.put("currentValvePosition", new PlcBOOL(currentValvePosition));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedStatus_RTC))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean coolingModeEnabled = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean heatingModeEnabled = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean additionalHeatingCoolingStage2Stage = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean controllerInactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean overheatAlarm = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean frostAlarm = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean dewPointStatus = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activeMode = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean generalFailureInformation = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("coolingModeEnabled", new PlcBOOL(coolingModeEnabled));
            _map.put("heatingModeEnabled", new PlcBOOL(heatingModeEnabled));
            _map.put("additionalHeatingCoolingStage2Stage", new PlcBOOL(additionalHeatingCoolingStage2Stage));
            _map.put("controllerInactive", new PlcBOOL(controllerInactive));
            _map.put("overheatAlarm", new PlcBOOL(overheatAlarm));
            _map.put("frostAlarm", new PlcBOOL(frostAlarm));
            _map.put("dewPointStatus", new PlcBOOL(dewPointStatus));
            _map.put("activeMode", new PlcBOOL(activeMode));
            _map.put("generalFailureInformation", new PlcBOOL(generalFailureInformation));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Media))) {
            int reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = readBuffer.readUnsignedInt("", 10, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean knxIp = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean rf = readBuffer.readBit("", new WithReaderArgs[0]);
            byte reserved12 = readBuffer.readUnsignedByte("", 1, new WithReaderArgs[0]);
            if (reserved12 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved12 + " for reserved field.");
            }
            Boolean pl110 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean tp1 = readBuffer.readBit("", new WithReaderArgs[0]);
            byte reserved13 = readBuffer.readUnsignedByte("", 1, new WithReaderArgs[0]);
            if (reserved13 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved13 + " for reserved field.");
            }
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("knxIp", new PlcBOOL(knxIp));
            _map.put("rf", new PlcBOOL(rf));
            _map.put("pl110", new PlcBOOL(pl110));
            _map.put("tp1", new PlcBOOL(tp1));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Channel_Activation_16))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean activationStateOfChannel1 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel2 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel3 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel4 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel5 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel6 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel7 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel8 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel9 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel10 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel11 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel12 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel13 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel14 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel15 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel16 = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("activationStateOfChannel1", new PlcBOOL(activationStateOfChannel1));
            _map.put("activationStateOfChannel2", new PlcBOOL(activationStateOfChannel2));
            _map.put("activationStateOfChannel3", new PlcBOOL(activationStateOfChannel3));
            _map.put("activationStateOfChannel4", new PlcBOOL(activationStateOfChannel4));
            _map.put("activationStateOfChannel5", new PlcBOOL(activationStateOfChannel5));
            _map.put("activationStateOfChannel6", new PlcBOOL(activationStateOfChannel6));
            _map.put("activationStateOfChannel7", new PlcBOOL(activationStateOfChannel7));
            _map.put("activationStateOfChannel8", new PlcBOOL(activationStateOfChannel8));
            _map.put("activationStateOfChannel9", new PlcBOOL(activationStateOfChannel9));
            _map.put("activationStateOfChannel10", new PlcBOOL(activationStateOfChannel10));
            _map.put("activationStateOfChannel11", new PlcBOOL(activationStateOfChannel11));
            _map.put("activationStateOfChannel12", new PlcBOOL(activationStateOfChannel12));
            _map.put("activationStateOfChannel13", new PlcBOOL(activationStateOfChannel13));
            _map.put("activationStateOfChannel14", new PlcBOOL(activationStateOfChannel14));
            _map.put("activationStateOfChannel15", new PlcBOOL(activationStateOfChannel15));
            _map.put("activationStateOfChannel16", new PlcBOOL(activationStateOfChannel16));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_OnOffAction))) {
            short reserved = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte value = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Alarm_Reaction))) {
            short reserved = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte value = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_UpDown_Action))) {
            short reserved = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte value = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVAC_PB_Action))) {
            short reserved = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte value = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DoubleNibble))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte busy = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Byte nak = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            HashMap<String, PlcSINT> _map = new HashMap<String, PlcSINT>();
            _map.put("busy", new PlcSINT(busy));
            _map.put("nak", new PlcSINT(nak));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SceneInfo))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 1, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean sceneIsInactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Short scenenumber = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("sceneIsInactive", new PlcBOOL(sceneIsInactive));
            _map.put("scenenumber", new PlcINT(scenenumber));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedInfoOnOff))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean maskBitInfoOnOffOutput16 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput15 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput14 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput13 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput12 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput11 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput10 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput9 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput8 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput7 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput6 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput5 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput4 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput3 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput2 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput1 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput16 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput15 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput14 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput13 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput12 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput11 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput10 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput9 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput8 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput7 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput6 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput5 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput4 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput3 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput2 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput1 = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("maskBitInfoOnOffOutput16", new PlcBOOL(maskBitInfoOnOffOutput16));
            _map.put("maskBitInfoOnOffOutput15", new PlcBOOL(maskBitInfoOnOffOutput15));
            _map.put("maskBitInfoOnOffOutput14", new PlcBOOL(maskBitInfoOnOffOutput14));
            _map.put("maskBitInfoOnOffOutput13", new PlcBOOL(maskBitInfoOnOffOutput13));
            _map.put("maskBitInfoOnOffOutput12", new PlcBOOL(maskBitInfoOnOffOutput12));
            _map.put("maskBitInfoOnOffOutput11", new PlcBOOL(maskBitInfoOnOffOutput11));
            _map.put("maskBitInfoOnOffOutput10", new PlcBOOL(maskBitInfoOnOffOutput10));
            _map.put("maskBitInfoOnOffOutput9", new PlcBOOL(maskBitInfoOnOffOutput9));
            _map.put("maskBitInfoOnOffOutput8", new PlcBOOL(maskBitInfoOnOffOutput8));
            _map.put("maskBitInfoOnOffOutput7", new PlcBOOL(maskBitInfoOnOffOutput7));
            _map.put("maskBitInfoOnOffOutput6", new PlcBOOL(maskBitInfoOnOffOutput6));
            _map.put("maskBitInfoOnOffOutput5", new PlcBOOL(maskBitInfoOnOffOutput5));
            _map.put("maskBitInfoOnOffOutput4", new PlcBOOL(maskBitInfoOnOffOutput4));
            _map.put("maskBitInfoOnOffOutput3", new PlcBOOL(maskBitInfoOnOffOutput3));
            _map.put("maskBitInfoOnOffOutput2", new PlcBOOL(maskBitInfoOnOffOutput2));
            _map.put("maskBitInfoOnOffOutput1", new PlcBOOL(maskBitInfoOnOffOutput1));
            _map.put("infoOnOffOutput16", new PlcBOOL(infoOnOffOutput16));
            _map.put("infoOnOffOutput15", new PlcBOOL(infoOnOffOutput15));
            _map.put("infoOnOffOutput14", new PlcBOOL(infoOnOffOutput14));
            _map.put("infoOnOffOutput13", new PlcBOOL(infoOnOffOutput13));
            _map.put("infoOnOffOutput12", new PlcBOOL(infoOnOffOutput12));
            _map.put("infoOnOffOutput11", new PlcBOOL(infoOnOffOutput11));
            _map.put("infoOnOffOutput10", new PlcBOOL(infoOnOffOutput10));
            _map.put("infoOnOffOutput9", new PlcBOOL(infoOnOffOutput9));
            _map.put("infoOnOffOutput8", new PlcBOOL(infoOnOffOutput8));
            _map.put("infoOnOffOutput7", new PlcBOOL(infoOnOffOutput7));
            _map.put("infoOnOffOutput6", new PlcBOOL(infoOnOffOutput6));
            _map.put("infoOnOffOutput5", new PlcBOOL(infoOnOffOutput5));
            _map.put("infoOnOffOutput4", new PlcBOOL(infoOnOffOutput4));
            _map.put("infoOnOffOutput3", new PlcBOOL(infoOnOffOutput3));
            _map.put("infoOnOffOutput2", new PlcBOOL(infoOnOffOutput2));
            _map.put("infoOnOffOutput1", new PlcBOOL(infoOnOffOutput1));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActiveEnergy_V64))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readLong("", 64, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ApparantEnergy_V64))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readLong("", 64, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ReactiveEnergy_V64))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readLong("", 64, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Channel_Activation_24))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean activationStateOfChannel1 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel2 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel3 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel4 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel5 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel6 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel7 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel8 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel9 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel10 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel11 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel12 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel13 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel14 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel15 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel16 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel17 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel18 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel19 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel20 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel21 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel22 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel23 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel24 = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("activationStateOfChannel1", new PlcBOOL(activationStateOfChannel1));
            _map.put("activationStateOfChannel2", new PlcBOOL(activationStateOfChannel2));
            _map.put("activationStateOfChannel3", new PlcBOOL(activationStateOfChannel3));
            _map.put("activationStateOfChannel4", new PlcBOOL(activationStateOfChannel4));
            _map.put("activationStateOfChannel5", new PlcBOOL(activationStateOfChannel5));
            _map.put("activationStateOfChannel6", new PlcBOOL(activationStateOfChannel6));
            _map.put("activationStateOfChannel7", new PlcBOOL(activationStateOfChannel7));
            _map.put("activationStateOfChannel8", new PlcBOOL(activationStateOfChannel8));
            _map.put("activationStateOfChannel9", new PlcBOOL(activationStateOfChannel9));
            _map.put("activationStateOfChannel10", new PlcBOOL(activationStateOfChannel10));
            _map.put("activationStateOfChannel11", new PlcBOOL(activationStateOfChannel11));
            _map.put("activationStateOfChannel12", new PlcBOOL(activationStateOfChannel12));
            _map.put("activationStateOfChannel13", new PlcBOOL(activationStateOfChannel13));
            _map.put("activationStateOfChannel14", new PlcBOOL(activationStateOfChannel14));
            _map.put("activationStateOfChannel15", new PlcBOOL(activationStateOfChannel15));
            _map.put("activationStateOfChannel16", new PlcBOOL(activationStateOfChannel16));
            _map.put("activationStateOfChannel17", new PlcBOOL(activationStateOfChannel17));
            _map.put("activationStateOfChannel18", new PlcBOOL(activationStateOfChannel18));
            _map.put("activationStateOfChannel19", new PlcBOOL(activationStateOfChannel19));
            _map.put("activationStateOfChannel20", new PlcBOOL(activationStateOfChannel20));
            _map.put("activationStateOfChannel21", new PlcBOOL(activationStateOfChannel21));
            _map.put("activationStateOfChannel22", new PlcBOOL(activationStateOfChannel22));
            _map.put("activationStateOfChannel23", new PlcBOOL(activationStateOfChannel23));
            _map.put("activationStateOfChannel24", new PlcBOOL(activationStateOfChannel24));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVACModeNext))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer delayTimeMin = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short hvacMode = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("delayTimeMin", new PlcDINT(delayTimeMin));
            _map.put("hvacMode", new PlcINT(hvacMode));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DHWModeNext))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer delayTimeMin = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short dhwMode = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("delayTimeMin", new PlcDINT(delayTimeMin));
            _map.put("dhwMode", new PlcINT(dhwMode));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_OccModeNext))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer delayTimeMin = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short occupancyMode = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("delayTimeMin", new PlcDINT(delayTimeMin));
            _map.put("occupancyMode", new PlcINT(occupancyMode));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BuildingModeNext))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer delayTimeMin = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short buildingMode = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("delayTimeMin", new PlcDINT(delayTimeMin));
            _map.put("buildingMode", new PlcINT(buildingMode));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusLightingActuator))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean validactualvalue = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean locked = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean forced = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean nightmodeactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean staircaselightingFunction = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean dimming = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean localoverride = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean failure = readBuffer.readBit("", new WithReaderArgs[0]);
            Short actualvalue = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("validactualvalue", new PlcBOOL(validactualvalue));
            _map.put("locked", new PlcBOOL(locked));
            _map.put("forced", new PlcBOOL(forced));
            _map.put("nightmodeactive", new PlcBOOL(nightmodeactive));
            _map.put("staircaselightingFunction", new PlcBOOL(staircaselightingFunction));
            _map.put("dimming", new PlcBOOL(dimming));
            _map.put("localoverride", new PlcBOOL(localoverride));
            _map.put("failure", new PlcBOOL(failure));
            _map.put("actualvalue", new PlcINT(actualvalue));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Version))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short magicNumber = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0]);
            Short versionNumber = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0]);
            Short revisionNumber = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            HashMap<String, PlcINT> _map = new HashMap<String, PlcINT>();
            _map.put("magicNumber", new PlcINT(magicNumber));
            _map.put("versionNumber", new PlcINT(versionNumber));
            _map.put("revisionNumber", new PlcINT(revisionNumber));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_AlarmInfo))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short logNumber = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short alarmPriority = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short applicationArea = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short errorClass = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            byte reserved14 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved14 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved14 + " for reserved field.");
            }
            Boolean errorcodeSup = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean alarmtextSup = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean timestampSup = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean ackSup = readBuffer.readBit("", new WithReaderArgs[0]);
            short reserved15 = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0]);
            if (reserved15 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved15 + " for reserved field.");
            }
            Boolean locked = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean alarmunack = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean inalarm = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("logNumber", new PlcINT(logNumber));
            _map.put("alarmPriority", new PlcINT(alarmPriority));
            _map.put("applicationArea", new PlcINT(applicationArea));
            _map.put("errorClass", new PlcINT(errorClass));
            _map.put("errorcodeSup", new PlcBOOL(errorcodeSup));
            _map.put("alarmtextSup", new PlcBOOL(alarmtextSup));
            _map.put("timestampSup", new PlcBOOL(timestampSup));
            _map.put("ackSup", new PlcBOOL(ackSup));
            _map.put("locked", new PlcBOOL(locked));
            _map.put("alarmunack", new PlcBOOL(alarmunack));
            _map.put("inalarm", new PlcBOOL(inalarm));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TempRoomSetpSetF16_3))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float tempsetpcomf = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float tempsetpstdby = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float tempsetpeco = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            HashMap<String, PlcREAL> _map = new HashMap<String, PlcREAL>();
            _map.put("tempsetpcomf", new PlcREAL(tempsetpcomf));
            _map.put("tempsetpstdby", new PlcREAL(tempsetpstdby));
            _map.put("tempsetpeco", new PlcREAL(tempsetpeco));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TempRoomSetpSetShiftF16_3))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float tempsetpshiftcomf = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float tempsetpshiftstdby = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float tempsetpshifteco = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            HashMap<String, PlcREAL> _map = new HashMap<String, PlcREAL>();
            _map.put("tempsetpshiftcomf", new PlcREAL(tempsetpshiftcomf));
            _map.put("tempsetpshiftstdby", new PlcREAL(tempsetpshiftstdby));
            _map.put("tempsetpshifteco", new PlcREAL(tempsetpshifteco));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Scaling_Speed))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer timePeriod = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short percent = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("timePeriod", new PlcDINT(timePeriod));
            _map.put("percent", new PlcINT(percent));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Scaling_Step_Time))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer timePeriod = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short percent = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("timePeriod", new PlcDINT(timePeriod));
            _map.put("percent", new PlcINT(percent));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_MeteringValue))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer countval = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            Short valinffield = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            byte reserved16 = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            if (reserved16 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved16 + " for reserved field.");
            }
            Boolean alarmunack = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean inalarm = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean overridden = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean fault = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean outofservice = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("countval", new PlcDINT(countval));
            _map.put("valinffield", new PlcINT(valinffield));
            _map.put("alarmunack", new PlcBOOL(alarmunack));
            _map.put("inalarm", new PlcBOOL(inalarm));
            _map.put("overridden", new PlcBOOL(overridden));
            _map.put("fault", new PlcBOOL(fault));
            _map.put("outofservice", new PlcBOOL(outofservice));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_MBus_Address))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer manufactid = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Long identnumber = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            Short version = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short medium = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("manufactid", new PlcDINT(manufactid));
            _map.put("identnumber", new PlcLINT(identnumber));
            _map.put("version", new PlcINT(version));
            _map.put("medium", new PlcINT(medium));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Colour_RGB))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short r = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short g = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short b = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, PlcINT> _map = new HashMap<String, PlcINT>();
            _map.put("r", new PlcINT(r));
            _map.put("g", new PlcINT(g));
            _map.put("b", new PlcINT(b));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LanguageCodeAlpha2_ASCII))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            String value = readBuffer.readString("", 16, "ASCII", new WithReaderArgs[0]);
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Tariff_ActiveEnergy))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer activeelectricalenergy = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            Short tariff = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            short reserved17 = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved17 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved17 + " for reserved field.");
            }
            Boolean electricalengergyvalidity = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean tariffvalidity = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("activeelectricalenergy", new PlcDINT(activeelectricalenergy));
            _map.put("tariff", new PlcINT(tariff));
            _map.put("electricalengergyvalidity", new PlcBOOL(electricalengergyvalidity));
            _map.put("tariffvalidity", new PlcBOOL(tariffvalidity));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Prioritised_Mode_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean deactivationOfPriority = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte priorityLevel = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            Byte modeLevel = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("deactivationOfPriority", new PlcBOOL(deactivationOfPriority));
            _map.put("priorityLevel", new PlcSINT(priorityLevel));
            _map.put("modeLevel", new PlcSINT(modeLevel));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DALI_Control_Gear_Diagnostic))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean convertorError = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean ballastFailure = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean lampFailure = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean readOrResponse = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean addressIndicator = readBuffer.readBit("", new WithReaderArgs[0]);
            Short daliDeviceAddressOrDaliGroupAddress = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("convertorError", new PlcBOOL(convertorError));
            _map.put("ballastFailure", new PlcBOOL(ballastFailure));
            _map.put("lampFailure", new PlcBOOL(lampFailure));
            _map.put("readOrResponse", new PlcBOOL(readOrResponse));
            _map.put("addressIndicator", new PlcBOOL(addressIndicator));
            _map.put("daliDeviceAddressOrDaliGroupAddress", new PlcINT(daliDeviceAddressOrDaliGroupAddress));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DALI_Diagnostics))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean ballastFailure = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean lampFailure = readBuffer.readBit("", new WithReaderArgs[0]);
            Short deviceAddress = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("ballastFailure", new PlcBOOL(ballastFailure));
            _map.put("lampFailure", new PlcBOOL(lampFailure));
            _map.put("deviceAddress", new PlcINT(deviceAddress));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedPosition))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short heightPosition = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short slatsPosition = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            short reserved18 = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved18 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved18 + " for reserved field.");
            }
            Boolean validityHeightPosition = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean validitySlatsPosition = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("heightPosition", new PlcINT(heightPosition));
            _map.put("slatsPosition", new PlcINT(slatsPosition));
            _map.put("validityHeightPosition", new PlcBOOL(validityHeightPosition));
            _map.put("validitySlatsPosition", new PlcBOOL(validitySlatsPosition));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusSAB))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short heightPosition = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short slatsPosition = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Boolean upperEndPosReached = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean lowerEndPosReached = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean targetPosDrive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean restrictionOfTargetHeightPosPosCanNotBeReached = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean restrictionOfSlatsHeightPosPosCanNotBeReached = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean upDownPositionIsForcedByMoveupdownforcedInput = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean movementIsLockedEGByDevicelockedInput = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean generalFailureOfTheActuatorOrTheDrive = readBuffer.readBit("", new WithReaderArgs[0]);
            byte reserved19 = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            if (reserved19 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved19 + " for reserved field.");
            }
            Boolean validityHeightPos = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean validitySlatsPos = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("heightPosition", new PlcINT(heightPosition));
            _map.put("slatsPosition", new PlcINT(slatsPosition));
            _map.put("upperEndPosReached", new PlcBOOL(upperEndPosReached));
            _map.put("lowerEndPosReached", new PlcBOOL(lowerEndPosReached));
            _map.put("lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent", new PlcBOOL(lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent));
            _map.put("targetPosDrive", new PlcBOOL(targetPosDrive));
            _map.put("restrictionOfTargetHeightPosPosCanNotBeReached", new PlcBOOL(restrictionOfTargetHeightPosPosCanNotBeReached));
            _map.put("restrictionOfSlatsHeightPosPosCanNotBeReached", new PlcBOOL(restrictionOfSlatsHeightPosPosCanNotBeReached));
            _map.put("atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm", new PlcBOOL(atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm));
            _map.put("upDownPositionIsForcedByMoveupdownforcedInput", new PlcBOOL(upDownPositionIsForcedByMoveupdownforcedInput));
            _map.put("movementIsLockedEGByDevicelockedInput", new PlcBOOL(movementIsLockedEGByDevicelockedInput));
            _map.put("actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface", new PlcBOOL(actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface));
            _map.put("generalFailureOfTheActuatorOrTheDrive", new PlcBOOL(generalFailureOfTheActuatorOrTheDrive));
            _map.put("validityHeightPos", new PlcBOOL(validityHeightPos));
            _map.put("validitySlatsPos", new PlcBOOL(validitySlatsPos));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Colour_xyY))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer xAxis = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Integer yAxis = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short brightness = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            short reserved20 = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved20 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved20 + " for reserved field.");
            }
            Boolean validityXy = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean validityBrightness = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("xAxis", new PlcDINT(xAxis));
            _map.put("yAxis", new PlcDINT(yAxis));
            _map.put("brightness", new PlcINT(brightness));
            _map.put("validityXy", new PlcBOOL(validityXy));
            _map.put("validityBrightness", new PlcBOOL(validityBrightness));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Converter_Status))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte converterModeAccordingToTheDaliConverterStateMachine = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            byte reserved21 = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved21 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved21 + " for reserved field.");
            }
            Boolean hardwiredSwitchIsActive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean hardwiredInhibitIsActive = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte functionTestPending = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            Byte durationTestPending = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            Byte partialDurationTestPending = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            Byte converterFailure = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("converterModeAccordingToTheDaliConverterStateMachine", new PlcSINT(converterModeAccordingToTheDaliConverterStateMachine));
            _map.put("hardwiredSwitchIsActive", new PlcBOOL(hardwiredSwitchIsActive));
            _map.put("hardwiredInhibitIsActive", new PlcBOOL(hardwiredInhibitIsActive));
            _map.put("functionTestPending", new PlcSINT(functionTestPending));
            _map.put("durationTestPending", new PlcSINT(durationTestPending));
            _map.put("partialDurationTestPending", new PlcSINT(partialDurationTestPending));
            _map.put("converterFailure", new PlcSINT(converterFailure));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Converter_Test_Result))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte ltrf = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Byte ltrd = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Byte ltrp = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            byte reserved22 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved22 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved22 + " for reserved field.");
            }
            Byte sf = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            Byte sd = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            Byte sp = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            byte reserved23 = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved23 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved23 + " for reserved field.");
            }
            Integer ldtr = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short lpdtr = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("ltrf", new PlcSINT(ltrf));
            _map.put("ltrd", new PlcSINT(ltrd));
            _map.put("ltrp", new PlcSINT(ltrp));
            _map.put("sf", new PlcSINT(sf));
            _map.put("sd", new PlcSINT(sd));
            _map.put("sp", new PlcSINT(sp));
            _map.put("ldtr", new PlcDINT(ldtr));
            _map.put("lpdtr", new PlcINT(lpdtr));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Battery_Info))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean batteryFailure = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean batteryDurationFailure = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean batteryFullyCharged = readBuffer.readBit("", new WithReaderArgs[0]);
            Short batteryChargeLevel = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("batteryFailure", new PlcBOOL(batteryFailure));
            _map.put("batteryDurationFailure", new PlcBOOL(batteryDurationFailure));
            _map.put("batteryFullyCharged", new PlcBOOL(batteryFullyCharged));
            _map.put("batteryChargeLevel", new PlcINT(batteryChargeLevel));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Brightness_Colour_Temperature_Transition))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer ms = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Integer temperatureK = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short percent = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            short reserved24 = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0]);
            if (reserved24 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved24 + " for reserved field.");
            }
            Boolean validityOfTheTimePeriod = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean validityOfTheAbsoluteColourTemperature = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean validityOfTheAbsoluteBrightness = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("ms", new PlcDINT(ms));
            _map.put("temperatureK", new PlcDINT(temperatureK));
            _map.put("percent", new PlcINT(percent));
            _map.put("validityOfTheTimePeriod", new PlcBOOL(validityOfTheTimePeriod));
            _map.put("validityOfTheAbsoluteColourTemperature", new PlcBOOL(validityOfTheAbsoluteColourTemperature));
            _map.put("validityOfTheAbsoluteBrightness", new PlcBOOL(validityOfTheAbsoluteBrightness));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Brightness_Colour_Temperature_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean cct = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeColourTemperature = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            byte reserved25 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved25 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved25 + " for reserved field.");
            }
            Boolean cb = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeBrightness = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            short reserved26 = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            if (reserved26 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved26 + " for reserved field.");
            }
            Boolean cctAndStepCodeColourValidity = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean cbAndStepCodeBrightnessValidity = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("cct", new PlcBOOL(cct));
            _map.put("stepCodeColourTemperature", new PlcSINT(stepCodeColourTemperature));
            _map.put("cb", new PlcBOOL(cb));
            _map.put("stepCodeBrightness", new PlcSINT(stepCodeBrightness));
            _map.put("cctAndStepCodeColourValidity", new PlcBOOL(cctAndStepCodeColourValidity));
            _map.put("cbAndStepCodeBrightnessValidity", new PlcBOOL(cbAndStepCodeBrightnessValidity));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Colour_RGBW))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short colourLevelRed = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short colourLevelGreen = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short colourLevelBlue = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short colourLevelWhite = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            short reserved27 = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved27 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved27 + " for reserved field.");
            }
            if ((reserved27 = (short)readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved27 + " for reserved field.");
            }
            Boolean mr = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean mg = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean mb = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean mw = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("colourLevelRed", new PlcINT(colourLevelRed));
            _map.put("colourLevelGreen", new PlcINT(colourLevelGreen));
            _map.put("colourLevelBlue", new PlcINT(colourLevelBlue));
            _map.put("colourLevelWhite", new PlcINT(colourLevelWhite));
            _map.put("mr", new PlcBOOL(mr));
            _map.put("mg", new PlcBOOL(mg));
            _map.put("mb", new PlcBOOL(mb));
            _map.put("mw", new PlcBOOL(mw));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Relative_Control_RGBW))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean maskcw = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskcb = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskcg = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskcr = readBuffer.readBit("", new WithReaderArgs[0]);
            byte reserved28 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved28 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved28 + " for reserved field.");
            }
            Boolean cw = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeColourWhite = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            byte reserved29 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved29 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved29 + " for reserved field.");
            }
            Boolean cb = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeColourBlue = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            byte reserved30 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved30 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved30 + " for reserved field.");
            }
            Boolean cg = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeColourGreen = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            byte reserved31 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved31 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved31 + " for reserved field.");
            }
            Boolean cr = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeColourRed = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            byte reserved32 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved32 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved32 + " for reserved field.");
            }
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("maskcw", new PlcBOOL(maskcw));
            _map.put("maskcb", new PlcBOOL(maskcb));
            _map.put("maskcg", new PlcBOOL(maskcg));
            _map.put("maskcr", new PlcBOOL(maskcr));
            _map.put("cw", new PlcBOOL(cw));
            _map.put("stepCodeColourWhite", new PlcSINT(stepCodeColourWhite));
            _map.put("cb", new PlcBOOL(cb));
            _map.put("stepCodeColourBlue", new PlcSINT(stepCodeColourBlue));
            _map.put("cg", new PlcBOOL(cg));
            _map.put("stepCodeColourGreen", new PlcSINT(stepCodeColourGreen));
            _map.put("cr", new PlcBOOL(cr));
            _map.put("stepCodeColourRed", new PlcSINT(stepCodeColourRed));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Relative_Control_RGB))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean cb = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeColourBlue = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            byte reserved33 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved33 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved33 + " for reserved field.");
            }
            Boolean cg = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeColourGreen = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            byte reserved34 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved34 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved34 + " for reserved field.");
            }
            Boolean cr = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeColourRed = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            byte reserved35 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved35 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved35 + " for reserved field.");
            }
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("cb", new PlcBOOL(cb));
            _map.put("stepCodeColourBlue", new PlcSINT(stepCodeColourBlue));
            _map.put("cg", new PlcBOOL(cg));
            _map.put("stepCodeColourGreen", new PlcSINT(stepCodeColourGreen));
            _map.put("cr", new PlcBOOL(cr));
            _map.put("stepCodeColourRed", new PlcSINT(stepCodeColourRed));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_GeographicalLocation))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float longitude = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            Float latitude = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            HashMap<String, PlcREAL> _map = new HashMap<String, PlcREAL>();
            _map.put("longitude", new PlcREAL(longitude));
            _map.put("latitude", new PlcREAL(latitude));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TempRoomSetpSetF16_4))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float roomTemperatureSetpointComfort = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float roomTemperatureSetpointStandby = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float roomTemperatureSetpointEconomy = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float roomTemperatureSetpointBuildingProtection = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            HashMap<String, PlcREAL> _map = new HashMap<String, PlcREAL>();
            _map.put("roomTemperatureSetpointComfort", new PlcREAL(roomTemperatureSetpointComfort));
            _map.put("roomTemperatureSetpointStandby", new PlcREAL(roomTemperatureSetpointStandby));
            _map.put("roomTemperatureSetpointEconomy", new PlcREAL(roomTemperatureSetpointEconomy));
            _map.put("roomTemperatureSetpointBuildingProtection", new PlcREAL(roomTemperatureSetpointBuildingProtection));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TempRoomSetpSetShiftF16_4))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float roomTemperatureSetpointShiftComfort = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float roomTemperatureSetpointShiftStandby = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float roomTemperatureSetpointShiftEconomy = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float roomTemperatureSetpointShiftBuildingProtection = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            HashMap<String, PlcREAL> _map = new HashMap<String, PlcREAL>();
            _map.put("roomTemperatureSetpointShiftComfort", new PlcREAL(roomTemperatureSetpointShiftComfort));
            _map.put("roomTemperatureSetpointShiftStandby", new PlcREAL(roomTemperatureSetpointShiftStandby));
            _map.put("roomTemperatureSetpointShiftEconomy", new PlcREAL(roomTemperatureSetpointShiftEconomy));
            _map.put("roomTemperatureSetpointShiftBuildingProtection", new PlcREAL(roomTemperatureSetpointShiftBuildingProtection));
            return new PlcStruct(_map);
        }
        return null;
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, KnxDatapointType datapointType) throws SerializationException {
        KnxDatapoint.staticSerialize(writeBuffer, _value, datapointType, ByteOrder.BIG_ENDIAN);
    }

    /*
     * Opcode count of 14473 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, KnxDatapointType datapointType, ByteOrder byteOrder) throws SerializationException {
        block1: {
            block345: {
                block344: {
                    block343: {
                        block342: {
                            block341: {
                                block340: {
                                    block339: {
                                        block338: {
                                            block337: {
                                                block336: {
                                                    block335: {
                                                        block334: {
                                                            block333: {
                                                                block332: {
                                                                    block331: {
                                                                        block330: {
                                                                            block329: {
                                                                                block328: {
                                                                                    block327: {
                                                                                        block326: {
                                                                                            block325: {
                                                                                                block324: {
                                                                                                    block323: {
                                                                                                        block322: {
                                                                                                            block321: {
                                                                                                                block320: {
                                                                                                                    block319: {
                                                                                                                        block318: {
                                                                                                                            block317: {
                                                                                                                                block316: {
                                                                                                                                    block315: {
                                                                                                                                        block314: {
                                                                                                                                            block313: {
                                                                                                                                                block312: {
                                                                                                                                                    block311: {
                                                                                                                                                        block310: {
                                                                                                                                                            block309: {
                                                                                                                                                                block308: {
                                                                                                                                                                    block307: {
                                                                                                                                                                        block306: {
                                                                                                                                                                            block305: {
                                                                                                                                                                                block304: {
                                                                                                                                                                                    block303: {
                                                                                                                                                                                        block302: {
                                                                                                                                                                                            block301: {
                                                                                                                                                                                                block300: {
                                                                                                                                                                                                    block299: {
                                                                                                                                                                                                        block298: {
                                                                                                                                                                                                            block297: {
                                                                                                                                                                                                                block296: {
                                                                                                                                                                                                                    block295: {
                                                                                                                                                                                                                        block294: {
                                                                                                                                                                                                                            block293: {
                                                                                                                                                                                                                                block292: {
                                                                                                                                                                                                                                    block291: {
                                                                                                                                                                                                                                        block290: {
                                                                                                                                                                                                                                            block289: {
                                                                                                                                                                                                                                                block288: {
                                                                                                                                                                                                                                                    block287: {
                                                                                                                                                                                                                                                        block286: {
                                                                                                                                                                                                                                                            block285: {
                                                                                                                                                                                                                                                                block284: {
                                                                                                                                                                                                                                                                    block283: {
                                                                                                                                                                                                                                                                        block282: {
                                                                                                                                                                                                                                                                            block281: {
                                                                                                                                                                                                                                                                                block280: {
                                                                                                                                                                                                                                                                                    block279: {
                                                                                                                                                                                                                                                                                        block278: {
                                                                                                                                                                                                                                                                                            block277: {
                                                                                                                                                                                                                                                                                                block276: {
                                                                                                                                                                                                                                                                                                    block275: {
                                                                                                                                                                                                                                                                                                        block274: {
                                                                                                                                                                                                                                                                                                            block273: {
                                                                                                                                                                                                                                                                                                                block272: {
                                                                                                                                                                                                                                                                                                                    block271: {
                                                                                                                                                                                                                                                                                                                        block270: {
                                                                                                                                                                                                                                                                                                                            block269: {
                                                                                                                                                                                                                                                                                                                                block268: {
                                                                                                                                                                                                                                                                                                                                    block267: {
                                                                                                                                                                                                                                                                                                                                        block266: {
                                                                                                                                                                                                                                                                                                                                            block265: {
                                                                                                                                                                                                                                                                                                                                                block264: {
                                                                                                                                                                                                                                                                                                                                                    block263: {
                                                                                                                                                                                                                                                                                                                                                        block262: {
                                                                                                                                                                                                                                                                                                                                                            block261: {
                                                                                                                                                                                                                                                                                                                                                                block260: {
                                                                                                                                                                                                                                                                                                                                                                    block259: {
                                                                                                                                                                                                                                                                                                                                                                        block258: {
                                                                                                                                                                                                                                                                                                                                                                            block257: {
                                                                                                                                                                                                                                                                                                                                                                                block256: {
                                                                                                                                                                                                                                                                                                                                                                                    block255: {
                                                                                                                                                                                                                                                                                                                                                                                        block254: {
                                                                                                                                                                                                                                                                                                                                                                                            block253: {
                                                                                                                                                                                                                                                                                                                                                                                                block252: {
                                                                                                                                                                                                                                                                                                                                                                                                    block251: {
                                                                                                                                                                                                                                                                                                                                                                                                        block250: {
                                                                                                                                                                                                                                                                                                                                                                                                            block249: {
                                                                                                                                                                                                                                                                                                                                                                                                                block248: {
                                                                                                                                                                                                                                                                                                                                                                                                                    block247: {
                                                                                                                                                                                                                                                                                                                                                                                                                        block246: {
                                                                                                                                                                                                                                                                                                                                                                                                                            block245: {
                                                                                                                                                                                                                                                                                                                                                                                                                                block244: {
                                                                                                                                                                                                                                                                                                                                                                                                                                    block243: {
                                                                                                                                                                                                                                                                                                                                                                                                                                        block242: {
                                                                                                                                                                                                                                                                                                                                                                                                                                            block241: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                block240: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    block239: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        block238: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            block237: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                block236: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block235: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block234: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block233: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block232: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block231: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block230: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block229: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block228: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block227: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block226: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block225: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block224: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block223: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block222: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block221: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block220: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block219: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block218: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block217: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block216: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block215: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block214: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block213: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block212: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block211: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block210: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block209: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block208: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block207: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block206: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block205: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block204: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block203: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block202: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block201: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block200: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block199: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block198: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block197: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block196: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block195: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block194: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block193: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block192: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block191: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block190: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block189: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block188: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block187: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block186: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block185: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block184: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block183: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block182: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block181: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block180: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block179: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block178: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block177: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block176: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block175: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block174: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block173: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block172: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block171: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block170: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block169: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block168: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block167: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block166: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block165: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block164: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block163: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block162: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block161: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block160: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block159: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block158: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block157: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block156: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block155: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block154: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block153: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block152: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block151: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block150: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block149: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block148: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block147: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block146: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block145: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block144: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block143: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block142: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block141: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block140: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block139: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block138: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block137: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block136: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block135: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block134: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block133: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block132: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block131: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block130: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block129: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block128: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block127: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block126: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block125: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block124: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block123: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block122: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block121: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block120: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block119: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block118: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block117: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block116: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block115: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block114: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block113: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block112: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block111: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block110: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block109: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block108: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block107: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block106: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block105: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block104: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block103: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block102: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block101: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block100: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block99: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block98: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block97: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block96: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block95: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block94: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block93: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block92: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block91: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block90: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block89: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block88: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block87: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block86: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block85: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block84: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block83: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block82: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block81: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block80: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block79: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block78: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block77: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block76: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block75: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block74: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block73: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block72: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block71: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block70: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block69: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block68: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block67: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block66: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block65: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block64: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block63: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block62: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block61: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block60: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block59: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block58: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block57: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block56: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block55: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block54: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block53: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block52: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block51: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block50: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block49: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block48: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block47: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block46: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block45: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block44: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block43: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block42: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block41: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block40: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block39: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block38: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block37: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block36: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block35: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block34: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block33: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block32: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block31: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block30: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block29: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block28: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block27: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block26: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block25: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block24: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block23: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block22: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block21: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block20: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block19: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block18: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block17: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block16: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block15: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block14: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block13: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block12: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block11: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block10: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block9: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block8: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block7: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block6: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block5: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block4: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block3: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block2: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block0: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.BOOL))) break block0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.BYTE))) break block2;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            short value = _value.getShort();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.WORD))) break block3;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        int value = _value.getInt();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DWORD))) break block4;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    long value = _value.getLong();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LWORD))) break block5;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BigInteger value = _value.getBigInteger();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.USINT))) break block6;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            short value = _value.getShort();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.SINT))) break block7;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        byte value = _value.getByte();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeSignedByte("", 8, ((Number)value).byteValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.UINT))) break block8;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    int value = _value.getInt();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.INT))) break block9;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                short value = _value.getShort();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.UDINT))) break block10;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            long value = _value.getLong();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DINT))) break block11;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        int value = _value.getInt();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.ULINT))) break block12;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    BigInteger value = _value.getBigInteger();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LINT))) break block13;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                long value = _value.getLong();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeLong("", 64, ((Number)value).longValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.REAL))) break block14;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            float value = _value.getFloat();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LREAL))) break block15;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        double value = _value.getDouble();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeDouble("", 64, value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.CHAR))) break block16;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String value = _value.getString();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeString("", 8, "UTF-8", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.WCHAR))) break block17;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                String value = _value.getString();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeString("", 16, "UTF-16", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.TIME))) break block18;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            long value = _value.getLong();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LTIME))) break block19;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BigInteger value = _value.getBigInteger();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DATE))) break block20;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    int value = _value.getInt();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.TIME_OF_DAY))) break block21;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                long value = _value.getLong();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.TOD))) break block22;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            long value = _value.getLong();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DATE_AND_TIME))) break block23;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        int year = 0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedInt("", 16, ((Number)year).intValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        short month = 0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 8, ((Number)month).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        short day = 0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 8, ((Number)day).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        short dayOfWeek = 0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 8, ((Number)dayOfWeek).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        short hour = 0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 8, ((Number)hour).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        short minutes = 0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 8, ((Number)minutes).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        short seconds = 0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 8, ((Number)seconds).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        long nanos = 0L;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedLong("", 32, ((Number)nanos).longValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DT))) break block24;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    int year = 0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedInt("", 16, ((Number)year).intValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    short month = 0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 8, ((Number)month).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    short day = 0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 8, ((Number)day).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    short dayOfWeek = 0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 8, ((Number)dayOfWeek).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    short hour = 0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 8, ((Number)hour).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    short minutes = 0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 8, ((Number)minutes).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    short seconds = 0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 8, ((Number)seconds).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    long nanos = 0L;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedLong("", 32, ((Number)nanos).longValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Switch))) break block25;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Bool))) break block26;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Enable))) break block27;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Ramp))) break block28;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Alarm))) break block29;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BinaryValue))) break block30;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Step))) break block31;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_UpDown))) break block32;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_OpenClose))) break block33;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Start))) break block34;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_State))) break block35;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Invert))) break block36;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DimSendStyle))) break block37;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_InputSource))) break block38;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Reset))) break block39;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Ack))) break block40;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Trigger))) break block41;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Occupancy))) break block42;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Window_Door))) break block43;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LogicalFunction))) break block44;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Scene_AB))) break block45;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ShutterBlinds_Mode))) break block46;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DayNight))) break block47;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Heat_Cool))) break block48;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    boolean value = _value.getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeBit("", value, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Switch_Control))) break block49;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeUnsignedShort("", 6, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeBit("", control, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                boolean on = ((PlcValue)_value.getStruct().get("on")).getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeBit("", on, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Bool_Control))) break block50;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedShort("", 6, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeBit("", control, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            boolean valueTrue = ((PlcValue)_value.getStruct().get("valueTrue")).getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeBit("", valueTrue, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Enable_Control))) break block51;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 6, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeBit("", control, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        boolean enable = ((PlcValue)_value.getStruct().get("enable")).getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeBit("", enable, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Ramp_Control))) break block52;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeUnsignedShort("", 6, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeBit("", control, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    boolean ramp = ((PlcValue)_value.getStruct().get("ramp")).getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    writeBuffer.writeBit("", ramp, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Alarm_Control))) break block53;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeUnsignedShort("", 6, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeBit("", control, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                boolean alarm = ((PlcValue)_value.getStruct().get("alarm")).getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                writeBuffer.writeBit("", alarm, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BinaryValue_Control))) break block54;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeUnsignedShort("", 6, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeBit("", control, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            boolean high = ((PlcValue)_value.getStruct().get("high")).getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            writeBuffer.writeBit("", high, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Step_Control))) break block55;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeUnsignedShort("", 6, ((Number)0).shortValue(), new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeBit("", control, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        boolean increase = ((PlcValue)_value.getStruct().get("increase")).getBoolean();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        writeBuffer.writeBit("", increase, new WithWriterArgs[0]);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block1;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                          