/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum FirmwareType {
    SYSTEM_1(16),
    SYSTEM_2(32),
    SYSTEM_300(768),
    SYSTEM_7(1792),
    SYSTEM_B(1968),
    IR_DECODER(2064),
    COUPLER(2320),
    NONE(2800),
    SYSTEM_1_PL110(4272),
    SYSTEM_B_PL110(6064),
    MEDIA_COUPLER_PL_TP(6400),
    RF_BI_DIRECTIONAL_DEVICES(8192),
    RF_UNI_DIRECTIONAL_DEVICES(8448),
    SYSTEM_1_TP0(12288),
    SYSTEM_1_PL132(16384),
    SYSTEM_7_KNX_NET_IP(22272);

    private static final Map<Integer, FirmwareType> map;
    private int value;

    private FirmwareType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static FirmwareType enumForValue(int value) {
        return map.get(value);
    }

    public static Boolean isDefined(int value) {
        return map.containsKey(value);
    }

    static {
        map = new HashMap<Integer, FirmwareType>();
        for (FirmwareType value : FirmwareType.values()) {
            map.put(value.getValue(), value);
        }
    }
}

