/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.protocol;

import io.netty.channel.socket.DatagramChannel;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.commons.codec.binary.Hex;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.knxnetip.context.KnxNetIpDriverContext;
import org.apache.plc4x.java.knxnetip.ets.model.EtsModel;
import org.apache.plc4x.java.knxnetip.ets.model.GroupAddress;
import org.apache.plc4x.java.knxnetip.field.KnxNetIpField;
import org.apache.plc4x.java.knxnetip.model.KnxNetIpSubscriptionHandle;
import org.apache.plc4x.java.knxnetip.readwrite.Apdu;
import org.apache.plc4x.java.knxnetip.readwrite.ApduData;
import org.apache.plc4x.java.knxnetip.readwrite.ApduDataContainer;
import org.apache.plc4x.java.knxnetip.readwrite.ApduDataGroupValueWrite;
import org.apache.plc4x.java.knxnetip.readwrite.CEMIAdditionalInformation;
import org.apache.plc4x.java.knxnetip.readwrite.CEMIPriority;
import org.apache.plc4x.java.knxnetip.readwrite.ConnectionRequest;
import org.apache.plc4x.java.knxnetip.readwrite.ConnectionRequestInformationTunnelConnection;
import org.apache.plc4x.java.knxnetip.readwrite.ConnectionResponse;
import org.apache.plc4x.java.knxnetip.readwrite.ConnectionResponseDataBlockTunnelConnection;
import org.apache.plc4x.java.knxnetip.readwrite.ConnectionStateRequest;
import org.apache.plc4x.java.knxnetip.readwrite.ConnectionStateResponse;
import org.apache.plc4x.java.knxnetip.readwrite.DisconnectRequest;
import org.apache.plc4x.java.knxnetip.readwrite.DisconnectResponse;
import org.apache.plc4x.java.knxnetip.readwrite.HPAIControlEndpoint;
import org.apache.plc4x.java.knxnetip.readwrite.HPAIDataEndpoint;
import org.apache.plc4x.java.knxnetip.readwrite.HPAIDiscoveryEndpoint;
import org.apache.plc4x.java.knxnetip.readwrite.HostProtocolCode;
import org.apache.plc4x.java.knxnetip.readwrite.IPAddress;
import org.apache.plc4x.java.knxnetip.readwrite.KnxAddress;
import org.apache.plc4x.java.knxnetip.readwrite.KnxDatapoint;
import org.apache.plc4x.java.knxnetip.readwrite.KnxGroupAddress;
import org.apache.plc4x.java.knxnetip.readwrite.KnxGroupAddress2Level;
import org.apache.plc4x.java.knxnetip.readwrite.KnxGroupAddress3Level;
import org.apache.plc4x.java.knxnetip.readwrite.KnxGroupAddressFreeLevel;
import org.apache.plc4x.java.knxnetip.readwrite.KnxNetIpMessage;
import org.apache.plc4x.java.knxnetip.readwrite.KnxNetIpTunneling;
import org.apache.plc4x.java.knxnetip.readwrite.LDataExtended;
import org.apache.plc4x.java.knxnetip.readwrite.LDataFrame;
import org.apache.plc4x.java.knxnetip.readwrite.LDataInd;
import org.apache.plc4x.java.knxnetip.readwrite.LDataReq;
import org.apache.plc4x.java.knxnetip.readwrite.SearchRequest;
import org.apache.plc4x.java.knxnetip.readwrite.SearchResponse;
import org.apache.plc4x.java.knxnetip.readwrite.ServiceId;
import org.apache.plc4x.java.knxnetip.readwrite.Status;
import org.apache.plc4x.java.knxnetip.readwrite.TunnelingRequest;
import org.apache.plc4x.java.knxnetip.readwrite.TunnelingRequestDataBlock;
import org.apache.plc4x.java.knxnetip.readwrite.TunnelingResponse;
import org.apache.plc4x.java.knxnetip.readwrite.TunnelingResponseDataBlock;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionEvent;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.model.DefaultPlcConsumerRegistration;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionField;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnxNetIpProtocolLogic
extends Plc4xProtocolBase<KnxNetIpMessage>
implements PlcSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnxNetIpProtocolLogic.class);
    public static final Duration REQUEST_TIMEOUT = Duration.ofMillis(10000L);
    private KnxNetIpDriverContext knxNetIpDriverContext;
    private Timer connectionStateTimer;
    private static final AtomicInteger sequenceCounter = new AtomicInteger(0);
    private RequestTransactionManager tm;
    private final Map<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>> consumers = new ConcurrentHashMap<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>>();

    public void setDriverContext(DriverContext driverContext) {
        super.setDriverContext(driverContext);
        this.knxNetIpDriverContext = (KnxNetIpDriverContext)driverContext;
        this.tm = new RequestTransactionManager(1);
    }

    public void onConnect(final ConversationContext<KnxNetIpMessage> context) {
        if (!context.isPassive()) {
            LOGGER.info("KNX Driver running in ACTIVE mode.");
            this.knxNetIpDriverContext.setPassiveMode(false);
            DatagramChannel channel = (DatagramChannel)context.getChannel();
            InetSocketAddress localSocketAddress = channel.localAddress();
            this.knxNetIpDriverContext.setLocalIPAddress(new IPAddress(localSocketAddress.getAddress().getAddress()));
            this.knxNetIpDriverContext.setLocalPort(localSocketAddress.getPort());
            LOGGER.info("Sending KNXnet/IP Search Request.");
            SearchRequest searchRequest = new SearchRequest(new HPAIDiscoveryEndpoint(HostProtocolCode.IPV4_UDP, this.knxNetIpDriverContext.getLocalIPAddress(), this.knxNetIpDriverContext.getLocalPort()));
            context.sendRequest((Object)searchRequest).expectResponse(KnxNetIpMessage.class, Duration.ofMillis(1000L)).check(p -> p instanceof SearchResponse).unwrap(p -> (SearchResponse)p).handle(searchResponse -> {
                LOGGER.info("Got KNXnet/IP Search Response.");
                ServiceId tunnelingService = searchResponse.getDibSuppSvcFamilies().getServiceIds().stream().filter(serviceId -> serviceId instanceof KnxNetIpTunneling).findFirst().orElse(null);
                if (tunnelingService != null) {
                    this.knxNetIpDriverContext.setGatewayAddress(searchResponse.getDibDeviceInfo().getKnxAddress());
                    this.knxNetIpDriverContext.setGatewayName(new String(searchResponse.getDibDeviceInfo().getDeviceFriendlyName()).trim());
                    LOGGER.info(String.format("Found KNXnet/IP Gateway '%s' with KNX address '%d.%d.%d'", this.knxNetIpDriverContext.getGatewayName(), this.knxNetIpDriverContext.getGatewayAddress().getMainGroup(), this.knxNetIpDriverContext.getGatewayAddress().getMiddleGroup(), this.knxNetIpDriverContext.getGatewayAddress().getSubGroup()));
                    ConnectionRequest connectionRequest = new ConnectionRequest(new HPAIDiscoveryEndpoint(HostProtocolCode.IPV4_UDP, this.knxNetIpDriverContext.getLocalIPAddress(), this.knxNetIpDriverContext.getLocalPort()), new HPAIDataEndpoint(HostProtocolCode.IPV4_UDP, this.knxNetIpDriverContext.getLocalIPAddress(), this.knxNetIpDriverContext.getLocalPort()), new ConnectionRequestInformationTunnelConnection(this.knxNetIpDriverContext.getTunnelConnectionType()));
                    LOGGER.info("Sending KNXnet/IP Connection Request.");
                    context.sendRequest((Object)connectionRequest).expectResponse(KnxNetIpMessage.class, Duration.ofMillis(1000L)).check(p -> p instanceof ConnectionResponse).unwrap(p -> (ConnectionResponse)p).handle(connectionResponse -> {
                        this.knxNetIpDriverContext.setCommunicationChannelId(connectionResponse.getCommunicationChannelId());
                        LOGGER.info(String.format("Received KNXnet/IP Connection Response (Connection Id %s)", this.knxNetIpDriverContext.getCommunicationChannelId()));
                        Status status = connectionResponse.getStatus();
                        if (status == Status.NO_ERROR) {
                            ConnectionResponseDataBlockTunnelConnection tunnelConnectionDataBlock = (ConnectionResponseDataBlockTunnelConnection)connectionResponse.getConnectionResponseDataBlock();
                            this.knxNetIpDriverContext.setClientKnxAddress(tunnelConnectionDataBlock.getKnxAddress());
                            KnxAddress gatewayAddress = this.knxNetIpDriverContext.getGatewayAddress();
                            KnxAddress clientKnxAddress = this.knxNetIpDriverContext.getClientKnxAddress();
                            LOGGER.info(String.format("Successfully connected to KNXnet/IP Gateway '%s' with KNX address '%d.%d.%d' got assigned client KNX address '%d.%d.%d'", this.knxNetIpDriverContext.getGatewayName(), gatewayAddress.getMainGroup(), gatewayAddress.getMiddleGroup(), gatewayAddress.getSubGroup(), clientKnxAddress.getMainGroup(), clientKnxAddress.getMiddleGroup(), clientKnxAddress.getSubGroup()));
                            context.fireConnected();
                            this.connectionStateTimer = new Timer();
                            this.connectionStateTimer.scheduleAtFixedRate(new TimerTask(){

                                @Override
                                public void run() {
                                    ConnectionStateRequest connectionStateRequest = new ConnectionStateRequest(KnxNetIpProtocolLogic.this.knxNetIpDriverContext.getCommunicationChannelId(), new HPAIControlEndpoint(HostProtocolCode.IPV4_UDP, KnxNetIpProtocolLogic.this.knxNetIpDriverContext.getLocalIPAddress(), KnxNetIpProtocolLogic.this.knxNetIpDriverContext.getLocalPort()));
                                    context.sendRequest((Object)connectionStateRequest).expectResponse(KnxNetIpMessage.class, Duration.ofMillis(1000L)).check(p -> p instanceof ConnectionStateResponse).unwrap(p -> (ConnectionStateResponse)p).handle(connectionStateResponse -> {
                                        if (connectionStateResponse.getStatus() != Status.NO_ERROR) {
                                            if (connectionStateResponse.getStatus() != null) {
                                                LOGGER.error(String.format("Connection state problems. Got %s", connectionStateResponse.getStatus().name()));
                                            } else {
                                                LOGGER.error("Connection state problems. Got no status information.");
                                            }
                                            KnxNetIpProtocolLogic.this.connectionStateTimer.cancel();
                                        }
                                    });
                                }
                            }, 60000L, 60000L);
                        } else {
                            LOGGER.error(String.format("Not connected to KNXnet/IP Gateway '%s' with KNX address '%d.%d.%d' got status: '%s'", this.knxNetIpDriverContext.getGatewayName(), this.knxNetIpDriverContext.getGatewayAddress().getMainGroup(), this.knxNetIpDriverContext.getGatewayAddress().getMiddleGroup(), this.knxNetIpDriverContext.getGatewayAddress().getSubGroup(), status.toString()));
                        }
                    });
                } else {
                    LOGGER.error("Not connected to KNCnet/IP Gateway. The device doesn't support Tunneling.");
                }
            });
        } else {
            LOGGER.info("KNX Driver running in PASSIVE mode.");
            this.knxNetIpDriverContext.setPassiveMode(true);
            context.fireConnected();
        }
    }

    public void onDisconnect(ConversationContext<KnxNetIpMessage> context) {
        this.connectionStateTimer.cancel();
        DisconnectRequest disconnectRequest = new DisconnectRequest(this.knxNetIpDriverContext.getCommunicationChannelId(), new HPAIControlEndpoint(HostProtocolCode.IPV4_UDP, this.knxNetIpDriverContext.getLocalIPAddress(), this.knxNetIpDriverContext.getLocalPort()));
        context.sendRequest((Object)disconnectRequest).expectResponse(KnxNetIpMessage.class, Duration.ofMillis(1000L)).check(p -> p instanceof DisconnectResponse).unwrap(p -> (DisconnectResponse)p).handle(disconnectResponse -> {
            String gatewayName = this.knxNetIpDriverContext.getGatewayName();
            KnxAddress gatewayAddress = this.knxNetIpDriverContext.getGatewayAddress();
            LOGGER.info(String.format("Disconnected from KNX Gateway '%s' with KNX address '%d.%d.%d'", gatewayName, gatewayAddress.getMainGroup(), gatewayAddress.getMiddleGroup(), gatewayAddress.getSubGroup()));
            context.fireDisconnected();
            LOGGER.debug("Disconnected event fired from KNX protocol");
        });
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        DefaultPlcWriteRequest request = (DefaultPlcWriteRequest)writeRequest;
        Optional first = request.getFieldNames().stream().findFirst();
        if (first.isPresent()) {
            String fieldName = (String)first.get();
            KnxNetIpField field = (KnxNetIpField)request.getField(fieldName);
            byte[] destinationAddress = this.toKnxAddressData(field);
            if (sequenceCounter.get() == Short.MAX_VALUE) {
                sequenceCounter.set(0);
            }
            PlcValue value = request.getPlcValue(fieldName);
            byte dataFirstByte = 0;
            byte[] data = null;
            EtsModel etsModel = this.knxNetIpDriverContext.getEtsModel();
            if (etsModel != null) {
                String destinationAddressString = etsModel.parseGroupAddress(destinationAddress);
                GroupAddress groupAddress = etsModel.getGroupAddresses().get(destinationAddressString);
                if (groupAddress == null || groupAddress.getType() == null) {
                    future.completeExceptionally((Throwable)new PlcRuntimeException("ETS5 model didn't specify group address '" + destinationAddressString + "' or didn't define a type for it."));
                    return future;
                }
                try {
                    WriteBufferByteBased writeBuffer = new WriteBufferByteBased(KnxDatapoint.getLengthInBytes(value, groupAddress.getType()));
                    KnxDatapoint.staticSerialize((WriteBuffer)writeBuffer, value, groupAddress.getType());
                    byte[] serialized = writeBuffer.getData();
                    dataFirstByte = serialized[0];
                    data = new byte[serialized.length - 1];
                    System.arraycopy(serialized, 1, data, 0, serialized.length - 1);
                }
                catch (SerializationException e) {
                    future.completeExceptionally((Throwable)new PlcRuntimeException("Error serializing PlcValue.", (Throwable)e));
                    return future;
                }
            } else if (value.isByte()) {
                if (value.getByte() > 63 || value.getByte() < 0) {
                    future.completeExceptionally((Throwable)new PlcRuntimeException("If no ETS5 model is provided, value of the first byte must be between 0 and 63."));
                    return future;
                }
                dataFirstByte = value.getByte();
            } else if (value.isList()) {
                List list = value.getList();
                data = new byte[list.size() - 1];
                boolean allValuesAreBytes = !list.isEmpty();
                int numByte = 0;
                for (PlcValue plcValue : list) {
                    if (numByte == 0) {
                        if (!plcValue.isByte() && plcValue.getByte() > 63 || plcValue.getByte() < 0) {
                            allValuesAreBytes = false;
                            break;
                        }
                        dataFirstByte = plcValue.getByte();
                    } else {
                        if (!plcValue.isByte()) {
                            allValuesAreBytes = false;
                            break;
                        }
                        data[numByte - 1] = plcValue.getByte();
                    }
                    ++numByte;
                }
                if (!allValuesAreBytes) {
                    future.completeExceptionally((Throwable)new PlcRuntimeException("If no ETS5 model is provided, the only supported type for writing data is writing of single byte or list of bytes and the value of the first byte must be between 0 and 63."));
                    return future;
                }
            } else {
                future.completeExceptionally((Throwable)new PlcRuntimeException("If no ETS5 model is provided, the only supported type for writing data is writing of single byte or list of bytes."));
                return future;
            }
            short communicationChannelId = this.knxNetIpDriverContext.getCommunicationChannelId();
            TunnelingRequest knxRequest = new TunnelingRequest(new TunnelingRequestDataBlock(communicationChannelId, (short)sequenceCounter.getAndIncrement()), new LDataReq(0, new ArrayList<CEMIAdditionalInformation>(0), new LDataExtended(false, false, CEMIPriority.LOW, false, false, true, 6, 0, this.knxNetIpDriverContext.getClientKnxAddress(), destinationAddress, new ApduDataContainer(true, 0, new ApduDataGroupValueWrite(dataFirstByte, data, (short)-1), (short)-1)), -1), -1);
            RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
            transaction.submit(() -> this.context.sendRequest((Object)knxRequest).expectResponse(KnxNetIpMessage.class, REQUEST_TIMEOUT).onTimeout(future::completeExceptionally).onError((tr, e) -> future.completeExceptionally((Throwable)e)).check(tr -> tr instanceof TunnelingResponse).unwrap(tr -> (TunnelingResponse)tr).check(tr -> tr.getTunnelingResponseDataBlock().getCommunicationChannelId() == knxRequest.getTunnelingRequestDataBlock().getCommunicationChannelId()).check(tr -> tr.getTunnelingResponseDataBlock().getSequenceCounter() == knxRequest.getTunnelingRequestDataBlock().getSequenceCounter()).handle(tr -> {
                PlcResponseCode responseCode = tr.getTunnelingResponseDataBlock().getStatus() == Status.NO_ERROR ? PlcResponseCode.OK : PlcResponseCode.INTERNAL_ERROR;
                DefaultPlcWriteResponse response = new DefaultPlcWriteResponse((PlcWriteRequest)request, Collections.singletonMap(fieldName, responseCode));
                future.complete((PlcWriteResponse)response);
                transaction.endRequest();
            }));
        }
        return future;
    }

    protected void decode(ConversationContext<KnxNetIpMessage> context, KnxNetIpMessage msg) throws Exception {
        if (msg instanceof TunnelingRequest) {
            TunnelingRequest tunnelingRequest = (TunnelingRequest)msg;
            short curCommunicationChannelId = tunnelingRequest.getTunnelingRequestDataBlock().getCommunicationChannelId();
            if (this.knxNetIpDriverContext.isPassiveMode() || curCommunicationChannelId == this.knxNetIpDriverContext.getCommunicationChannelId()) {
                ApduDataContainer apduDataContainer;
                ApduData dataApdu;
                LDataExtended lDataFrameDataExt;
                Apdu apdu;
                LDataInd dataInd;
                LDataFrame lDataFrame;
                if (tunnelingRequest.getCemi() instanceof LDataInd && (lDataFrame = (dataInd = (LDataInd)tunnelingRequest.getCemi()).getDataFrame()) instanceof LDataExtended && (apdu = (lDataFrameDataExt = (LDataExtended)lDataFrame).getApdu()) instanceof ApduDataContainer && (dataApdu = (apduDataContainer = (ApduDataContainer)apdu).getDataApdu()) instanceof ApduDataGroupValueWrite) {
                    ApduDataGroupValueWrite groupWrite = (ApduDataGroupValueWrite)dataApdu;
                    this.processCemiData(lDataFrameDataExt.getSourceAddress(), lDataFrameDataExt.getDestinationAddress(), groupWrite.getDataFirstByte(), groupWrite.getData());
                }
                short sequenceCounter = tunnelingRequest.getTunnelingRequestDataBlock().getSequenceCounter();
                TunnelingResponse tunnelingResponse = new TunnelingResponse(new TunnelingResponseDataBlock(this.knxNetIpDriverContext.getCommunicationChannelId(), sequenceCounter, Status.NO_ERROR));
                context.sendToWire((Object)tunnelingResponse);
            }
        } else if (msg instanceof TunnelingResponse) {
            // empty if block
        }
    }

    protected void processCemiData(KnxAddress sourceAddress, byte[] destinationGroupAddress, byte firstByte, byte[] restBytes) throws ParseException {
        byte[] payload = new byte[1 + restBytes.length];
        payload[0] = firstByte;
        System.arraycopy(restBytes, 0, payload, 1, restBytes.length);
        ReadBufferByteBased addressBuffer = new ReadBufferByteBased(destinationGroupAddress);
        KnxGroupAddress knxGroupAddress = KnxGroupAddress.staticParse((ReadBuffer)addressBuffer, this.knxNetIpDriverContext.getGroupAddressType());
        String destinationAddress = KnxNetIpProtocolLogic.toString(knxGroupAddress);
        if (this.knxNetIpDriverContext.getEtsModel() != null) {
            EtsModel etsModel = this.knxNetIpDriverContext.getEtsModel();
            GroupAddress groupAddress = etsModel.getGroupAddresses().get(destinationAddress);
            String areaName = etsModel.getTopologyName(destinationAddress.substring(0, destinationAddress.indexOf(47)));
            String lineName = etsModel.getTopologyName(destinationAddress.substring(0, destinationAddress.indexOf(47, destinationAddress.indexOf(47) + 1)));
            if (groupAddress != null && groupAddress.getType() != null) {
                LOGGER.trace(String.format("Message from: '%s' to: '%s'", KnxNetIpProtocolLogic.toString(sourceAddress), destinationAddress));
                ReadBufferByteBased rawDataReader = new ReadBufferByteBased(payload);
                PlcValue value = KnxDatapoint.staticParse((ReadBuffer)rawDataReader, groupAddress.getType());
                HashMap<String, Object> dataPointMap = new HashMap<String, Object>();
                dataPointMap.put("sourceAddress", new PlcSTRING(KnxNetIpProtocolLogic.toString(sourceAddress)));
                dataPointMap.put("targetAddress", new PlcSTRING(groupAddress.getGroupAddress()));
                if (groupAddress.getFunction() != null) {
                    dataPointMap.put("location", new PlcSTRING(groupAddress.getFunction().getSpaceName()));
                    dataPointMap.put("function", new PlcSTRING(groupAddress.getFunction().getName()));
                } else {
                    dataPointMap.put("location", null);
                    dataPointMap.put("function", null);
                }
                if (areaName != null) {
                    dataPointMap.put("area", new PlcSTRING(areaName));
                }
                if (lineName != null) {
                    dataPointMap.put("line", new PlcSTRING(lineName));
                }
                dataPointMap.put("description", new PlcSTRING(groupAddress.getName()));
                dataPointMap.put("unitOfMeasurement", new PlcSTRING(groupAddress.getType().getName()));
                dataPointMap.put("value", value);
                PlcStruct dataPoint = new PlcStruct(dataPointMap);
                this.publishEvent(groupAddress, (PlcValue)dataPoint);
            } else {
                LOGGER.warn(String.format("Message from: '%s' to unknown group address: '%s'%n payload: '%s'", KnxNetIpProtocolLogic.toString(sourceAddress), destinationAddress, Hex.encodeHexString((byte[])payload)));
            }
        } else {
            LOGGER.info(String.format("Raw Message: '%s' to: '%s'%n payload: '%s'", KnxNetIpProtocolLogic.toString(sourceAddress), destinationAddress, Hex.encodeHexString((byte[])payload)));
        }
    }

    public void close(ConversationContext<KnxNetIpMessage> context) {
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        HashMap<String, ResponseItem> values = new HashMap<String, ResponseItem>();
        for (String fieldName : subscriptionRequest.getFieldNames()) {
            DefaultPlcSubscriptionField field = (DefaultPlcSubscriptionField)subscriptionRequest.getField(fieldName);
            if (!(field.getPlcField() instanceof KnxNetIpField)) {
                values.put(fieldName, new ResponseItem(PlcResponseCode.INVALID_ADDRESS, null));
                continue;
            }
            values.put(fieldName, new ResponseItem(PlcResponseCode.OK, (Object)new KnxNetIpSubscriptionHandle(this, (KnxNetIpField)field.getPlcField())));
        }
        return CompletableFuture.completedFuture(new DefaultPlcSubscriptionResponse(subscriptionRequest, values));
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> collection) {
        DefaultPlcConsumerRegistration consumerRegistration = new DefaultPlcConsumerRegistration((PlcSubscriber)this, consumer, collection.toArray(new PlcSubscriptionHandle[0]));
        this.consumers.put(consumerRegistration, consumer);
        return consumerRegistration;
    }

    public void unregister(PlcConsumerRegistration plcConsumerRegistration) {
        DefaultPlcConsumerRegistration consumerRegistration = (DefaultPlcConsumerRegistration)plcConsumerRegistration;
        this.consumers.remove(consumerRegistration);
    }

    protected void publishEvent(GroupAddress groupAddress, PlcValue plcValue) {
        DefaultPlcSubscriptionEvent event = new DefaultPlcSubscriptionEvent(Instant.now(), Collections.singletonMap("knxData", new ResponseItem(PlcResponseCode.OK, (Object)plcValue)));
        for (Map.Entry<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>> entry : this.consumers.entrySet()) {
            DefaultPlcConsumerRegistration registration = entry.getKey();
            Consumer<PlcSubscriptionEvent> consumer = entry.getValue();
            for (PlcSubscriptionHandle handle : registration.getSubscriptionHandles()) {
                KnxNetIpSubscriptionHandle subscriptionHandle;
                if (!(handle instanceof KnxNetIpSubscriptionHandle) || !(subscriptionHandle = (KnxNetIpSubscriptionHandle)handle).getField().matchesGroupAddress(groupAddress)) continue;
                consumer.accept((PlcSubscriptionEvent)event);
            }
        }
    }

    protected byte[] toKnxAddressData(KnxNetIpField field) {
        WriteBufferByteBased address = new WriteBufferByteBased(2);
        try {
            switch (this.knxNetIpDriverContext.getGroupAddressType()) {
                case 3: {
                    address.writeUnsignedShort(5, Short.parseShort(field.getMainGroup()));
                    address.writeUnsignedByte(3, Byte.parseByte(field.getMiddleGroup()));
                    address.writeUnsignedShort(8, Short.parseShort(field.getSubGroup()));
                    break;
                }
                case 2: {
                    address.writeUnsignedShort(5, Short.parseShort(field.getMainGroup()));
                    address.writeUnsignedShort(11, Short.parseShort(field.getSubGroup()));
                    break;
                }
                case 1: {
                    address.writeUnsignedShort(16, Short.parseShort(field.getSubGroup()));
                }
            }
        }
        catch (Exception e) {
            throw new PlcRuntimeException("Error converting field into knx address data.", (Throwable)e);
        }
        return address.getData();
    }

    protected static String toString(KnxAddress knxAddress) {
        return knxAddress.getMainGroup() + "." + knxAddress.getMiddleGroup() + "." + knxAddress.getSubGroup();
    }

    protected static String toString(KnxGroupAddress groupAddress) {
        if (groupAddress instanceof KnxGroupAddress3Level) {
            KnxGroupAddress3Level level3 = (KnxGroupAddress3Level)groupAddress;
            return level3.getMainGroup() + "/" + level3.getMiddleGroup() + "/" + level3.getSubGroup();
        }
        if (groupAddress instanceof KnxGroupAddress2Level) {
            KnxGroupAddress2Level level2 = (KnxGroupAddress2Level)groupAddress;
            return level2.getMainGroup() + "/" + level2.getSubGroup();
        }
        if (groupAddress instanceof KnxGroupAddressFreeLevel) {
            KnxGroupAddressFreeLevel free = (KnxGroupAddressFreeLevel)groupAddress;
            return free.getSubGroup() + "";
        }
        throw new PlcRuntimeException("Unsupported Group Address Type " + groupAddress.getClass().getName());
    }
}

