/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.firmata.readwrite.tag;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.firmata.readwrite.tag.FirmataTag;
import org.apache.plc4x.java.spi.model.DefaultArrayInfo;

public class FirmataTagAnalog
extends FirmataTag {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("analog:" + FirmataTag.ADDRESS_PATTERN);

    public FirmataTagAnalog(int address, Integer quantity) {
        super(address, quantity);
    }

    public String getAddressString() {
        String address = "analog:" + this.getAddress();
        if (this.getNumberOfElements() != 1) {
            address = String.valueOf(address) + "[" + this.getNumberOfElements() + "]";
        }
        return address;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.INT;
    }

    public List<ArrayInfo> getArrayInfo() {
        if (this.getNumberOfElements() != 1) {
            return Collections.singletonList(new DefaultArrayInfo(0, this.getNumberOfElements()));
        }
        return Collections.emptyList();
    }

    public static FirmataTagAnalog of(String addressString) throws PlcInvalidTagException {
        Matcher matcher = ADDRESS_PATTERN.matcher(addressString);
        if (!matcher.matches()) {
            throw new PlcInvalidTagException(addressString, ADDRESS_PATTERN);
        }
        int address = Integer.parseInt(matcher.group("address"));
        String quantityString = matcher.group("quantity");
        Integer quantity = quantityString != null ? Integer.valueOf(quantityString) : null;
        return new FirmataTagAnalog(address, quantity);
    }
}

