/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.firmata.readwrite.tag;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.firmata.readwrite.PinMode;
import org.apache.plc4x.java.firmata.readwrite.tag.FirmataTag;
import org.apache.plc4x.java.spi.model.DefaultArrayInfo;

public class FirmataTagDigital
extends FirmataTag {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("digital:" + FirmataTag.ADDRESS_PATTERN + "(:(?<mode>PULLUP))?");
    protected final BitSet bitSet = new BitSet();
    protected final PinMode pinMode;

    public FirmataTagDigital(int address, Integer quantity, PinMode pinMode) {
        super(address, quantity);
        int i = this.getAddress();
        while (i < this.getAddress() + this.getNumberOfElements()) {
            this.bitSet.set(i, true);
            ++i;
        }
        this.pinMode = pinMode;
    }

    public String getAddressString() {
        String address = "digital:" + this.getAddress();
        if (this.getNumberOfElements() != 1) {
            address = String.valueOf(address) + "[" + this.getNumberOfElements() + "]";
        }
        return address;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.BOOL;
    }

    public List<ArrayInfo> getArrayInfo() {
        if (this.getNumberOfElements() != 1) {
            return Collections.singletonList(new DefaultArrayInfo(0, this.getNumberOfElements()));
        }
        return Collections.emptyList();
    }

    public BitSet getBitSet() {
        return this.bitSet;
    }

    public PinMode getPinMode() {
        return this.pinMode;
    }

    public static FirmataTagDigital of(String addressString) {
        Matcher matcher = ADDRESS_PATTERN.matcher(addressString);
        if (!matcher.matches()) {
            throw new PlcInvalidTagException(addressString, ADDRESS_PATTERN);
        }
        int address = Integer.parseInt(matcher.group("address"));
        String quantityString = matcher.group("quantity");
        Integer quantity = quantityString != null ? Integer.valueOf(quantityString) : null;
        PinMode pinMode = "PULLUP".equals(matcher.group("mode")) ? PinMode.PinModePullup : null;
        return new FirmataTagDigital(address, quantity, pinMode);
    }
}

