/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.eip.readwrite.CIPDataTypeCode;
import org.apache.plc4x.java.eip.readwrite.CIPStructTypeCode;
import org.apache.plc4x.java.eip.readwrite.CipExchange;
import org.apache.plc4x.java.eip.readwrite.CipRRData;
import org.apache.plc4x.java.eip.readwrite.CipReadRequest;
import org.apache.plc4x.java.eip.readwrite.CipReadResponse;
import org.apache.plc4x.java.eip.readwrite.CipService;
import org.apache.plc4x.java.eip.readwrite.CipUnconnectedRequest;
import org.apache.plc4x.java.eip.readwrite.CipWriteRequest;
import org.apache.plc4x.java.eip.readwrite.CipWriteResponse;
import org.apache.plc4x.java.eip.readwrite.EipConnectionRequest;
import org.apache.plc4x.java.eip.readwrite.EipDisconnectRequest;
import org.apache.plc4x.java.eip.readwrite.EipPacket;
import org.apache.plc4x.java.eip.readwrite.MultipleServiceRequest;
import org.apache.plc4x.java.eip.readwrite.MultipleServiceResponse;
import org.apache.plc4x.java.eip.readwrite.Services;
import org.apache.plc4x.java.eip.readwrite.configuration.EIPConfiguration;
import org.apache.plc4x.java.eip.readwrite.field.EipField;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EipProtocolLogic
extends Plc4xProtocolBase<EipPacket>
implements HasConfiguration<EIPConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(EipProtocolLogic.class);
    public static final Duration REQUEST_TIMEOUT = Duration.ofMillis(10000L);
    private static final List<Short> emptySenderContext = Arrays.asList((short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0);
    private List<Short> senderContext;
    private EIPConfiguration configuration;
    private final AtomicInteger transactionCounterGenerator = new AtomicInteger(10);
    private RequestTransactionManager tm;
    private long sessionHandle;

    public void setConfiguration(EIPConfiguration configuration) {
        this.configuration = configuration;
        this.tm = new RequestTransactionManager(1);
    }

    public void onConnect(ConversationContext<EipPacket> context) {
        logger.debug("Sending RegisterSession EIP Package");
        EipConnectionRequest connectionRequest = new EipConnectionRequest(0L, 0L, emptySenderContext, 0L);
        context.sendRequest((Object)connectionRequest).expectResponse(EipPacket.class, REQUEST_TIMEOUT).unwrap(p -> p).check(p -> p instanceof EipConnectionRequest).handle(p -> {
            if (p.getStatus() == 0L) {
                this.sessionHandle = p.getSessionHandle();
                this.senderContext = p.getSenderContext();
                logger.debug("Got assigned with Session {}", (Object)this.sessionHandle);
                context.fireConnected();
            } else {
                logger.warn("Got status code [{}]", (Object)p.getStatus());
            }
        });
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        DefaultPlcReadRequest request = (DefaultPlcReadRequest)readRequest;
        ArrayList<CipReadRequest> requests = new ArrayList<CipReadRequest>(request.getNumberOfFields());
        for (PlcField field : request.getFields()) {
            EipField plcField = (EipField)field;
            String tag = plcField.getTag();
            int elements = 1;
            if (plcField.getElementNb() > 1) {
                elements = plcField.getElementNb();
            }
            CipReadRequest req = new CipReadRequest(this.getRequestSize(tag), this.toAnsi(tag), elements, -1);
            requests.add(req);
        }
        return this.toPlcReadResponse(readRequest, this.readInternal(requests));
    }

    private byte getRequestSize(String tag) {
        boolean isArray = false;
        boolean isStruct = false;
        String tagIsolated = tag;
        if (tag.contains("[")) {
            isArray = true;
            tagIsolated = tag.substring(0, tag.indexOf("["));
        }
        if (tag.contains(".")) {
            isStruct = true;
            tagIsolated = tagIsolated.replace(".", "");
        }
        int dataLength = tagIsolated.length() + 2 + tagIsolated.length() % 2 + (isArray ? 2 : 0) + (isStruct ? 2 : 0);
        byte requestPathSize = (byte)(dataLength / 2);
        return requestPathSize;
    }

    private byte[] toAnsi(String tag) {
        int arrayIndex = 0;
        boolean isArray = false;
        boolean isStruct = false;
        String tagFinal = tag;
        if (tag.contains("[")) {
            isArray = true;
            String index = tag.substring(tag.indexOf("[") + 1, tag.indexOf("]"));
            arrayIndex = Integer.parseInt(index);
            tagFinal = tag.substring(0, tag.indexOf("["));
        }
        if (tag.contains(".")) {
            tagFinal = tag.substring(0, tag.indexOf("."));
            isStruct = true;
        }
        boolean isPadded = tagFinal.length() % 2 != 0;
        int dataSegLength = 2 + tagFinal.length() + (isPadded ? 1 : 0) + (isArray ? 2 : 0);
        if (isStruct) {
            for (String subStr : tag.substring(tag.indexOf(".") + 1).split("\\.", -1)) {
                dataSegLength += 2 + subStr.length() + subStr.length() % 2;
            }
        }
        ByteBuffer buffer = ByteBuffer.allocate(dataSegLength).order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)-111);
        buffer.put((byte)tagFinal.length());
        byte[] tagBytes = null;
        tagBytes = tagFinal.getBytes(StandardCharsets.US_ASCII);
        buffer.put(tagBytes);
        buffer.position(2 + tagBytes.length);
        if (isPadded) {
            buffer.put((byte)0);
        }
        if (isArray) {
            buffer.put((byte)40);
            buffer.put((byte)arrayIndex);
        }
        if (isStruct) {
            buffer.put(this.toAnsi(tag.substring(tag.indexOf(".") + 1, tag.length())));
        }
        return buffer.array();
    }

    private CompletableFuture<PlcReadResponse> toPlcReadResponse(PlcReadRequest readRequest, CompletableFuture<CipService> response) {
        return response.thenApply(p -> (PlcReadResponse)this.decodeReadResponse((CipService)p, readRequest));
    }

    private CompletableFuture<CipService> readInternal(List<CipReadRequest> request) {
        CompletableFuture<CipService> future = new CompletableFuture<CipService>();
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        if (request.size() > 1) {
            int nb = request.size();
            ArrayList<Integer> offsets = new ArrayList<Integer>(nb);
            int offset = 2 + nb * 2;
            for (int i = 0; i < nb; ++i) {
                offsets.add(offset);
                offset += request.get(i).getLengthInBytes();
            }
            ArrayList<CipService> serviceArr = new ArrayList<CipService>(nb);
            for (int i = 0; i < nb; ++i) {
                serviceArr.add(request.get(i));
            }
            Services data = new Services(nb, offsets, serviceArr, -1);
            CipRRData pkt = new CipRRData(this.sessionHandle, 0L, emptySenderContext, 0L, new CipExchange(new CipUnconnectedRequest(new MultipleServiceRequest(data, -1), (byte)this.configuration.getBackplane(), (byte)this.configuration.getSlot(), -1), -1), -1);
            transaction.submit(() -> this.lambda$readInternal$13(pkt, future, (short)nb, transaction));
        } else if (request.size() == 1) {
            CipExchange exchange = new CipExchange(new CipUnconnectedRequest(request.get(0), (byte)this.configuration.getBackplane(), (byte)this.configuration.getSlot(), -1), -1);
            CipRRData pkt = new CipRRData(this.sessionHandle, 0L, emptySenderContext, 0L, exchange, -1);
            transaction.submit(() -> this.context.sendRequest((Object)pkt).expectResponse(EipPacket.class, REQUEST_TIMEOUT).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(p -> p instanceof CipRRData).check(p -> p.getSessionHandle() == this.sessionHandle).unwrap(p -> (CipRRData)p).unwrap(p -> p.getExchange().getService()).check(p -> p instanceof CipReadResponse).unwrap(p -> (CipReadResponse)p).handle(p -> {
                future.complete((CipService)p);
                transaction.endRequest();
            }));
        }
        return future;
    }

    private PlcResponse decodeReadResponse(CipService p, PlcReadRequest readRequest) {
        HashMap<String, ResponseItem> values = new HashMap<String, ResponseItem>();
        if (p instanceof CipReadResponse) {
            CipReadResponse resp = (CipReadResponse)p;
            String fieldName = (String)readRequest.getFieldNames().iterator().next();
            EipField field = (EipField)readRequest.getField(fieldName);
            PlcResponseCode code = this.decodeResponseCode(resp.getStatus());
            PlcValue plcValue = null;
            CIPDataTypeCode type = resp.getDataType();
            ByteBuf data = Unpooled.wrappedBuffer((byte[])resp.getData());
            if (code == PlcResponseCode.OK) {
                plcValue = this.parsePlcValue(field, data, type);
            }
            ResponseItem result = new ResponseItem(code, plcValue);
            values.put(fieldName, result);
        } else if (p instanceof MultipleServiceResponse) {
            MultipleServiceResponse responses = (MultipleServiceResponse)p;
            int nb = responses.getServiceNb();
            ArrayList<CipService> arr = new ArrayList<CipService>(nb);
            ReadBufferByteBased read = new ReadBufferByteBased(responses.getServicesData(), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
            int total = read.getTotalBytes();
            for (int i = 0; i < nb; ++i) {
                int length = 0;
                int offset = responses.getOffsets().get(i) - responses.getOffsets().get(0);
                length = i == nb - 1 ? total - offset : responses.getOffsets().get(i + 1) - offset - responses.getOffsets().get(0);
                ReadBufferByteBased serviceBuf = new ReadBufferByteBased(read.getBytes(offset, offset + length), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
                CipService service = null;
                try {
                    service = CipService.staticParse((ReadBuffer)read, length);
                    arr.add(service);
                    continue;
                }
                catch (ParseException e) {
                    throw new PlcRuntimeException((Throwable)e);
                }
            }
            Services services = new Services(nb, responses.getOffsets(), arr, -1);
            Iterator it = readRequest.getFieldNames().iterator();
            for (int i = 0; i < nb && it.hasNext(); ++i) {
                String fieldName = (String)it.next();
                EipField field = (EipField)readRequest.getField(fieldName);
                PlcValue plcValue = null;
                if (!(services.getServices().get(i) instanceof CipReadResponse)) continue;
                CipReadResponse readResponse = (CipReadResponse)services.getServices().get(i);
                PlcResponseCode code = readResponse.getStatus() == 0 ? PlcResponseCode.OK : PlcResponseCode.INTERNAL_ERROR;
                CIPDataTypeCode type = readResponse.getDataType();
                ByteBuf data = Unpooled.wrappedBuffer((byte[])readResponse.getData());
                if (code == PlcResponseCode.OK) {
                    plcValue = this.parsePlcValue(field, data, type);
                }
                ResponseItem result = new ResponseItem(code, plcValue);
                values.put(fieldName, result);
            }
        }
        return new DefaultPlcReadResponse(readRequest, values);
    }

    private PlcValue parsePlcValue(EipField field, ByteBuf data, CIPDataTypeCode type) {
        int STRING_LEN_OFFSET = 2;
        int STRING_DATA_OFFSET = 6;
        int nb = field.getElementNb();
        if (nb > 1) {
            int index = 0;
            ArrayList<Object> list = new ArrayList<Object>();
            block18: for (int i = 0; i < nb; ++i) {
                switch (type) {
                    case DINT: {
                        list.add(new PlcDINT(Integer.reverseBytes(data.getInt(index))));
                        index += type.getSize();
                        continue block18;
                    }
                    case INT: {
                        list.add(new PlcINT(Integer.valueOf(Integer.reverseBytes(data.getInt(index)))));
                        index += type.getSize();
                        continue block18;
                    }
                    case SINT: {
                        list.add(new PlcSINT(Integer.valueOf(Integer.reverseBytes(data.getInt(index)))));
                        index += type.getSize();
                        continue block18;
                    }
                    case REAL: {
                        list.add(new PlcLREAL((double)this.swap(data.getFloat(index))));
                        index += type.getSize();
                        continue block18;
                    }
                    case LINT: {
                        list.add(new PlcLINT(Long.reverseBytes(data.getLong(index))));
                        index += type.getSize();
                        continue block18;
                    }
                    case BOOL: {
                        list.add(new PlcBOOL(data.getBoolean(index)));
                        index += type.getSize();
                        continue block18;
                    }
                    case STRUCTURED: {
                        Short structuredType = Short.reverseBytes(data.getShort(0));
                        Short structuredLen = Short.reverseBytes(data.getShort(2));
                        if (structuredType.shortValue() == CIPStructTypeCode.STRING.getValue()) {
                            list.add(new PlcSTRING(StandardCharsets.UTF_8.decode(data.nioBuffer(6, (int)structuredLen.shortValue())).toString()));
                            index += type.getSize();
                        }
                    }
                    default: {
                        return null;
                    }
                }
            }
            return new PlcList(list);
        }
        switch (type) {
            case SINT: {
                return new PlcSINT(data.getByte(0));
            }
            case INT: {
                return new PlcINT(Short.reverseBytes(data.getShort(0)));
            }
            case DINT: {
                return new PlcDINT(Integer.reverseBytes(data.getInt(0)));
            }
            case LINT: {
                return new PlcLINT(Long.reverseBytes(data.getLong(0)));
            }
            case REAL: {
                return new PlcREAL(this.swap(data.getFloat(0)));
            }
            case BOOL: {
                return new PlcBOOL(data.getBoolean(0));
            }
            case STRUCTURED: 
            case STRING36: 
            case STRING: {
                Short structuredType = Short.reverseBytes(data.getShort(0));
                Short structuredLen = Short.reverseBytes(data.getShort(2));
                if (structuredType.shortValue() != CIPStructTypeCode.STRING.getValue()) break;
                return new PlcSTRING(StandardCharsets.UTF_8.decode(data.nioBuffer(6, (int)structuredLen.shortValue())).toString());
            }
        }
        return null;
    }

    public float swap(float value) {
        int bytes = Float.floatToIntBits(value);
        int b1 = bytes & 0xFF;
        int b2 = bytes >> 8 & 0xFF;
        int b3 = bytes >> 16 & 0xFF;
        int b4 = bytes >> 24 & 0xFF;
        return Float.intBitsToFloat(b1 << 24 | b2 << 16 | b3 << 8 | b4);
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        DefaultPlcWriteRequest request = (DefaultPlcWriteRequest)writeRequest;
        ArrayList<CipWriteRequest> items = new ArrayList<CipWriteRequest>(writeRequest.getNumberOfFields());
        for (String fieldName : request.getFieldNames()) {
            EipField field = (EipField)request.getField(fieldName);
            PlcValue value = request.getPlcValue(fieldName);
            String tag = field.getTag();
            int elements = 1;
            if (field.getElementNb() > 1) {
                elements = field.getElementNb();
            }
            boolean isArray = false;
            boolean isStruct = false;
            String tagIsolated = tag;
            if (tag.contains("[")) {
                isArray = true;
                tagIsolated = tag.substring(0, tag.indexOf("["));
            }
            if (tag.contains(".")) {
                isStruct = true;
                tagIsolated = tagIsolated.replace(".", "");
            }
            int dataLength = tagIsolated.length() + 2 + tagIsolated.length() % 2 * 2 + (isArray ? 2 : 0) + (isStruct ? 2 : 0);
            byte requestPathSize = (byte)(dataLength / 2);
            byte[] data = this.encodeValue(value, field.getType(), (short)elements);
            CipWriteRequest writeReq = new CipWriteRequest(requestPathSize, this.toAnsi(tag), field.getType(), elements, data, -1);
            items.add(writeReq);
        }
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        if (items.size() == 1) {
            this.tm.startRequest();
            CipRRData rrdata = new CipRRData(this.sessionHandle, 0L, this.senderContext, 0L, new CipExchange(new CipUnconnectedRequest((CipService)items.get(0), (byte)this.configuration.getBackplane(), (byte)this.configuration.getSlot(), -1), -1), -1);
            transaction.submit(() -> this.context.sendRequest((Object)rrdata).expectResponse(EipPacket.class, REQUEST_TIMEOUT).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(p -> p instanceof CipRRData).unwrap(p -> (CipRRData)p).check(p -> p.getSessionHandle() == this.sessionHandle).check(p -> p.getExchange().getService() instanceof CipWriteResponse).unwrap(p -> (CipWriteResponse)p.getExchange().getService()).handle(p -> {
                future.complete((PlcWriteResponse)this.decodeWriteResponse((CipService)p, writeRequest));
                transaction.endRequest();
            }));
        } else {
            this.tm.startRequest();
            int nb = items.size();
            ArrayList<Integer> offsets = new ArrayList<Integer>(nb);
            int offset = 2 + nb * 2;
            for (int i = 0; i < nb; ++i) {
                offsets.add(offset);
                offset += ((CipWriteRequest)items.get(i)).getLengthInBytes();
            }
            ArrayList<CipService> serviceArr = new ArrayList<CipService>(nb);
            for (int i = 0; i < nb; ++i) {
                serviceArr.add((CipService)items.get(i));
            }
            Services data = new Services(nb, offsets, serviceArr, -1);
            CipRRData pkt = new CipRRData(this.sessionHandle, 0L, emptySenderContext, 0L, new CipExchange(new CipUnconnectedRequest(new MultipleServiceRequest(data, -1), (byte)this.configuration.getBackplane(), (byte)this.configuration.getSlot(), -1), -1), -1);
            transaction.submit(() -> this.lambda$write$40(pkt, future, (short)nb, writeRequest, transaction));
        }
        return future;
    }

    private PlcResponse decodeWriteResponse(CipService p, PlcWriteRequest writeRequest) {
        HashMap<String, PlcResponseCode> responses = new HashMap<String, PlcResponseCode>();
        if (p instanceof CipWriteResponse) {
            CipWriteResponse resp = (CipWriteResponse)p;
            String fieldName = (String)writeRequest.getFieldNames().iterator().next();
            EipField field = (EipField)writeRequest.getField(fieldName);
            responses.put(fieldName, this.decodeResponseCode(resp.getStatus()));
            return new DefaultPlcWriteResponse(writeRequest, responses);
        }
        if (p instanceof MultipleServiceResponse) {
            MultipleServiceResponse resp = (MultipleServiceResponse)p;
            int nb = resp.getServiceNb();
            ArrayList<CipService> arr = new ArrayList<CipService>(nb);
            ReadBufferByteBased read = new ReadBufferByteBased(resp.getServicesData());
            int total = read.getTotalBytes();
            for (int i = 0; i < nb; ++i) {
                int length = 0;
                int offset = resp.getOffsets().get(i);
                length = offset == nb - 1 ? total - offset : resp.getOffsets().get(i + 1) - offset;
                ReadBufferByteBased serviceBuf = new ReadBufferByteBased(read.getBytes(offset, length), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
                CipService service = null;
                try {
                    service = CipService.staticParse((ReadBuffer)read, length);
                    arr.add(service);
                    continue;
                }
                catch (ParseException e) {
                    throw new PlcRuntimeException((Throwable)e);
                }
            }
            Services services = new Services(nb, resp.getOffsets(), arr, -1);
            Iterator it = writeRequest.getFieldNames().iterator();
            for (int i = 0; i < nb && it.hasNext(); ++i) {
                String fieldName = (String)it.next();
                EipField field = (EipField)writeRequest.getField(fieldName);
                Object plcValue = null;
                if (!(services.getServices().get(i) instanceof CipWriteResponse)) continue;
                CipWriteResponse writeResponse = (CipWriteResponse)services.getServices().get(i);
                PlcResponseCode code = this.decodeResponseCode(writeResponse.getStatus());
                responses.put(fieldName, code);
            }
            return new DefaultPlcWriteResponse(writeRequest, responses);
        }
        return null;
    }

    private byte[] encodeValue(PlcValue value, CIPDataTypeCode type, short elements) {
        ByteBuffer buffer = ByteBuffer.allocate(type.getSize()).order(ByteOrder.LITTLE_ENDIAN);
        switch (type) {
            case BOOL: {
                buffer.put(value.getByte());
                break;
            }
            case SINT: {
                buffer.put(value.getByte());
                break;
            }
            case INT: {
                buffer.putShort(value.getShort());
                break;
            }
            case DINT: {
                buffer.putInt(value.getInteger());
                break;
            }
            case REAL: {
                buffer.putDouble(value.getDouble());
                break;
            }
            case LINT: {
                buffer.putLong(value.getLong());
                break;
            }
            case STRING36: 
            case STRING: {
                buffer.putInt(value.getString().length());
                buffer.put(value.getString().getBytes(), 0, value.getString().length());
                break;
            }
            case STRUCTURED: {
                break;
            }
        }
        return buffer.array();
    }

    private PlcResponseCode decodeResponseCode(int status) {
        switch (status) {
            case 0: {
                return PlcResponseCode.OK;
            }
        }
        return PlcResponseCode.INTERNAL_ERROR;
    }

    public void close(ConversationContext<EipPacket> context) {
        logger.debug("Sending UnregisterSession EIP Pakcet");
        context.sendRequest((Object)new EipDisconnectRequest(this.sessionHandle, 0L, emptySenderContext, 0L));
        logger.debug("Unregistred Session {}", (Object)this.sessionHandle);
    }

    private /* synthetic */ void lambda$write$40(CipRRData pkt, CompletableFuture future, short nb, PlcWriteRequest writeRequest, RequestTransactionManager.RequestTransaction transaction) {
        this.context.sendRequest((Object)pkt).expectResponse(EipPacket.class, REQUEST_TIMEOUT).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(p -> p instanceof CipRRData).check(p -> p.getSessionHandle() == this.sessionHandle).unwrap(p -> (CipRRData)p).unwrap(p -> p.getExchange().getService()).check(p -> p instanceof MultipleServiceResponse).unwrap(p -> (MultipleServiceResponse)p).check(p -> p.getServiceNb() == nb).handle(p -> {
            future.complete((PlcWriteResponse)this.decodeWriteResponse((CipService)p, writeRequest));
            transaction.endRequest();
        });
    }

    private /* synthetic */ void lambda$readInternal$13(CipRRData pkt, CompletableFuture future, short nb, RequestTransactionManager.RequestTransaction transaction) {
        this.context.sendRequest((Object)pkt).expectResponse(EipPacket.class, REQUEST_TIMEOUT).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(p -> p instanceof CipRRData).check(p -> p.getSessionHandle() == this.sessionHandle).unwrap(p -> (CipRRData)p).unwrap(p -> p.getExchange().getService()).check(p -> p instanceof MultipleServiceResponse).unwrap(p -> (MultipleServiceResponse)p).check(p -> p.getServiceNb() == nb).handle(p -> {
            future.complete(p);
            transaction.endRequest();
        });
    }
}

