/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite.field;

import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.eip.readwrite.CIPDataTypeCode;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;

public class EipField
implements PlcField,
Serializable {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^%(?<tag>[a-zA-Z_.0-9]+\\[?[0-9]*\\]?):?(?<dataType>[A-Z]*):?(?<elementNb>[0-9]*)");
    private static final String TAG = "tag";
    private static final String ELEMENTS = "elementNb";
    private static final String TYPE = "dataType";
    private final String tag;
    private CIPDataTypeCode type;
    private int elementNb;

    public CIPDataTypeCode getType() {
        return this.type;
    }

    public void setType(CIPDataTypeCode type) {
        this.type = type;
    }

    public int getElementNb() {
        return this.elementNb;
    }

    public void setElementNb(int elementNb) {
        this.elementNb = elementNb;
    }

    public String getTag() {
        return this.tag;
    }

    public EipField(String tag) {
        this.tag = tag;
    }

    public EipField(String tag, int elementNb) {
        this.tag = tag;
        this.elementNb = elementNb;
    }

    public EipField(String tag, CIPDataTypeCode type, int elementNb) {
        this.tag = tag;
        this.type = type;
        this.elementNb = elementNb;
    }

    public EipField(String tag, CIPDataTypeCode type) {
        this.tag = tag;
        this.type = type;
    }

    public static boolean matches(String fieldQuery) {
        return ADDRESS_PATTERN.matcher(fieldQuery).matches();
    }

    public static EipField of(String fieldString) {
        Matcher matcher = ADDRESS_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            String tag = matcher.group(TAG);
            int nb = 0;
            CIPDataTypeCode type = null;
            if (!matcher.group(ELEMENTS).isEmpty()) {
                nb = Integer.parseInt(matcher.group(ELEMENTS));
            }
            if (!matcher.group(TYPE).isEmpty()) {
                type = CIPDataTypeCode.valueOf(matcher.group(TYPE));
            }
            if (nb != 0) {
                if (type != null) {
                    return new EipField(tag, type, nb);
                }
                return new EipField(tag, nb);
            }
            if (type != null) {
                return new EipField(tag, type);
            }
            return new EipField(tag);
        }
        return null;
    }

    public String getPlcDataType() {
        return this.type.toString();
    }

    public Class<?> getDefaultJavaType() {
        switch (this.type) {
            case INT: 
            case DINT: 
            case SINT: 
            case LINT: {
                return Integer.class;
            }
            case STRING: 
            case STRING36: {
                return String.class;
            }
            case REAL: {
                return Double.class;
            }
            case BOOL: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        writeBuffer.writeString("node", this.tag.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), this.tag, new WithWriterArgs[0]);
        if (this.type != null) {
            writeBuffer.writeString("type", this.type.name().getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), this.type.name(), new WithWriterArgs[0]);
        }
        writeBuffer.writeUnsignedInt(ELEMENTS, 16, this.elementNb, new WithWriterArgs[0]);
        String defaultJavaType = (this.type == null ? Object.class : this.getDefaultJavaType()).getName();
        writeBuffer.writeString("defaultJavaType", defaultJavaType.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), defaultJavaType, new WithWriterArgs[0]);
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

