/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.eip.readwrite.CipService;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class Services
implements Message {
    protected final int serviceNb;
    protected final List<Integer> offsets;
    protected final List<CipService> services;
    protected final Integer servicesLen;

    public Services(int serviceNb, List<Integer> offsets, List<CipService> services, Integer servicesLen) {
        this.serviceNb = serviceNb;
        this.offsets = offsets;
        this.services = services;
        this.servicesLen = servicesLen;
    }

    public int getServiceNb() {
        return this.serviceNb;
    }

    public List<Integer> getOffsets() {
        return this.offsets;
    }

    public List<CipService> getServices() {
        return this.services;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("Services", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"serviceNb", (Object)this.serviceNb, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"offsets", this.offsets, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"services", this.services, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("Services", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        Services _value = this;
        lengthInBits += 16;
        if (this.offsets != null) {
            lengthInBits += 16 * this.offsets.size();
        }
        if (this.services != null) {
            int i = 0;
            for (CipService element : this.services) {
                boolean last = ++i >= this.services.size();
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static Services staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Integer servicesLen;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Integer) {
            servicesLen = (Integer)args[0];
        } else if (args[0] instanceof String) {
            servicesLen = Integer.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Integer or a string which is parseable but was " + args[0].getClass().getName());
        }
        return Services.staticParse(readBuffer, servicesLen);
    }

    public static Services staticParse(ReadBuffer readBuffer, Integer servicesLen) throws ParseException {
        readBuffer.pullContext("Services", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        int serviceNb = (Integer)FieldReaderFactory.readSimpleField((String)"serviceNb", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        List offsets = FieldReaderFactory.readCountArrayField((String)"offsets", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (long)serviceNb, (WithReaderArgs[])new WithReaderArgs[0]);
        List services = FieldReaderFactory.readCountArrayField((String)"services", (DataReader)new DataReaderComplexDefault(() -> CipService.staticParse(readBuffer, servicesLen / serviceNb), readBuffer), (long)serviceNb, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("Services", new WithReaderArgs[0]);
        Services _services = new Services(serviceNb, offsets, services, servicesLen);
        return _services;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Services)) {
            return false;
        }
        Services that = (Services)o;
        return this.getServiceNb() == that.getServiceNb() && this.getOffsets() == that.getOffsets() && this.getServices() == that.getServices();
    }

    public int hashCode() {
        return Objects.hash(this.getServiceNb(), this.getOffsets(), this.getServices());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

