/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.CIPDataTypeCode;
import org.apache.plc4x.java.eip.readwrite.CipService;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class CipReadResponse
extends CipService
implements Message {
    protected final short status;
    protected final short extStatus;
    protected final CIPDataTypeCode dataType;
    protected final byte[] data;
    protected final Integer serviceLen;
    private Short reservedField0;

    @Override
    public Short getService() {
        return (short)204;
    }

    public CipReadResponse(short status, short extStatus, CIPDataTypeCode dataType, byte[] data, Integer serviceLen) {
        super(serviceLen);
        this.status = status;
        this.extStatus = extStatus;
        this.dataType = dataType;
        this.data = data;
        this.serviceLen = serviceLen;
    }

    public short getStatus() {
        return this.status;
    }

    public short getExtStatus() {
        return this.extStatus;
    }

    public CIPDataTypeCode getDataType() {
        return this.dataType;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected void serializeCipServiceChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("CipReadResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)(this.reservedField0 != null ? this.reservedField0 : (short)0), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"status", (Object)this.status, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"extStatus", (Object)this.extStatus, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"dataType", (String)"CIPDataTypeCode", (Object)((Object)this.dataType), (DataWriter)new DataWriterEnumDefault(CIPDataTypeCode::getValue, Enum::name, DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"data", (byte[])this.data, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("CipReadResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CipReadResponse _value = this;
        lengthInBits += 8;
        lengthInBits += 8;
        lengthInBits += 8;
        lengthInBits += 16;
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public static CipReadResponseBuilder staticParseBuilder(ReadBuffer readBuffer, Integer serviceLen) throws ParseException {
        readBuffer.pullContext("CipReadResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        Short reservedField0 = (Short)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        short status = (Short)FieldReaderFactory.readSimpleField((String)"status", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        short extStatus = (Short)FieldReaderFactory.readSimpleField((String)"extStatus", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        CIPDataTypeCode dataType = (CIPDataTypeCode)((Object)FieldReaderFactory.readEnumField((String)"dataType", (String)"CIPDataTypeCode", (DataReader)new DataReaderEnumDefault(CIPDataTypeCode::enumForValue, DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16)), (WithReaderArgs[])new WithReaderArgs[0]));
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(serviceLen - 6), new WithReaderArgs[0]);
        readBuffer.closeContext("CipReadResponse", new WithReaderArgs[0]);
        return new CipReadResponseBuilder(status, extStatus, dataType, data, serviceLen, reservedField0);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CipReadResponse)) {
            return false;
        }
        CipReadResponse that = (CipReadResponse)o;
        return this.getStatus() == that.getStatus() && this.getExtStatus() == that.getExtStatus() && this.getDataType() == that.getDataType() && this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getStatus(), this.getExtStatus(), this.getDataType(), this.getData()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CipReadResponseBuilder
    implements CipService.CipServiceBuilder {
        private final short status;
        private final short extStatus;
        private final CIPDataTypeCode dataType;
        private final byte[] data;
        private final Integer serviceLen;
        private final Short reservedField0;

        public CipReadResponseBuilder(short status, short extStatus, CIPDataTypeCode dataType, byte[] data, Integer serviceLen, Short reservedField0) {
            this.status = status;
            this.extStatus = extStatus;
            this.dataType = dataType;
            this.data = data;
            this.serviceLen = serviceLen;
            this.reservedField0 = reservedField0;
        }

        @Override
        public CipReadResponse build(Integer serviceLen) {
            CipReadResponse cipReadResponse = new CipReadResponse(this.status, this.extStatus, this.dataType, this.data, serviceLen);
            cipReadResponse.reservedField0 = this.reservedField0;
            return cipReadResponse;
        }
    }
}

