/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.CipService;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class CipReadRequest
extends CipService
implements Message {
    protected final byte requestPathSize;
    protected final byte[] tag;
    protected final int elementNb;
    protected final Integer serviceLen;

    @Override
    public Short getService() {
        return (short)76;
    }

    public CipReadRequest(byte requestPathSize, byte[] tag, int elementNb, Integer serviceLen) {
        super(serviceLen);
        this.requestPathSize = requestPathSize;
        this.tag = tag;
        this.elementNb = elementNb;
        this.serviceLen = serviceLen;
    }

    public byte getRequestPathSize() {
        return this.requestPathSize;
    }

    public byte[] getTag() {
        return this.tag;
    }

    public int getElementNb() {
        return this.elementNb;
    }

    @Override
    protected void serializeCipServiceChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("CipReadRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestPathSize", (Object)this.requestPathSize, (DataWriter)DataWriterFactory.writeSignedByte((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"tag", (byte[])this.tag, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"elementNb", (Object)this.elementNb, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("CipReadRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CipReadRequest _value = this;
        lengthInBits += 8;
        if (this.tag != null) {
            lengthInBits += 8 * this.tag.length;
        }
        return lengthInBits += 16;
    }

    public static CipReadRequestBuilder staticParseBuilder(ReadBuffer readBuffer, Integer serviceLen) throws ParseException {
        readBuffer.pullContext("CipReadRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        byte requestPathSize = (Byte)FieldReaderFactory.readSimpleField((String)"requestPathSize", (DataReader)DataReaderFactory.readSignedByte((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] tag = readBuffer.readByteArray("tag", Math.toIntExact(requestPathSize * 2), new WithReaderArgs[0]);
        int elementNb = (Integer)FieldReaderFactory.readSimpleField((String)"elementNb", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("CipReadRequest", new WithReaderArgs[0]);
        return new CipReadRequestBuilder(requestPathSize, tag, elementNb, serviceLen);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CipReadRequest)) {
            return false;
        }
        CipReadRequest that = (CipReadRequest)o;
        return this.getRequestPathSize() == that.getRequestPathSize() && this.getTag() == that.getTag() && this.getElementNb() == that.getElementNb() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestPathSize(), this.getTag(), this.getElementNb());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CipReadRequestBuilder
    implements CipService.CipServiceBuilder {
        private final byte requestPathSize;
        private final byte[] tag;
        private final int elementNb;
        private final Integer serviceLen;

        public CipReadRequestBuilder(byte requestPathSize, byte[] tag, int elementNb, Integer serviceLen) {
            this.requestPathSize = requestPathSize;
            this.tag = tag;
            this.elementNb = elementNb;
            this.serviceLen = serviceLen;
        }

        @Override
        public CipReadRequest build(Integer serviceLen) {
            CipReadRequest cipReadRequest = new CipReadRequest(this.requestPathSize, this.tag, this.elementNb, serviceLen);
            return cipReadRequest;
        }
    }
}

