/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.CipExchange;
import org.apache.plc4x.java.eip.readwrite.EipPacket;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class CipRRData
extends EipPacket
implements Message {
    protected final CipExchange exchange;
    protected final Integer packetLength;
    private Long reservedField0;
    private Integer reservedField1;

    @Override
    public Integer getCommand() {
        return 111;
    }

    public CipRRData(long sessionHandle, long status, List<Short> senderContext, long options, CipExchange exchange, Integer packetLength) {
        super(sessionHandle, status, senderContext, options);
        this.exchange = exchange;
        this.packetLength = packetLength;
    }

    public CipExchange getExchange() {
        return this.exchange;
    }

    @Override
    protected void serializeEipPacketChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("CipRRData", new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)(this.reservedField0 != null ? this.reservedField0 : 0L), (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)(this.reservedField1 != null ? this.reservedField1 : 0), (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"exchange", (Object)this.exchange, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        writeBuffer.popContext("CipRRData", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CipRRData _value = this;
        lengthInBits += 32;
        lengthInBits += 16;
        return lengthInBits += this.exchange.getLengthInBits();
    }

    public static CipRRDataBuilder staticParseBuilder(ReadBuffer readBuffer, Integer packetLength) throws ParseException {
        readBuffer.pullContext("CipRRData", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        Long reservedField0 = (Long)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (Object)0L, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        Integer reservedField1 = (Integer)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (Object)0, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        CipExchange exchange = (CipExchange)FieldReaderFactory.readSimpleField((String)"exchange", (DataReader)new DataReaderComplexDefault(() -> CipExchange.staticParse(readBuffer, packetLength - 6), readBuffer), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        readBuffer.closeContext("CipRRData", new WithReaderArgs[0]);
        return new CipRRDataBuilder(exchange, packetLength, reservedField0, reservedField1);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CipRRData)) {
            return false;
        }
        CipRRData that = (CipRRData)o;
        return this.getExchange() == that.getExchange() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getExchange());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CipRRDataBuilder
    implements EipPacket.EipPacketBuilder {
        private final CipExchange exchange;
        private final Integer packetLength;
        private final Long reservedField0;
        private final Integer reservedField1;

        public CipRRDataBuilder(CipExchange exchange, Integer packetLength, Long reservedField0, Integer reservedField1) {
            this.exchange = exchange;
            this.packetLength = packetLength;
            this.reservedField0 = reservedField0;
            this.reservedField1 = reservedField1;
        }

        @Override
        public CipRRData build(long sessionHandle, long status, List<Short> senderContext, long options) {
            CipRRData cipRRData = new CipRRData(sessionHandle, status, senderContext, options, this.exchange, this.packetLength);
            cipRRData.reservedField0 = this.reservedField0;
            cipRRData.reservedField1 = this.reservedField1;
            return cipRRData;
        }
    }
}

