/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum CIPDataTypeCode {
    BOOL(193, 1),
    SINT(194, 1),
    INT(195, 2),
    DINT(196, 4),
    LINT(197, 8),
    REAL(202, 4),
    DWORD(211, 4),
    STRUCTURED(672, 88),
    STRING(672, 88),
    STRING36(672, 40);

    private static final Map<Integer, CIPDataTypeCode> map;
    private int value;
    private short size;

    private CIPDataTypeCode(int value, short size) {
        this.value = value;
        this.size = size;
    }

    public int getValue() {
        return this.value;
    }

    public short getSize() {
        return this.size;
    }

    public static CIPDataTypeCode firstEnumForFieldSize(short fieldValue) {
        for (CIPDataTypeCode _val : CIPDataTypeCode.values()) {
            if (_val.getSize() != fieldValue) continue;
            return _val;
        }
        return null;
    }

    public static List<CIPDataTypeCode> enumsForFieldSize(short fieldValue) {
        ArrayList<CIPDataTypeCode> _values = new ArrayList<CIPDataTypeCode>();
        for (CIPDataTypeCode _val : CIPDataTypeCode.values()) {
            if (_val.getSize() != fieldValue) continue;
            _values.add(_val);
        }
        return _values;
    }

    public static CIPDataTypeCode enumForValue(int value) {
        return map.get(value);
    }

    public static Boolean isDefined(int value) {
        return map.containsKey(value);
    }

    static {
        map = new HashMap<Integer, CIPDataTypeCode>();
        for (CIPDataTypeCode value : CIPDataTypeCode.values()) {
            map.put(value.getValue(), value);
        }
    }
}

