/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.tag;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.canopen.readwrite.CANOpenService;
import org.apache.plc4x.java.canopen.tag.CANOpenSubscriptionTag;
import org.apache.plc4x.java.canopen.tag.CANOpenTag;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class CANOpenHeartbeatTag
extends CANOpenTag
implements CANOpenSubscriptionTag {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("HEARTBEAT|HEARTBEAT:" + NODE_PATTERN);

    public CANOpenHeartbeatTag(int node) {
        super(node);
    }

    @Override
    public CANOpenService getService() {
        return CANOpenService.HEARTBEAT;
    }

    @Override
    public boolean isWildcard() {
        return this.getNodeId() == 0;
    }

    public String getAddressString() {
        return "HEARTBEAT:" + this.getNodeId();
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.NULL;
    }

    public List<ArrayInfo> getArrayInfo() {
        return Collections.emptyList();
    }

    public static boolean matches(String addressString) {
        return ADDRESS_PATTERN.matcher(addressString).matches();
    }

    public static Matcher getMatcher(String addressString) throws PlcInvalidTagException {
        Matcher matcher = ADDRESS_PATTERN.matcher(addressString);
        if (matcher.matches()) {
            return matcher;
        }
        throw new PlcInvalidTagException(addressString, ADDRESS_PATTERN);
    }

    public static CANOpenHeartbeatTag of(String addressString) {
        Matcher matcher = CANOpenHeartbeatTag.getMatcher(addressString);
        int nodeId = matcher.group("nodeId") == null ? 0 : Integer.parseInt(matcher.group("nodeId"));
        return new CANOpenHeartbeatTag(nodeId);
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        String serviceName = this.getService().name();
        writeBuffer.writeString("service", serviceName.getBytes(StandardCharsets.UTF_8).length * 8, serviceName, new WithWriterArgs[]{WithOption.WithEncoding((String)StandardCharsets.UTF_8.name())});
        writeBuffer.writeInt("node", 64, this.getNodeId(), new WithWriterArgs[0]);
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

