/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.api.conversation.canopen;

import io.vavr.control.Either;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.apache.plc4x.java.api.exceptions.PlcException;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.canopen.api.conversation.canopen.CANConversation;
import org.apache.plc4x.java.canopen.readwrite.CANOpenDataType;
import org.apache.plc4x.java.canopen.readwrite.CANOpenFrame;
import org.apache.plc4x.java.canopen.readwrite.CANOpenSDORequest;
import org.apache.plc4x.java.canopen.readwrite.CANOpenSDOResponse;
import org.apache.plc4x.java.canopen.readwrite.CANOpenService;
import org.apache.plc4x.java.canopen.readwrite.DataItem;
import org.apache.plc4x.java.canopen.readwrite.SDOAbort;
import org.apache.plc4x.java.canopen.readwrite.SDOAbortResponse;
import org.apache.plc4x.java.canopen.readwrite.SDORequest;
import org.apache.plc4x.java.canopen.readwrite.SDOResponse;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;

public abstract class CANOpenConversationBase {
    protected final CANConversation delegate;
    protected final int nodeId;
    protected final int answerNodeId;

    public CANOpenConversationBase(CANConversation delegate, int nodeId, int answerNodeId) {
        this.delegate = delegate;
        this.nodeId = nodeId;
        this.answerNodeId = answerNodeId;
    }

    protected PlcValue decodeFrom(byte[] data, CANOpenDataType type, int length) throws ParseException {
        return DataItem.staticParse((ReadBuffer)new ReadBufferByteBased(data, ByteOrder.LITTLE_ENDIAN), type, length);
    }

    protected <T> void onError(CompletableFuture<T> receiver, CANOpenSDOResponse response, Throwable error) {
        if (error != null) {
            receiver.completeExceptionally(error);
            return;
        }
        if (response.getResponse() instanceof SDOAbortResponse) {
            SDOAbortResponse abort = (SDOAbortResponse)response.getResponse();
            SDOAbort sdoAbort = abort.getAbort();
            receiver.completeExceptionally((Throwable)new PlcException("Could not read value. Remote party reported code " + sdoAbort.getCode()));
        }
    }

    protected <X extends SDOResponse> Either<SDOAbort, X> unwrap(Class<X> payload, SDOResponse response) {
        if (response instanceof SDOAbortResponse) {
            return Either.left((Object)((SDOAbortResponse)response).getAbort());
        }
        if (payload.isInstance(response)) {
            return Either.right((Object)response);
        }
        throw new RuntimeException("Unexpected payload kind " + response);
    }

    protected CANOpenFrame createFrame(SDORequest rq) {
        return new CANOpenFrame((short)this.nodeId, CANOpenService.RECEIVE_SDO, new CANOpenSDORequest(rq.getCommand(), rq));
    }

    static class NodeIdPredicate
    implements Predicate<CANOpenFrame> {
        private final int nodeId;

        NodeIdPredicate(int nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public boolean test(CANOpenFrame frame) {
            return frame.getNodeId() == this.nodeId && frame.getService() == CANOpenService.TRANSMIT_SDO;
        }

        public String toString() {
            return "NodeIdPredicate [" + this.nodeId + "]";
        }
    }

    static class TypeOrAbortPredicate<T extends SDOResponse>
    extends TypePredicate<T, SDOResponse> {
        public TypeOrAbortPredicate(Class<T> type) {
            super(type);
        }

        @Override
        public boolean test(SDOResponse response) {
            return super.test(response) || response instanceof SDOAbortResponse;
        }
    }

    static class TypePredicate<T, X>
    implements Predicate<X> {
        private final Class<T> type;

        public TypePredicate(Class<T> type) {
            this.type = type;
        }

        @Override
        public boolean test(X value) {
            return this.type.isInstance(value);
        }

        public String toString() {
            return "Type [" + this.type + "]";
        }
    }
}

