/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.canopen.readwrite.SDOAbortRequest;
import org.apache.plc4x.java.canopen.readwrite.SDOBlockRequest;
import org.apache.plc4x.java.canopen.readwrite.SDOInitiateDownloadRequest;
import org.apache.plc4x.java.canopen.readwrite.SDOInitiateUploadRequest;
import org.apache.plc4x.java.canopen.readwrite.SDORequestCommand;
import org.apache.plc4x.java.canopen.readwrite.SDOSegmentDownloadRequest;
import org.apache.plc4x.java.canopen.readwrite.SDOSegmentUploadRequest;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class SDORequest
implements Message {
    public abstract SDORequestCommand getCommand();

    protected abstract void serializeSDORequestChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("SDORequest", new WithWriterArgs[0]);
        this.serializeSDORequestChild(writeBuffer);
        writeBuffer.popContext("SDORequest", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        SDORequest _value = this;
        return lengthInBits;
    }

    public static SDORequest staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        SDORequestCommand command;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof SDORequestCommand) {
            command = (SDORequestCommand)((Object)args[0]);
        } else if (args[0] instanceof String) {
            command = SDORequestCommand.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type SDORequestCommand or a string which is parseable but was " + args[0].getClass().getName());
        }
        return SDORequest.staticParse(readBuffer, command);
    }

    public static SDORequest staticParse(ReadBuffer readBuffer, SDORequestCommand command) throws ParseException {
        readBuffer.pullContext("SDORequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        SDORequestBuilder builder = null;
        if (EvaluationHelper.equals((Object)((Object)command), (Object)((Object)SDORequestCommand.SEGMENT_DOWNLOAD))) {
            builder = SDOSegmentDownloadRequest.staticParseBuilder(readBuffer, command);
        } else if (EvaluationHelper.equals((Object)((Object)command), (Object)((Object)SDORequestCommand.INITIATE_DOWNLOAD))) {
            builder = SDOInitiateDownloadRequest.staticParseBuilder(readBuffer, command);
        } else if (EvaluationHelper.equals((Object)((Object)command), (Object)((Object)SDORequestCommand.INITIATE_UPLOAD))) {
            builder = SDOInitiateUploadRequest.staticParseBuilder(readBuffer, command);
        } else if (EvaluationHelper.equals((Object)((Object)command), (Object)((Object)SDORequestCommand.SEGMENT_UPLOAD))) {
            builder = SDOSegmentUploadRequest.staticParseBuilder(readBuffer, command);
        } else if (EvaluationHelper.equals((Object)((Object)command), (Object)((Object)SDORequestCommand.ABORT))) {
            builder = SDOAbortRequest.staticParseBuilder(readBuffer, command);
        } else if (EvaluationHelper.equals((Object)((Object)command), (Object)((Object)SDORequestCommand.BLOCK))) {
            builder = SDOBlockRequest.staticParseBuilder(readBuffer, command);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [command=" + (Object)((Object)command) + "]");
        }
        readBuffer.closeContext("SDORequest", new WithReaderArgs[0]);
        SDORequest _sDORequest = builder.build();
        return _sDORequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SDORequest)) {
            return false;
        }
        SDORequest that = (SDORequest)o;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface SDORequestBuilder {
        public SDORequest build();
    }
}

