/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.math.BigInteger;
import java.util.LinkedList;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.canopen.readwrite.CANOpenDataType;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataItem.class);

    public static PlcValue staticParse(ReadBuffer readBuffer, CANOpenDataType dataType, Integer size) throws ParseException {
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.BOOLEAN))) {
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED8))) {
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED16))) {
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED24))) {
            Long value = readBuffer.readUnsignedLong("", 24, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED32))) {
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED40))) {
            BigInteger value = readBuffer.readUnsignedBigInteger("", 40, new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED48))) {
            BigInteger value = readBuffer.readUnsignedBigInteger("", 48, new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED56))) {
            BigInteger value = readBuffer.readUnsignedBigInteger("", 56, new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED64))) {
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER8))) {
            Byte value = readBuffer.readSignedByte("", 8, new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER16))) {
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER24))) {
            Integer value = readBuffer.readInt("", 24, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER32))) {
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER40))) {
            Long value = readBuffer.readLong("", 40, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER48))) {
            Long value = readBuffer.readLong("", 48, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER56))) {
            Long value = readBuffer.readLong("", 56, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER64))) {
            Long value = readBuffer.readLong("", 64, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.REAL32))) {
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.REAL64))) {
            Double value = readBuffer.readDouble("", 64, new WithReaderArgs[0]);
            return new PlcLREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.RECORD))) {
            long _valueLength = size.intValue();
            long valueEndPos = (long)readBuffer.getPos() + _valueLength;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            while ((long)readBuffer.getPos() < valueEndPos) {
                value.add(new PlcSINT(readBuffer.readByte("", new WithReaderArgs[0])));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.OCTET_STRING))) {
            String _valueLength = readBuffer.readString("", size.intValue(), "UTF-8", new WithReaderArgs[0]);
        } else {
            if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.VISIBLE_STRING))) {
                String value = readBuffer.readString("", size.intValue(), "UTF-8", new WithReaderArgs[0]);
                return new PlcSTRING(value);
            }
            if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNICODE_STRING))) {
                String value = readBuffer.readString("", size / 8, "UTF-8", new WithReaderArgs[0]);
                return new PlcSTRING(value);
            }
        }
        return null;
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, CANOpenDataType dataType, Integer size) throws SerializationException {
        DataItem.staticSerialize(writeBuffer, _value, dataType, size, ByteOrder.BIG_ENDIAN);
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, CANOpenDataType dataType, Integer size, ByteOrder byteOrder) throws SerializationException {
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.BOOLEAN))) {
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED8))) {
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED16))) {
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED24))) {
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 24, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED32))) {
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED40))) {
            BigInteger value = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 40, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED48))) {
            BigInteger value = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 48, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED56))) {
            BigInteger value = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 56, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED64))) {
            BigInteger value = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER8))) {
            byte value = _value.getByte();
            writeBuffer.writeSignedByte("", 8, ((Number)value).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER16))) {
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER24))) {
            int value = _value.getInt();
            writeBuffer.writeInt("", 24, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER32))) {
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER40))) {
            long value = _value.getLong();
            writeBuffer.writeLong("", 40, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER48))) {
            long value = _value.getLong();
            writeBuffer.writeLong("", 48, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER56))) {
            long value = _value.getLong();
            writeBuffer.writeLong("", 56, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER64))) {
            long value = _value.getLong();
            writeBuffer.writeLong("", 64, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.REAL32))) {
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.REAL64))) {
            double value = _value.getDouble();
            writeBuffer.writeDouble("", 64, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.RECORD))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.OCTET_STRING))) {
            String test = null;
            writeBuffer.writeString("", size.intValue(), "UTF-8", test, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.VISIBLE_STRING))) {
            String value = _value.getString();
            writeBuffer.writeString("", size.intValue(), "UTF-8", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNICODE_STRING))) {
            String value = _value.getString();
            writeBuffer.writeString("", size / 8, "UTF-8", value, new WithWriterArgs[0]);
        }
    }

    public static int getLengthInBytes(PlcValue _value, CANOpenDataType dataType, Integer size) {
        return (int)Math.ceil((double)DataItem.getLengthInBits(_value, dataType, size) / 8.0);
    }

    public static int getLengthInBits(PlcValue _value, CANOpenDataType dataType, Integer size) {
        int sizeInBits = 0;
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.BOOLEAN))) {
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED8))) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED16))) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED24))) {
            sizeInBits += 24;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED32))) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED40))) {
            sizeInBits += 40;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED48))) {
            sizeInBits += 48;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED56))) {
            sizeInBits += 56;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNSIGNED64))) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER8))) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER16))) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER24))) {
            sizeInBits += 24;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER32))) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER40))) {
            sizeInBits += 40;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER48))) {
            sizeInBits += 48;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER56))) {
            sizeInBits += 56;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.INTEGER64))) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.REAL32))) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.REAL64))) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.RECORD))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.OCTET_STRING))) {
            --sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.VISIBLE_STRING))) {
            --sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)CANOpenDataType.UNICODE_STRING))) {
            --sizeInBits;
        }
        return sizeInBits;
    }
}

