/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.field;

import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.canopen.field.CANOpenHeartbeatField;
import org.apache.plc4x.java.canopen.field.CANOpenNMTField;
import org.apache.plc4x.java.canopen.field.CANOpenPDOField;
import org.apache.plc4x.java.canopen.field.CANOpenSDOField;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class CANOpenField
implements PlcField,
Serializable {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("(?:(0[xX](?<indexHex>[0-9a-fA-F]+))|(?<index>\\d+))/(?:(0[xX](?<subIndexHex>[0-9a-fA-F]+))|(?<subIndex>\\d+)):(?<canDataType>\\w+)(\\[(?<numberOfElements>\\d)])?");
    public static final Pattern NODE_PATTERN = Pattern.compile("(?<nodeId>\\d+)");
    private final int nodeId;

    public CANOpenField(int nodeId) {
        this.nodeId = nodeId;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public static CANOpenField of(String addressString) throws PlcInvalidFieldException {
        if (CANOpenSDOField.matches(addressString)) {
            return CANOpenSDOField.of(addressString);
        }
        if (CANOpenPDOField.matches(addressString)) {
            return CANOpenPDOField.of(addressString);
        }
        if (CANOpenNMTField.matches(addressString)) {
            return CANOpenNMTField.of(addressString);
        }
        if (CANOpenHeartbeatField.matches(addressString)) {
            return CANOpenHeartbeatField.of(addressString);
        }
        throw new PlcInvalidFieldException("Unable to parse address: " + addressString);
    }
}

